unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, SwColor, SwareCtl, ComCtrls, Spin, ExtCtrls;

type
  TMainForm = class(TForm)
    PageCtl: TPageControl;
    ColorButtonPage: TTabSheet;
    ColorButton1: TSwareCtl;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    BtnShadowClr: TSwComboColor;
    BtnHiliteClr: TSwComboColor;
    EndColor: TSwComboColor;
    BeginColor: TSwComboColor;
    ButtonFont: TFontComboBox;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    TxtShadowClr: TSwComboColor;
    TxtHiliteClr: TSwComboColor;
    BorderColor: TSwComboColor;
    SwapColor: TCheckBox;
    BackStyle: TComboBox;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    TextLayout: TComboBox;
    Label11: TLabel;
    TextStyle: TComboBox;
    ShadeType: TComboBox;
    Label12: TLabel;
    ColorButton2: TSwareCtl;
    EditButton: TCheckBox;
    Label13: TLabel;
    FontColor: TSwComboColor;
    Blink: TCheckBox;
    Label14: TLabel;
    FrameSize: TSpinEdit;
    Label15: TLabel;
    FontSize: TSpinEdit;
    ColorLabel: TTabSheet;
    SwareLabel1: TSwareLabel;
    Utility: TTabSheet;
    SwareLabel2: TSwareLabel;
    ColorStatusBar1: TColorStatusBar;
    GroupBox1: TGroupBox;
    StatusText1: TEdit;
    StatusBackColor1: TSwComboColor;
    StatusFontColor1: TSwComboColor;
    StatusFontColor: TLabel;
    StatusBackColor: TLabel;
    StatusBlink1: TCheckBox;
    GroupBox2: TGroupBox;
    Label16: TLabel;
    Label17: TLabel;
    StatusText2: TEdit;
    StatusBackColor2: TSwComboColor;
    StatusFontColor2: TSwComboColor;
    StatusBlink2: TCheckBox;
    ReadMe: TTabSheet;
    Memo1: TMemo;
    Label18: TLabel;
    Image1: TImage;
    DrawRectangle: TSwareCtl;
    EllipseGradient: TSwareCtl;
    DrawTriangle: TSwareCtl;
    GradientinEllipse: TSwareCtl;
    procedure FormCreate(Sender: TObject);
    procedure BeginColorChange(Sender: TObject);
    procedure GradientinEllipseClick(Sender: TObject);
    procedure EllipseGradientClick(Sender: TObject);
    procedure DrawRectangleClick(Sender: TObject);
    procedure DrawTriangleClick(Sender: TObject);
    procedure SwapColorClick(Sender: TObject);
    procedure EditButtonClick(Sender: TObject);
    procedure TextLayoutChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
    BeginColor.AddColor('clBlack',clBlack);
    BeginColor.AddColor('clNavy',clNavy);
    BeginColor.AddColor('clGreen',clGreen);
    BeginColor.AddColor('clTeal',clTeal);
    BeginColor.AddColor('clMaroon',clMaroon);
    BeginColor.AddColor('clPurple',clPurple);
    BeginColor.AddColor('clOlive',clOlive);
    BeginColor.AddColor('clSilver',clSilver);
    BeginColor.AddColor('clGray',clGray);
    BeginColor.AddColor('clBlue',clBlue);
    BeginColor.AddColor('clLime',clLime);
    BeginColor.AddColor('clAqua',clAqua);
    BeginColor.AddColor('clRed',clRed);
    BeginColor.AddColor('clFuchsia',clFuchsia);
    BeginColor.AddColor('clYellow',clYellow);
    BeginColor.AddColor('clWhite',clWhite);
    BeginColor.AddColor('clWhite',clWhite);  // This line added to get space for Custom color.
    BeginColor.SelectedColor := clPurple;
    EndColor.Items.Assign(BeginColor.Items);
    EndColor.SelectedColor:=clAqua;
    BtnHiliteClr.Items.Assign(BeginColor.Items);
    BtnHiliteClr.SelectedColor:=clBtnHighlight;
    BtnShadowClr.Items.Assign(BeginColor.Items);
    BtnShadowClr.SelectedColor:=clBtnShadow;
    BorderColor.Items.Assign(BeginColor.Items);
    BorderColor.SelectedColor:=clBlack;
    TxtHiliteClr.Items.Assign(BeginColor.Items);
    TxtHiliteClr.SelectedColor:=clSilver;
    TxtShadowClr.Items.Assign(BeginColor.Items);
    TxtShadowClr.SelectedColor:=clRed;
    FontColor.Items.Assign(BeginColor.Items);
    FontColor.SelectedColor:=clYellow;
    ButtonFont.ItemIndex:=ButtonFont.Items.IndexOf(ColorButton1.Font.Name);
    BackStyle.ItemIndex:=2;
    ShadeType.ItemIndex:=0;
    TextLayout.ItemIndex:=0;
    TextStyle.ItemIndex:=1;
    FrameSize.Value:=3;
    FontSize.Value:=12;

    StatusBackColor1.Items.Assign(BeginColor.Items);
    StatusBackColor1.SelectedColor:=clBlue;
    StatusFontColor1.Items.Assign(BeginColor.Items);
    StatusFontColor1.SelectedColor:=clYellow;
    StatusBackColor2.Items.Assign(BeginColor.Items);
    StatusBackColor2.SelectedColor:=clYellow;
    StatusFontColor2.Items.Assign(BeginColor.Items);
    StatusFontColor2.SelectedColor:=clBlue;

end;

procedure TMainForm.BeginColorChange(Sender: TObject);
begin
     ColorButton1.BeginColor:=BeginColor.SelectedColor;
     ColorButton1.EndColor:=EndColor.SelectedColor;
     ColorButton1.BtnHiliteClr:=BtnHiliteClr.SelectedColor;
     ColorButton1.BtnShadowClr:=BtnShadowClr.SelectedColor;
     ColorButton1.BorderColor:=BorderColor.SelectedColor;
     ColorButton1.TxtHiliteClr:=TxtHiliteClr.SelectedColor;
     ColorButton1.TxtShadowClr:=TxtShadowClr.SelectedColor;
     ColorButton1.Font.Color:=FontColor.SelectedColor;
     ColorButton1.Font.Name:=ButtonFont.Items.Strings[ButtonFont.ItemIndex];;
     ColorButton1.GradientStyle:=TGradientStyle(BackStyle.ItemIndex);
     ColorButton1.TextLayout:=TTextLayout(TextLayout.ItemIndex);
     ColorButton1.TextShadeType:=TShadeType(ShadeType.ItemIndex);
     ColorButton1.TextStyle:=TTextStyle(TextStyle.ItemIndex);
     ColorButton1.SwapColors:=SwapColor.Checked;
     ColorButton1.DesignMode:=EditButton.Checked;
     ColorButton1.Blink:=Blink.Checked;
     ColorButton1.FrameSize:=FrameSize.Value;
     ColorButton1.Font.Size:=FontSize.Value;

     ColorButton2.BeginColor:=BeginColor.SelectedColor;
     ColorButton2.EndColor:=EndColor.SelectedColor;
     ColorButton2.BtnHiliteClr:=BtnHiliteClr.SelectedColor;
     ColorButton2.BtnShadowClr:=BtnShadowClr.SelectedColor;
     ColorButton2.BorderColor:=BorderColor.SelectedColor;
     ColorButton2.TxtHiliteClr:=TxtHiliteClr.SelectedColor;
     ColorButton2.TxtShadowClr:=TxtShadowClr.SelectedColor;
     ColorButton2.Font.Color:=FontColor.SelectedColor;
     ColorButton2.Font.Name:=ButtonFont.Items.Strings[ButtonFont.ItemIndex];;
     ColorButton2.GradientStyle:=TGradientStyle(BackStyle.ItemIndex);
     ColorButton2.TextLayout:=TTextLayout(TextLayout.ItemIndex);
     ColorButton2.TextShadeType:=TShadeType(ShadeType.ItemIndex);
     ColorButton2.TextStyle:=TTextStyle(TextStyle.ItemIndex);
     ColorButton2.SwapColors:=SwapColor.Checked;
     ColorButton2.DesignMode:=EditButton.Checked;
     ColorButton2.Blink:=Blink.Checked;
     ColorButton2.FrameSize:=FrameSize.Value;
     ColorButton2.Font.Size:=FontSize.Value;

     ColorStatusBar1.Panels.Items[0].Text := StatusText1.Text ;
     ColorStatusBar1.Panels.Items[0].Blink := StatusBlink1.Checked ;
     ColorStatusBar1.Panels.Items[0].Color := StatusBackColor1.SelectedColor ;
     ColorStatusBar1.Panels.Items[0].Font.Color := StatusFontColor1.SelectedColor ;
     ColorStatusBar1.Panels.Items[1].Text := StatusText2.Text ;
     ColorStatusBar1.Panels.Items[1].Blink := StatusBlink2.Checked ;
     ColorStatusBar1.Panels.Items[1].Color := StatusBackColor2.SelectedColor ;
     ColorStatusBar1.Panels.Items[1].Font.Color := StatusFontColor2.SelectedColor ;
end;

procedure TMainForm.GradientinEllipseClick(Sender: TObject);
var i:integer;
begin
{SwareGradientDrawEllipse(Canvas:TCanvas; _Type,Left , Top , Right , Bottom,Pwidth:Integer; BeginColor,EndColor:TColor;ParentLeft,ParentTop:Integer)}
     for i:=0 to 10 do
     begin
          Image1.Canvas.Brush.Color:=clWhite;
          Image1.Canvas.Brush.Style:=bsSolid;
          Image1.Canvas.FillRect(Rect(0,0,Image1.Width,Image1.Height));
          SwareGradientDrawEllipse(Image1.Canvas,i,10,10,Image1.Width-10,Image1.Height-10,5,clGreen,clYellow,0,0) ;
          Application.ProcessMessages();
          sleep(500);
     end;
     Image1.Canvas.Font.Size:=12;
     Image1.Canvas.Font.Color:=clBlack;
     Image1.Canvas.TextOut(10,Image1.Height-20,'SwareGradientDrawEllipse');
end;

procedure TMainForm.EllipseGradientClick(Sender: TObject);
var i:integer;
begin
{SwareGradientDrawEllipseDefault(Canvas:TCanvas; _Type,Left , Top , Right , Bottom,Pwidth:Integer; BeginColor,EndColor:TColor) }
     for i:=0 to 11 do
     begin
          Image1.Canvas.Brush.Color:=clWhite;
          Image1.Canvas.Brush.Style:=bsSolid;
          Image1.Canvas.FillRect(Rect(0,0,Image1.Width,Image1.Height));
          SwareGradientDrawEllipseDefault(Image1.Canvas,i mod 2,10,10,Image1.Width-10,Image1.Height-10,5,clGreen,clYellow) ;
          Application.ProcessMessages();
          sleep(500);
     end;
     Image1.Canvas.Font.Size:=12;
     Image1.Canvas.Font.Color:=clBlack;
     Image1.Canvas.TextOut(10,Image1.Height-20,'SwareGradientDrawEllipseDefault');
end;

procedure TMainForm.DrawRectangleClick(Sender: TObject);
var i:integer;
begin
{SwareGradientDrawRect(Canvas:TCanvas; _Type,Left,Top,Right,Bottom,width:Integer; BeginColor,EndColor:TColor)}
     for i:=0 to 10 do
     begin
          Image1.Canvas.Brush.Color:=clWhite;
          Image1.Canvas.Brush.Style:=bsSolid;
          Image1.Canvas.FillRect(Rect(0,0,Image1.Width,Image1.Height));
          SwareGradientDrawRect(Image1.Canvas,i,10,10,Image1.Width-10,Image1.Height-10,5,clGreen,clYellow) ;
          Application.ProcessMessages();
          sleep(500);
     end;
     Image1.Canvas.Font.Size:=12;
     Image1.Canvas.Font.Color:=clBlack;
     Image1.Canvas.TextOut(10,Image1.Height-20,'SwareGradientDrawRect');
end;

procedure TMainForm.DrawTriangleClick(Sender: TObject);
var i:integer;
begin
{SwareGradientDrawTriangle(Canvas:TCanvas; _Type,Left,Top,Right,Bottom,Pwidth:Integer; BeginColor,EndColor:TColor)}
     for i:=0 to 11 do
     begin
          Image1.Canvas.Brush.Color:=clWhite;
          Image1.Canvas.Brush.Style:=bsSolid;
          Image1.Canvas.FillRect(Rect(0,0,Image1.Width,Image1.Height));
          Image1.Canvas.Pen.Color:=clYellow;
          SwareGradientDrawTriangle(Image1.Canvas,i mod 2,10,10,Image1.Width-10,Image1.Height-10,5,clGreen,clYellow) ;
          Application.ProcessMessages();
          sleep(500);
     end;
     Image1.Canvas.Font.Size:=12;
     Image1.Canvas.Font.Color:=clBlack;
     Image1.Canvas.TextOut(10,Image1.Height-20,'SwareGradientDrawTriangle');
end;

procedure TMainForm.SwapColorClick(Sender: TObject);
begin
     BeginColorChange(Sender);
     if SwapColor.Checked then Application.MessageBox('Click the button to see color swap when mouse down','SwapColors',MB_OK);
end;

procedure TMainForm.EditButtonClick(Sender: TObject);
begin
     BeginColorChange(Sender);
     if EditButton.Checked then Application.MessageBox('You can move the button now','DesignMode',MB_OK);
end;

procedure TMainForm.TextLayoutChange(Sender: TObject);
begin
     BeginColorChange(Sender);
     if (TextLayout.ItemIndex<>0) then Application.MessageBox('This property is for Multibytes character such as : Chinese,Japanese','TextLayout',MB_OK);
end;

end.
