unit SwareCtl;
interface

uses
  SysUtils,Messages, Windows, Classes, Controls, Forms, CommCtrl , Graphics, Dialogs,
  ExtCtrls,StdCtrls, Printers , Consts ;

{These are the nine different gradient styles available.}
type
  TGradientStyle = (gsHorizontal, gsVertical, gsRectangle,
					gsVertCenter, gsHorizCenter,gsLeftTop,gsRightTop,
					gsLeftTopRightBottom,gsRightTopLeftBottom,
					gsElliptic,gsNone,gsImage,gsTextOnly);

{Text can be normal, or 3D raised/inset}
type
  TTextStyle = (tsNormal, tsRaised, tsInset);

{ShadeType refers to the 3D text effect.}
type
  TShadeType = (stLight, stHeavy);

{TextLayout refers to or.}
type
  TTextLayout = (tlLeftRight, tlUpDown);

type
  TFrameLayout = (flNone, flUp, flDown);

  TPosChangedEvent = procedure (Sender: TObject; CurLeft, CurTop: Longint) of object;

type
  TSwareCtl = class(TCustomControl)
  private
    { Private declarations }
	FDefault : Boolean;
    FClicksDisabled : Boolean; //Add for WndProc
    FActive      : Boolean;
    FFrameSize   : Integer ;
    FBorderColor : TColor;
	FImage       : TBitmap;


    FBtnHiliteClr : TColor;   //Hilite around button
    FBtnShadowClr : TColor;   //Shadow around button
    FTxtHiliteClr : TColor;  //Text Hilite
    FTxtShadowClr : TColor;  //Text Shadow
    FBeginClr : TColor;    //Start color for gradient
    FEndClr : TColor;     //End color for gradient
    FSwapClr : Boolean;    //Swap start-end colors on button press?
    FMouseDownEffect : Boolean ;
    FGradientStyle : TGradientStyle;  //One of six choices
    FTextStyle : TTextStyle;  //Raised, Inset, or None
	FShadeType : TShadeType; //Light or heavy text shading
	FTextLayout: TTextLayout ;  // or 
	mDn, mUp : Boolean;    //Flags for Mouse Up and Down
	bm : TBitmap;          //WorkHorse internal bmp
	TmpClr : TColor;       //Holding area for Color during Mouse Down.

	FTimer: TTimer;
	FBlink: Boolean;
	FInterval:Word;
	FFontColor: TColor;
	FShowColor: TColor;

	FResizing: Integer;
	SavedCursor: TCursor ;
	CursorSaveOk:Boolean ;
	FResizeBorder: Integer;
	FDesignMode: Boolean;
	MouseDownX : Integer ;
	MouseDownY : Integer ;
	FEditSelected : Boolean ;
	FPosMoved : Boolean ;
	FSwareCommand : String ;
	FOnPosChanged : TPosChangedEvent ;

	procedure Paint; override;  //Override Paint - entire control is painted.
	procedure SetDefault(Value: Boolean);
	procedure CMTextChanged(var Msg:TMessage); message CM_TEXTCHANGED;
	//I had to add this to get the Caption to change while designing
    procedure WMEraseBkgnd(Var Msg : TMessage); message WM_ERASEBKGND;
    //I added this to help reduce flicker and speed things up.
    procedure CMFocusChanged(var Message: TCMFocusChanged); message CM_FOCUSCHANGED;
	procedure SetSwareCtlStyle(ADefault: Boolean); virtual;

    procedure ChangedFont(Sender:TObject);
    procedure SetBlink(Value: Boolean);
    procedure SetInterval(Value: Word);

	procedure SetDesignMode(Value: Boolean);
	procedure SetEditSelected(Value: Boolean);
	procedure SetResizeBorder(Value: Integer);
	procedure SetSwareCommand(Value: String);

//	procedure Click ;  override;
	procedure MouseDown(Button:TMouseButton; Shift: TShiftState;
	  X, Y: Integer); override;
	procedure MouseMove(Shift:TShiftState; X, Y: Integer); override;
	procedure MouseUp(Button:TMouseButton; Shift:TShiftState;
	  X, Y: Integer); override;

    //Mouse up and down are what I use to swap gradient colors
	procedure SetBtnHilite(Value: TColor);  //Set color of top and left of frame
    procedure SetBtnShadow(Value: TColor);  //Set Color of right and bottom of frame
    procedure SetTxtHilite(Value: TColor);  //Set color for text 3D effect hilite
	procedure SetTxtShadow(Value: TColor);  //Set color for text 3D effect sadow
    procedure SetBeginClr(Value : TColor);  //Set start color of gradient
    procedure SetEndClr(Value : TColor);    //Set end color of gradient
    procedure SetSwap(Value : Boolean);  //Swap the start-end true-false
    procedure SetMouseDownEffect(Value:Boolean);
    procedure SetStyle(Value: TTextStyle);  //Set Caption 3D style
    procedure SetShade(Value: TShadeType);  //Set Caption shading type
    procedure ChangedImage(Sender:TObject);
    procedure SetImage(Value:TBitmap);

    procedure SetLayout(Value: TTextLayout);  // or 
    procedure SetFrameSize(Value: Integer);  //߿
    procedure SetBorderColor(Value: TColor);  //ɫ

    procedure DoRaise(offset: Integer);   //This draws the 3D Caption 'raised'
    procedure DoInset(offset: Integer);  //This draws te 3D caption 'inset'
    procedure DoNorm(offset: Integer);   //This draws the caption with no 3D
    procedure SetGradient(Value : TGradientStyle);  //Choose gradient fill style
	procedure DoElliptic(fr, fg, fb, dr, dg, db : Integer); // The fr fg fb etc
	procedure DoFocusRect;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
  protected
    procedure WndProc(var Message: TMessage); override;
    procedure WCtlBlink(Sender:TObject) ; dynamic;
    { Protected declarations }
  public
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    property BtnHiliteClr : TColor read FBtnHiliteClr
       write SetBtnHilite default clBtnHighLight;
    property BtnShadowClr : TColor read FBtnShadowClr
       write SetBtnShadow default clBtnShadow;
	property TxtHiliteClr : TColor read FTxtHiliteClr
       write SetTxtHilite default clBtnHighLight;
    property TxtShadowClr : TColor read FTxtShadowClr
       write SetTxtShadow default clBtnShadow;
    property BeginColor : TColor read FBeginClr
       write SetBeginClr default clNavy;
    property EndColor : TColor read FEndClr
	   write SetEndClr default clAqua;
    property SwapColors : Boolean read FSwapClr
       write SetSwap default TRUE;
    property MouseDownEffect : Boolean read FMouseDownEffect
             write SetMouseDownEffect default TRUE;
    property GradientStyle : TGradientStyle read FGradientStyle
       write SetGradient default gsNone;
    property TextStyle : TTextStyle read FTextStyle
       write SetStyle default tsNormal;
    property TextShadeType : TShadeType read FShadeType
       write SetShade default stLight;

    property TextLayout : TTextLayout read FTextLayout
       write SetLayout default tlLeftRight; // or 
    property FrameSize : Integer read FFrameSize
       write SetFrameSize default 3 ; //ť߿
    property BorderColor : TColor read FBorderColor
       write SetBorderColor default clBlack ; //ť߿

    property Image : TBitmap read FImage
	   write SetImage ;

	property Default: Boolean read FDefault write SetDefault default False;

	property Blink: Boolean read FBlink write SetBlink;
	property Interval: Word read FInterval write SetInterval;

	property ResizeBorder: Integer read FResizeBorder write SetResizeBorder;
	property DesignMode: Boolean read FDesignMode write SetDesignMode;
	property EditSelected: Boolean read FEditSelected write SetEditSelected;
	property SwareCommand: String read FSwareCommand write SetSwareCommand;

	property Caption;      //Added these so they show up in the Obj Insp.
	property OnClick;      // When deriving from a Custom type control,
	property OnDblClick;
	property OnMouseDown;  // these don't normally show up unless you specifically
	property OnMouseUp;    // declare them yourself.  You can find them by
	property Visible;      // going through the browser.
	property Enabled;
	property Font;
	property PopupMenu;
	property ShowHint;
	property TabOrder;
	property TabStop;
	property OnEnter;
	property OnExit;
	property OnKeyDown;
	property OnKeyPress;
	property OnKeyUp;
	property OnMouseMove;
	property OnDragDrop ;
	property OnDragOver ;
	property OnEndDrag ;
	property OnStartDrag ;
	property OnPosChanged : TPosChangedEvent read FOnPosChanged write FOnPosChanged;
  end;


type
  TSwareLabel = class(TCustomLabel)
  private
    { Private declarations }
	FFrameSize   : Integer ;
    FBorderColor : TColor;
    FShadowOffset: Integer ;
    FDrawBorder  : Boolean ;

    FBtnHiliteClr : TColor;   //Hilite around button
    FBtnShadowClr : TColor;   //Shadow around button
    FTxtHiliteClr : TColor;  //Text Hilite
    FTxtShadowClr : TColor;  //Text Shadow
    FBeginClr : TColor;    //Start color for gradient
    FEndClr : TColor;     //End color for gradient
    FGradientStyle : TGradientStyle;  //One of six choices
    FTextStyle : TTextStyle;  //Raised, Inset, or None
    FShadeType : TShadeType; //Light or heavy text shading
    FTextLayout: TTextLayout ;  // or 

    FResizing: Integer;
	SavedCursor: TCursor ;
    CursorSaveOk:Boolean ;
	FResizeBorder: Integer;
	FDesignMode: Boolean;
	FEditSelected : Boolean ;
	FPosMoved : Boolean ;
	FSwareCommand : String ;
	FOnPosChanged : TPosChangedEvent ;
	mDn   :Boolean ;
	mUp   :Boolean ;
	MouseDownX : Integer ;
	MouseDownY : Integer ;

    procedure Paint; override;  //Override Paint - entire control is painted.
    procedure CMTextChanged(var Msg:TMessage); message CM_TEXTCHANGED;
    //I had to add this to get the Caption to change while designing
    procedure WMEraseBkgnd(Var Msg : TMessage); message WM_ERASEBKGND;
    //I added this to help reduce flicker and speed things up.
    procedure SetBtnHilite(Value: TColor);  //Set color of top and left of frame
    procedure SetBtnShadow(Value: TColor);  //Set Color of right and bottom of frame
    procedure SetTxtHilite(Value: TColor);  //Set color for text 3D effect hilite
    procedure SetTxtShadow(Value: TColor);  //Set color for text 3D effect sadow
    procedure SetBeginClr(Value : TColor);  //Set start color of gradient
    procedure SetEndClr(Value : TColor);    //Set end color of gradient
    procedure SetStyle(Value: TTextStyle);  //Set Caption 3D style
    procedure SetShade(Value: TShadeType);  //Set Caption shading type

	procedure SetLayout(Value: TTextLayout);  // or 
    procedure SetFrameSize(Value: Integer);  //߿
	procedure SetShadowOffset(Value: Integer);  //
    procedure SetBorderColor(Value: TColor);  //ɫ
	procedure SetDrawBorder(Value: Boolean);  //

    procedure DoRaise(offset: Integer);   //This draws the 3D Caption 'raised'
    procedure DoInset(offset: Integer);  //This draws te 3D caption 'inset'
    procedure DoNorm(offset: Integer);   //This draws the caption with no 3D
    procedure SetGradient(Value : TGradientStyle);  //Choose gradient fill style
	procedure DoElliptic(fr, fg, fb, dr, dg, db : Integer); // The fr fg fb etc

	procedure SetDesignMode(Value: Boolean);
	procedure SetEditSelected(Value: Boolean);
	procedure SetSwareCommand(Value: String);

	procedure SetResizeBorder(Value: Integer);
	procedure MouseDown(Button:TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
	procedure MouseMove(Shift:TShiftState; X, Y: Integer); override;
	procedure MouseUp(Button:TMouseButton; Shift:TShiftState;
	  X, Y: Integer); override;

    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
  protected
    { Protected declarations }
  public
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    property Canvas ;
  published
    property BtnHiliteClr : TColor read FBtnHiliteClr
       write SetBtnHilite default clBtnHighLight;
    property BtnShadowClr : TColor read FBtnShadowClr
       write SetBtnShadow default clBtnShadow;
    property TxtHiliteClr : TColor read FTxtHiliteClr
       write SetTxtHilite default clBtnHighLight;
    property TxtShadowClr : TColor read FTxtShadowClr
       write SetTxtShadow default clBtnShadow;
    property BeginColor : TColor read FBeginClr
       write SetBeginClr default clNavy;
    property EndColor : TColor read FEndClr
       write SetEndClr default clAqua;
	property GradientStyle : TGradientStyle read FGradientStyle
       write SetGradient default gsNone;
	property TextStyle : TTextStyle read FTextStyle
	   write SetStyle default tsNormal;
    property TextShadeType : TShadeType read FShadeType
	   write SetShade default stLight;

    property TextLayout : TTextLayout read FTextLayout
       write SetLayout default tlLeftRight; // or 
    property FrameSize : Integer read FFrameSize
       write SetFrameSize default 3 ; //ť߿
    property ShadowOffset : Integer read FShadowOffset
       write SetShadowOffset default 2 ; //
    property BorderColor : TColor read FBorderColor
       write SetBorderColor default clBlack ; //ť߿
    property DrawBorder : Boolean read FDrawBorder
       write SetDrawBorder default true ; //ť߿

    property ResizeBorder: Integer read FResizeBorder write SetResizeBorder;
	property DesignMode: Boolean read FDesignMode write SetDesignMode;
	property EditSelected: Boolean read FEditSelected write SetEditSelected;
	property SwareCommand: String read FSwareCommand write SetSwareCommand;

    property Caption;      //Added these so they show up in the Obj Insp.
    property OnClick;      // When deriving from a Custom type control,
	property OnMouseDown;  // these don't normally show up unless you specifically
    property OnMouseUp;    // declare them yourself.  You can find them by
	property Visible;      // going through the browser.
	property Enabled;
    property AutoSize;
	property Align;
    property Cursor;
    property Transparent;
    property Font;
    property PopupMenu;
    property ShowHint;
    property OnDblClick ;
    property OnDragDrop ;
    property OnDragOver ;
    property OnEndDrag ;
    property OnMouseMove ;
    property OnStartDrag ;
	property OnPosChanged : TPosChangedEvent read FOnPosChanged write FOnPosChanged;
  end;

  TColorStatusBar = class;

  TColorStatusPanelStyle = (psText, psOwnerDraw);
  TColorStatusPanelBevel = (pbNone, pbLowered, pbRaised);

  TColorStatusPanel = class(TCollectionItem)
  private
	FText: string;
    FWidth: Integer;
    FAlignment: TAlignment;
    FBevel: TColorStatusPanelBevel;
    FStyle: TColorStatusPanelStyle;
    FFont:  TFont;
    FColor: TColor;
    FSaveColor : TColor;
    FShowColor : TColor;
    FBlink: bool ;
    function GetDisplayName: string; override;
    procedure SetAlignment(Value: TAlignment);
    procedure SetBevel(Value: TColorStatusPanelBevel);
	procedure SetStyle(Value: TColorStatusPanelStyle);
    procedure SetText(const Value: string);
    procedure SetWidth(Value: Integer);
    procedure SetFont(Value: TFont);
    procedure ChangedFont(Sender:TObject);
    procedure SetColor(Value: TColor);
    procedure SetSaveColor(Value: TColor);
    procedure SetShowColor(Value: TColor);
    procedure SetBlink(Value: bool);
  public
    constructor Create(Collection: TCollection); override;
    destructor Destroy; override;
	procedure Assign(Source: TPersistent); override;
  published
    property Alignment: TAlignment read FAlignment write SetAlignment default taLeftJustify;
    property Bevel: TColorStatusPanelBevel read FBevel write SetBevel default pbLowered;
    property Style: TColorStatusPanelStyle read FStyle write SetStyle default psText;
    property Text: string read FText write SetText;
	property Width: Integer read FWidth write SetWidth;
    property Font: TFont read FFont write SetFont;
    property Color: TColor read FColor write SetColor;
    property SaveColor: TColor read FSaveColor write SetSaveColor;
    property ShowColor: TColor read FShowColor write SetShowColor;
    property Blink: bool read FBlink write SetBlink;
  end;

  TColorStatusPanels = class(TCollection)
  private
    FStatusBar: TColorStatusBar;
    function GetItem(Index: Integer): TColorStatusPanel;
    procedure SetItem(Index: Integer; Value: TColorStatusPanel);
  protected
    function GetOwner: TPersistent; override;
    procedure Update(Item: TCollectionItem); override;
  public
    constructor Create(StatusBar: TColorStatusBar);
    function Add: TColorStatusPanel;
	property Items[Index: Integer]: TColorStatusPanel read GetItem write SetItem; default;
  end;

  TDrawPanelEvent = procedure(StatusBar: TColorStatusBar; Panel: TColorStatusPanel;
    const Rect: TRect) of object;

  TColorStatusBar = class(TWinControl)
  private
    FPanels: TColorStatusPanels;
    FCanvas: TCanvas;
    FSimpleText: string;
    FSimplePanel: Boolean;
    FSizeGrip: Boolean;
	FTimer: TTimer;
    FBlink: Boolean;
    FInterval:Word;
    FOnDrawPanel: TDrawPanelEvent;
    FOnResize: TNotifyEvent;
    procedure SetPanels(Value: TColorStatusPanels);
    procedure SetSimplePanel(Value: Boolean);
    procedure SetSimpleText(const Value: string);
    procedure SetSizeGrip(Value: Boolean);

    procedure SetBlink(Value: Boolean);
    procedure SetInterval(Value: Word);

    procedure UpdatePanel(Index: Integer);
    procedure UpdatePanels;
    procedure CNDrawItem(var Message: TWMDrawItem); message CN_DRAWITEM;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
  protected
	procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure DrawPanel(Panel: TColorStatusPanel; const Rect: TRect); dynamic;
    procedure Resize; dynamic;
    procedure StatusBarBlink(Sender:TObject) ; dynamic;
  public
    constructor Create(AOwner: TComponent); override;
	destructor Destroy; override;
    property Canvas: TCanvas read FCanvas;
  published
    property Align default alBottom;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property Panels: TColorStatusPanels read FPanels write SetPanels;
	property ParentFont;
    property ParentShowHint;
    property PopupMenu;
	property ShowHint;
    property SimplePanel: Boolean read FSimplePanel write SetSimplePanel;
    property SimpleText: string read FSimpleText write SetSimpleText;
    property SizeGrip: Boolean read FSizeGrip write SetSizeGrip default True;
    property Blink: Boolean read FBlink write SetBlink;
    property Interval: Word read FInterval write SetInterval;
	property Visible;
	property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
	property OnMouseMove;
    property OnMouseUp;
    property OnDrawPanel: TDrawPanelEvent read FOnDrawPanel write FOnDrawPanel;
    property OnResize: TNotifyEvent read FOnResize write FOnResize;
    property OnStartDrag;
  end;
procedure PrintBitmap(Bitmap : Graphics.TBitmap;X, Y, pWidth, pHeight: Integer);
procedure SwareGradientDrawArea(Canvas:TCanvas ; _Type,Left,Top,Right,Bottom:integer; BeginColor,EndColor:TColor);
procedure SwareGradientDrawLine(Canvas:TCanvas;  _Type,Left,Top,Right,Bottom,width:integer; BeginColor,EndColor: TColor;Style:Integer) ;
procedure SwareGradientDrawPLine(Canvas:TCanvas;  _Type,width:Integer;Points:array of TPoint ; BeginColor,EndColor: TColor;Style:Integer) ;
procedure SwareGradientDrawRect(Canvas:TCanvas; _Type,Left,Top,Right,Bottom,width:Integer; BeginColor,EndColor:TColor) ;
procedure SwareGradientDrawEllipseDefault(Canvas:TCanvas; _Type,Left , Top , Right , Bottom,Pwidth:Integer; BeginColor,EndColor:TColor) ;
procedure SwareGradientDrawEllipse(Canvas:TCanvas; _Type,Left,Top,Right,Bottom,Pwidth:Integer; BeginColor,EndColor:TColor;ParentLeft,ParentTop:Integer) ;
procedure SwareGradientDrawTriangle(Canvas:TCanvas; _Type,Left,Top,Right,Bottom,Pwidth:Integer; BeginColor,EndColor:TColor) ;
procedure DrawButton(Canvas:TCanvas;Left,Top,Right,Bottom:Integer;
                    Caption,FontName:PChar;FontColor,BackColor:TColor;
                    FontSize,FrameSize:Integer;Horz,mDown:boolean);
procedure DrawLabel(Canvas:TCanvas;Style,Left,Top,Right,Bottom:Integer;
                    Caption:Pchar;FontName:PChar;
                    FontColor,ShadowColor,BeginColor,EndColor:TColor;
                    FontSize,FrameSize:Integer;Horz,Transparent:boolean);
procedure FocusRect(Canvas:TCanvas; FocusArea:TRect);

function  minint(a,b:Integer):Integer ;

procedure Register;

function InitColorStatusControl(CC: Integer): Boolean;

implementation

procedure PrintBitmap(Bitmap : Graphics.TBitmap;X, Y, pWidth, pHeight: Integer);
	var
 	 Info     : PBitmapInfo;
	 InfoSize : DWord;
	 Image    : Pointer;
	{$IFDEF WIN32}
	  ImageSize: DWord;
	{$ELSE}
	  ImageSize: LongInt;

{$ENDIF}
	begin
	   if (pWidth < 1) or (pHeight < 1) then
       begin
	      pWidth:=Bitmap.Width;
	      pHeight:=Bitmap.Height;
	   end;

    with Bitmap do begin
      GetDIBSizes(Handle, InfoSize, ImageSize);
      GetMem(Info,InfoSize);
      try
		Image := GlobalAllocPtr(HeapAllocFlags, ImageSize);
		try
          GetDIB(Handle, Palette, Info^, Image^);
          with Info^.bmiHeader do
           StretchDIBits(Printer.Canvas.Handle, X, Y, pWidth,

            pHeight, 0, 0, biWidth, biHeight, Image, Info^,
			DIB_RGB_COLORS, SRCCOPY)

		 finally
          GlobalFreePtr(Image);
         end;
      finally
	   FreeMem(Info, InfoSize);
	  end;
	end;
end ;

procedure SwareGradientDrawArea(Canvas:TCanvas ; _Type,Left,Top,Right,Bottom:integer; BeginColor,EndColor:TColor);
var
	frect , frect2 : TRect ;
		i , loopcount , halfloopcount : Integer;
	fr,fg,fb,dr,dg,db ,cr,cg,cb:Integer ;
	Temppoints:array[0..255] of TPoint ;
	frgn : HRGN ;
	bm : TBitMap ;
begin
			bm := TBitMap.Create ;
			bm.Width := Right - Left ;
			bm.Height := Bottom-Top ;
	fr := (BeginColor and $000000FF) ;
	fg := ((BeginColor shr 8) and $000000ff) ;
	fb := ((BeginColor shr 16) and $000000ff) ;
	dr := ((EndColor and $000000ff) - fr) ;
	dg := (((EndColor shr 8) and $000000ff) - fg) ;
	db := (((EndColor shr 16) and $000000ff) - fb) ;
	if (_Type>10) then _Type:=2 ;
	if (_Type<0) then _Type:=2 ;
	case (_Type) of
		0:              // Hor
		begin
			frect.Top := Top ;
			frect.Bottom := Bottom ;
			frect.Left := Left ;
			frect.Right := Right ;
			Canvas.Brush.Color := BeginColor ;
			Canvas.FillRect(frect) ;
		end;
		1:              // Hor
		begin
			frect.Top := Top ;
			frect.Bottom := Bottom ;
			for i:=0 to 255 do
			begin
				frect.Left := (Left+i*(Right - Left)div 255) ;
				frect.Right := Left+(i+1)*(Right - Left)div 255 ;
				cr := (fr+i*dr div 255) ;
				cg := (fg+i*dg div 255) ;
				cb := (fb+i*db div 255) ;
				Canvas.Brush.Color := TColor(RGB(cr,cg,cb)) ;
				Canvas.FillRect(frect) ;
			end;
		end;
		2:
		begin
			frect.left := Left ;
			frect.right := Right ;
			for i:=0 to 255 do
			begin
				frect.top := Top+i*(Bottom - Top) div 255 ;
				frect.bottom := Top+(i+1)*(Bottom - Top) div 255 ;
				cr := (fr+i*dr div 255) ;
				cg := (fg+i*dg div 255) ;
				cb := (fb+i*db div 255) ;
				Canvas.Brush.Color := TColor(RGB(cr,cg,cb)) ;
				Canvas.FillRect(frect) ;
			end;
		end;
		3:
		begin
			loopcount := abs(Bottom-Top) ;
			if ((Right - Left)>(Bottom-Top)) then loopcount:=abs(Right - Left) ;
			halfloopcount:= loopcount div 2 ;
			for i:=0 to halfloopcount do
			begin
				cr := (fr+i*dr div halfloopcount) ;
				cg := (fg+i*dg div halfloopcount) ;
				cb := (fb+i*db div halfloopcount) ;
				frect.Top := Top+i*(Bottom - Top) div loopcount ;
				frect.Bottom := Bottom-i*(Bottom - Top) div loopcount ;
				frect.Left := Left+i*(Right - Left) div loopcount ;
				frect.Right := Right-i*(Right - Left) div loopcount ;
				Canvas.Brush.Color := TColor(RGB(cr,cg,cb)) ;
				Canvas.FrameRect(frect) ;
			end;
			Canvas.FillRect(frect) ;
		end;
		4:
		begin
			frect.left := Left ;
			frect.right := Right ;
			frect2 := frect ;
            for i:=0 to 254 do
			begin
				frect.top := Top+i*(Bottom - Top) div 510 ;
				frect.bottom := Top+(i+1)*(Bottom - Top) div 510 ;
				cr := (fr+i*dr div 255) ;
				cg := (fg+i*dg div 255) ;
                cb := (fb+i*db div 255) ;
            	Canvas.Brush.Color := TColor(RGB(cr,cg,cb)) ;
                Canvas.FillRect(frect) ;
                frect2.top := Bottom - (i)*(Bottom - Top) div 510 ;
				frect2.bottom := Bottom - (i+1)*(Bottom - Top) div 510 ;
				Canvas.FillRect(frect2) ;
			end;
            frect2.top := frect.bottom ;
			Canvas.FillRect(frect2) ;
        end;
		5:
        begin
			frect.top := Top ;
			frect.bottom := Bottom ;
			frect2 := frect ;
			for i:=0 to 254 do
            begin
				frect.left := Left+i*(Right - Left) div 510 ;
                frect.right := Left+(i+1)*(Right - Left) div 510 ;
                cr := (fr+i*dr div 255) ;
				cg := (fg+i*dg div 255) ;
				cb := (fb+i*db div 255) ;
				Canvas.Brush.Color := TColor(RGB(cr,cg,cb)) ;
				Canvas.FillRect(frect) ;
                frect2.left := Right-i*(Right - Left) div 510 ;
				frect2.right := Right-(i+1)*(Right - Left) div 510 ;
                Canvas.FillRect(frect2) ;
			end;
			frect2.left := frect.right ;
			Canvas.FillRect(frect2) ;
		end;
		6:
		begin
			Canvas.Pen.Width := 1 ;
			halfloopcount:=128 ;
			loopcount:= halfloopcount*2 ;
			bm.Canvas.Brush.Style := bsSolid ;
			for i:=0 to loopcount do
			begin
				cr := (fr+i*dr div loopcount) ;
				cg := (fg+i*dg div loopcount) ;
				cb := (fb+i*db div loopcount) ;
				bm.Canvas.Brush.Color := TColor(RGB(cr,cg,cb)) ;
				if (i<halfloopcount) then
				begin
					Temppoints[0].x:= 0 ; Temppoints[0].y:= i*(Bottom-Top) div halfloopcount;
					Temppoints[1].x:= 0 ; Temppoints[1].y:= (i+1)*(Bottom-Top) div halfloopcount;
					Temppoints[3].x:= i*(Right-Left) div halfloopcount;  Temppoints[3].y:= 0;
					Temppoints[2].x:= (i+1)*(Right-Left) div halfloopcount;     Temppoints[2].y:= 0;
					frgn:=CreatePolygonRgn(Temppoints,4,ALTERNATE);
					PaintRgn(bm.Canvas.Handle, frgn) ;
					DeleteObject(frgn) ;
				end
				else
				begin
					Temppoints[0].x:= (i-halfloopcount)*(Right - Left) div halfloopcount;  Temppoints[0].y:= Bottom-Top;
					Temppoints[1].x:= (i+1-halfloopcount)*(Right - Left) div halfloopcount;  Temppoints[1].y:= Bottom-Top;
					Temppoints[3].x:= Right - Left;  Temppoints[3].y:= (i-halfloopcount)*(Bottom-Top) div halfloopcount;
					Temppoints[2].x:= Temppoints[3].x;     Temppoints[2].y:= (i+1-halfloopcount)*(Bottom-Top) div halfloopcount;
					frgn:=CreatePolygonRgn(Temppoints,4,ALTERNATE);
					PaintRgn(bm.Canvas.Handle, frgn) ;
					DeleteObject(frgn) ;
				end;
			end;
			Canvas.Draw(Left,Top , bm) ;
		end;
		7:
		begin
			Canvas.Pen.Width := 1 ;
			halfloopcount:=128 ;
			loopcount:= halfloopcount*2 ;
			bm.Canvas.Brush.Style := bsSolid ;
			for i:=0 to loopcount do
			begin
				cr := (fr+i*dr div loopcount) ;
				cg := (fg+i*dg div loopcount) ;
				cb := (fb+i*db div loopcount) ;
				bm.Canvas.Brush.Color := TColor(RGB(cr,cg,cb)) ;
				if (i<halfloopcount) then
				begin
					Temppoints[0].x:= Right-Left;  Temppoints[0].y:= i*(Bottom-Top) div halfloopcount;
					Temppoints[1].x:= Right-Left;  Temppoints[1].y:= (i+1)*(Bottom-Top) div halfloopcount;
					Temppoints[2].x:= Right-Left - (i+1)*(Right-Left) div halfloopcount;  Temppoints[2].y:= 0;
					Temppoints[3].x:= Right-Left - i*(Right-Left) div halfloopcount;    Temppoints[3].y:= 0;
					frgn:=CreatePolygonRgn(Temppoints,4,ALTERNATE);
					PaintRgn(bm.Canvas.Handle, frgn) ;
					DeleteObject(frgn) ;
				end
				else
				begin
					Temppoints[0].x:= Right-Left - (i-halfloopcount)*(Right-Left) div halfloopcount;  Temppoints[0].y:= Bottom-Top ;
					Temppoints[1].x:= Right-Left - (i+1-halfloopcount)*(Right-Left) div halfloopcount;  Temppoints[1].y:= Bottom-Top ;
					Temppoints[3].x:= 0;  Temppoints[3].y:= (i-halfloopcount)*(Bottom-Top) div halfloopcount;;
					Temppoints[2].x:= 0;    Temppoints[2].y:= (i+1-halfloopcount)*(Bottom-Top) div halfloopcount;;
					frgn:=CreatePolygonRgn(Temppoints,4,ALTERNATE);
					PaintRgn(bm.Canvas.Handle, frgn) ;
					DeleteObject(frgn) ;
				end;
			end;
			Canvas.Draw(Left,Top , bm) ;
		end;
		8:
		begin
			Canvas.Pen.Width := 1 ;
			loopcount:= 128 ;
			bm.Canvas.Brush.Style := bsSolid ;
			for i:=0 to loopcount do
			begin
				cr := (fr+i*dr div loopcount) ;
				cg := (fg+i*dg div loopcount) ;
				cb := (fb+i*db div loopcount) ;
				bm.Canvas.Brush.Color := TColor(RGB(cr,cg,cb)) ;
					Temppoints[0].x:= 0 ; Temppoints[0].y:= i*(Bottom-Top) div loopcount;
					Temppoints[1].x:= 0 ; Temppoints[1].y:= (i+1)*(Bottom-Top) div loopcount;
					Temppoints[3].x:= i*(Right-Left) div loopcount;  Temppoints[3].y:= 0;
					Temppoints[2].x:= (i+1)*(Right-Left) div loopcount;     Temppoints[2].y:= 0;
					frgn:=CreatePolygonRgn(Temppoints,4,ALTERNATE);
					PaintRgn(bm.Canvas.Handle, frgn) ;
					DeleteObject(frgn) ;

					Temppoints[0].x:= Right-Left-i*(Right - Left) div loopcount;  Temppoints[0].y:= Bottom-Top;
					Temppoints[1].x:= Right-Left-(i+1)*(Right - Left) div loopcount;  Temppoints[1].y:= Bottom-Top;
					Temppoints[2].x:= Right - Left;  Temppoints[2].y:= Bottom-Top-(i+1)*(Bottom-Top) div loopcount;
					Temppoints[3].x:= Temppoints[2].x;     Temppoints[3].y:= Bottom-Top-i*(Bottom-Top) div loopcount;
					frgn:=CreatePolygonRgn(Temppoints,4,ALTERNATE);
					PaintRgn(bm.Canvas.Handle, frgn) ;
					DeleteObject(frgn) ;
			end;
			Canvas.Draw(Left,Top , bm) ;
		end;
		9:
		begin
			Canvas.Pen.Width := 1 ;
			loopcount:= 128 ;
			bm.Canvas.Brush.Style := bsSolid ;
			for i:=0 to loopcount do
			begin
				cr := (fr+i*dr div loopcount) ;
				cg := (fg+i*dg div loopcount) ;
				cb := (fb+i*db div loopcount) ;
				bm.Canvas.Brush.Color := TColor(RGB(cr,cg,cb)) ;
					Temppoints[0].x:= Right-Left;  Temppoints[0].y:= i*(Bottom-Top) div loopcount;
					Temppoints[1].x:= Right-Left;  Temppoints[1].y:= (i+1)*(Bottom-Top) div loopcount;
					Temppoints[2].x:= Right-Left - (i+1)*(Right-Left) div loopcount;  Temppoints[2].y:= 0;
					Temppoints[3].x:= Right-Left - i*(Right-Left) div loopcount;    Temppoints[3].y:= 0;
					frgn:=CreatePolygonRgn(Temppoints,4,ALTERNATE);
					PaintRgn(bm.Canvas.Handle, frgn) ;
					DeleteObject(frgn) ;

					Temppoints[0].x:= i*(Right-Left) div loopcount;  Temppoints[0].y:= Bottom-Top ;
					Temppoints[1].x:= (i+1)*(Right-Left) div loopcount;  Temppoints[1].y:= Bottom-Top ;
					Temppoints[2].x:= 0;  Temppoints[2].y:= Bottom-Top-(i+1)*(Bottom-Top) div loopcount;;
					Temppoints[3].x:= 0;    Temppoints[3].y:= Bottom-Top-i*(Bottom-Top) div loopcount;;
					frgn:=CreatePolygonRgn(Temppoints,4,ALTERNATE);
					PaintRgn(bm.Canvas.Handle, frgn) ;
					DeleteObject(frgn) ;
			end;
			Canvas.Draw(Left,Top , bm) ;
		end;
	end;
			bm.Free ;
end;

procedure SwareGradientDrawLine(Canvas:TCanvas;  _Type,Left,Top,Right,Bottom,width:Integer; BeginColor,EndColor: TColor;Style:Integer) ;
var
	i : Integer;
	fr,fg,fb,dr,dg,db ,cr,cg,cb : Integer ;
	x1,y1,x2,y2 , width2 : Integer;
begin
	if (_Type=0) then
	begin
		Canvas.Pen.Color := BeginColor ;
		Canvas.Pen.Width := width ;
		Canvas.Pen.Style := TPenStyle(Style) ;
		Canvas.MoveTo(Left,Top) ;
       	Canvas.LineTo(Right,Bottom) ;
		Exit ;
    end ;

	fr := (BeginColor and $000000FF) ;
	fg := ((BeginColor shr 8) and $000000ff) ;
	fb := ((BeginColor shr 16) and $000000ff) ;
    dr := ((EndColor and $000000ff) - fr) ;
	dg := (((EndColor shr 8) and $000000ff) - fg) ;
	db := (((EndColor shr 16) and $000000ff) - fb) ;

   	Canvas.Pen.Width := 1 ;
	width2 := width div 2+1 ;
	if (abs(Right - Left)>abs(Bottom - Top)) then
    begin
		if (Left>Right) then
        begin
			x1 := Left+width2 ;
			x2 := Right-width2 ;
        end
		else
        begin
			x1 := Left-width2 ;
			x2 := Right+width2 ;
        end;
	    for i:=0 to width2 do
		begin
			y1 := Top+i ;
    	    y2 := Bottom+i ;
	        cr := (fr+i*dr div width2) ;
    	    cg := (fg+i*dg div width2) ;
			cb := (fb+i*db div width2) ;
			Canvas.Pen.Color := TColor(RGB(cr,cg,cb)) ;
			Canvas.MoveTo(x1,y1) ;
			Canvas.LineTo(x2,y2) ;
			y1 := Top-i ;
    	    y2 := Bottom-i ;
			Canvas.MoveTo(x1,y1) ;
			Canvas.LineTo(x2,y2) ;
        end;
	end
    else
	begin
        if (Top>Bottom) then
        begin
			y1 := Top+width2 ;
			y2 := Bottom-width2 ;
		end
		else
        begin
			y1 := Top-width2 ;
			y2 := Bottom+width2 ;
        end;
	    for i:=0 to width2 do
		begin
			x1 := Left+i ;
			x2 := Right+i ;
			cr := (fr+i*dr div width2) ;
			cg := (fg+i*dg div width2) ;
			cb := (fb+i*db div width2) ;
			Canvas.Pen.Color := TColor(RGB(cr,cg,cb)) ;
			Canvas.MoveTo(x1,y1) ;
			Canvas.LineTo(x2,y2) ;
			x1 := Left-i ;
			x2 := Right-i ;
			Canvas.MoveTo(x1,y1) ;
			Canvas.LineTo(x2,y2) ;
		end;
	end;
end;

procedure SwareGradientDrawPLineCount(Canvas:TCanvas;  _Type,width:Integer;Points:array of TPoint ; _Count:Integer ;BeginColor,EndColor: TColor;Style:Integer) ;
var
	i , j , k : Integer ;
	fr,fg,fb,dr,dg,db ,cr,cg,cb : Integer ;
	width2 : Integer ;
	Temppoints:array[0..255] of TPoint ;
	LineDir:array[0..255] of Integer ;
	KDir:array[0..1] of Integer ;
	Count : Integer ;
begin
	Count:=_Count ;
	if Count>255 then Count:=255 ;
	if Count<2 then
	begin
		Exit ;
	end;
	Canvas.Pen.Mode := pmCopy ;
	if (_Type=0) then
	begin
		Canvas.Pen.Color := BeginColor ;
		Canvas.Pen.Width := width ;
		Canvas.Pen.Style := TPenStyle(Style) ;
		Canvas.MoveTo(Points[0].x,Points[0].y) ;
		Canvas.Polyline(Slice(Points,Count)) ;
		Exit ;
	end ;

	for i:=0 to Count-2 do
	begin
        LineDir[i]:=0 ;
		if (abs(Points[i+1].x - Points[i].x)>abs(Points[i+1].y - Points[i].y)) then
		begin
			if (Points[i].x>Points[i+1].x) then
            begin
    		    LineDir[i]:=1 ;
			end
            else
			begin
				LineDir[i]:=2 ;
			end;
        end
		else
		begin
            if (Points[i].y>Points[i+1].y) then
			begin
				LineDir[i]:=3 ;
			end
            else
            begin
				LineDir[i]:=4 ;
            end;
		end;
	end;

    fr := (EndColor and $000000FF) ;
	fg := ((EndColor shr 8) and $000000ff) ;
    fb := ((EndColor shr 16) and $000000ff) ;
	dr := ((BeginColor and $000000ff) - fr) ;
    dg := (((BeginColor shr 8) and $000000ff) - fg) ;
    db := (((BeginColor shr 16) and $000000ff) - fb) ;

   	Canvas.Pen.Width := 1 ;
	width2 := width div 2+1 ;
	KDir[0]:=1 ;
	KDir[1]:=-1 ;
    for j:=0 to width2 do
	begin
		cr := (fr+j*dr div width2) ;
   	    cg := (fg+j*dg div width2) ;
		cb := (fb+j*db div width2) ;
		Canvas.Pen.Color := TColor(RGB(cr,cg,cb)) ;
		for k:=0 to 1 do
        begin
			case LineDir[0] of
			1:
				begin TempPoints[0].x:=Points[0].x+width2 ;
				TempPoints[0].y:=Points[0].y+j*KDir[k] ; end ;
			2:
				begin TempPoints[0].x:=Points[0].x-width2 ;
				TempPoints[0].y:=Points[0].y-j*KDir[k] ; end ;
			3:
				begin TempPoints[0].x:=Points[0].x-j*KDir[k] ;
				TempPoints[0].y:=Points[0].y+width2 ; end ;
            4:
                begin TempPoints[0].x:=Points[0].x+j*KDir[k] ;
				TempPoints[0].y:=Points[0].y-width2 ; end ;
            end;
			for i:=1 to Count-2 do
			begin
				TempPoints[i].x:=Points[i].x+j*KDir[k] ;
				TempPoints[i].y:=Points[i].y+j*KDir[k] ;
				case LineDir[i-1] of
				1:
					case LineDir[i] of
						1,3:
						begin TempPoints[i].x:=Points[i].x-j*KDir[k] ;
						TempPoints[i].y:=Points[i].y+j*KDir[k] ; end ;
						4:
						begin TempPoints[i].x:=Points[i].x+j*KDir[k] ;
						TempPoints[i].y:=Points[i].y+j*KDir[k] ; end ;
					end;
				2:
					case LineDir[i] of
						2,3:
						begin TempPoints[i].x:=Points[i].x-j*KDir[k] ;
						TempPoints[i].y:=Points[i].y-j*KDir[k] ; end ;
						4:
						begin TempPoints[i].x:=Points[i].x+j*KDir[k] ;
						TempPoints[i].y:=Points[i].y-j*KDir[k] ; end ;
					end;
				3:
					case LineDir[i] of
						1,3:
						begin TempPoints[i].x:=Points[i].x-j*KDir[k] ;
						TempPoints[i].y:=Points[i].y+j*KDir[k] ; end ;
						2:
						begin TempPoints[i].x:=Points[i].x-j*KDir[k] ;
						TempPoints[i].y:=Points[i].y-j*KDir[k] ; end ;
					end;
				4:
					case LineDir[i] of
						1,4:
						begin TempPoints[i].x:=Points[i].x+j*KDir[k] ;
						TempPoints[i].y:=Points[i].y+j*KDir[k] ; end ;
						2:
						begin TempPoints[i].x:=Points[i].x+j*KDir[k] ;
						TempPoints[i].y:=Points[i].y-j*KDir[k] ; end ;
					end;
				end;
			end ;
			case LineDir[Count-2] of
			1:
				begin TempPoints[Count-1].x:=Points[Count-1].x-width2-1 ;
				TempPoints[Count-1].y:=Points[Count-1].y+j*KDir[k] ; end;
			2:
				begin TempPoints[Count-1].x:=Points[Count-1].x+width2+1 ;
				TempPoints[Count-1].y:=Points[Count-1].y-j*KDir[k] ; end ;
			3:
				begin TempPoints[Count-1].x:=Points[Count-1].x-j*KDir[k] ;
				TempPoints[Count-1].y:=Points[Count-1].y-width2-1 ; end ;
			4:
				begin TempPoints[Count-1].x:=Points[Count-1].x+j*KDir[k] ;
				TempPoints[Count-1].y:=Points[Count-1].y+width2+1 ; end ;
			end;
			Canvas.MoveTo(TempPoints[0].x,TempPoints[0].y) ;
			Canvas.Polyline(Slice(TempPoints,Count)) ;
		end;
	end;
end;

procedure SwareGradientDrawPLine(Canvas:TCanvas;  _Type,width:Integer;Points:array of TPoint ; BeginColor,EndColor: TColor;Style:Integer) ;
begin
     SwareGradientDrawPLineCount(Canvas,_Type,width,Points,High(Points),BeginColor,EndColor,Style) ;
end;

procedure SwareGradientDrawRect(Canvas:TCanvas; _Type,Left,Top,Right,Bottom,width:Integer; BeginColor,EndColor:TColor) ;
var
	i ,j , x1 ,x2 , y1 , y2 : Integer;
	fr,fg,fb,dr,dg,db ,cr,cg,cb : Integer;
	Width2 : Integer;
begin
	if (_Type=0) then
	begin
		if (abs(Right-Left)<=(width)) then _Type := 1 ;
		if (abs(Bottom-Top)<=(width)) then _Type := 1 ;
	end;
	if (Left>Right) then
	begin
		x1 := Right ;
		x2 := Left ;
	end
	else
	begin
		x2 := Right ;
		x1 := Left ;
	end;
	if (Top>Bottom) then
	begin
		y1 := Bottom ;
		y2 := Top ;
	end
	else
	begin
		y2 := Bottom ;
		y1 := Top ;
	end;
	Width2 := width div 2+1 ;
	Canvas.Pen.Mode := pmCopy	;
	if (_Type=0) then
	begin
		if (BeginColor = EndColor) then
		begin
			Canvas.Pen.Color := BeginColor ;
			Canvas.Pen.Width := width ;
			Canvas.Brush.Style := bsClear ;
			Canvas.Rectangle(x1,y1,x2+1,y2+1);
		end
		else
		begin
			fr := (BeginColor and $000000FF) ;
			fg := ((BeginColor shr 8) and $000000ff) ;
			fb := ((BeginColor shr 16) and $000000ff) ;
			dr := ((EndColor and $000000ff) - fr) ;
			dg := (((EndColor shr 8) and $000000ff) - fg) ;
			db := (((EndColor shr 16) and $000000ff) - fb) ;
			Canvas.Pen.Width := 1 ;
			Canvas.Brush.Style := bsSolid ;
            x1:=x1+Width2;   y1:=y1+Width2;
            x2:=x2-Width2;   y2:=y2-Width2;
			for i:=0 to Width2 do
			begin
				cr := (fr+i*dr div Width2) ;
				cg := (fg+i*dg div Width2) ;
				cb := (fb+i*db div Width2) ;
				j:=Width2-i ;
				Canvas.Brush.Color := TColor(RGB(cr,cg,cb)) ;
				Canvas.FrameRect(Rect(x1-j,y1-j,x2+j+1,y2+j+1));
				Canvas.FrameRect(Rect(x1+j,y1+j,x2-j+1,y2-j+1));
			end;
		end ;
		Canvas.Brush.Style := bsSolid ;
	end
	else
    if _Type<10 then SwareGradientDrawArea(Canvas , _Type , x1 , y1 , x2+1 , y2+1 , BeginColor , EndColor)
    else begin
            SwareGradientDrawRect(Canvas , 0 , x1 , y1 , x2+1 , y2+1 , width , BeginColor,EndColor) ;
            x1:=x1+Width2;   y1:=y1+Width2;
            x2:=x2-Width2;   y2:=y2-Width2;
            SwareGradientDrawArea(Canvas , 1 , x1+1 , y1+1 , x2 , y2 , BeginColor , BeginColor);
         end;
end;

procedure SwareGradientDrawEllipseDefault(Canvas:TCanvas; _Type,Left , Top , Right , Bottom,Pwidth:Integer; BeginColor,EndColor:TColor) ;
var
	Width, Height ,Width2 , PenWidth , i: Integer ;
	fr,fg,fb,dr,dg,db,cr,cg,cb : Integer ;
	frgn : HRGN ;
	EllipseRect : TRect ;
	bm : TBitMap ;
begin
	Width := Right - Left ;
	Height := Bottom-Top ;
	if (_Type = 0) then   // No gradient
	begin
		PenWidth := PWidth ;
		if (PWidth>Width) then PenWidth :=Width ;
		if (PWidth>Height) then PenWidth :=Height ;
		Width2 :=PenWidth div 2 ;
		Canvas.Pen.Width := PenWidth ;
		Canvas.Ellipse(Width2, Width2, Width-Width2, Height-Width2);
	end
	else
	begin
		bm := TBitMap.Create ;
		bm.Width := Width ;
		bm.Height := Height ;
		bm.Canvas.CopyRect(Rect(0,0,Width,Height),Canvas,Rect(Left,Top,Right,Bottom)) ;
		fr := (BeginColor and $000000FF) ;
		fg := ((BeginColor shr 8) and $000000ff) ;
		fb := ((BeginColor shr 16) and $000000ff) ;
		dr := ((EndColor and $000000ff) - fr) ;
		dg := (((EndColor shr 8) and $000000ff) - fg) ;
		db := (((EndColor shr 16) and $000000ff) - fb) ;
		bm.Canvas.Brush.Style := bsSolid ;
		bm.Canvas.Pen.Width := 1 ;
		bm.Canvas.Pen.Style := psClear ;
		bm.Canvas.Pen.Mode := pmCopy ;
		if (Width>Height) then Width2 := Height div 2 else Width2 := Width div 2 ;
		for i:=0 to Width2 do
		begin
			cr := (fr+i*dr div Width2) ;
			cg := (fg+i*dg div Width2) ;
			cb := (fb+i*db div Width2) ;
			EllipseRect.Left := i ;
			EllipseRect.Top  := i ;
			EllipseRect.Right := Width - i ;
			EllipseRect.Bottom := Height - i ;
			bm.Canvas.Brush.Color :=TColor(RGB(cr,cg,cb)) ;
			frgn:=CreateEllipticRgnIndirect(EllipseRect);
			PaintRgn(bm.Canvas.Handle, frgn) ;
			DeleteObject(frgn) ;
		end;
		bm.Canvas.Ellipse(EllipseRect.Left,EllipseRect.Top,EllipseRect.Right,EllipseRect.Bottom);
		Canvas.Draw(Left,Top,bm);
		bm.Free ;
	end;
end;

procedure SwareGradientDrawEllipse(Canvas:TCanvas; _Type,Left , Top , Right , Bottom,Pwidth:Integer; BeginColor,EndColor:TColor;ParentLeft,ParentTop:Integer) ;
var
	Width, Height ,Width2 , PenWidth : Integer ;
	frgn : HRGN ;
begin
	Width := Right - Left ;
	Height := Bottom-Top ;
	if (_Type = 0) then   // No gradient
	begin
		PenWidth := PWidth ;
		if (PWidth>Width) then PenWidth :=Width ;
		if (PWidth>Height) then PenWidth :=Height ;
		Width2 :=PenWidth div 2 ;
		Canvas.Pen.Width := PenWidth ;
		Canvas.Ellipse(Width2, Width2, Width-Width2, Height-Width2);
	end
	else
	begin
		frgn:=CreateEllipticRgnIndirect(Rect(Left+ParentLeft,Top+ParentTop,Right+ParentLeft,Bottom+ParentTop));
		SelectClipRgn(Canvas.Handle, frgn) ;
		SwareGradientDrawRect(Canvas,_Type,Left,Top,Right,Bottom,Pwidth,BeginColor,EndColor) ;
		SelectClipRgn(Canvas.Handle, 0) ;
		DeleteObject(frgn) ;
	end;
end;

procedure SwareGradientDrawTriangle(Canvas:TCanvas; _Type,Left,Top,Right,Bottom,Pwidth:Integer; BeginColor,EndColor:TColor) ;
var
	Width2 , i , PenWidth , Width , Height : Integer ;
	fr,fg,fb,dr,dg,db,cr,cg,cb : Integer ;
	triangle : array[0..2] of TPoint;
begin
	Width := Right - Left ;
	Height := Bottom - Top ;
	if (_Type = 0) then   // No gradient
    begin
		PenWidth := Pwidth ;
		if (Pwidth>Width) then PenWidth :=Width ;
        if (Pwidth>Height) then PenWidth :=Height ;
        Width2 :=PenWidth div 2 ;
		Canvas.Pen.Width := PenWidth ;
        triangle[0].x := Left + Width div 2 ;
		triangle[0].y := Top + Width2 ;
        triangle[1].x := Left + Width2 ;
		triangle[1].y := Bottom-trunc(Width2*Height/Width)-1 ;
        triangle[2].x := Right-Width2-1 ;
		triangle[2].y := Bottom-trunc(Width2*Height/Width)-1 ;
		Canvas.Polygon(triangle);
	end
	else
	begin
		fr := (BeginColor and $000000FF) ;
		fg := ((BeginColor shr 8) and $000000ff) ;
		fb := ((BeginColor shr 16) and $000000ff) ;
		dr := ((EndColor and $000000ff) - fr) ;
		dg := (((EndColor shr 8) and $000000ff) - fg) ;
		db := (((EndColor shr 16) and $000000ff) - fb) ;
		Canvas.Brush.Style := bsSolid ;
		Canvas.Pen.Width :=1 ;
		Canvas.Pen.Style := psClear ;
		Canvas.Pen.Mode := pmCopy ;
		if (Width>Height) then Width2 := Height div 2 else Width2 := Width div 2 ;
		for i:=0 to Width2 do
		begin
			cr := (fr+i*dr div Width2) ;
			cg := (fg+i*dg div Width2) ;
			cb := (fb+i*db div Width2) ;
			triangle[0].x := Left + Width div 2 ;
			triangle[0].y := Top + i ;
			triangle[1].x := Left + trunc(i*Width/Height) ;
			triangle[1].y := Bottom - trunc(i*Height/Width)-1 ;
			triangle[2].x := Right-trunc(i*Width/Height)-1 ;
			triangle[2].y := Bottom - trunc(i*Height/Width)-1 ;
			Canvas.Brush.Color :=TColor(RGB(cr,cg,cb)) ;
			Canvas.Pen.Color :=Canvas.Brush.Color ;
			Canvas.Polygon(triangle);
		end;
		Canvas.Pen.Style := psSolid ;
	end;
end;

procedure DrawButton(Canvas:TCanvas;Left,Top,Right,Bottom:Integer;
                    Caption:Pchar;
                    FontName:PChar;FontColor,BackColor:TColor;
                    FontSize,FrameSize:Integer;Horz,mDown:boolean);
var
  rct , RectTemp : TRect;
  offset , Width , Height, W , H : Integer ;
begin
  Canvas.Font.Name := FontName;
  Canvas.Font.Size := FontSize;
  Canvas.Font.Color := FontColor;
  rct := Rect(Left,Top,Right,Bottom);
    SwareGradientDrawArea(Canvas,0,Left,Top,Right,Bottom,BackColor,BackColor);
  Canvas.Brush.Style := bsClear;
        if (mDown=FALSE)then begin
          offset := 0;
          Frame3D(Canvas,rct,clBtnHighLight,clBtnShadow,FrameSize);
        end
        else begin
          offset := 1;
          Frame3D(Canvas,rct,clBtnShadow,clBtnHighLight,FrameSize);
        end;
        Canvas.Brush.Color:=clBlack;
        rct.Left:=rct.Left-FrameSize ;
        rct.Top:=rct.Top-FrameSize ;
        rct.Right:=rct.Right+FrameSize ;
        rct.Bottom:=rct.Bottom+FrameSize ;
        Canvas.FrameRect(rct);
    if (not (FontColor=BackColor)) then
    begin
        Width := Right - Left ;
        Height := Bottom - Top ;
        Canvas.Brush.Style := bsClear;
        Canvas.Font.Color := FontColor;
        if (Horz=TRUE) then
        begin
            Canvas.TextOut(Left+((Width-Canvas.TextWidth(Caption)) div 2)+offset,
            Top+((Height-Canvas.TextHeight(Caption)) div 2)+offset,Caption);
        end
        else
        begin
            W := (Width-Canvas.TextWidth('GG')) div 2 ;
            H := (Height-((Canvas.TextHeight(Caption)*Length(Caption)) div 2)) div 2 ;
            RectTemp:=Rect((Left+W)+offset,(Top+H)+offset,Right-W+offset,Bottom-H+offset);
            DrawText(Canvas.Handle,Caption,Length(Caption),RectTemp,DT_EXPANDTABS or DT_WORDBREAK);
        end;
    end;
    Canvas.Brush.Style := bsSolid;
end;

procedure DrawLabel(Canvas:TCanvas;Style,Left,Top,Right,Bottom:Integer;
                    Caption:Pchar;FontName:PChar;
                    FontColor,ShadowColor,BeginColor,EndColor:TColor;
                    FontSize,FrameSize:Integer;Horz,Transparent:boolean);
var
  rct , RectTemp : TRect;
  offset , Width , Height, W , H : Integer ;
begin
  Canvas.Font.Name := FontName;
  Canvas.Font.Size := FontSize;
  Canvas.Font.Color := FontColor;
  rct := Rect(Left,Top,Right,Bottom);

  if (Transparent=false) then
	   SwareGradientDrawArea(Canvas,Style,Left,Top,Right,Bottom,BeginColor,EndColor);
  Canvas.Brush.Style := bsClear;
        if Transparent=false then
        begin
          if (FrameSize>0) then
		  begin
			Frame3D(Canvas,rct,clBtnHighLight,clBtnShadow,FrameSize);
			rct.Left:=rct.Left-FrameSize ;
			rct.Top:=rct.Top-FrameSize ;
			rct.Right:=rct.Right+FrameSize ;
			rct.Bottom:=rct.Bottom+FrameSize ;
		  end;
			Canvas.Brush.Color:=clBlack;
			Canvas.FrameRect(rct);
		end;

//DrawText
        Width := Right - Left ;
        Height := Bottom - Top ;
        Canvas.Brush.Style := bsClear;
        offset:=0;
    if (FontColor=ShadowColor) then
    begin
        Canvas.Font.Color := FontColor;
        Canvas.Font.Style:=[fsBold] ;
        if (Horz=TRUE) then
        begin
            Canvas.TextOut(Left+((Width-Canvas.TextWidth(Caption)) div 2)+offset,
            Top+((Height-Canvas.TextHeight(Caption)) div 2)+offset,Caption);
        end
        else
        begin
            W := (Width-Canvas.TextWidth('GG')) div 2 ;
            H := (Height-((Canvas.TextHeight(Caption)*Length(Caption)) div 2)) div 2 ;
            RectTemp:=Rect((Left+W)+offset,(Top+H)+offset,Right-W+offset,Bottom-H+offset);
            DrawText(Canvas.Handle,Caption,Length(Caption),RectTemp,DT_EXPANDTABS or DT_WORDBREAK);
        end;
        Canvas.Font.Style:=[] ;
    end
    else
    begin
        Canvas.Font.Color := ShadowColor;
        offset :=-1 ;
        if (Horz=TRUE) then
        begin
            Canvas.TextOut(Left+((Width-Canvas.TextWidth(Caption)) div 2)+offset,
            Top+((Height-Canvas.TextHeight(Caption)) div 2)+offset,Caption);
        end
        else
        begin
            W := (Width-Canvas.TextWidth('GG')) div 2 ;
            H := (Height-((Canvas.TextHeight(Caption)*Length(Caption)) div 2)) div 2 ;
            RectTemp:=Rect((Left+W)+offset,(Top+H)+offset,Right-W+offset,Bottom-H+offset);
            DrawText(Canvas.Handle,Caption,Length(Caption),RectTemp,DT_EXPANDTABS or DT_WORDBREAK);
        end;
        Canvas.Font.Color := FontColor;
        offset :=1 ;
        if (Horz=TRUE) then
        begin
            Canvas.TextOut(Left+((Width-Canvas.TextWidth(Caption)) div 2)+offset,
            Top+((Height-Canvas.TextHeight(Caption)) div 2)+offset,Caption);
        end
        else
        begin
            W := (Width-Canvas.TextWidth('GG')) div 2 ;
            H := (Height-((Canvas.TextHeight(Caption)*Length(Caption)) div 2)) div 2 ;
            RectTemp:=Rect((Left+W)+offset,(Top+H)+offset,Right-W+offset,Bottom-H+offset);
            DrawText(Canvas.Handle,Caption,Length(Caption),RectTemp,DT_EXPANDTABS or DT_WORDBREAK);
        end;
    end;
    Canvas.Brush.Style := bsSolid;
end;

procedure FocusRect(Canvas:TCanvas; FocusArea:TRect);
var r :Integer ;
begin
    Canvas.Pen.Width := 1 ;
    Canvas.Pen.Style := psDot ;
    Canvas.Pen.Mode := pmNot ;
    Canvas.Brush.Style := bsClear;
    Canvas.Rectangle(FocusArea.Left,FocusArea.Top,FocusArea.Right,FocusArea.Bottom);
    r := 2 ;
    Canvas.Pen.Width := 2 ;
    Canvas.Pen.Style := psSolid ;
    if ((abs(FocusArea.Left-FocusArea.Right)>5) and (abs(FocusArea.Top-FocusArea.Bottom)>5)) then
    begin
        Canvas.Rectangle(FocusArea.Left+1,FocusArea.Top+1,FocusArea.Left+r+r+1+1,FocusArea.Top+r+r+1+1);
        Canvas.Rectangle(FocusArea.Left+1,FocusArea.Bottom-r-r-1-1,FocusArea.Left+r+r+1+1,FocusArea.Bottom-1);
        Canvas.Rectangle(FocusArea.Right-r-1-r-1,FocusArea.Top+1,FocusArea.Right-1,FocusArea.Top+r+r+1+1);
        Canvas.Rectangle(FocusArea.Right-r-1-r-1,FocusArea.Bottom-r-r-r-1,FocusArea.Right-1,FocusArea.Bottom-1);
    end
    else
    begin
//        Canvas.Rectangle(FocusArea.Left-r,FocusArea.Top-r,FocusArea.Left+r+1,FocusArea.Top+r+1);
//        Canvas.Rectangle(FocusArea.Left-r,FocusArea.Bottom-r,FocusArea.Left+r+1,FocusArea.Bottom+r+1);
//        Canvas.Rectangle(FocusArea.Right-r-1,FocusArea.Top-r-1,FocusArea.Right+r,FocusArea.Top+r);
//        Canvas.Rectangle(FocusArea.Right-r-1,FocusArea.Bottom-r-1,FocusArea.Right+r,FocusArea.Bottom+r);
    end;
    Canvas.Brush.Style := bsSolid;
    Canvas.Pen.Width := 1 ;
    Canvas.Pen.Style := psSolid ;
    Canvas.Pen.Mode := pmCopy ;
end;

function  minint(a,b:Integer):Integer;
begin
    if a>b then Result:=b else Result :=b ;
end;

function InitColorStatusControl(CC: Integer): Boolean;
var
  ICC: TInitCommonControlsEx;
begin
  ICC.dwSize := SizeOf(TInitCommonControlsEx);
  ICC.dwICC := CC;
  Result := InitCommonControlsEx(ICC);
  if not Result then InitCommonControls;
end;

constructor TSwareCtl.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FBtnHiliteClr := clBtnHighLight;   //Default Hilite Color
  FBtnShadowClr := clBtnShadow;      //Default Shadow Color
  FTxtHiliteClr := clBtnHighLight;   //Default Text Hilite
  FTxtShadowClr := clBtnShadow;      //Default Text Shadow
  FBeginClr := clGreen;            //Start Color is at the Top of button
  FEndClr := clAqua;             //Stop Color is at the Bottom of button
  Height := 25;                   //Default button size
  Width := 75;
  bm := TBitmap.Create;          //Create the internal BMP
  bm.Canvas.Pen.Style:= psSolid; //These may already be the default,
  bm.Canvas.Pen.Mode:= pmCopy;   // but just in case...

  FImage  :=TBitmap.Create;
  FImage.OnChange:=ChangedImage;

  mDn := FALSE;                   //Mouse is UP to begin with
  mUp := TRUE;

//  ControlStyle := ControlStyle + [csOpaque];   //This reduces flicker
  FSwapClr := FALSE;               //By default, we swap colors on Mouse Down
  FMouseDownEffect := TRUE ;
  FTextStyle := tsNormal;         //No 3D text
  FShadeType := stLight;          //Light text shading by default
  FGradientStyle := gsNone;   //Top & Bottom to Center for gradient Fill default
  FFrameSize := 3;
  FBorderColor := clBlack ;

  Font.Color := clYellow ;
  FFontColor := Font.Color;
  FShowColor := Font.Color;

  Font.OnChange := ChangedFont ;

  FResizeBorder := 4 ;
  FDesignMode := FALSE ;
  FPosMoved := FALSE ;
  FEditSelected := FALSE ;
  CursorSaveOk := FALSE ;
  TabStop := True;
  FBlink := false ;
  FInterval :=650 ;
  FTimer := TTimer.Create(Self) ;
  FTimer.Enabled :=FBlink ;
  FTimer.OnTimer :=WCtlBlink ;
  FTimer.Interval :=FInterval ;
end;

//WndProc Added by victor Chen
procedure TSwareCtl.WndProc(var Message: TMessage);
begin
  case Message.Msg of
	WM_LBUTTONDOWN, WM_RBUTTONDOWN, WM_LBUTTONDBLCLK:
	  if not (csDesigning in ComponentState) and not Focused then
      begin
		FClicksDisabled := True;
        Windows.SetFocus(Handle);
		FClicksDisabled := False;
        if not Focused then Exit;
      end;
    CN_COMMAND:
      if FClicksDisabled then Exit;
  end;
  inherited WndProc(Message);
end;

procedure TSwareCtl.CMFocusChanged(var Message: TCMFocusChanged);
begin
  with Message do
    if Sender is TSwareCtl then
      FActive := Sender = Self
    else
      FActive := FDefault;
  SetSwareCtlStyle(FActive);
  Invalidate;
  inherited;
end;

procedure TSwareCtl.Paint;
var
  FromR, FromG, FromB : Integer; //These are the separate color values for RGB
  DiffR, DiffG, DiffB : Integer; // of color values.
  rct : TRect;                   //Rectangle used to draw frame around button
  offset : Integer;              //Used for Caption location during Mouse Down

 {To speed things up and reduce flicker, I use a Bitmap to draw the button in
 its entirety, ten BitBlt it to the canvas of the control.}
begin
	if (FDesignMode=FALSE) then
    begin
        if (CursorSaveOk=FALSE) then
		begin
			SavedCursor := Cursor ;
			CursorSaveOk := TRUE ;
		end ;
	end;

  bm.Canvas.Font := Font;     // Set the Bitmap font to match control font
  bm.Canvas.Font.Color := FShowColor; //Keep Bitmap in synch with settings.
  bm.Width := Width;          //Set BMP dimensions to match control's
  bm.Height := Height;
  rct := Rect(0,0,Width,Height);  //Set rectangle size for later use
  case FGradientStyle of
	   gsNone      : SwareGradientDrawArea(bm.Canvas,0,0,0,Width,Height,FBeginClr,FBeginClr);
	   gsTextOnly  : SwareGradientDrawArea(bm.Canvas,0,0,0,Width,Height,FBeginClr,FBeginClr) ;
	   gsHorizontal: SwareGradientDrawRect(bm.Canvas,1,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsVertical  : SwareGradientDrawRect(bm.Canvas,2,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsElliptic  :
	   begin
			  FromR := FBeginClr and $000000ff;  //Strip out separate RGB values
			  FromG := (FBeginClr shr 8) and $000000ff;
			  FromB := (FBeginClr shr 16) and $000000ff;
			  DiffR := (FEndClr and $000000ff) - FromR;   //Find the difference
			  DiffG := ((FEndClr shr 8) and $000000ff) - FromG;
			  DiffB := ((FEndClr shr 16) and $000000ff) - FromB;
			  DoElliptic(FromR, FromG, FromB, DiffR, DiffG, DiffB);
	   end;
	   gsRectangle : SwareGradientDrawRect(bm.Canvas,3,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsVertCenter: SwareGradientDrawRect(bm.Canvas,4,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsHorizCenter:SwareGradientDrawRect(bm.Canvas,5,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsLeftTop    :SwareGradientDrawRect(bm.Canvas,6,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsRightTop   :SwareGradientDrawRect(bm.Canvas,7,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsLeftTopRightBottom: SwareGradientDrawRect(bm.Canvas,8,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsRightTopLeftBottom: SwareGradientDrawRect(bm.Canvas,9,0,0,Width,Height,0,FBeginClr,FEndClr) ;
  end;

  //By setting the Brush style to Clear, it will draw without overlaying bkgrnd
  bm.Canvas.Brush.Style := bsClear;  //Gradient is done, time for Hilite-Shadow
  case FGradientStyle of
	gsImage : BitBlt(bm.Canvas.Handle,0,0,Width,Height,FImage.Canvas.Handle,0,0,SRCCOPY);
	gsTextOnly : begin
				  if mUp = TRUE then offset := 0 else offset := 1;
				  DoNorm(offset);
				 end ;
  else
	  begin
        if ((mUp=TRUE) or (FMouseDownEffect=False)) then begin       //If Mouse up do normal button
          offset := 0;  //offset is used to move the Caption down a notch when the
                  // button is pressed.
          Frame3D(bm.Canvas,rct,FBtnHiliteClr,FBtnShadowClr,FFrameSize); //Draw frame
        end
        else begin
          offset := 1; //If mouse down, we want caption to 'move' and reverse the frame
          Frame3D(bm.Canvas,rct,FBtnShadowClr,FBtnHiliteClr,FFrameSize);
        end;
        bm.Canvas.Brush.Color:=FBorderColor;
        rct.Left:=rct.Left-FFrameSize ;
        rct.Top:=rct.Top-FFrameSize ;
        rct.Right:=rct.Right+FFrameSize ;
        rct.Bottom:=rct.Bottom+FFrameSize ;
        bm.Canvas.FrameRect(rct);

        if FTextStyle = tsRaised then DoRaise(offset);  //Based on style, we draw
        if FTextStyle = tsInset then DoInset(offset);   // the caption on the
        if FTextStyle = tsNormal then DoNorm(offset);   // button
	  end;
    end ;

  if FDesignMode = FALSE then begin if FActive then DoFocusRect ; end ;
  if ((FDesignMode = TRUE) and (FEditSelected = TRUE)) then
  begin
	bm.Canvas.Brush.Style := bsClear;
	bm.Canvas.Pen.Color := clBlue ;
	bm.Canvas.Pen.Mode := pmCopy ;
	bm.Canvas.Pen.Width := 1 ;
	bm.Canvas.Pen.Style := psDot ;
	bm.Canvas.Rectangle(1,1,Width-1,Height-1) ;
	bm.Canvas.Pen.Style := psSolid ;
	bm.Canvas.Brush.Style := bsSolid;
  end;

  BitBlt(Canvas.Handle,0,0,Width,Height,bm.Canvas.Handle,0,0,SRCCOPY);
end;

procedure TSwareCtl.SetDesignMode(Value: boolean);
begin
  if FDesignMode <> Value then
  begin
	FDesignMode := Value;
    Invalidate;
  end;
end;

procedure TSwareCtl.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  if FDesignMode and Enabled then
  begin
    if FEditSelected=False then
    begin
        FEditSelected:=True;
        Repaint;
    end;
  end;
end;

procedure TSwareCtl.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if Enabled then
  begin
    if FEditSelected=True then
    begin
        FEditSelected:=False;
        Invalidate;
    end;
  end;
end;

procedure TSwareCtl.SetEditSelected(Value: boolean);
begin
  if FEditSelected <> Value then
  begin
	FEditSelected := Value;
	Invalidate;
  end;
end;

procedure TSwareCtl.SetSwareCommand(Value: String);
begin
	FSwareCommand := Value;
end;

procedure TSwareCtl.SetResizeBorder(Value: Integer);
begin
  if FResizeBorder <> Value then
  begin
    FResizeBorder := Value;
    Invalidate;
  end;
end;

procedure TSwareCtl.SetBtnHilite(Value: TColor);
begin
  if FBtnHiliteClr <> Value then begin
    FBtnHiliteClr := Value;
	Invalidate;  //Invalidate tells windows to do a Paint.  Our control
  end;           // goes through its Paint procedure.
end;

procedure TSwareCtl.SetBtnShadow(Value: TColor);
begin
  if FBtnShadowClr <> Value then begin
    FBtnShadowClr := Value;
    Invalidate;
  end;
end;

procedure TSwareCtl.SetTxtHilite(Value: TColor);
begin
  if FTxtHiliteClr <> Value then begin
    FTxtHiliteClr := Value;
    Invalidate;
  end;
end;

procedure TSwareCtl.SetTxtShadow(Value: TColor);
begin
  if FTxtShadowClr <> Value then begin
    FTxtShadowClr := Value;
    Invalidate;
  end;
end;

procedure TSwareCtl.SetBeginClr(Value : TColor);
begin
  if FBeginClr <> Value then begin
    FBeginClr := Value;
    Invalidate;
  end;
end;

procedure TSwareCtl.SetEndClr(Value : TColor);
begin
  if FEndClr <> Value then begin
    FEndClr := Value;
    Invalidate;
  end;
end;

procedure TSwareCtl.SetSwap(Value : Boolean);
begin
  if FSwapClr <> Value then
    FSwapClr := Value;
end;

procedure TSwareCtl.SetMouseDownEffect(Value : Boolean);
begin
  if FMouseDownEffect <> Value then
    FMouseDownEffect := Value;
end;

procedure TSwareCtl.WCtlBlink(Sender : TObject) ;
begin
      if FShowColor = FFontColor then
		FShowColor := FBeginClr
      else
		FShowColor := FFontColor ;
    Invalidate ;
end;

procedure TSwareCtl.ChangedFont(Sender:TObject);
begin
    FFontColor := Font.Color;
    FShowColor := Font.Color;
    Invalidate ;
end;

procedure TSwareCtl.SetBlink(Value: Boolean);
begin
  if FBlink <> Value then
  begin
    FBlink := Value;
    FTimer.Enabled := Value;
    if not FTimer.Enabled then
    begin
        FShowColor := FFontColor ;
        Invalidate ;
    end;
  end;
end;

procedure TSwareCtl.SetInterval(Value: Word);
begin
  if FInterval <> Value then
  begin
    FInterval := Value;
    FTimer.Interval := Value;
  end;
end;

procedure TSwareCtl.MouseDown(Button:TMouseButton; Shift: TShiftState;
      X, Y: Integer);
begin
  if ((FDesignMode = TRUE) and (FEditSelected=TRUE)) then
  begin
	if (Button=mbLeft) then
	begin
		mDn := TRUE;
		mUp := FALSE;
		MouseDownX := X ;
		MouseDownY := Y ;
	end;
	Invalidate;
	Exit ;
  end;
  inherited;
  mDn := TRUE;
  mUp := FALSE;
  if FSwapClr = TRUE then begin    //If SwapClrs is true, we need to save
    TmpClr := FBeginClr;           // the original stuff.  Hence, TmpClr
    FBeginClr := FEndClr;
    FEndClr := TmpClr;
  end;
  Invalidate;
end;

//procedure TSwareCtl.Click;
//begin
//  if FDesignMode = TRUE then
//  begin
//        Exit ;
//  end;
//  inherited;
////  Invalidate;
//end;

procedure TSwareCtl.MouseMove(Shift: TShiftState;
	  X, Y: Integer);
begin
  if ((FDesignMode = TRUE) and (FEditSelected=TRUE)) then
  begin
	if (mDn=TRUE) then
	begin
	if ((MouseDownX=X) and (MouseDownY=Y)) then Exit ;
	FPosMoved:=TRUE;
		case FReSizing of
            0:
                begin
                    Cursor := crDefault ;
                    Left := Left+(X-MouseDownX) ;
                    Top := Top+(Y-MouseDownY) ;
                end;
			1:
                begin
                    Width := Width-(X-MouseDownX) ;
                    Height := Height-(Y-MouseDownY) ;
                    Left := Left+(X-MouseDownX) ;
					Top := Top+(Y-MouseDownY) ;
                end;
            2:
                begin
                    Width := Width-(X-MouseDownX) ;
                    Left := Left+(X-MouseDownX) ;
                end;
			3:
				begin
					Width := Width-(X-MouseDownX) ;
                    Height := Y ;
                    Left := Left+(X-MouseDownX) ;
				end;
            4:
                begin
                    Height := Y ;
                end;
            5:
                begin
                    Width := X ;
					Height := Y ;
                end;
            6:
                begin
                    Width := X ;
				end;
            7:
                begin
                    Width := X ;
                    Height := Height-(Y-MouseDownY) ;
                    Top := Top+(Y-MouseDownY) ;
                end;
			8:
				begin
					Height := Height-(Y-MouseDownY) ;
                    Top := Top+(Y-MouseDownY) ;
                end;
        end;
        if (Width<1) then Width := 1 ;
        if (Height<1) then Height := 1 ;
		Exit ;
    end
    else
    begin
	FReSizing := 0 ;
        Cursor := crDefault ;
        Exit ;
        if (X<FResizeBorder) then
		begin
            if (Y<FResizeBorder) then begin Cursor := crSizeNWSE ; FReSizing := 1 ; Exit ;end;
            if (Y>(Height-FResizeBorder)) then begin Cursor := crSizeNESW ;  FReSizing := 3 ; Exit ;end;
            Cursor := crSizeWE ;  FReSizing := 2; Exit ;
        end;
		if (X>Width-FResizeBorder) then
        begin
            if (Y<FResizeBorder) then begin Cursor := crSizeNESW ;  FReSizing := 7 ; Exit ;end;
            if (Y>(Height-FResizeBorder)) then begin Cursor := crSizeNWSE ;  FReSizing := 5 ; Exit ;end;
            Cursor := crSizeWE ;  FReSizing := 6 ; Exit ;
        end;
        if (Y<FResizeBorder) then begin Cursor := crSizeNS ;  FReSizing := 8 ; Exit ;end;
		if (Y>(Height-FResizeBorder)) then begin Cursor := crSizeNS ;  FReSizing := 4 ; Exit ;end;
		FReSizing := 0 ;
        Cursor := crDefault ;
        Exit ;
    end;
  end;
    Cursor := SavedCursor ;
    inherited;
//  Invalidate;
end;

procedure TSwareCtl.MouseUp;
begin
  mUp := TRUE;
  mDn := FALSE;
  if ((FDesignMode = TRUE) and (FEditSelected=TRUE)) then
  begin
	  Invalidate;
	if Assigned(FOnPosChanged) and FPosMoved=TRUE then FOnPosChanged(Self, Left,Top);
	FPosMoved :=FALSE ;
	  Exit ;
  end;
  inherited;
  if FSwapClr = TRUE then
  begin
	TmpClr := FBeginClr;
	FBeginClr := FEndClr;
	FEndClr := TmpClr;
  end;
  Invalidate;
end;

procedure TSwareCtl.CMTextChanged(var Msg:TMessage);
begin
  Inherited;
  Invalidate;
end;

procedure TSwareCtl.WMEraseBkgnd(var Msg:TMessage);
begin
  Msg.Result := 0;  //We intercept this message and tell
end;                // Windows it processed OK.

procedure TSwareCtl.SetSwareCtlStyle(ADefault: Boolean);
const
  BS_MASK = $000F;
var
  Style: Word;
begin
  if HandleAllocated then
  begin
    if ADefault then Style := BS_DEFPUSHBUTTON else Style := BS_PUSHBUTTON;
    if GetWindowLong(Handle, GWL_STYLE) and BS_MASK <> Style then
      SendMessage(Handle, BM_SETSTYLE, Style, 1);
  end;
end;

procedure TSwareCtl.SetDefault(Value: Boolean);
var
  Form: TCustomForm;
begin
  FDefault := Value;
  if HandleAllocated then
  begin
    Form := GetParentForm(Self);
    if Form <> nil then
      Form.Perform(CM_FOCUSCHANGED, 0, Longint(Form.ActiveControl));
  end;
end;

procedure TSwareCtl.SetGradient(Value : TGradientStyle);
begin
  if FGradientStyle <> Value then begin
    FGradientStyle := Value;
    Invalidate;
  end;
end;

procedure TSwareCtl.SetStyle(Value: TTextStyle);
begin
  if FTextStyle <> Value then begin
    FTextStyle := Value;
    Invalidate;
  end;
end;

procedure TSwareCtl.SetShade(Value: TShadeType);
begin
  {When user selects a shade, set the variable to new type and do
   an invalidate to force a re-paint of the component.}
  if FShadeType <> Value then begin
    FShadeType := Value;
    Invalidate;
  end;
end;

procedure TSwareCtl.SetLayout(Value: TTextLayout);  //Add by Victor Chen
begin
  if FTextLayout <> Value then begin
    FTextLayout := Value;
	Invalidate;
  end;
end;

procedure TSwareCtl.SetFrameSize(Value: Integer);  //Add by Victor Chen
begin
  if FFrameSize <> Value then
  begin
    FFrameSize := Value;
    if FFrameSize > 10 then FFrameSize := 3;
    if FFrameSize < 1 then FFrameSize := 3;
    Invalidate;
  end;
end;

procedure TSwareCtl.SetBorderColor(Value: TColor);  //Add by Victor Chen
begin
  if FBorderColor <> Value then
  begin
    FBorderColor := Value;
    Invalidate;
  end;
end;

procedure TSwareCtl.SetImage(Value: TBitmap);
begin
  if Assigned(Value) then
    FImage.Assign(Value)
  else
  begin
    FImage.Height:=0;
    FImage.Width:=0;
  end;
end;

procedure TSwareCtl.ChangedImage(Sender:TObject);
begin
  Invalidate;
end;

procedure TSwareCtl.DoElliptic(fr, fg, fb, dr, dg, db : Integer);
var
  I: Integer;
  R, G, B : Byte;
  Pw, Ph : Real;
  x1,y1,x2,y2 : Real;
{The elliptic is a bit different, since I had to use real numbers. I cut down
 on the number (to 155 instead of 255) of iterations in an attempt to speed
 things up, to no avail.  I think it just takes longer for windows to draw an
 ellipse as opposed to a rectangle.}
begin
  bm.Canvas.Pen.Style := psClear;
  bm.Canvas.Pen.Mode := pmCopy;
  x1 := 0 - (bm.Width / 4);
  x2 := bm.Width + (bm.Width / 4);
  y1 := 0 - (bm.Height / 4);
  y2 := bm.Height + (bm.Height / 4);
  Pw := ((bm.Width / 4) + (bm.Width / 2)) / 155;
  Ph := ((bm.Height / 4) + (bm.Height / 2)) / 155;
  for I := 0 to 155 do begin         //Make ellipses of color
    x1 := x1 + Pw;
    x2 := X2 - Pw;
	y1 := y1 + Ph;
    y2 := y2 - Ph;
    R := fr + MulDiv(I, dr, 155);    //Find the RGB values
    G := fg + MulDiv(I, dg, 155);
	B := fb + MulDiv(I, db, 155);
	bm.Canvas.Brush.Color := R or (G shl 8) or (b shl 16);   //Plug colors into brush
	bm.Canvas.Ellipse(Trunc(x1),Trunc(y1),Trunc(x2),Trunc(y2));
  end;
  bm.Canvas.Pen.Style := psSolid;
end;

procedure TSwareCtl.DoRaise(offset: Integer);
var
   StrText  :array[0..255] of char ;
   RectTemp :TRect ;
begin
    GetTextBuf(StrText , Sizeof(StrText)) ;
    bm.Canvas.Brush.Style := bsClear;
    bm.Canvas.Font.Color := FTxtHiliteClr;
    if (FTextLayout=tlLeftRight) then
    begin
        bm.Canvas.TextOut(((bm.Width-bm.Canvas.TextWidth(Caption)) div 2)-1+offset,
        ((bm.Height-bm.Canvas.TextHeight(Caption)) div 2)-1+offset,Caption);
        if FShadeType = stHeavy then
        begin
            bm.Canvas.Font.Color := FTxtShadowClr;
            bm.Canvas.TextOut(((bm.Width-bm.Canvas.TextWidth(Caption)) div 2)+1+offset,
            ((bm.Height-bm.Canvas.TextHeight(Caption)) div 2)+1+offset,Caption);
        end;
        bm.Canvas.Font.Color := FShowColor;
        bm.Canvas.TextOut(((bm.Width-bm.Canvas.TextWidth(Caption)) div 2)+offset,
        ((bm.Height-bm.Canvas.TextHeight(Caption)) div 2)+offset,Caption);
        bm.Canvas.Brush.Style := bsSolid;
    end
    else
    begin
        RectTemp:=Rect(((bm.Width-bm.Canvas.TextWidth('GG')) div 2)-1+offset,
        ((bm.Height-((bm.Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2)-1+offset,
        bm.Width,bm.Height);
        DrawText(bm.Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK) ;
        if FShadeType = stHeavy then
        begin
            bm.Canvas.Font.Color := FTxtShadowClr;
        RectTemp:=Rect(((bm.Width-bm.Canvas.TextWidth('GG')) div 2)+1+offset,
        ((bm.Height-((bm.Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2)+1+offset,
        bm.Width,bm.Height);
        DrawText(bm.Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK) ;
        end;
        bm.Canvas.Font.Color := FShowColor;
        RectTemp:=Rect(((bm.Width-bm.Canvas.TextWidth('GG')) div 2)+offset,
        ((bm.Height-((bm.Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2)+offset,
        bm.Width,bm.Height);
        DrawText(bm.Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK) ;
    end;
    bm.Canvas.Brush.Style := bsSolid;
end;

procedure TSwareCtl.DoInset(offset: Integer);
var
   StrText  :array[0..255] of char ;
   RectTemp :TRect ;
begin
    GetTextBuf(StrText , Sizeof(StrText)) ;
  bm.Canvas.Brush.Style := bsClear;
    if (FTextLayout=tlLeftRight) then
    begin
        if FShadeType = stHeavy then begin
        bm.Canvas.Font.Color := FTxtShadowClr;
        bm.Canvas.TextOut(((bm.Width-bm.Canvas.TextWidth(Caption)) div 2)-1+offset,
          ((bm.Height-bm.Canvas.TextHeight(Caption)) div 2)-1+offset,Caption);
        end;
        bm.Canvas.Font.Color := FTxtHiliteClr;
        bm.Canvas.TextOut(((bm.Width-bm.Canvas.TextWidth(Caption)) div 2)+1+offset,
        ((bm.Height-bm.Canvas.TextHeight(Caption)) div 2)+1+offset,Caption);
        bm.Canvas.Font.Color := FShowColor;
        bm.Canvas.TextOut(((bm.Width-bm.Canvas.TextWidth(Caption)) div 2)+offset,
        ((bm.Height-bm.Canvas.TextHeight(Caption)) div 2)+offset,Caption);
    end
    else
    begin
        if FShadeType = stHeavy then begin
        bm.Canvas.Font.Color := FTxtShadowClr;
        RectTemp:=Rect(((bm.Width-bm.Canvas.TextWidth('GG')) div 2)-1+offset,
        ((bm.Height-((bm.Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2)-1+offset,
        bm.Width,bm.Height);
        DrawText(bm.Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK) ;
        end;
        bm.Canvas.Font.Color := FTxtHiliteClr;
        RectTemp:=Rect(((bm.Width-bm.Canvas.TextWidth('GG')) div 2)+1+offset,
        ((bm.Height-((bm.Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2)+1+offset,
        bm.Width,bm.Height);
        DrawText(bm.Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK) ;
        bm.Canvas.Font.Color := FShowColor;
        RectTemp:=Rect(((bm.Width-bm.Canvas.TextWidth('GG')) div 2)+offset,
        ((bm.Height-((bm.Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2)+offset,
        bm.Width,bm.Height);
        DrawText(bm.Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK) ;
    end;
  bm.Canvas.Brush.Style := bsSolid;
end;

procedure TSwareCtl.DoNorm(offset: Integer);
var
   StrText  :array[0..255] of char ;
   RectTemp :TRect ;
begin
    GetTextBuf(StrText , Sizeof(StrText)) ;
    bm.Canvas.Brush.Style := bsClear;
    bm.Canvas.Font.Color := FShowColor;
    if (FTextLayout=tlLeftRight) then
    begin
    bm.Canvas.TextOut(((bm.Width-bm.Canvas.TextWidth(Caption)) div 2)+offset,
      ((bm.Height-bm.Canvas.TextHeight(Caption)) div 2)+offset,Caption);
    end
    else
    begin
        RectTemp:=Rect(((bm.Width-bm.Canvas.TextWidth('GG')) div 2)+offset,
        ((bm.Height-((bm.Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2)+offset,
        bm.Width,bm.Height);
        DrawText(bm.Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK);
    end;
    bm.Canvas.Brush.Style := bsSolid;
end;

procedure TSwareCtl.DoFocusRect ;
var
   RectTemp :TRect ;
   i        :integer;
begin
     case FGradientStyle of
         gsImage,gsTextOnly : i:=2;
     else i:= Round(FFrameSize*1.6);
     end;

       begin
        RectTemp.Left:=i ;
        RectTemp.Top:=i ;
        RectTemp.Right:=bm.Width-i ;
        RectTemp.Bottom:=bm.Height-i ;
        if((RectTemp.Right>RectTemp.Left) and (RectTemp.Bottom>RectTemp.Top)) then
        begin
            bm.Canvas.DrawFocusRect(RectTemp);
        end;
       end;
end;

destructor TSwareCtl.Destroy;
begin
  bm.Free;       //Cleanup the bitmap - no memory leaks
  FImage.Free;
  FTimer.Free;
  inherited Destroy;
end;


constructor TSwareLabel.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FBtnHiliteClr := clBtnHighLight;   //Default Hilite Color
  FBtnShadowClr := clBtnShadow;      //Default Shadow Color
  FTxtHiliteClr := clGray;   //Default Text Hilite
  FTxtShadowClr := clBtnShadow;      //Default Text Shadow
  FBeginClr := clGreen;            //Start Color is at the Top of button
  FEndClr := clYellow;             //Stop Color is at the Bottom of button
  Height := 25;                   //Default button size
  Width := 75;
  Canvas.Pen.Style:= psSolid; //These may already be the default,
  Canvas.Pen.Mode:= pmCopy;   // but just in case...
  AutoSize :=false ;

	FResizeBorder:=4;
	FDesignMode:=FALSE;
  FPosMoved := FALSE ;
  FEditSelected := FALSE ;
	CursorSaveOk:=FALSE;
	mDn:=FALSE ;
	mUp:=TRUE ;

  Font.Color := clBlue;          //Default Font Color
//  ControlStyle := ControlStyle + [csOpaque];   //This reduces flicker
  FTextStyle := tsNormal;         //No 3D text
  FShadeType := stLight;          //Light text shading by default
  FGradientStyle := gsVertCenter;   //Top & Bottom to Center for gradient Fill default
  FFrameSize := 3;
  FShadowOffset :=2;
  FBorderColor := clBlack ;
  FDrawBorder :=true ;
end;

procedure TSwareLabel.Paint;
var
  FromR, FromG, FromB : Integer; //These are the separate color values for RGB
  DiffR, DiffG, DiffB : Integer; // of color values.
  rct : TRect;                   //Rectangle used to draw frame around button
begin
	if (FDesignMode=FALSE) then
    begin
        if (CursorSaveOk=FALSE) then
		begin
            SavedCursor := Cursor ;
            CursorSaveOk := TRUE ;
        end ;
    end;
  Canvas.Font.Color := Font.Color; //Keep Bitmap in synch with settings.
  Canvas.Font := Font;     // Set the Bitmap font to match control font
  Width := Width;          //Set BMP dimensions to match control's
  Height := Height;
  rct := Rect(0,0,Width,Height);  //Set rectangle size for later use
  if (Transparent=false) then
  begin
  case FGradientStyle of
	   gsNone      : SwareGradientDrawArea(Canvas,0,0,0,Width,Height,FBeginClr,FBeginClr);
	   gsTextOnly  : SwareGradientDrawArea(Canvas,0,0,0,Width,Height,FBeginClr,FBeginClr) ;
	   gsHorizontal: SwareGradientDrawRect(Canvas,1,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsVertical  : SwareGradientDrawRect(Canvas,2,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsElliptic  :
	   begin
			  FromR := FBeginClr and $000000ff;  //Strip out separate RGB values
			  FromG := (FBeginClr shr 8) and $000000ff;
			  FromB := (FBeginClr shr 16) and $000000ff;
			  DiffR := (FEndClr and $000000ff) - FromR;   //Find the difference
			  DiffG := ((FEndClr shr 8) and $000000ff) - FromG;
			  DiffB := ((FEndClr shr 16) and $000000ff) - FromB;
			  DoElliptic(FromR, FromG, FromB, DiffR, DiffG, DiffB);
	   end;
	   gsRectangle : SwareGradientDrawRect(Canvas,3,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsVertCenter: SwareGradientDrawRect(Canvas,4,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsHorizCenter:SwareGradientDrawRect(Canvas,5,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsLeftTop    :SwareGradientDrawRect(Canvas,6,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsRightTop   :SwareGradientDrawRect(Canvas,7,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsLeftTopRightBottom: SwareGradientDrawRect(Canvas,8,0,0,Width,Height,0,FBeginClr,FEndClr) ;
	   gsRightTopLeftBottom: SwareGradientDrawRect(Canvas,9,0,0,Width,Height,0,FBeginClr,FEndClr) ;
  end;
  end;
  //By setting the Brush style to Clear, it will draw without overlaying bkgrnd
  Canvas.Brush.Style := bsClear;  //Gradient is done, time for Hilite-Shadow
  case FGradientStyle of
	gsTextOnly : begin
                  DoNorm(FShadowOffset);
				 end ;
  else
      begin
        if Transparent=false then
        begin
          if (FFrameSize>0) then
		  begin
			Frame3D(Canvas,rct,FBtnHiliteClr,FBtnShadowClr,FFrameSize);
			rct.Left:=rct.Left-FFrameSize ;
			rct.Top:=rct.Top-FFrameSize ;
			rct.Right:=rct.Right+FFrameSize ;
			rct.Bottom:=rct.Bottom+FFrameSize ;
		  end;
		  if FDrawBorder=true then
		  begin
			Canvas.Brush.Color:=FBorderColor;
			Canvas.FrameRect(rct);
		  end;
		end;

		if FTextStyle = tsRaised then DoRaise(FShadowOffset);  //Based on style, we draw
		if FTextStyle = tsInset then  DoInset(FShadowOffset);   // the caption on the
		if FTextStyle = tsNormal then DoNorm(FShadowOffset);   //
	  end;
	end ;
  if ((FDesignMode = TRUE) and (FEditSelected = TRUE)) then
  begin
	Canvas.Brush.Style := bsClear;
	Canvas.Pen.Color := clBlue ;
	Canvas.Pen.Mode := pmCopy ;
	Canvas.Pen.Width := 1 ;
	Canvas.Pen.Style := psDot ;
	Canvas.Rectangle(1,1,Width-1,Height-1) ;
	Canvas.Pen.Style := psSolid ;
	Canvas.Brush.Style := bsSolid;
  end;
end;

procedure TSwareLabel.SetBtnHilite(Value: TColor);
begin
  if FBtnHiliteClr <> Value then begin
	FBtnHiliteClr := Value;
	Invalidate;  //Invalidate tells windows to do a Paint.  Our control
  end;           // goes through its Paint procedure.
end;

procedure TSwareLabel.SetBtnShadow(Value: TColor);
begin
  if FBtnShadowClr <> Value then begin
    FBtnShadowClr := Value;
    Invalidate;
  end;
end;

procedure TSwareLabel.SetTxtHilite(Value: TColor);
begin
  if FTxtHiliteClr <> Value then begin
    FTxtHiliteClr := Value;
    Invalidate;
  end;
end;

procedure TSwareLabel.SetTxtShadow(Value: TColor);
begin
  if FTxtShadowClr <> Value then begin
    FTxtShadowClr := Value;
    Invalidate;
  end;
end;

procedure TSwareLabel.SetBeginClr(Value : TColor);
begin
  if FBeginClr <> Value then begin
    FBeginClr := Value;
    Invalidate;
  end;
end;

procedure TSwareLabel.SetEndClr(Value : TColor);
begin
  if FEndClr <> Value then begin
    FEndClr := Value;
    Invalidate;
  end;
end;

procedure TSwareLabel.CMTextChanged(var Msg:TMessage);
begin
  Inherited;
  Invalidate;
end;

procedure TSwareLabel.WMEraseBkgnd(var Msg:TMessage);
begin
  Msg.Result := 0;  //We intercept this message and tell
end;                // Windows it processed OK.

procedure TSwareLabel.SetGradient(Value : TGradientStyle);
begin
  if FGradientStyle <> Value then begin
    FGradientStyle := Value;
    Invalidate;
  end;
end;

procedure TSwareLabel.SetStyle(Value: TTextStyle);
begin
  if FTextStyle <> Value then begin
    FTextStyle := Value;
    Invalidate;
  end;
end;

procedure TSwareLabel.SetShade(Value: TShadeType);
begin
  {When user selects a shade, set the variable to new type and do
   an invalidate to force a re-paint of the component.}
  if FShadeType <> Value then begin
    FShadeType := Value;
    Invalidate;
  end;
end;

procedure TSwareLabel.SetLayout(Value: TTextLayout);  //Add by Victor Chen
begin
  if FTextLayout <> Value then begin
    FTextLayout := Value;
    Invalidate;
  end;
end;

procedure TSwareLabel.SetFrameSize(Value: Integer);  //Add by Victor Chen
begin
  if FFrameSize <> Value then
  begin
    FFrameSize := Value;
    if FFrameSize > 10 then FFrameSize := 3;
    if FFrameSize < 0 then FFrameSize := 3;
    Invalidate;
  end;
end;

procedure TSwareLabel.SetShadowOffset(Value: Integer);  //Add by Victor Chen
begin
  if FShadowOffset <> Value then
  begin
    FShadowOffset := Value;
    if FShadowOffset > 10 then FShadowOffset := 2;
    if FShadowOffset < 1 then FShadowOffset := 2;
    Invalidate;
  end;
end;

procedure TSwareLabel.SetBorderColor(Value: TColor);  //Add by Victor Chen
begin
  if FBorderColor <> Value then
  begin
    FBorderColor := Value;
    Invalidate;
  end;
end;

procedure TSwareLabel.SetDrawBorder(Value: Boolean);  //Add by Victor Chen
begin
  if FDrawBorder <> Value then
  begin
	FDrawBorder := Value;
	Invalidate;
  end;
end;

procedure TSwareLabel.DoElliptic(fr, fg, fb, dr, dg, db : Integer);
var
  I: Integer;
  R, G, B : Byte;
  Pw, Ph : Real;
  x1,y1,x2,y2 : Real;
{The elliptic is a bit different, since I had to use real numbers. I cut down
 on the number (to 155 instead of 255) of iterations in an attempt to speed
 things up, to no avail.  I think it just takes longer for windows to draw an
 ellipse as opposed to a rectangle.}
begin
  Canvas.Pen.Style := psClear;
  Canvas.Pen.Mode := pmCopy;
  x1 := 0 - (Width / 4);
  x2 := Width + (Width / 4);
  y1 := 0 - (Height / 4);
  y2 := Height + (Height / 4);
  Pw := ((Width / 4) + (Width / 2)) / 155;
  Ph := ((Height / 4) + (Height / 2)) / 155;
  for I := 0 to 155 do begin         //Make ellipses of color
    x1 := x1 + Pw;
    x2 := X2 - Pw;
    y1 := y1 + Ph;
    y2 := y2 - Ph;
    R := fr + MulDiv(I, dr, 155);    //Find the RGB values
    G := fg + MulDiv(I, dg, 155);
    B := fb + MulDiv(I, db, 155);
    Canvas.Brush.Color := R or (G shl 8) or (b shl 16);   //Plug colors into brush
	Canvas.Ellipse(Trunc(x1),Trunc(y1),Trunc(x2),Trunc(y2));
  end;
  Canvas.Pen.Style := psSolid;
end;

procedure TSwareLabel.DoRaise(offset: Integer);
var
   StrText  :array[0..255] of char ;
   RectTemp :TRect ;
begin
	GetTextBuf(StrText , Sizeof(StrText)) ;
	Canvas.Brush.Style := bsClear;
    Canvas.Font.Color := FTxtHiliteClr;
    if (FTextLayout=tlLeftRight) then
    begin
        Canvas.TextOut(((Width-Canvas.TextWidth(Caption)) div 2),
        ((Height-Canvas.TextHeight(Caption)) div 2),Caption);
        if FShadeType = stHeavy then
        begin
            Canvas.Font.Color := FTxtShadowClr;
            Canvas.TextOut(((Width-Canvas.TextWidth(Caption)) div 2)+2*offset,
            ((Height-Canvas.TextHeight(Caption)) div 2)+2*offset,Caption);
        end;
        Canvas.Font.Color := Font.Color;
        Canvas.TextOut(((Width-Canvas.TextWidth(Caption)) div 2)+offset,
        ((Height-Canvas.TextHeight(Caption)) div 2)+offset,Caption);
        Canvas.Brush.Style := bsSolid;
    end
    else
    begin
        RectTemp:=Rect(((Width-Canvas.TextWidth('GG')) div 2),
        ((Height-((Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2),
        Width,Height);
        DrawText(Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK) ;
        if FShadeType = stHeavy then
        begin
            Canvas.Font.Color := FTxtShadowClr;
        RectTemp:=Rect(((Width-Canvas.TextWidth('GG')) div 2)+2*offset,
        ((Height-((Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2)+2*offset,
		Width,Height);
        DrawText(Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK) ;
        end;
        Canvas.Font.Color := Font.Color;
        RectTemp:=Rect(((Width-Canvas.TextWidth('GG')) div 2)+offset,
        ((Height-((Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2)+offset,
        Width,Height);
        DrawText(Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK) ;
    end;
    Canvas.Brush.Style := bsSolid;
end;

procedure TSwareLabel.DoInset(offset: Integer);
var
   StrText  :array[0..255] of char ;
   RectTemp :TRect ;
begin
    GetTextBuf(StrText , Sizeof(StrText)) ;
  Canvas.Brush.Style := bsClear;
    if (FTextLayout=tlLeftRight) then
    begin
        if FShadeType = stHeavy then begin
        Canvas.Font.Color := FTxtShadowClr;
        Canvas.TextOut(((Width-Canvas.TextWidth(Caption)) div 2),
          ((Height-Canvas.TextHeight(Caption)) div 2),Caption);
        end;
        Canvas.Font.Color := FTxtHiliteClr;
        Canvas.TextOut(((Width-Canvas.TextWidth(Caption)) div 2)+2*offset,
		((Height-Canvas.TextHeight(Caption)) div 2)+2*offset,Caption);
        Canvas.Font.Color := Font.Color;
        Canvas.TextOut(((Width-Canvas.TextWidth(Caption)) div 2)+offset,
        ((Height-Canvas.TextHeight(Caption)) div 2)+offset,Caption);
    end
    else
    begin
        if FShadeType = stHeavy then begin
        Canvas.Font.Color := FTxtShadowClr;
        RectTemp:=Rect(((Width-Canvas.TextWidth('GG')) div 2),
        ((Height-((Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2),
        Width,Height);
        DrawText(Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK) ;
        end;
        Canvas.Font.Color := FTxtHiliteClr;
        RectTemp:=Rect(((Width-Canvas.TextWidth('GG')) div 2)+2*offset,
        ((Height-((Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2)+2*offset,
        Width,Height);
        DrawText(Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK) ;
        Canvas.Font.Color := Font.Color;
        RectTemp:=Rect(((Width-Canvas.TextWidth('GG')) div 2)+offset,
        ((Height-((Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2)+offset,
        Width,Height);
        DrawText(Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK) ;
    end;
  Canvas.Brush.Style := bsSolid;
end;

procedure TSwareLabel.DoNorm(offset: Integer);
var
   StrText  :array[0..255] of char ;
   RectTemp :TRect ;
begin
    GetTextBuf(StrText , Sizeof(StrText)) ;
    Canvas.Brush.Style := bsClear;
    Canvas.Font.Color := Font.Color;
    if (FTextLayout=tlLeftRight) then
    begin
    Canvas.TextOut(((Width-Canvas.TextWidth(Caption)) div 2)+offset,
      ((Height-Canvas.TextHeight(Caption)) div 2)+offset,Caption);
    end
    else
    begin
        RectTemp:=Rect(((Width-Canvas.TextWidth('GG')) div 2)+offset,
        ((Height-((Canvas.TextHeight(Caption)*Length(StrText)) div 2)) div 2)+offset,
        Width,Height);
        DrawText(Canvas.Handle,StrText,Length(StrText),RectTemp,DT_EXPANDTABS or DT_WORDBREAK);
    end;
    Canvas.Brush.Style := bsSolid;
end;

procedure TSwareLabel.SetDesignMode(Value: boolean);
begin
  if FDesignMode <> Value then
  begin
    FDesignMode := Value;
    Invalidate;
  end;
end;

procedure TSwareLabel.SetEditSelected(Value: boolean);
begin
  if FEditSelected <> Value then
  begin
	FEditSelected := Value;
	Invalidate;
  end;
end;

procedure TSwareLabel.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  if FDesignMode and Enabled then
  begin
    if FEditSelected=False then
    begin
        FEditSelected:=True;
        Repaint;
    end;
  end;
end;

procedure TSwareLabel.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  if Enabled then
  begin
    if FEditSelected=True then
    begin
        FEditSelected:=False;
        Invalidate;
    end;
  end;
end;

procedure TSwareLabel.SetSwareCommand(Value: String);
begin
	FSwareCommand := Value;
end;

procedure TSwareLabel.SetResizeBorder(Value: Integer);
begin
  if FResizeBorder <> Value then
  begin
    FResizeBorder := Value;
    Invalidate;
  end;
end;

procedure TSwareLabel.MouseDown(Button:TMouseButton; Shift: TShiftState;
	  X, Y: Integer);
begin
  mDn := TRUE;
  mUp := FALSE;
  if ((FDesignMode = TRUE) and (FEditSelected=TRUE)) then
  begin
	if (Button=mbLeft) then
	begin
		MouseDownX := X ;
		MouseDownY := Y ;
		Invalidate;
		Exit ;
	end;
  end;
  inherited;
  Invalidate;
end;

procedure TSwareLabel.MouseMove(Shift: TShiftState;
	  X, Y: Integer);
begin
  if ((FDesignMode = TRUE) and (FEditSelected=TRUE)) then
  begin
	if (mDn=TRUE) then
    begin
	if ((MouseDownX=X) and (MouseDownY=Y)) then Exit ;
	FPosMoved:=TRUE;
        FReSizing:=0 ;
        Cursor := crDefault ;
		case FReSizing of
            0:
                begin
                    Cursor := crDefault ;
                    Left := Left+(X-MouseDownX) ;
                    Top := Top+(Y-MouseDownY) ;
				end;
            1:
                begin
					Width := Width-(X-MouseDownX) ;
                    Height := Height-(Y-MouseDownY) ;
                    Left := Left+(X-MouseDownX) ;
                    Top := Top+(Y-MouseDownY) ;
                end;
            2:
                begin
                    Width := Width-(X-MouseDownX) ;
                    Left := Left+(X-MouseDownX) ;
                end;
            3:
                begin
                    Width := Width-(X-MouseDownX) ;
					Height := Y ;
                    Left := Left+(X-MouseDownX) ;
				end;
            4:
                begin
                    Height := Y ;
				end;
            5:
                begin
                    Width := X ;
                    Height := Y ;
                end;
			6:
                begin
                    Width := X ;
				end;
            7:
                begin
                    Width := X ;
                    Height := Height-(Y-MouseDownY) ;
                    Top := Top+(Y-MouseDownY) ;
                end;
            8:
                begin
                    Height := Height-(Y-MouseDownY) ;
					Top := Top+(Y-MouseDownY) ;
                end;
        end;
        if (Width<1) then Width := 1 ;
        if (Height<1) then Height := 1 ;
		Exit ;
    end
    else
    begin
	FReSizing := 0 ;
        Cursor := crDefault ;
        Exit ;
		if (X<FResizeBorder) then
        begin
            if (Y<FResizeBorder) then begin Cursor := crSizeNWSE ; FReSizing := 1 ; Exit ;end;
            if (Y>(Height-FResizeBorder)) then begin Cursor := crSizeNESW ;  FReSizing := 3 ; Exit ;end;
            Cursor := crSizeWE ;  FReSizing := 2; Exit ;
        end;
		if (X>Width-FResizeBorder) then
        begin
            if (Y<FResizeBorder) then begin Cursor := crSizeNESW ;  FReSizing := 7 ; Exit ;end;
			if (Y>(Height-FResizeBorder)) then begin Cursor := crSizeNWSE ;  FReSizing := 5 ; Exit ;end;
            Cursor := crSizeWE ;  FReSizing := 6 ; Exit ;
        end;
        if (Y<FResizeBorder) then begin Cursor := crSizeNS ;  FReSizing := 8 ; Exit ;end;
        if (Y>(Height-FResizeBorder)) then begin Cursor := crSizeNS ;  FReSizing := 4 ; Exit ;end;
        FReSizing := 0 ;
        Cursor := crDefault ;
		Exit ;
    end;
  end;
    Cursor := SavedCursor ;
    inherited;
  Invalidate;
end;

procedure TSwareLabel.MouseUp;
begin
  mUp := TRUE;
  mDn := FALSE;
  if ((FDesignMode = TRUE) and (FEditSelected=TRUE)) then begin
	  Invalidate;
	if Assigned(FOnPosChanged) and FPosMoved=TRUE then FOnPosChanged(Self, Left,Top);
	FPosMoved :=FALSE ;
	  Exit ;
  end;
  inherited;
  Invalidate;
end;

destructor TSwareLabel.Destroy;
begin
  inherited Destroy;
end;

{ TColorStatusPanel }

constructor TColorStatusPanel.Create(Collection: TCollection);
begin
  FWidth := 80;
  FBevel := pbLowered;
  FColor := clBtnFace;
  FStyle := psOwnerDraw;
  FBlink := False;
  FFont  := TFont.Create;
  FFont.OnChange :=ChangedFont;
  FSaveColor := FFont.Color;
  FShowColor := FFont.Color;
  inherited Create(Collection);
end;

destructor TColorStatusPanel.Destroy;
begin
  FFont.Free;
  inherited Destroy;
end;

procedure TColorStatusPanel.Assign(Source: TPersistent);
begin
  if Source is TColorStatusPanel then
  begin
    Text := TColorStatusPanel(Source).Text;
    Width := TColorStatusPanel(Source).Width;
    Alignment := TColorStatusPanel(Source).Alignment;
    Bevel := TColorStatusPanel(Source).Bevel;
    Style := TColorStatusPanel(Source).Style;
    Font := TColorStatusPanel(Source).Font;
    Color := TColorStatusPanel(Source).Color;
    SaveColor := TColorStatusPanel(Source).SaveColor;
    ShowColor := TColorStatusPanel(Source).ShowColor;
    Blink := TColorStatusPanel(Source).Blink;
    Exit;
  end;
  inherited Assign(Source);
end;

function TColorStatusPanel.GetDisplayName: string;
begin
  Result := Text;
  if Result = '' then Result := inherited GetDisplayName;
end;

procedure TColorStatusPanel.SetAlignment(Value: TAlignment);
begin
  if FAlignment <> Value then
  begin
    FAlignment := Value;
    Changed(False);
  end;
end;

procedure TColorStatusPanel.SetBevel(Value: TColorStatusPanelBevel);
begin
  if FBevel <> Value then
  begin
    FBevel := Value;
    Changed(True);
  end;
end;

procedure TColorStatusPanel.SetStyle(Value: TColorStatusPanelStyle);
begin
  if FStyle <> Value then
  begin
    FStyle := Value;
    Changed(False);
  end;
end;

procedure TColorStatusPanel.SetText(const Value: string);
begin
  if FText <> Value then
  begin
    FText := Value;
    Changed(False);
  end;
end;

procedure TColorStatusPanel.SetWidth(Value: Integer);
begin
  if FWidth <> Value then
  begin
    FWidth := Value;
    Changed(True);
  end;
end;

procedure TColorStatusPanel.SetFont(Value: TFont);
begin
  if FFont <> Value then
  begin
    FFont := Value;
  end;
end;

procedure TColorStatusPanel.ChangedFont(Sender:TObject);
begin
    FSaveColor := FFont.Color;
    FShowColor := FFont.Color;
    Changed(True);
end;

procedure TColorStatusPanel.SetShowColor(Value: TColor);
begin
  if FShowColor <> Value then
  begin
    FShowColor := Value;
    Changed(True);
  end;
end;

procedure TColorStatusPanel.SetColor(Value: TColor);
begin
  if FColor <> Value then
  begin
    FColor := Value;
    Changed(True);
  end;
end;

procedure TColorStatusPanel.SetSaveColor(Value: TColor);
begin
  if FSaveColor <> Value then
  begin
    FSaveColor := Value;
  end;
end;

procedure TColorStatusPanel.SetBlink(Value: bool);
begin
  if FBlink <> Value then
  begin
    FBlink := Value;
    if FBlink=False then FShowColor := FSaveColor;
    Changed(True);
  end;
end;

{ TColorStatusPanels }

constructor TColorStatusPanels.Create(StatusBar: TColorStatusBar);
begin
  inherited Create(TColorStatusPanel);
  FStatusBar := StatusBar;
end;

function TColorStatusPanels.Add: TColorStatusPanel;
begin
  Result := TColorStatusPanel(inherited Add);
  Items[Count-1].Font :=FStatusBar.Font ;
end;

function TColorStatusPanels.GetItem(Index: Integer): TColorStatusPanel;
begin
  Result := TColorStatusPanel(inherited GetItem(Index));
end;

function TColorStatusPanels.GetOwner: TPersistent;
begin
  Result := FStatusBar;
end;

procedure TColorStatusPanels.SetItem(Index: Integer; Value: TColorStatusPanel);
begin
  inherited SetItem(Index, Value);
end;

procedure TColorStatusPanels.Update(Item: TCollectionItem);
begin
  if Item <> nil then
    FStatusBar.UpdatePanel(Item.Index) else
    FStatusBar.UpdatePanels;
end;

{ TColorStatusBar }

constructor TColorStatusBar.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := [csCaptureMouse, csClickEvents, csDoubleClicks, csOpaque];
  Color := clBtnFace;
  Height := 19;
  Align := alBottom;
  FPanels := TColorStatusPanels.Create(Self);
  FCanvas := TControlCanvas.Create;
  TControlCanvas(FCanvas).Control := Self;
  FBlink :=true ;
  FInterval :=500 ;
  FTimer := TTimer.Create(Self) ;
  FTimer.OnTimer :=StatusBarBlink ;
  FTimer.Enabled :=FBlink ;
  FTimer.Interval :=FInterval ;
  FSizeGrip := True;
end;

destructor TColorStatusBar.Destroy;
begin
  FTimer.Free;
  FCanvas.Free;
  FPanels.Free;
  inherited Destroy;
end;

procedure TColorStatusBar.StatusBarBlink(Sender : TObject) ;
var i , j : Integer ;
begin
  j := FPanels.Count-1 ;
  for i:=0 to j do
  begin
    if FPanels.Items[i].Blink=true then
    begin
      if FPanels.Items[i].ShowColor = FPanels.Items[i].Color then
        FPanels.Items[i].ShowColor := FPanels.Items[i].SaveColor
      else
        FPanels.Items[i].ShowColor := FPanels.Items[i].Color ;
      UpdatePanel(i) ;
    end
    else
    begin
      if FPanels.Items[i].ShowColor = FPanels.Items[i].Color then
        FPanels.Items[i].ShowColor := FPanels.Items[i].SaveColor
    end;
  end;
end;

procedure TColorStatusBar.CreateParams(var Params: TCreateParams);
begin
  InitColorStatusControl(ICC_BAR_CLASSES);
  inherited CreateParams(Params);
  CreateSubClass(Params, STATUSCLASSNAME);
  with Params do
  begin
    if FSizeGrip then
      Style := Style or SBARS_SIZEGRIP else
      Style := Style or CCS_TOP;
    WindowClass.style := WindowClass.style and not CS_HREDRAW;
  end;
end;

procedure TColorStatusBar.CreateWnd;
begin
  inherited CreateWnd;
  UpdatePanels;
  if FSimpleText <> '' then
    SendMessage(Handle, SB_SETTEXT, 255, Integer(PChar(FSimpleText)));
  if FSimplePanel then
    SendMessage(Handle, SB_SIMPLE, 1, 0);
end;

procedure TColorStatusBar.DrawPanel(Panel: TColorStatusPanel; const Rect: TRect);
begin
  if Assigned(FOnDrawPanel) then
    FOnDrawPanel(Self, Panel, Rect)
  else
  begin
    FCanvas.Font.Color := Panel.ShowColor;
    FCanvas.Brush.Color := Panel.Color;
    FCanvas.FillRect(Rect);
    FCanvas.TextRect(Rect,Rect.Left,Rect.Top+((Rect.Bottom-Rect.Top-FCanvas.TextHeight(Panel.Text)) div 2),Panel.Text);
  end ;
end;

procedure TColorStatusBar.Resize;
begin
  if Assigned(FOnResize) then FOnResize(Self);
end;

procedure TColorStatusBar.SetPanels(Value: TColorStatusPanels);
begin
  FPanels.Assign(Value);
end;

procedure TColorStatusBar.SetSimplePanel(Value: Boolean);
begin
  if FSimplePanel <> Value then
  begin
    FSimplePanel := Value;
    if HandleAllocated then
      SendMessage(Handle, SB_SIMPLE, Ord(FSimplePanel), 0);
  end;
end;

procedure TColorStatusBar.SetSimpleText(const Value: string);
begin
  if FSimpleText <> Value then
  begin
    FSimpleText := Value;
    if HandleAllocated then
      SendMessage(Handle, SB_SETTEXT, 255, Integer(PChar(FSimpleText)));
  end;
end;

procedure TColorStatusBar.SetSizeGrip(Value: Boolean);
begin
  if FSizeGrip <> Value then
  begin
    FSizeGrip := Value;
    RecreateWnd;
  end;
end;

procedure TColorStatusBar.SetBlink(Value: Boolean);
var i , j : Integer ;
begin
  if FBlink <> Value then
  begin
    FBlink := Value;
    FTimer.Enabled := Value;
    if not FTimer.Enabled then
    begin
      j := FPanels.Count-1 ;
      for i:=0 to j do
      begin
        FPanels.Items[i].ShowColor := FPanels.Items[i].SaveColor ; //        UpdatePanel(i) ;
      end;
    end;
  end;
end;

procedure TColorStatusBar.SetInterval(Value: Word);
begin
  if FInterval <> Value then
  begin
    FInterval := Value;
    FTimer.Interval := Value;
  end;
end;

procedure TColorStatusBar.UpdatePanel(Index: Integer);
var
  Flags: Integer;
  S: string;
begin
  if HandleAllocated then
    with Panels[Index] do
    begin
      Flags := 0;
      case Bevel of
        pbNone: Flags := SBT_NOBORDERS;
        pbRaised: Flags := SBT_POPOUT;
      end;
      if Style = psOwnerDraw then Flags := Flags or SBT_OWNERDRAW;
      S := Text;
      case Alignment of
        taCenter: S := #9 + S;
        taRightJustify: S := #9#9 + S;
      end;
      SendMessage(Handle, SB_SETTEXT, Index or Flags, Integer(PChar(S)));
      InvalidateRect(Handle, Nil, True);
    end;
end;

procedure TColorStatusBar.UpdatePanels;
const
  MaxPanelCount = 128;
var
  I, Count, PanelPos: Integer;
  PanelEdges: array[0..MaxPanelCount - 1] of Integer;
begin
  if HandleAllocated then
  begin
    Count := Panels.Count;
    if Count > MaxPanelCount then Count := MaxPanelCount;
    if Count = 0 then
    begin
      PanelEdges[0] := -1;
      SendMessage(Handle, SB_SETPARTS, 1, Integer(@PanelEdges));
      SendMessage(Handle, SB_SETTEXT, 0, Integer(PChar('')));
    end else
    begin
      PanelPos := 0;
      for I := 0 to Count - 2 do
      begin
        Inc(PanelPos, Panels[I].Width);
        PanelEdges[I] := PanelPos;
      end;
      PanelEdges[Count - 1] := -1;
      SendMessage(Handle, SB_SETPARTS, Count, Integer(@PanelEdges));
      for I := 0 to Count - 1 do UpdatePanel(I);
    end;
  end;
end;

procedure TColorStatusBar.CNDrawItem(var Message: TWMDrawItem);
var
  SaveIndex: Integer;
begin
  with Message.DrawItemStruct^ do
  begin
    SaveIndex := SaveDC(hDC);
    FCanvas.Handle := hDC;
    FCanvas.Font := Font;
    FCanvas.Brush.Style := bsSolid;
    DrawPanel(Panels[itemID], rcItem);
    FCanvas.Handle := 0;
    RestoreDC(hDC, SaveIndex);
  end;
  Message.Result := 1;
end;

procedure TColorStatusBar.WMSize(var Message: TWMSize);
begin
  { Eat WM_SIZE message to prevent control from doing alignment }
  if not (csLoading in ComponentState) then Resize;
  Repaint;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TSwareCtl]);
  RegisterComponents('Samples', [TSwareLabel]);
  RegisterComponents('Samples', [TColorStatusBar]);
end;

end.


