unit StringFns;

interface

function Instr(str:string;substr:string):integer;
function LeftStr(instring:string;index:integer):String;
function RightStr(instring:string;numchars:byte):String;
function MidStrToEnd(instring:string;index:integer):string;
function ReplaceStr(str,old,new:string):string;
function StringStripAll(instring,charac:string):string;
function StringStripLeading(instring,charac:string):string;
function StringStripTrailing(instring,charac:string):string;

implementation

function Instr(str:string;substr:string):integer;
Begin
     Instr:=pos(substr,str);
end;

function LeftStr(instring:string;index:integer):String;
Begin
    LeftStr:=copy(instring,1,index);
end;

function RightStr(instring:string;numchars:byte):String;
Var
   index:byte;
Begin
     If numchars>=Length(instring)then
        RightStr:=instring
     else
         Begin
              index:=Length(instring)-numchars+1;
              RightStr:=Copy(instring,index,numchars)
         end
end;

function MidStrToEnd(instring:string;index:integer):string;
Begin
   MidStrToEnd:=copy(instring,index,Length(instring)-index+2);
end;

function ReplaceStr(str,old,new:string):string;
Var
   pos:integer;
   first,last:string[255];
Begin
   pos:=Instr(str,old);
   first:=Leftstr(str,Instr(str,old)-1);
   last:=copy(str,pos+Length(old),Length(str)-pos);
   ReplaceStr:=first+new+last;
end;

function StringStripAll(instring,charac:string):string;
Var
   done:Boolean;
   posit:integer;
Begin
   Repeat
         posit:=Instr(instring,charac);
         If posit>0 then
            Begin
               done:=False;
               delete(instring,posit,1);
            end
         else
            done:=True;
         {endif}
   Until done;
   StringStripAll:=instring;
end;

function StringStripLeading(instring,charac:string):string;
Begin
while LeftStr(instring,1) = LeftStr(charac,1) do
  instring:= midstrtoend(instring,2);
result:=instring;
end;

function StringStripTrailing(instring,charac:string):string;
Begin
while RightStr(instring,1) = LeftStr(charac,1) do
  instring:=LeftStr(instring,Length(instring) - 1);
result:=instring;
end;

end.
