{

Copyright  2000, StreamSec HB - http://www.streamsec.com/
All rights reserved.

}
unit HelpAppMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Docs, ToolWin, ExtCtrls, StdCtrls, ActnList, ImgList, Macro,
  DesignPoint;

type
  TMainForm = class(TForm)
    Docs1: TDocs;
    TreeView1: TTreeView;
    Panel1: TPanel;
    RichEdit1: TRichEdit;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ActionList1: TActionList;
    DocBack: TDocBack;
    DocNext: TDocNext;
    DocPrev: TDocPrev;
    DocDemo: TDocDemo;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    Splitter1: TSplitter;
    ImageList1: TImageList;
    DesignPoint1: TDesignPoint;
    procedure DocBackExecute(Sender: TObject);
    procedure DocNextExecute(Sender: TObject);
    procedure DocPrevExecute(Sender: TObject);
    procedure DocDemoExecute(Sender: TObject);
    procedure Docs1Selection(Sender: TObject; Doc: TDoc);
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure TreeView1Click(Sender: TObject);
    procedure Docs1DocList1MacroDemo0Notify(Sender: TObject);
    procedure Docs1DocList3MacroDemo0Notify(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.DocBackExecute(Sender: TObject);
begin
  Docs1.BackExecute(Sender);
end;

procedure TMainForm.DocNextExecute(Sender: TObject);
begin
  Docs1.NextExecute(Sender);
end;

procedure TMainForm.DocPrevExecute(Sender: TObject);
begin
  Docs1.PrevExecute(Sender);
end;

procedure TMainForm.DocDemoExecute(Sender: TObject);
begin
  Docs1.DemoExecute(Sender);
end;

procedure TMainForm.Docs1Selection(Sender: TObject; Doc: TDoc);
begin
  if Assigned(Doc) and Doc.Selected then
    RichEdit1.Lines.LoadFromStream(Doc.TextAsStream);
end;

procedure TMainForm.TreeView1Change(Sender: TObject; Node: TTreeNode);
var
  Doc: TDoc;
begin
  if Node.Selected then begin
    try
      Doc := TObject(Node.Data) as TDoc;    
    except
      Doc := nil;
    end;
    if Assigned(Doc) then Doc.Selected := True;
  end;
end;

procedure TMainForm.TreeView1Click(Sender: TObject);
begin
  if TreeView1.Selected <> nil then
    TreeView1Change(Sender,TreeView1.Selected);
end;

procedure TMainForm.Docs1DocList1MacroDemo0Notify(Sender: TObject);
begin
  MouseTo(TreeView1);
end;

procedure TMainForm.Docs1DocList3MacroDemo0Notify(Sender: TObject);
begin
  MouseTo(TreeView1);
end;

end.
    