unit DesignPoint;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TDesignPoint = class(TComponent)
  private
    FSleepPerPixel: Cardinal;
    function GetLeft: SmallInt;
    function GetTop: SmallInt;
    procedure SetLeft(const Value: SmallInt);
    procedure SetTop(const Value: SmallInt);
    procedure SetSleepPerPixel(const Value: Cardinal);
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Top: SmallInt read GetTop write SetTop;
    property Left: SmallInt read GetLeft write SetLeft;
    property SleepPerPixel: Cardinal read FSleepPerPixel
                                     write SetSleepPerPixel
                                     default 5;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('StreamSec', [TDesignPoint]);
end;

{ TDesignPoint }

constructor TDesignPoint.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FSleepPerPixel := 5;
end;

function TDesignPoint.GetLeft: SmallInt;
begin
  Result := SmallInt(LongRec(DesignInfo).Lo);
end;

function TDesignPoint.GetTop: SmallInt;
begin
  Result := SmallInt(LongRec(DesignInfo).Hi);
end;

procedure TDesignPoint.SetLeft(const Value: SmallInt);
var
  LR: LongRec;
begin
  LR := LongRec(DesignInfo);
  LR.Lo := Word(Value);
  DesignInfo := LongInt(LR);
end;

procedure TDesignPoint.SetSleepPerPixel(const Value: Cardinal);
begin
  FSleepPerPixel := Value;
end;

procedure TDesignPoint.SetTop(const Value: SmallInt);
var
  LR: LongRec;
begin
  LR := LongRec(DesignInfo);
  LR.Hi := Word(Value);
  DesignInfo := LongInt(LR);
end;

end.
