unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, inovaGIS_TLB;
(*
  INSTALLATION
    To compile this project you MUST first import the inovaGIS
    type library (the unit inovaGIS_TLB), by doing

    MENU
    PROJECT | IMPORT TYPE LIBRARY ...
    and choose the inovagis library creating the file in the
    same directory you place this project.
    Please remember that for any update of the inovagis library
    you repeat this import.
  *)
type
  TForm1 = class(TForm)
    Button1: TButton;
    ScrollBox1: TScrollBox;
    Panel1: TPanel;
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    ComboBox1: TComboBox;
    Button2: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
    map: iImg;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
     if OpenDialog1.Execute then
        begin
             map.Terminate;
             map.Document.Name := OpenDialog1.FileName;
             if map.Open then
                begin
                // clear image
                     Image1.width:=1;
                     Image1.Height:=1;
                     Image1.Refresh;
                // first let's set the image size ...
                     Image1.Width := Map.Cols;
                     Image1.Height := Map.Rows;
                     map.Legend.Palette.Name:= ComboBox1.ItemIndex+1;
                     map.Draw(0,0,100,Image1.Canvas.Handle);

                // and now to have an automatic zoom using the stretch property
                // of Timage
                     if (Image1.Width<ScrollBox1.Width) and
                         (Image1.Height<ScrollBox1.Height) then
                          begin
                               Image1.Width:=ScrollBox1.Width;
                               Image1.Height:=ScrollBox1.Height;
                          end;

                     Image1.Canvas.Refresh;
                end
             else
                 MessageDlg('Unable to open File.', mtError,[mbOk], 0);
        end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     map:= CoiImg.Create;
     ComboBox1.ItemIndex:=0;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     map.Terminate;
     map:=nil;
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);

  var nx, ny : integer;
      nZ: Single;
      Xstr: String;

begin
     //first calculate the X and Y equivalent in the Idrisi raster image
     if not map.Empty then
        begin
             nX:=1+Trunc(X * ( map.Cols /Image1.Width ));
             nY:=1+Trunc(Y * ( map.Rows /Image1.Height ));

             nZ:= map.pointXY[nx,ny];
             Str(nZ:0:2,Xstr);
             Panel1.Caption := 'X: '+IntToStr(nx)+
                               ';  Y: '+IntToStr(ny)+
                               '; Value:'+Xstr;
        end;
end;




procedure TForm1.Button2Click(Sender: TObject);
begin
     if not map.Empty then
        begin
                // clear image
                     Image1.width:=1;
                     Image1.Height:=1;
                     Image1.Refresh;
                // first let's set the image size ...
                     Image1.Width := Map.Cols;
                     Image1.Height := Map.Rows;
                     map.Legend.Palette.Name:= ComboBox1.ItemIndex+1;
                     map.Draw(0,0,100,Image1.Canvas.Handle);

                // and now to have an automatic zoom using the stretch property
                // of Timage
                     if (Image1.Width<ScrollBox1.Width) and
                         (Image1.Height<ScrollBox1.Height) then
                          begin
                               Image1.Width:=ScrollBox1.Width;
                               Image1.Height:=ScrollBox1.Height;
                          end;

                     Image1.Canvas.Refresh;
        end;
end;

end.
