 (*********************************************)
 (*                                           *)
 (*   SQLSet v1.02 for Delphi 3/4/5/6         *)
 (*                                           *)
 (*   Copiright 2000 by George Barbakadze     *)
 (*   All rights reserved                     *)
 (*                                           *)
 (*********************************************)

{$D+,L+,Y+}

unit sqlset;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, DList, Reader;

const
  VarStruct = 0;
    
type
  PStrValue = ^string;

  TSQLItem = class(TCollectionItem)
  private
    FTitle, FSQLText: string;
    procedure SetTitle(const value: string);
    procedure SetSQLText(const value: string);
  public
    constructor Create(Collection: TCollection); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
  published
    property Title: string read FTitle write SetTitle;
    property SQLText: string read FSQLText write SetSQLText;
  end;

  TSQLSet = class;

  TSQLItems = class(TCollection)
  private
    FSQLSet: TSQLSet;
    function GetItem(Index: Integer): TSQLItem;
    procedure SetItem(Index: Integer; Value: TSQLItem);
  public
    constructor Create(SQLSet: TSQLSet);
    function Add: TSQLItem;
    property SQLSet: TSQLSet read FSQLSet;
    property Items[index: Integer]: TSQLItem read GetItem write SetItem;
  end;

  TSQLSet = class(TComponent)
  private
    { Private declarations }
    FSQLItems: TSQLItems;
    Reader: TReader;
    procedure SetSQLItems(const Value: TSQLItems);
    function GetSQLItems: TSQLItems;
    procedure DisposeValue(Sender: TObject; Structure: integer;
      Properties: pointer);
    function GetText(const Title: string): string;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function RegisterVar(const VarName, Value: string): boolean;
    procedure RemoveVar(const VarName: string);
    procedure ClearVariables;
    procedure AddSQL(const Title, SQLText: string);
    procedure RemoveSQL(const Title: string);
    procedure ClearItems;
    function GetSQL(const Title: string): string;
  published
    { Published declarations }
    property SQLItems: TSQLItems read GetSQLItems write SetSQLItems;
  end;

implementation

{TSQLItem}
constructor TSQLItem.Create(Collection: TCollection);
begin
  inherited Create(Collection);
end;

destructor TSQLItem.Destroy;
begin
  inherited Destroy;
end;

procedure TSQLItem.SetTitle(const value: String);
begin
  FTitle := value;
  Changed(false);
end;

procedure TSQLItem.SetSQLText(const value: String);
begin
  FSQLText := value;
  Changed(false);
end;

procedure TSQLItem.Assign(Source: TPersistent);
begin
  if Source is TSQLItem then begin
    Title := TSQLItem(Source).Title;
    SQLText := TSQLItem(Source).SQLText;
  end
  else inherited Assign(Source);
end;

{TSQLItems}
constructor TSQLItems.Create(SQLSet: TSQLSet);
begin
  inherited Create(TSQLItem);
  FSQLSet := SQLSet;
end;

function TSQLItems.GetItem(Index: Integer): TSQLItem;
begin
  Result := TSQLItem(inherited GetItem(Index));
end;

procedure TSQLItems.SetItem(Index: Integer; Value: TSQLItem);
begin
  inherited SetItem(Index, Value);
end;

function TSQLItems.Add: TSQLItem;
begin
  Result := TSQLItem(inherited Add);
end;

{TSQLSet}
constructor TSQLSet.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FSQLItems := TSQLItems.Create(self);
  Reader:=TReader.Create(Self);
  with Reader do begin
    OnDisposeProperties:=DisposeValue;
    RegStandardFreeSymbols;
    RemoveFreeSymbol(#13);
    RemoveFreeSymbol(#10);
    AddDelimiter(#13+#10, 0, nil);
    AddDelimiter('.', 0, nil);
    AddDelimiter(',', 0, nil);
    AddDelimiter(';', 0, nil);
    AddDelimiter(':', 0, nil);
    AddDelimiter('''', 0, nil);
    AddDelimiter('"', 0, nil);
    AddDelimiter('@', 0, nil);
    AddDelimiter('(', 0, nil);
    AddDelimiter(')', 0, nil);
    AddDelimiter('/', 0, nil);
    AddDelimiter('*', 0, nil);
    AddDelimiter('^', 0, nil);
    AddDelimiter('+', 0, nil);
    AddDelimiter('-', 0, nil);
    AddDelimiter('=', 0, nil);
    AddDelimiter('>', 0, nil);
    AddDelimiter('<', 0, nil);
    AddDelimiter('<>', 0, nil);
    AddDelimiter('>=', 0, nil);
    AddDelimiter('<=', 0, nil);
    AddDelimiter('[', 0, nil);
    AddDelimiter(']', 0, nil);
    AddDelimiter('{', 0, nil);
    AddDelimiter('}', 0, nil);
    AddDelimiter('(+)', 0, nil);
    AddDelimiter(':=', 0, nil);
    AddDelimiter('!=', 0, nil);
    AddDelimiter('^=', 0, nil);
    AddDelimiter('--', 0, nil);
    AddDelimiter('||', 0, nil);
    AddDelimiter('/*', 0, nil);
    AddDelimiter('*/', 0, nil);
  end;
end;

destructor TSQLSet.Destroy;
begin
  FSQLItems.Destroy;
  Reader.Destroy;
  inherited Destroy;
end;

procedure TSQLSet.SetSQLItems(const Value: TSQLItems);
begin;
  FSQLItems.Assign(Value);
end;

function TSQLSet.GetSQLItems: TSQLItems;
begin;
  Result := FSQLItems;
end;

procedure TSQLSet.DisposeValue(Sender: TObject; Structure: integer;
  Properties: pointer);
begin
  if Structure=VarStruct then if PStrValue(Properties)^<>'' then
    Dispose(PStrValue(Properties));
end;

function TSQLSet.RegisterVar(const VarName, Value: string): boolean;
var
  VarValue: PStrValue;
  i: integer;
begin
  Result:=false;
  if VarName = '' then
    MessageDlg('Variable name missing', mtError, [mbOK], 0)
  else begin
    New(VarValue);
    for i:=1 to Length(VarName) do if Reader.IsDelimiter(VarName[i]) then begin
      MessageDlg('The variable name can not contain a devider "'+
                 VarName[i]+'"', mtError, [mbOK], 0);
      Exit;
    end;
    VarValue^:=Value;
    Reader.AddKeyWord(AnsiLowerCase(VarName), VarStruct, VarValue);
    Result:=true;
  end;
end;

procedure TSQLSet.RemoveVar(const VarName: string);
begin
  Reader.Remove(AnsiLowerCase(VarName));
end;

procedure TSQLSet.ClearVariables;
begin
  Reader.ClearKeyWords;
end;

procedure TSQLSet.AddSQL(const Title, SQLText: string);
var
  i: integer;
  VC: TSQLItem;
begin
  for i := 0 to FSQLItems.Count - 1 do
    if AnsiLowerCase(FSQLItems.Items[i].Title)=
      AnsiLowerCase(Title) then begin
      FSQLItems.Items[i].Title:=Title;
      FSQLItems.Items[i].SQLText:=SQLText;
      Exit;
    end;
  VC := FSQLItems.Add;
  VC.Title := Title;
  VC.SQLText := SQLText;
end;

procedure TSQLSet.RemoveSQL(const Title: string);
var
  OldSQLItems: TSQLItems;
  i, i1: Integer;
begin
  OldSQLItems := TSQLItems.Create(Self);
  try
    OldSQLItems.Assign(FSQLItems);
    FSQLItems.Clear;
    i1:=0;
    for i := 0 to OldSQLItems.Count - 1 do
      if AnsiLowerCase(OldSQLItems.Items[i].Title)=
        AnsiLowerCase(Title) then inc(i1)
      else begin
        FSQLItems.Add;
        FSQLItems.Items[i-i1].Assign(OldSQLItems.Items[i]);
      end;
  finally
    OldSQLItems.Free;
  end;
end;

procedure TSQLSet.ClearItems;
begin
  FSQLItems.Clear;
end;

function TSQLSet.GetText(const Title: string): string;
var
  i: integer;
begin
  Result:='';
  for i := 0 to FSQLItems.Count - 1 do
    if AnsiLowerCase(FSQLItems.Items[i].Title)=
      AnsiLowerCase(Title) then begin
      Result:=FSQLItems.Items[i].SQLText;
      Exit;
    end;
end;

function TSQLSet.GetSQL(const Title: string): string;
var
  Scroller: TScroller;
  s: string;
  i: integer;
begin
  Result:='';
  Scroller:=TScroller.Create(Reader);
  try
    with Scroller do begin
      First(GetText(Title), 0);
      while PosList[0].Status<>sNone do begin
        s:='';
        for i:=1 to Length(PosList[0].FreeStr) do s:=s+' ';
        if PosList[0].Status=sKeyWord then
          Result:=Result+s+PStrValue(PosList[0].Additional)^
        else Result:=Result+s+PosList[0].ActiveStr;
        Next;
      end;
    end;
  finally
    Scroller.Destroy;
  end;
end;

end.

