{$D+,L+,Y+}

unit SQLsEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, SQLSet, ComCtrls, ExtCtrls;

type
  TSQLsEditor = class(TForm)
    GroupBox1: TGroupBox;
    bnNew: TButton;
    bnDelete: TButton;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    GroupBox2: TGroupBox;
    mSQL: TMemo;
    lbSQLItems: TListBox;
    Label1: TLabel;
    edTitle: TEdit;
    procedure bnNewClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bnDeleteClick(Sender: TObject);
    procedure lbSQLItemsClick(Sender: TObject);
    procedure edTitleExit(Sender: TObject);
    procedure edTitleChange(Sender: TObject);
    procedure mSQLExit(Sender: TObject);
    procedure mSQLChange(Sender: TObject);
  private
    FSQLSet: TSQLSet;
    SQLItems: TSQLItems;
    TitleChanged, SQLTextChanged: boolean;
    procedure RefreshItems;
    procedure UpdateScreen(value: TSQLItem);
    procedure ClearScreen;
    procedure ShowSelectMsg;
    procedure SelectItem(value: Integer);
  public
    procedure SetValues(SQLSet: TSQLSet);
    function GetValues(SQLSet: TSQLSet): Boolean;
  end;

  function EditSQLItems(SQLSet: TSQLSet): Boolean;

implementation

{$R *.DFM}

function EditSQLItems(SQLSet: TSQLSet): Boolean;
var
  SQLsEditor: TSQLsEditor;
begin
  Result:=False;
  SQLsEditor := TSQLsEditor.Create(Application);
  try
    SQLsEditor.SetValues(SQLSet);
    If SQLsEditor.ShowModal = mrOK then
      begin
        SQLsEditor.GetValues(SQLSet);
        Result:=true;
      end;
  finally
    SQLsEditor.Destroy;
  end;
end;

procedure TSQLsEditor.SelectItem(value: Integer);
var
  i: Integer;
begin
  for i := 0 to lbSQLItems.Items.Count -1 do lbSQLItems.Selected[i] := false;
  try
    lbSQLItems.ItemIndex := value;
    lbSQLItems.Selected[value]:= true;
  except
    If lbSQLItems.Items.Count > 0 then lbSQLItems.ItemIndex := 0;
  end;
end;

procedure TSQLsEditor.ShowSelectMsg;
begin
  MessageDlg('You have to select a SQLItem',mtError, [mbOK],0);
  lbSQLItems.SetFocus;
end;

procedure TSQLsEditor.RefreshItems;
var
  i: Integer;
begin
  lbSQLItems.Items.Clear;
  with SQLItems do for i := 0 to Count - 1 do
    lbSQLItems.Items.Add('Item_' + IntToStr(i) + ': ' + Items[i].Title);
end;

procedure TSQLsEditor.SetValues(SQLSet: TSQLSet);
begin
  FSQLSet := SQLSet;
  SQLItems := TSQLItems.Create(FSQLSet);
  SQLItems.Assign(FSQLSet.SQLItems);
  if SQLItems.Count > 0 then begin
    RefreshItems;
    SelectItem(0);
    UpdateScreen(SQLItems.Items[lbSQLItems.ItemIndex]);
  end;
  TitleChanged:=false;
  SQLTextChanged:=false;
end;

function TSQLsEditor.GetValues(SQLSet: TSQLSet): Boolean;
begin
  SQLSet.SQLItems.Clear;
  SQLSet.SQLItems.Assign(SQLItems);
  GetValues := True;
end;

procedure TSQLsEditor.UpdateScreen(value: TSQLItem);
begin
  edTitle.Text := Value.Title;
  mSQL.Text := Value.SQLText;
end;

procedure TSQLsEditor.ClearScreen;
begin
  edTitle.Text := '';
  mSQL.Clear;
end;

procedure TSQLsEditor.FormDestroy(Sender: TObject);
begin
  SQLItems.Free;
end;

procedure TSQLsEditor.bnNewClick(Sender: TObject);
var
  i: Integer;
  VC: TSQLItem;
begin
  i := lbSQLItems.Items.Count;
  lbSQLItems.Items.Add('Item_' + IntToStr(i) + ':');
  SelectItem(i);
  VC := SQLItems.Add;
  VC.Title := '';
  VC.SQLText := '';
  UpdateScreen(VC);
end;

procedure TSQLsEditor.bnDeleteClick(Sender: TObject);
var
  OldSQLItems: TSQLItems;
  i, i1: Integer;
begin
  If lbSQLItems.ItemIndex = -1 then begin
    ShowSelectMsg;
    Exit;
  end;
  OldSQLItems := TSQLItems.Create(FSQLSet);
  try
    OldSQLItems.Assign(SQLItems);
    SQLItems.Clear;
    i1:=0;
    for i := 0 to lbSQLItems.Items.Count - 1 do
      if lbSQLItems.Selected[i] then inc(i1)
      else begin
        SQLItems.Add;
        SQLItems.Items[i-i1].Assign(OldSQLItems.Items[i]);
      end;
    i := lbSQLItems.ItemIndex;
    RefreshItems;
    if i<=lbSQLItems.Items.Count-1 then lbSQLItems.ItemIndex:=i
    else lbSQLItems.ItemIndex:=lbSQLItems.Items.Count-1;
    if lbSQLItems.ItemIndex>-1 then begin
      SelectItem(lbSQLItems.ItemIndex);
      UpdateScreen(SQLItems.Items[lbSQLItems.ItemIndex]);
    end
    else begin
      SelectItem(0);
      ClearScreen;
    end;
  finally
    OldSQLItems.Free;
  end;
end;

procedure TSQLsEditor.lbSQLItemsClick(Sender: TObject);
begin
  UpdateScreen(SQLItems.Items[lbSQLItems.ItemIndex]);
end;

procedure TSQLsEditor.edTitleExit(Sender: TObject);
var
  i: Integer;
begin
  if TitleChanged then begin
    TitleChanged:=false;
    If lbSQLItems.SelCount = 0 then ShowSelectMsg
    else for i := 0 to lbSQLItems.Items.Count - 1 do
      If lbSQLItems.Selected[i] then begin
        SQLItems.Items[i].Title := edTitle.Text;
        lbSQLItems.Items[i]:='Item_' + IntToStr(i) + ': ' + edTitle.Text;
        lbSQLItems.Selected[i]:=true;
      end;
  end;
end;

procedure TSQLsEditor.edTitleChange(Sender: TObject);
begin
  TitleChanged:=true;
end;

procedure TSQLsEditor.mSQLExit(Sender: TObject);
var
  i: Integer;
begin
  if SQLTextChanged then begin
    SQLTextChanged:=false;
    If lbSQLItems.SelCount = 0 then ShowSelectMsg
    else for i := 0 to lbSQLItems.Items.Count - 1 do
      If lbSQLItems.Selected[i] then
        SQLItems.Items[i].SQLText := mSQL.Text;
  end;
end;

procedure TSQLsEditor.mSQLChange(Sender: TObject);
begin
  SQLTextChanged:=true;
end;

end.
