unit SpellDemoUnit;
//  TSpellChecker demo
//    Simple rich-text format editor with spelling check capability
//  Author: Alexander Obukhov
//
//    see comments in the listing to understand some
//    TSpellChecker methods and properties

interface

uses
  Windows, Messages, SysUtils, CommCtrl, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Menus, StdCtrls, ToolWin, Langs, RichEdit,
  RichEdit2, LCCombo, Menus97, ExtCtrls, Buttons, MenuToolBar,
  Spellers;

type
  TSpellDemoForm = class(TForm)
    Speller: TSpellChecker;
    Images: TImageList;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    FindDialog: TFindDialog;
    ReplaceDialog: TReplaceDialog;
    PrinterSetupDialog: TPrinterSetupDialog;
    ColorMenu: TPopupMenu;
    BlackMI: TMenuItem;
    MaroonMI: TMenuItem;
    GreenMI: TMenuItem;
    OliveMI: TMenuItem;
    NavyMI: TMenuItem;
    PurpleMI: TMenuItem;
    TealMI: TMenuItem;
    GrayMI: TMenuItem;
    SilverMI: TMenuItem;
    RedMI: TMenuItem;
    LimeMI: TMenuItem;
    YellowMI: TMenuItem;
    BlueMI: TMenuItem;
    FuchsiaMI: TMenuItem;
    AquaMI: TMenuItem;
    WhiteMI: TMenuItem;
    ColorMenu97: TPopupMenus97;
    HighlightMenu: TPopupMenu;
    BlackMI2: TMenuItem;
    MaroonMI2: TMenuItem;
    GreenMI2: TMenuItem;
    OliveMI2: TMenuItem;
    NavyMI2: TMenuItem;
    PurpleMI2: TMenuItem;
    TealMI2: TMenuItem;
    GrayMI2: TMenuItem;
    SilverMI2: TMenuItem;
    RedMI2: TMenuItem;
    LimeMI2: TMenuItem;
    YellowMI2: TMenuItem;
    BlueMI2: TMenuItem;
    FuchsiaMI2: TMenuItem;
    AquaMI2: TMenuItem;
    WhiteMI2: TMenuItem;
    HighlightMenu97: TPopupMenus97;
    AutoMI: TMenuItem;
    OtherMI: TMenuItem;
    NoneMI2: TMenuItem;
    ColorDialog: TColorDialog;
    NewMI: TMenuItem;
    OpenMI: TMenuItem;
    N1: TMenuItem;
    SaveMI: TMenuItem;
    SaveAsMI: TMenuItem;
    N2: TMenuItem;
    PrintSetupMI: TMenuItem;
    PrintMI: TMenuItem;
    N5: TMenuItem;
    ExitMI: TMenuItem;
    UndoMI: TMenuItem;
    RedoMI: TMenuItem;
    N3: TMenuItem;
    CutMI: TMenuItem;
    CopyMI: TMenuItem;
    PasteMI: TMenuItem;
    N4: TMenuItem;
    SelectAllMI: TMenuItem;
    N6: TMenuItem;
    FindMI: TMenuItem;
    ReplaceMI: TMenuItem;
    N7: TMenuItem;
    SpellMI: TMenuItem;
    CascadeMI: TMenuItem;
    TileMI: TMenuItem;
    ArrangeIconsMI: TMenuItem;
    MainMenu: TMainMenu;
    FileMI: TMenuItem;
    EditMI: TMenuItem;
    WindowMI: TMenuItem;
    AboutMI: TMenuItem;
    MainMenu97: TMainMenus97;
    MainToolBar: TToolBar;
    NewBtn: TToolButton;
    OpenBtn: TToolButton;
    SaveBtn: TToolButton;
    ToolButton3: TToolButton;
    PrintBtn: TToolButton;
    ToolButton4: TToolButton;
    UndoBtn: TToolButton;
    RedoBtn: TToolButton;
    ToolButton14: TToolButton;
    CutBtn: TToolButton;
    CopyBtn: TToolButton;
    PasteBtn: TToolButton;
    ToolButton8: TToolButton;
    FindBtn: TToolButton;
    ReplaceBtn: TToolButton;
    ToolButton11: TToolButton;
    SpellBtn: TToolButton;
    ToolButton2: TToolButton;
    ExitBtn: TToolButton;
    FmtToolBar: TToolBar;
    FontCombo: TComboBox;
    ToolButton6: TToolButton;
    FontSize: TComboBox;
    ToolButton9: TToolButton;
    BoldBtn: TToolButton;
    ItalicBtn: TToolButton;
    UndrlBtn: TToolButton;
    ToolButton10: TToolButton;
    TextColorBtn: TToolButton;
    BackColorBtn: TToolButton;
    ToolButton1: TToolButton;
    LeftBtn: TToolButton;
    CenterBtn: TToolButton;
    RightBtn: TToolButton;
    ToolButton13: TToolButton;
    BulletsBtn: TToolButton;
    ToolButton5: TToolButton;
    Languages: TLanguagesCombo;
    MenuToolBar: TMenuToolBar;
    CoolBar1: TCoolBar;
    HelpMI: TMenuItem;
    procedure NewMIClick(Sender: TObject);
    procedure SelectAllMIClick(Sender: TObject);
    procedure CutMIClick(Sender: TObject);
    procedure CopyMIClick(Sender: TObject);
    procedure PasteMIClick(Sender: TObject);
    procedure FindMIClick(Sender: TObject);
    procedure ReplaceMIClick(Sender: TObject);
    procedure SaveMIClick(Sender: TObject);
    procedure SaveAsMIClick(Sender: TObject);
    procedure FindDialogFind(Sender: TObject);
    procedure ReplaceDialogReplace(Sender: TObject);
    procedure UndoMIClick(Sender: TObject);
    procedure ExitMIClick(Sender: TObject);
    procedure LangMIClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PrintMIClick(Sender: TObject);
    procedure OpenMIClick(Sender: TObject);
    procedure PrintSetupMIClick(Sender: TObject);
    procedure FontSizeKeyPress(Sender: TObject; var Key: Char);
    procedure FontComboChange(Sender: TObject);
    procedure BoldBtnClick(Sender: TObject);
    procedure ItalicBtnClick(Sender: TObject);
    procedure UndrlBtnClick(Sender: TObject);
    procedure FontSizeKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FontSizeChange(Sender: TObject);
    procedure FontSizeDropDown(Sender: TObject);
    procedure LeftBtnClick(Sender: TObject);
    procedure CenterBtnClick(Sender: TObject);
    procedure RightBtnClick(Sender: TObject);
    procedure BulletsBtnClick(Sender: TObject);
    procedure AboutMIClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SpellMIClick(Sender: TObject);
    procedure CascadeMIClick(Sender: TObject);
    procedure TileMIClick(Sender: TObject);
    procedure ArrangeIconsMIClick(Sender: TObject);
    procedure FontComboDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure LanguagesChange(Sender: TObject);
    procedure SetColorButton(TB: TToolButton; Color: TColor);
    procedure ColorMIClick(Sender: TObject);
    function ColorMenu97DrawItem(Control: TMenu; Item: TMenuItem;
      Rect: TRect; State: TOwnerDrawState): Boolean;
    procedure ColorMenuPopup(Sender: TObject);
    procedure HighlightMenuPopup(Sender: TObject);
    procedure ColorMenu97MeasureItem(Control: TMenu; Item: TMenuItem;
      var Height, Width: Integer);
    procedure HighlightMIClick(Sender: TObject);
    procedure OtherMIClick(Sender: TObject);
    procedure RedoMIClick(Sender: TObject);
  private
    { Private declarations }
    WasDropped: Boolean;
    procedure NewMenubarProc(Var Message: TMessage); virtual;
    function GetMenuButtonAt(X, Y: Integer; var R: TRect): TToolButton;
  public
    { Public declarations }
    ChLang: Boolean;
  end;

var
  SpellDemoForm: TSpellDemoForm;

implementation

uses
  AboutUnit, MDIFormUnit;

const
  TBSTYLE_AUTOSIZE = $0010;
  TBSTYLE_EX_DRAWDDARROWS = 1;
  TB_SETEXTENDEDSTYLE   =  (WM_USER + 84);
  TB_GETEXTENDEDSTYLE   =  (WM_USER + 85);

{$R *.DFM}

procedure TSpellDemoForm.AboutMIClick(Sender: TObject);
begin
  AboutForm.ShowModal;
end;

procedure TSpellDemoForm.FormShow(Sender: TObject);
begin
  AboutForm.ShowModal;
  NewMIClick(Self);
end;

procedure TSpellDemoForm.NewMIClick(Sender: TObject);
begin
  TMDIForm.Create(Self);
end;

procedure TSpellDemoForm.SelectAllMIClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).SelectAll;
end;

procedure TSpellDemoForm.CutMIClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).Cut;
end;

procedure TSpellDemoForm.CopyMIClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).Copy;
end;

procedure TSpellDemoForm.PasteMIClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).Paste;
end;

procedure TSpellDemoForm.FindMIClick(Sender: TObject);
begin
  FindDialog.Execute;
end;

procedure TSpellDemoForm.ReplaceMIClick(Sender: TObject);
begin
  ReplaceDialog.Execute;
end;

procedure TSpellDemoForm.SaveMIClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).ExecSave;
end;

procedure TSpellDemoForm.SaveAsMIClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).ExecSaveAs;
end;

procedure TSpellDemoForm.FindDialogFind(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).Find(Sender);
end;

procedure TSpellDemoForm.ReplaceDialogReplace(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).Replace;
end;

procedure TSpellDemoForm.UndoMIClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).Undo;
end;

procedure TSpellDemoForm.ExitMIClick(Sender: TObject);
begin
  Close;
end;

function EnumFontFams(var elfe: TENUMLOGFONTEX; var ntme: TNEWTEXTMETRICEX;
    FontType : Integer; List: TStrings): Integer;
stdcall;
var
  Temp: String;
begin
  Temp := elfe.elfLogFont.lfFaceName;
  if (List.Count = 0) or (List[List.Count-1]<>Temp) then
    List.AddObject(Temp, Pointer(Ord(FontType=TRUETYPE_FONTTYPE)+1));
  Result:= 1;
end;

procedure TSpellDemoForm.FormCreate(Sender: TObject);
var
  Langs: TStringList;
  MI: TMenuItem;
  I: Integer;
  DC: HDC;
  LF: TLogFont;
  S: TStringList;
  TB: TTBButton;
begin
  S:= TStringList.Create;
  DC:= GetDC(0);
  LF.lfFaceName[0]:= #0;
  LF.lfCharSet:= DEFAULT_CHARSET;
  EnumFontFamiliesEx(DC, LF, @EnumFontFams, Integer(S), 0);
  ReleaseDC(0, DC);
  S.Sort;
  FontCombo.Items.Assign(S);
  S.Free;
  WasDropped:= False;
  FontCombo.ItemIndex:= FontCombo.Items.IndexOf('Arial');
  FmtToolbar.Perform(TB_SETEXTENDEDSTYLE, 0, TBSTYLE_EX_DRAWDDARROWS);
  ChLang:= True;
end;

procedure TSpellDemoForm.PrintMIClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).Print;
end;

procedure TSpellDemoForm.OpenMIClick(Sender: TObject);
var
  MDIForm: TMDIForm;
begin
  OpenDialog.FileName:= '';
  if OpenDialog.Execute then
    begin
      MDIForm:= TMDIForm.Create(Self);
      MDIForm.ExecLoad(OpenDialog.FileName);
    end;
end;

procedure TSpellDemoForm.PrintSetupMIClick(Sender: TObject);
begin
  PrinterSetupDialog.Execute;
end;

procedure TSpellDemoForm.FontSizeKeyPress(Sender: TObject; var Key: Char);
begin
  if not (Key in [#1..#31, '0'..'9']) then
    Key:= #0;
end;

procedure TSpellDemoForm.FontComboChange(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    begin
      (ActiveMDIChild as TMDIForm).SetFont(FontCombo.Text);
      Windows.SetFocus((ActiveMDIChild as TMDIForm).RichEdit.Handle);
    end;
end;

procedure TSpellDemoForm.BoldBtnClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).SetBold(BoldBtn.Down);
end;

procedure TSpellDemoForm.ItalicBtnClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).SetItalic(ItalicBtn.Down);
end;

procedure TSpellDemoForm.UndrlBtnClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).SetUnderline(UndrlBtn.Down);
end;

procedure TSpellDemoForm.FontSizeKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key=vk_Return) and (ActiveMDIChild<>nil) then
    begin
      (ActiveMDIChild as TMDIForm).SetFontSize(StrToInt(FontSize.Text));
      Windows.SetFocus((ActiveMDIChild as TMDIForm).RichEdit.Handle);
    end;
end;

procedure TSpellDemoForm.FontSizeChange(Sender: TObject);
begin
  if WasDropped then
    begin
      if ActiveMDIChild<>nil then
        begin
          (ActiveMDIChild as TMDIForm).SetFontSize(StrToInt(FontSize.Text));
          Windows.SetFocus((ActiveMDIChild as TMDIForm).RichEdit.Handle);
        end;
      WasDropped:= False;
    end;
end;

procedure TSpellDemoForm.FontSizeDropDown(Sender: TObject);
begin
  WasDropped:= True;
end;

procedure TSpellDemoForm.LeftBtnClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).SetAlignment(taLeft);
end;

procedure TSpellDemoForm.CenterBtnClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).SetAlignMent(taCenter);
end;

procedure TSpellDemoForm.RightBtnClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).SetAlignment(taRight);
end;

procedure TSpellDemoForm.BulletsBtnClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).SetNumbering(BulletsBtn.Down);
end;

// Changes speller language
procedure TSpellDemoForm.LangMIClick(Sender: TObject);
var
  MI: TMenuItem;
begin
  MI:= Sender as TMenuItem;
  MI.Checked:= True;
// Sets new language from selected menu item
  Speller.Language:= MI.Tag;
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).RichEdit.Language:= Speller.Language;
end;

procedure TSpellDemoForm.SpellMIClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).Spell;
end;

procedure TSpellDemoForm.CascadeMIClick(Sender: TObject);
begin
  Cascade;
end;

procedure TSpellDemoForm.TileMIClick(Sender: TObject);
begin
  Tile;
end;

procedure TSpellDemoForm.ArrangeIconsMIClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TSpellDemoForm.FontComboDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  Icon: TIcon;
begin
  Icon:= TIcon.Create;
  Images.GetIcon(18+Integer(FontCombo.Items.Objects[Index]), Icon);
  with FontCombo.Canvas do
    begin
      FillRect(Rect);
      TextOut(Rect.Left+18, Rect.Top, FontCombo.Items[Index]);
      DrawIconEx(Handle, Rect.Left+1, Rect.Top, Icon.Handle, 16, 16, 0, 0, DI_NORMAL)
    end;
  Icon.Free;
end;

procedure TSpellDemoForm.LanguagesChange(Sender: TObject);
begin
  if ChLang and (ActiveMDIChild<>nil) then
    begin
      (ActiveMDIChild as TMDIForm).SetLanguage(Languages.Language);
      Windows.SetFocus((ActiveMDIChild as TMDIForm).RichEdit.Handle);
    end;
end;

procedure TSpellDemoForm.SetColorButton(TB: TToolButton; Color: TColor);
var
  BMP, Mask: TBitmap;
begin
  BMP:= TBitmap.Create;
  Mask:= TBitmap.Create;
  Images.GetBitmap(TB.ImageIndex, BMP);
  Mask.Width:= 16;
  Mask.Height:= 16;
  with Mask.Canvas do
  begin
    Brush.Color := clWhite;
    FillRect(Rect(0, 0, 16, 16));
    ImageList_Draw(Images.Handle, TB.ImageIndex, Handle, 0, 0, ILD_MASK);
  end;
  with BMP.Canvas do
    begin
      Brush.Color:= Color;
      FillRect(Rect(0, 12, 16, 16));
    end;
  Images.Replace(TB.ImageIndex, BMP, Mask);
  BMP.Free;
  Mask.Free;
end;

procedure TSpellDemoForm.ColorMIClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).SetColor((Sender as TMenuItem).Tag);
end;

function TSpellDemoForm.ColorMenu97DrawItem(Control: TMenu;
  Item: TMenuItem; Rect: TRect; State: TOwnerDrawState): Boolean;
var
  Menus97: TPopupMenus97;
  P, H, I: Integer;
begin
  if Control=ColorMenu then
    Menus97:= ColorMenu97
  else
    Menus97:= HighlightMenu97;
  with Menus97.Canvas do
    begin
      Brush.Color:= clMenu;
      if odSelected in State then
        begin
          FillRect(Rect);
          if Item.Checked then
            Frame3D(Menus97.Canvas, Rect, clBtnShadow, clBtnHighlight, 1)
          else
            Frame3D(Menus97.Canvas, Rect, clBtnHighlight, clBtnShadow, 1);
          InflateRect(Rect, 1, 1);
        end
      else if Item.Checked then
        begin
          Brush.Color:= $E0E0E0;
          FillRect(Rect);
          Frame3D(Menus97.Canvas, Rect, clBtnShadow, clBtnHighlight, 1);
          InflateRect(Rect, 1, 1);
        end
      else
        FillRect(Rect);
      InflateRect(Rect, -3, -3);
      Pen.Color:= clGray;
      Pen.Width:= 1;
      if (Item=OtherMI) or (Item=NoneMI2) then
        if Item.Checked and not (odSelected in State) then
          Brush.Color:= $E0E0E0
        else
          Brush.Color:= clMenu
      else
        Brush.Color:= Item.Tag;
      Rectangle(Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
      if (Item=AutoMI) or (Item=OtherMI) or (Item=NoneMI2) then
        begin
          if Item=AutoMI then
            Font.Color:= clWhite
          else
            Font.Color:= clBlack;
          H:= TextHeight(Item.Caption)*4 div 5;
          P:= 40+H*(Length(Item.Caption)-3) div 2;
          for I:= Length(Item.Caption) downto 1 do
            begin
              TextOut(Rect.Left-2+(20-TextWidth(Item.Caption[I])) div 2, Rect.Top-2+P, Item.Caption[I]);
              Dec(P, H);
            end;
        end;
    end;
  Result:= True;
end;

procedure TSpellDemoForm.ColorMenuPopup(Sender: TObject);
var
  C: TColor;
  I: Integer;
begin
  if ActiveMDIChild<>nil then
    begin
      C:= (ActiveMDIChild as TMDIForm).RichEdit.SelAttributes.Color;
      for I:= 0 to ColorMenu.Items.Count-1 do
        ColorMenu.Items[I].Checked:= ColorMenu.Items[I].Tag=C;
    end;
end;

procedure TSpellDemoForm.HighlightMenuPopup(Sender: TObject);
var
  C: TColor;
  I: Integer;
begin
  if ActiveMDIChild<>nil then
    begin
      C:= (ActiveMDIChild as TMDIForm).RichEdit.SelAttributes.BackColor;
      for I:= 0 to HighLightMenu.Items.Count-1 do
        HighLightMenu.Items[I].Checked:= HighLightMenu.Items[I].Tag=C;
    end;
end;

procedure TSpellDemoForm.ColorMenu97MeasureItem(Control: TMenu;
  Item: TMenuItem; var Height, Width: Integer);
begin
  if (Item=AutoMI) or (Item=OtherMI) or (Item=NoneMI2) then
    Height:= 80;
end;

procedure TSpellDemoForm.HighlightMIClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).SetBackColor((Sender as TMenuItem).Tag);
end;

procedure TSpellDemoForm.OtherMIClick(Sender: TObject);
var
  MI: TMenuItem;
begin
  if ColorDialog.Execute then
    begin
      MI:= TMenuItem.Create(Self);
      MI.Tag:= ColorDialog.Color;
      MI.Break:= mbBreak;
      if ColorMenu.Items.Count>18 then
        ColorMenu.Items[18].Break:= mbNone;
      MI.OnClick:= ColorMIClick;
      ColorMenu.Items.Insert(18, MI);
      if ColorMenu.Items.Count=23 then
        ColorMenu.Items[22].Free;
      ColorMIClick(MI);
    end;
end;

procedure TSpellDemoForm.RedoMIClick(Sender: TObject);
begin
  if ActiveMDIChild<>nil then
    (ActiveMDIChild as TMDIForm).Redo;
end;

function TSpellDemoForm.GetMenuButtonAt(X, Y: Integer; var R: TRect): TToolButton;
begin
end;

procedure TSpellDemoForm.NewMenubarProc(var Message: TMessage);
begin
end;

end.
