unit Srep;

{
              Delphi 1.0.
    , , , (c) 1996 ..
           . (432)-467379, FidoNet 2:4625/30.16.
}

interface

uses
  SysUtils, WinProcs, WinTypes, Controls, Classes, Forms, DB,
  Dialogs, StdCtrls, SoUtils;

type
 JustifyType = ( JLeft, JMiddle, JRight );
 TCharSet = Set of Char;
 TSReportEvent = procedure of object;
 TPrintTo = (toFile, toDevice);

 TOnGetField = procedure (Sender : TObject; FieldName : string;
               var StrValue : string) of object;
 TAfterLinePrinted = procedure (Sender : TObject; CurrentLine : LongInt) of object;

 TCustomSReport = class (TComponent)
 protected
  {Variables}
  UserLine   : boolean; {true    PrintLine}
  FLpt       : integer; {Added by Wizard}
  FForm, FOut: String;
  FSource: TDataSource;
  StartPage, EndPage, RepFile, FCalc, FAnswer: TStringList;
  FPrintTo: TPrintTo;
  FStartHgt, FEndHgt, PrnLns, MaxMemo: Integer;
  MemoIndex, FCount, FPageHgt: Integer;
  FAfterDet, FBeforeDetail, FPagePrinted: TSReportEvent;
  FGetField  : TOnGetField;
  FAfterLine : TAfterLinePrinted;
  FCurrentLine : LongInt;
 private
  {Private variables}
  DetailMemos: String;

  {Additional methods}
  procedure SetSource (Value: TDataSource);
  procedure SetAnswer (Value: TStringList);
  procedure SetCalc (Value: TStringList);
  procedure SetLpt (Value : integer); {Added by Wizard}
 public
  {Methods}
  constructor Create (AOwner: TComponent); override;
  destructor Destroy;override;
  procedure PrintRep;
  procedure PrintOneStr (St: String);
  function PrintDet (St: String): Integer;
  procedure GetMaxMemoLines;
  function  GetLineOfMemo (FName: String; LIndex: Integer): String;
  function  TranslateVar (VarText: String): String;
  function  SAnsiToOEM (St: String): String;
  procedure PrintLine (Value : string);
  procedure PrintFile (FileName : string; Copies : integer);

  {Properties}
  property Answers: TStringList read FAnswer write SetAnswer;
  property DataSource: TDataSource read FSource write SetSource;
  property EndHgt: Integer read FEndHgt write FEndHgt;
  property FormName: String read FForm write FForm;
  property LPT : integer read FLpt write SetLpt default 1;{Added by Wizard}
  property OutFile: String read FOut write FOut;
  property PageHeight: Integer read FPageHgt write FPageHgt;
  property PrintTo: TPrintTo read FPrintTo write FPrintTo;
  property StartHgt: Integer read FStartHgt write FStartHgt;

  {Calculated properties}
  property CalcColumns: TStringList read FCalc write SetCalc;
  property DetCount: Integer read FCount write FCount;
  property CurrentLine : LongInt read FCurrentLine;

  {Events}
  property AfterDetails: TSReportEvent read FAfterDet
                             write FAfterDet;
  property BeforeDetail: TSReportEvent read FBeforeDetail
                             write FBeforeDetail;
  property PagePrinted: TSReportEvent read FPagePrinted
                             write FPagePrinted;
  property OnGetField : TOnGetField read FGetField write FGetField;
  property AfterLinePrinted : TAfterLinePrinted read FAfterLine write FAfterLine;
 end;

 TSReport = class (TCustomSReport)
 published
  property Answers;
  property DataSource;
  property EndHgt;
  property FormName;
  property LPT;
  property OutFile;
  property PageHeight;
  property PrintTo;
  property StartHgt;

  property AfterDetails;
  property BeforeDetail;
  property PagePrinted;
  property OnGetField;
 end;

{Additional variables}
var
 Out: TextFile;
 Is_EndPage: Boolean;

procedure Register;

implementation

{$IFNDEF WIN32}
procedure SetBinaryMode;
begin
 {Set Out-file to binary mode}
 asm
  MOV   BX, offset(Out)
  MOV   AX,4400H
  INT   21H
  OR    DL,20H
  MOV   DH,0
  MOV   AX,4401H
  INT   21H
 end;
end;
{$ENDIF}

constructor TCustomSReport.Create (AOwner: TComponent);
begin
 inherited Create (AOwner);

 {Intializing defaults}
 UserLine:=false;
 FormName := '';
 OutFile := '';
 FAnswer := TStringList.Create;
 FCalc := TStringList.Create;
 RepFile := TStringList.Create;
 StartPage := TStringList.Create;
 EndPage := TStringList.Create;
 FStartHgt := 1;
 FEndHgt := 1;
 PrintTo := toDevice;
 PageHeight := 50;
 FLpt    := 1;
 FCurrentLine:=0;
end;

destructor TCustomSReport.Destroy;
begin
 {Disposing created objects}

 FAnswer.Free;
 FCalc.Free;
 RepFile.Free;
 StartPage.Free;
 EndPage.Free;
 FSource := nil;

 inherited Destroy;
end;

procedure TCustomSReport.PrintFile (FileName : string; Copies : integer);
var k,i : integer;
begin
 {Output filename is absent when print to file is set}
     if not FileExists(FileName) then  begin
        ErrorMsg(' '+FileName+'  .  .');
        exit;
     end;

     if FPrintTo = toFile then AssignFile (Out, FOut)
     else begin
      AssignFile (Out, 'LPT'+IntToStr(FLpt)); { Output port }
      {$IFNDEF WIN32}
      SetBinaryMode;
      {$ENDIF}
     end;

     if (FPrintTo = toFile) and (FOut = '') then begin
      ErrorMsg ('    .');
      Exit;
     end;

     ReWrite (Out);

     RepFile.Clear;
     RepFile.LoadFromFile(FileName);
     for i:=1 to Copies do begin
          FCurrentLine:=0;
          for k:=0 to RepFile.Count-1 do begin
             inc(FCurrentLine);
             writeLn(Out, RepFile[k]);
          end;
          if RepFile.Count*2>PageHeight then writeLn(Out,#$0C);
     end;

     {WriteLn (Out, #$0C);}

     CloseFile (Out);
end;

procedure TCustomSReport.SetLpt;
begin
     if (Value<1) or (Value>2) then exit;
     FLpt:=Value;
end;

procedure TCustomSReport.PrintRep;
var
 DetailNum, a: Integer;
 DetailSt: String;
begin
 {Name of form is absent}

 if FForm = '' then begin
  ErrorMsg ('   ');
  Exit;
 end;

 {Output filename is absent when print to file is set}

 if (FPrintTo = toFile) and (FOut = '') then begin
  ErrorMsg ('    .');
  Exit;
 end;

 {The height of the page is zero}

 if PageHeight = 0 then begin
  ErrorMsg ('   .');
  Exit;
 end;

 {Height of start of page is more than height of
  the page}

 if StartHgt > PageHeight then begin
  ErrorMsg ('   .');
  Exit;
 end;

 {The file of form not found}

 if FileSearch (FForm, '') = '' then begin
  ErrorMsg ('  .');
  Exit;
 end;

 if FPrintTo = toFile then AssignFile (Out, FOut)
 else begin
  AssignFile (Out, 'LPT'+IntToStr(FLpt)); { Output port }
  {$IFNDEF WIN32}
  SetBinaryMode;
  {$ENDIF}
 end;

 RepFile.LoadFromFile (FForm);
 ReWrite (Out);

 {Which string you want to repeat}

 DetailNum := RepFile.Count;

 DetailMemos := '';

 {Reading a start of page}

 StartPage.Clear;

 For a := 0 to FStartHgt - 1 do StartPage.Add (RepFile[a]);

 {Reading an end of page}

 EndPage.Clear;

 For a := FStartHgt to FStartHgt + FEndHgt - 1 do EndPage.Add (RepFile[a]);

 For a := FStartHgt + FEndHgt to RepFile.Count - 1 do begin
  if (RepFile[a]<>'') and (RepFile[a][1] = '>') then DetailNum := a;

  if (RepFile[a]<>'') and (RepFile[a][1] = '~') then DetailMemos := RepFile[a];
 end;

 PrnLns := 0;

 {Printing before detail string}

 For a := FStartHgt + FEndHgt to DetailNum - 1 do PrintOneStr( RepFile[a] );

 {Printing detail string}

 FCount := 0;
 FCalc.Clear;

 if (FSource <> nil) and (FSource.DataSet <> nil) and
        FSource.DataSet.Active and (DetailNum < RepFile.Count) then begin

  For a := 0 to FSource.DataSet.FieldCount - 1 do FCalc.Add ('0');

  DetailSt := RepFile[DetailNum];
  FSource.DataSet.First;

  While not FSource.DataSet.EOF do begin
   GetMaxMemoLines;

   PrintDet (DetailSt);

   FSource.DataSet.Next;
  end;

  if Assigned (FAfterDet) then FAfterDet;
 end;

 {Printing after detail string}

 if DetailNum <> RepFile.Count then
  For a := DetailNum + 1 to RepFile.Count - 1 do PrintOneStr( RepFile[a] );

 CloseFile (Out);
end;

procedure TCustomSReport.GetMaxMemoLines;
var
 SList: TStringList;
 a: Integer;
begin
 MaxMemo := 0;

 SList := TStringList.Create;

 For a := 0 to FSource.DataSet.FieldCount - 1 do begin
  if FSource.DataSet.Fields[a].DataType = ftMemo then begin
   SList.Assign (FSource.DataSet.Fields[a]);
   if (SList.Count > MaxMemo) and (Pos ('{@' +
     FSource.DataSet.Fields[a].FieldName, DetailMemos) <> 0) then
       MaxMemo := SList.Count;
  end;
 end;

 SList.Free;
end;

function TCustomSReport.GetLineOfMemo (FName: String;
                                LIndex: Integer): String;
var
 SList: TStringList;
begin
 Result := '';

 SList := TStringList.Create;

 if FSource.DataSet.FieldByName (FName).DataType = ftMemo then begin
  SList.Assign (FSource.DataSet.FieldByName (FName));

  if SList.Count > LIndex then
    Result := SList[LIndex];
 end;

 SList.Free;
end;

procedure TCustomSReport.SetSource (Value: TDataSource);
begin
 FSource := Value;
end;

procedure TCustomSReport.SetAnswer (Value:TStringList);
begin
 FAnswer.Assign (Value);
end;

procedure TCustomSReport.SetCalc (Value:TStringList);
begin
 FCalc.Assign (Value);
end;

procedure TCustomSReport.PrintOneStr (St: String);
var
 S, V: String;
 a: Integer;
 Is_V: Boolean;
begin
 if St = DetailMemos then  Exit;
 S := '';
 Is_v := False;
 if (not IS_EndPage) and (not UserLine) then inc(FCurrentLine);

 For a := 1 to Length (St) do begin
  if St[a] = '{' then begin
   V := St[a];
   Is_V := True;
   Continue;
  end;

  if Is_V then V := V + St[a];

  if St[a] = '}' then begin
   S := S + TranslateVar (V);
   Is_V := False;
   V := '';
   Continue;
  end;

  if not Is_v then S := S + St[a];
 end;

 WriteLn (Out, S);
 if (Assigned(FAfterLine)) and (not Is_EndPage) and (not UserLine)
    then FAfterLine(self,FCurrentLine);

 if Is_EndPage then Exit;

 Inc (PrnLns);

 if (PrnLns = FPageHgt) then begin
   Is_EndPage := True;

  For a := 0 to FEndHgt - 1 do PrintOneStr (EndPage[a]);

  WriteLn (Out, #$0C);

  If Assigned (FPagePrinted) then FPagePrinted;
  PrnLns := 0;

  Is_EndPage := False;

  For a := 0 to FStartHgt - 1 do PrintOneStr (StartPage[a]);
 end;
end;

function TCustomSReport.PrintDet (St: String): Integer;
var
 a: Integer;
 S: String;
begin
 if Assigned (FBeforeDetail) then
      FBeforeDetail;

 St := Copy (St, 2, Length (St) - 1);

 MemoIndex := 0;

 PrintOneStr (St);

 if MemoIndex < MaxMemo - 1 then begin
  repeat
   Inc (MemoIndex);
   PrintOneStr (Copy (DetailMemos, 2, Length (DetailMemos) - 1));
  until MemoIndex = MaxMemo - 1;
 end;

 Result := MemoIndex + 1;

 Inc (FCount);

 For a := 0 to FSource.DataSet.FieldCount - 1 do begin
  if FSource.DataSet.Fields[a].DataType in
       [ftSmallint, ftInteger, ftWord, ftFloat, ftCurrency] then begin
   S := FCalc[a];
   S := FSource.DataSet.Fields[a].DisplayText; {Added by Wizard}
   FCalc[a] := S;
  end;
 end;
end;

function TCustomSReport.TranslateVar (VarText: String): String;

procedure CutSt( St, Divider: String; ListSt: TStringList );
var
 S: String;
 Pos: Integer;
begin
 Pos := 1;
 S := '';

 ListSt.Clear;

 While Pos <= Length( St ) do begin
  if St[ Pos ] = Divider then begin
   ListSt.Add( S );
   S := '';
  end
  else S := S + St[ Pos ];
  Inc( Pos );
 end;

 ListSt.Add( S );
end;

function Justify( St: String; Len: Byte; Just: JustifyType ): String;
var
 J: JustifyType;
begin
 Result := St;
 if Just = JLeft then while Length( Result ) < Len do Result := Result + ' ';

 if Just = JRight then
  while Length( Result ) < Len do Result := ' ' + Result;

 J := JLeft;
 if Just = JMiddle then begin
  while Length( Result ) < Len do begin
   Result := Justify( Result, Length( Result ) + 1, J );
   if J = JLeft then J := JRight
   else J := JLeft;
  end;
 end;

 if Length( St ) > Len then result := copy( St, 1, len );
end;

function DelOnlyNot( S: String; ChSet: TCharSet ): String;
var
 Res: String;
 a: Integer;
begin
 Res := '';
 For a := 1 to Length( S ) do
   if S[ a ] in ChSet then Res := Res + S[ a ];
 DelOnlyNot := Res;
end;

const
 nName = 0;
 nJust = 1;
 nLen  = 2;

 sLft: TCharSet = ['L', 'l'];
 sRgt: TCharSet = ['R', 'r'];
 sMid: TCharSet = ['M', 'm'];

var
 SList: TStringList;
 J: JustifyType;
 Len: Integer;
 S, Value: String;
begin
 Len := 0;

 SList := TStringList.Create;
 VarText := Copy (VarText, 2, Length (VarText) - 2);

 CutSt (VarText, ',', SList);

 J := jLeft;
 if SList[nJust][1] in sRgt then J := jRight;
 if SList[nJust][1] in sMid then J := jMiddle;

 S := DelOnlyNot (SList[nLen], ['0'..'9']);

 if Length (S) = 0 then S := '0';
 Len := StrToInt (S);

 S := SList[nName];

 if S[1] = '@' then begin
    S := Copy (S, 2, Length (S) - 1);
    if FSource.DataSet.FindField(S)=nil then Value:='not found'
    else
       begin
          if FSource.DataSet.FieldByName (S).DataType = ftMemo then
             begin Value := GetLineOfMemo (S, MemoIndex); end
          else
             begin
                 {All before 'else' and include last one - added by Wizard}
                 if FSource.DataSet.FieldByName (S).DataType in [ftSmallint,
                    ftInteger, ftWord, ftFloat, ftCurrency] then
                    Value := FSource.DataSet.FieldByName (S).DisplayText
                 else Value := FSource.DataSet.FieldByName (S).AsString;
             end;
       end;
    if Assigned(FGetField) and (not UserLine) then FGetField(self,S,Value);
  end
 else
  begin
       S := DelOnlyNot (S, ['0'..'9']);
       if Length (S) = 0 then S := '0';

       Value := FAnswer[StrToInt (S)];
  end;
  Value := SAnsiToOEM (Value);
  if Len <> 0 then Value := Justify (Value, Len, J);

  Result := Value;
end;

procedure TCustomSReport.PrintLine (Value : string);
begin
     UserLine:=true;
     PrintOneStr(Value);
     UserLine:=false;
end;

function TCustomSReport.SAnsiToOEM (St: String): String;
var res : string;
    k   : integer;
begin
     res:=St+#0;
     for k:=1 to length(St) do
      if res[k]=#160 then res[k]:=#32; {Change strange space on normal one}
     AnsiToOEM(@res[1],@res[1]);
     Result:=Copy(res,1,length(res)-1);
end;

procedure Register;
begin
   RegisterComponents('SOHO-Tools',[TSReport]);
end;

end.
