{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoSizeF;

{$I SOHOLIB.INC}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, SoTools, SohoBtns, SoCtrls;

type
  TsohoSizeForm = class(TForm)
    HorizontalSize: TRadioGroup;
    VerticalSize: TRadioGroup;
    sohoBitBtn1: TsohoBitBtn;
    sohoBitBtn2: TsohoBitBtn;
    GroupBox1: TGroupBox;
    SizeWidth: TsohoEdit;
    SizeHeight: TsohoEdit;
    Label1: TLabel;
    FormWidthE: TsohoEdit;
    Label2: TLabel;
    FormHeightE: TsohoEdit;
    procedure FormShow(Sender: TObject);
    procedure SizeWidthChange(Sender: TObject);
    procedure SizeWidthEnter(Sender: TObject);
    procedure SizeHeightEnter(Sender: TObject);
  private
    { Private declarations }
     function GetSize (var aWidth,aHeight : integer;
                       var aWidthValue, aHeightValue : integer;
                       FirstControl : TControl) : boolean;
  public
    { Public declarations }
  end;

var SizeForm: TsohoSizeForm;

function GetControlsSize (var aWidth,aHeight : integer;
                          var aWidthValue, aHeightValue : integer;
                          FirstControl : TControl) : boolean;

implementation

{$R *.DFM}
function GetControlsSize (var aWidth,aHeight : integer;
                          var aWidthValue, aHeightValue : integer;
                          FirstControl : TControl) : boolean;
begin
   Result := false;
   try
     SizeForm := TsohoSizeForm.Create(Application);
     Result := SizeForm.GetSize(aWidth,aHeight,aWidthValue, aHeightValue,FirstControl);
   finally
     SizeForm.Free;
   end;
end;

function TsohoSizeForm.GetSize (var aWidth,aHeight : integer;
                  var aWidthValue, aHeightValue : integer;
                  FirstControl : TControl) : boolean;
begin
    if FirstControl<>nil then begin
      SizeWidth.AsInteger := FirstControl.Width;
      SizeHeight.AsInteger := FirstControl.Height;
    end;
    Result := ShowModal = mrOk;
    if not Result then exit;
    aWidth  := HorizontalSize.ItemIndex;
    aHeight := VerticalSize.ItemIndex;
    aWidthValue := SizeWidth.AsInteger;
    aHeightValue := SizeHeight.AsInteger;
end;

procedure TsohoSizeForm.FormShow(Sender: TObject);
begin
    HorizontalSize.ItemIndex := 0;
    VerticalSize.ItemIndex   := 0;
end;

procedure TsohoSizeForm.SizeWidthChange(Sender: TObject);
begin
   with (Sender as TsohoEdit) do
    if Text<>'' then
     if AsInteger<0 then AsInteger := 0;
end;

procedure TsohoSizeForm.SizeWidthEnter(Sender: TObject);
begin
    HorizontalSize.ItemIndex := 3;
end;

procedure TsohoSizeForm.SizeHeightEnter(Sender: TObject);
begin
    VerticalSize.ItemIndex   := 3;
end;

end.
