{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoPropE;
{$I SOHOLIB.INC}

interface

uses DsgnIntf;

type

  TsohoStringProperty = class(TStringProperty)
  public
        procedure sohoAttr (var Mask,Title,FileNames : string);virtual;
        function  GetAttributes: TPropertyAttributes; override;
        procedure Edit; override;
  end;

  TFileNameProperty = class(TsohoStringProperty)
  public
        procedure sohoAttr (var Mask,Title,FileNames : string);override;
  end;

  TWavFileNameProperty = class(TsohoStringProperty)
  public
        procedure sohoAttr (var Mask,Title,FileNames : string);override;
  end;

  TIniFileNameProperty = class(TsohoStringProperty)
  public
        procedure sohoAttr (var Mask,Title,FileNames : string);override;
  end;

  TsohoDirNameProperty = class(TStringProperty)
  public
     procedure sohoAttr (var Title,MustExistFile : string);virtual;
     function  GetAttributes: TPropertyAttributes; override;
     procedure Edit; override;
  end;

  TTTFDirNameProperty = class(TsohoDirNameProperty)
  public
        procedure sohoAttr (var Title,MustExistFile : string);override;
  end;

  TsohoEditProperty = class(TClassProperty)
  public
    function GetAttributes : TPropertyAttributes; override;
  end;

  TsohoLabelProperty = class(TClassProperty)
  public
    function GetAttributes : TPropertyAttributes; override;
  end;

  {$IFDEF Ver40}
  TsohoMinMaxEditor = class (TComponentEditor)
    function  GetVerbCount : integer; override;
    function  GetVerb (Index : integer) : string; override;
    procedure ExecuteVerb (Index : integer);override;
  end;

  TsohoCheckLBItems = class (TClassProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;
  {$ENDIF}

  TsohoListBoxItems = class (TClassProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TsohoStringGridEditor = class (TComponentEditor)
    function  GetVerbCount : integer; override;
    function  GetVerb (Index : integer) : string; override;
    procedure ExecuteVerb (Index : integer);override;
  end;

  TsohoEnterTabEditor = class (TComponentEditor)
    function  GetVerbCount : integer; override;
    function  GetVerb (Index : integer) : string; override;
    procedure ExecuteVerb (Index : integer);override;
  end;

  TsohoHintsFileNameProperty = class(TsohoStringProperty)
  public
        procedure sohoAttr (var Mask,Title,FileNames : string);override;
  end;

  TsohoHintsCollectorEditor = class (TComponentEditor)
    function  GetVerbCount : integer; override;
    function  GetVerb (Index : integer) : string; override;
    procedure ExecuteVerb (Index : integer);override;
  end;

implementation
uses SysUtils, Controls, Dialogs, Forms, SoSDlgs, SohoTabs, SoCtrls,
     SoBrEd, Classes, SoGrdEd, Grids, {SohoGrid} SoGrids, SoTools,
     SoDualF, SoUtils, SohoHntE, IniFiles, SohoHntC;

function TsohoStringProperty.GetAttributes: TPropertyAttributes;
begin
     Result := inherited GetAttributes + [paDialog];
end;

procedure TsohoStringProperty.sohoAttr;
begin
     {Abstract}
     Mask      := '*.*';
     FileNames := 'All files';
     Title     := 'SohoLib String Property Editor';
end;

procedure TsohoStringProperty.Edit;
var Temp: string;
    Msk,Ttl,FNms : string;
begin
     GetDir(0,Temp);
     with TOpenDialog.Create(Application) do
     try
        Options    := [ofFileMustExist, ofHideReadOnly];
        sohoAttr(Msk,Ttl,FNms);
        DefaultExt := Copy(Msk,pos('.',Msk)+1,length(Msk));
        Filter     := FNms+'('+Msk+')|'+Msk;
        Title      := Ttl;
        if Execute then SetStrValue(FileName);
     finally
        Free;
     end;
     ChDir(Temp);
end;

{-----------------TFileName Editor---------------------}
procedure TFileNameProperty.sohoAttr;
begin
     Mask      := '*.*';
     FileNames := 'All files';
     Title     := 'File name editor';
end;

{------------------TWavFileName Editor-----------------}
procedure TWavFileNameProperty.sohoAttr;
begin
     Mask      := '*.wav';
     FileNames := 'WAVE files';
     Title     := 'WAV-file name editor';
end;

{------------------TIniFileName Editor-----------------}
procedure TIniFileNameProperty.sohoAttr;
begin
     Mask      := '*.ini';
     FileNames := 'INI files';
     Title     := 'INI-file name editor';
end;

{------------------TsohoHintsFileName Editor-----------------}
procedure TsohoHintsFileNameProperty.sohoAttr;
begin
     Mask      := '*.hnt';
     FileNames := 'Hints files';
     Title     := 'Hints file name editor';
end;

{-----------------TsohoardDirName Editor-----------------}
procedure TsohoDirNameProperty.sohoAttr;
begin
     MustExistFile := '';
     Title         := 'Directory name editor';
end;

function TsohoDirNameProperty.GetAttributes: TPropertyAttributes;
begin
     Result := inherited GetAttributes + [paDialog];
end;

procedure TsohoDirNameProperty.Edit;
var Temp: string;
    Me,Ttl : string;
begin
     GetDir(0,Temp);
     with TsohoDirectoryDialog.Create(Application) do
     try
        sohoAttr(TTl,ME);
        FileMustExists := ME;
        Title          := Ttl;
        if Execute then SetStrValue(Directory);
     finally
        Free;
     end;
     ChDir(Temp);
end;

{-----------------TTTFDirName Editor-----------------}
procedure TTTFDirNameProperty.sohoAttr;
begin
     MustExistFile := '*.ttf';
     Title         := 'SohoLib TTF Directory Property Editor';
end;

{----------------------TsohoEditProperty--------------}
function TsohoEditProperty.GetAttributes : TPropertyAttributes;
begin
     Result := [paSubProperties, paReadOnly];
end;
{----------------------TsohoLabelProperty-------------------}
function TsohoLabelProperty.GetAttributes : TPropertyAttributes;
begin
     Result := [paSubProperties, paReadOnly];
end;

{----------------------- TsohoListBoxItems ------------------------}
procedure TsohoListBoxItems.Edit;
var WizLBEditorForm : TWizLBEditorForm;
begin
     WizLBEditorForm := TWizLBEditorForm.Create(Application);
     try
        with (GetComponent(0) as TsohoListBox) do begin
           WizLBEditorForm.wPreview.Items.Assign(TStrings(GetOrdValue));
           WizLBEditorForm.wPreview.Color := Color;
           WizLBEditorForm.wPreview.LeftField  := LeftField;
           WizLBEditorForm.wPreview.RightField := RightField;
        end;
        if WizLBEditorForm.ShowModal=mrOk then begin
          SetOrdValue(Longint(WizLBEditorForm.wPreview.Items));
        end;
     finally
        WizLBEditorForm.Free;
     end;
end;

function TsohoListBoxItems.GetAttributes: TPropertyAttributes;
begin
     Result := [paDialog];
end;

{-------------------------- TsohoStringGridEditor -------------------------}
function TsohoStringGridEditor.GetVerbCount : integer;
begin
     Result := 1;
end;

function TsohoStringGridEditor.GetVerb (Index : integer) : string;
begin
     case Index of
       0 : Result := '&Edit the grid';
     end;
end;

procedure TsohoStringGridEditor.ExecuteVerb (Index : integer);
var GridEditorForm: TGridEditorForm;

begin
     try
        GridEditorForm := TGridEditorForm.Create(Application);
        GridEditorForm.Prepare(TStringGrid(Component).ColCount,
                               TStringGrid(Component).RowCount);
        GridEditorForm.CopyFrom(TStringGrid(Component));
        if Component is TsohoStringGrid then GridEditorForm.vGrid.PopupMenu :=
             GridEditorForm.AlignMenu
        else GridEditorForm.vGrid.PopupMenu := nil;
        if GridEditorForm.ShowModal = mrOk then begin
           GridEditorForm.CopyTo(TStringGrid(Component));
           Designer.Modified;
        end;
     finally
        GridEditorForm.Free;
     end;
end;

{-------------------------- TsohoEnterTabEditor -------------------------}
function TsohoEnterTabEditor.GetVerbCount : integer;
begin
     Result := 1;
end;

function TsohoEnterTabEditor.GetVerb (Index : integer) : string;
begin
     case Index of
       0 : Result := '&Edit OutList';
     end;
end;

procedure TsohoEnterTabEditor.ExecuteVerb (Index : integer);
var Ind          : integer;
    DualListForm : TComponentsDualListForm;
    Form         : TForm;
begin
     try
        DualListForm := TComponentsDualListForm.Create(Application);
        Form := GetOwnerForm(Component as TsohoEnterTab);
        for Ind := 0 to pred(Form.ControlCount) do
         if (Form.Components[Ind] is TWinControl) then begin
            if (Component as TsohoEnterTab).IndexOf(
                   TWinControl(Form.Components[Ind]))=-1 then
              DualListForm.FLeftList.Add(Form.Components[Ind])
            else DualListForm.FRightList.Add(Form.Components[Ind]);
         end;
         with DualListForm do begin
              Caption := (Component as TsohoEnterTab).Name+': OutList';
              LeftCaption.Caption := 'On Enter/Tab';
              RightCaption.Caption := 'On Tab only';
         end;
         if DualListForm.Execute then begin
            (Component as TsohoEnterTab).Clear;
            for Ind := 0 to pred(DualListForm.FRightList.Count) do
              (Component as TsohoEnterTab).AddControl(DualListForm.FRightList[Ind]);
            Designer.Modified;
         end;
     finally
        DualListForm.Free;
     end;
end;

{-------------------------- TsohoHintsCollectorEditor -------------------------}
function TsohoHintsCollectorEditor.GetVerbCount : integer;
begin
     Result := 3
end;

function TsohoHintsCollectorEditor.GetVerb (Index : integer) : string;
begin
     case Index of
       0 : Result := 'Edit hints';
       1 : Result := '-';
       2 : Result := 'Save hints';
     end;
end;

procedure TsohoHintsCollectorEditor.ExecuteVerb (Index : integer);
var Form : TForm;

    procedure SaveHints;
    var Index      : LongInt;
        OpenDialog : TOpenDialog;
        Ini        : TIniFile;
        WriteHint  : string;
    begin
         try
            OpenDialog := TOpenDialog.Create(nil);
            with OpenDialog do begin
               Filter := 'Hints files|*.HNT';
               Options := [ofOverwritePrompt, ofPathMustExist,ofHideReadOnly];
               if Execute then begin
                  Ini := TIniFile.Create(FileName);
                  with Ini do begin
                     for Index := 0 to pred(Form.ComponentCount) do
                      if IsProperty(Form.Components[Index],'Hint') then begin
                        WriteHint := GetStringProperty(Form.Components[Index],'Hint');
                        InfoMsg(WriteHint);
                        WriteHint := ChangeChars(WriteHint,#13,'|');
                        WriteHint := DeleteChars(WriteHint,[#10]);
                        InfoMsg(WriteHint);
                        WriteString((Component as TsohoHintsCollector).Section,
                                  Form.Components[Index].Name,WriteHint);
                      end;
                     Free;
                  end;
               end;
            end;
          finally
            OpenDialog.Free;
          end;
    end;
begin
     Form := GetOwnerForm(Component);
     if Form=nil then exit;
     case Index of
        0 : begin
              SetHintsExecute(Form);
              Designer.Modified;
        end;
        2 : SaveHints;
     end;
end;

end.
