{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                Written by Allex,VSM                   }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
     , ,
   ,      ,
  "" .  ,  
       
}
unit SohoWrds;

{$I SOHOLIB.INC}

interface

type
  { :   }
  TGender = (gnMale, gnFemale);

{     ""  }
function Real2Name(L: Double; G: TGender): string;
{        }
function Roubles: string;
{      ""     }
function FloatToRoubles(Value: Double): string;

{   ,     . 
     ,   Word :
  .|.|.
      ,    
   .  ,  ,    
   }
procedure WordToWordForm(const Word: string; var Form1, Form2, Form3: string);
{    }
function WordGender(const Word: string): TGender;

implementation
uses SoUtils, SysUtils;

var OldW: string;

function Roubles: string;
var suffix: string;
begin
  if OldW = '' then begin
    Result := '';
    exit;
  end;
  if OldW[2] = '1' then suffix := ''
  else
    case OldW[3] of
      '1': suffix := '';
      '2',
      '3',
      '4': suffix := '';
    else suffix := '';
    end;
  Result := '' + suffix;
end;

type

  Digits = array['0'..'9'] of string[15];

const

  unitsm: Digits  = ('', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
                     ' ', ' ');

  unitsf: array['0'..'2'] of string[12] = (' ', ' ', ' ');

  teens: Digits                         = (' ',
    ' ', ' ', ' ',
    ' ', ' ', ' ',
    ' ', ' ', ' ');

  tens: Digits                          = ('', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ');

  hunds: Digits                         = ('', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ');


function ThreeDigits(Data: string; G: TGender): string;
{   0   }
var N: Word;
  R: Integer;
  W: string;
begin
  OldW := Data;
  {Hundreds}
  W := hunds[Data[1]];
  val(Copy(Data, 2, 2), N, R);
  if N in [10..19] then W := W + teens[Data[3]]
  else begin
    W := W + tens[Data[2]];
    if G = gnMale then W := W + unitsm[Data[3]]
    else
      if Data[3] in ['1'..'2'] then W := W + unitsf[Data[3]]
      else W := W + unitsm[Data[3]];
  end;
  Result := W;
end;

function LastChars(Data: string; G: TGender): string;
begin
  if Data[2] = '1' then
    if G = gnMale then Result := ''
    else Result := ''
  else
    case Data[3] of
      '1': if G = gnMale then Result := ''
      else Result := '';
      '2',
        '3',
        '4': if G = gnMale then Result := ''
        else Result := '';
    else if G = gnMale then Result := ''
    else Result := '';
    end;
end;

function Real2Name(L: Double; G: TGender): string;
var Data : string;
    W    : string;
const Z = '000';

begin
  Result := '';
  if L < 0 then begin
    L := - L; Result := ' ' + Result;
  end;
  if L = 0 then begin
    Result := Result + unitsf['0'];
    exit;
  end;
  Str(L: 1: 0, Data);
  { Leading ZERO }
  while length(Data) < 255 do Data := '0' + Data;
  W := Copy(Data, length(Data) - 2 - 12, 3);
  Result := Result + ThreeDigits(W, G);
  if W <> Z then Result := Result + ' ' + LastChars(W, gnMale);
  W := Copy(Data, length(Data) - 2 - 9, 3);
  Result := Result + ThreeDigits(W, G);
  if W <> Z then Result := Result + ' ' + LastChars(W, gnMale);
  W := Copy(Data, length(Data) - 2 - 6, 3);
  Result := Result + ThreeDigits(W, G);
  if W <> Z then Result := Result + ' ' + LastChars(W, gnMale);
  W := Copy(Data, length(Data) - 2 - 3, 3);
  Result := Result + ThreeDigits(W, gnFemale);
  if W <> Z then Result := Result + ' ' + LastChars(W, gnFemale);
  W := Copy(Data, length(Data) - 2, 3);
  Result := Result + ThreeDigits(W, G);
end;

function WordGender(const Word: string): TGender;
begin
  Result := gnFemale;
  if Word = '' then exit;
  if Word[Length(Word)] = '' then Result := gnFemale
  else Result := gnMale;
end;

function IntToCopeckes (C : LongInt) : string;
var Last : byte;
begin
  Last := trunc(10*frac(c/10));
  case Last of
    1           : Result := '';
    2,3,4       : Result := '';
    0,5,6,7,8,9 : Result := '';
  end;
end;

function FloatToRoubles(Value: Double): string;
var Copeckes : LongInt;
begin
   Copeckes := round(frac(Value)*100);
   Result := Real2Name(trunc(Value), gnMale)+' '+Roubles;
   if Copeckes<>0 then Result := Result+' '+Real2Name(Copeckes, gnFeMale)+' '+
     IntToCopeckes(Copeckes);
end;

function WordToForm2(const Word: string): string;
begin
  Result := Word;
  if WordGender(Word) = gnFemale then Result[Length(Result)] := '';
end;

function WordToForm3(const Word: string): string;
begin
  Result := Word;
  if WordGender(Word) = gnFemale then Result[Length(Result)] := ''
  else Result := Result + '';
end;

procedure WordToWordForm(const Word: string; var Form1, Form2, Form3: string);
begin
  if Word = '' then exit;
  SetDivisers(['|']);
  Form1 := GetSomeWords(Word, 1, 1);
  Form2 := GetSomeWords(Word, 2, 2);
  Form3 := GetSomeWords(Word, 3, 3);
  if Form2 = '' then Form2 := WordToForm2(Form1);
  if Form3 = '' then Form3 := WordToForm3(Form1);
end;

end.

