{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoTreeView -    
 SohoLib        
}
unit SohoTree;

{$I SOHOLIB.INC}


interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Controls, DB,
     DBTables, SoCtmTre, SoDBGrid;

type
  
  {  TsohoTreeView -  ,    :
    TOutLine ( GroupOutLine)  TsohoDBGrid ( DBGrid).  
         -     .
    ,       .   
      Id (ftInteger) -   , Hash (ftInteger) - 
        , IdGrp (ftInteger) -   
    ,     , Name -  .    
          TsohoTreeView.     
    ,       OrderField.   
      : Id, Hash, IdParent (ftInteger) -   
     , Name -  .     ,  
      .      design-time,  
    Component Editor',   TsohoTreeView.   TsohoTreeView 
     TDataSet',         ,   -  
    .       GroupsDataSet  ItemsDataSet.  ,
           GroupsTable  ItemsTable (,
    ItemsTable := "items.db").     TsohoTreeView 
     ,         
     OnNewItem  OnItemEdit.     
          TsohoTVContainer.
     :  "" -      OutLine - 
       OutLine!     ,    
     'Id'      !  ,  
    TsohoTreeView,      .  ,
         ,     
     Hash,  TsohoTreeView     :
        Drag&Drop   , 
        ,   .  Ctrl+Ins 
    Shift-Ins   ""   .   
        ,      
          . TsohoTreeView  
       ( Folder)      ,
       OutLine,    ,    
    IncludeSubTree.
  }
  TsohoTreeView = class(TsohoCustomTreeView)
  private
    { Private declarations }
    OperationQuery: TQuery;
    FDataBaseName : string;
  protected
    { Protected declarations }
    function CreateGroupsTree: boolean;override;
    function  RenumberRecords: boolean;override;
    function  DeleteOneRecord(var ManyDelete: boolean; ItemID: Longint): boolean;override;
    procedure MoveGroup (NewParentId, NewHash, Id : LongInt);override;
    function  TreeViewGetGroupsIds(const aFixedGrpName, aGroupTable: string;
              var Ids: TsohoDBGridResults): boolean;override;
  public
    {          }
    function QuietAddGroup(var NewName: string): boolean; override;
    {          }
    function QuietEditGroup(var NewName: string): boolean; override;
    {   }
    function DeleteGroup: boolean; override;
    {   }
    function MoveItem: boolean; override;
    {   }
    function DeleteItem: boolean; override;
    {     Hash    }
    function GetNewItemHash(GrpId: Longint; AIdGroupField: string): Longint;override;
    {     .   
      Id, IdGrp, Hash }
    function AddNewItem(GrpId, ItemID, ItemHash: Longint): boolean;override;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    {     }
    property DataBaseName : string read FDataBaseName write FDataBaseName;
  end;

function GroupsIdsToStr(const KeyField, GrpField, aFixedGrpName, GroupTable, DataBaseName: string): string;

implementation
uses SohoWrds, SoUtils, SoUnit, SoCtmRgs, SoDBCns;

function GetGroupsIds(const KeyField, aFixedGrpName, aGroupTable, aDataBaseName: string; var Ids: TsohoDBGridResults): boolean;
var Query: TQuery;
  AddedCount      : Integer;
  CurId, CurParent: Longint;
begin
  Result := False;
  Query := TQuery.Create(nil);
  SetCursor(crHourGlass);
  with Query, SQL do begin
    DataBaseName := aDataBaseName;
    if ExtractFileExt(aGroupTable)<>'' then
       Add('select * from "' + aGroupTable + '"')
    else
       Add('select * from ' + aGroupTable);
    Add('order by IdParent, '+KeyField);
    try
      Open;
    except
      Free;
      exit;
    end;
  end;
  with Query do begin
    First;
    while (not EOF) and (FieldByName('Name').AsString <> aFixedGrpName) do Next;
    if FieldByName('Name').AsString = aFixedGrpName then
      Ids.Add(FieldByName(KeyField).AsInteger)
    else begin
      Query.Free;
      RestoreCursor;
      exit;
    end;
    AddedCount := -1;
    while AddedCount <> 0 do begin
      First;
      AddedCount := 0;
      while not EOF do begin
        CurId := FieldByName(KeyField).AsInteger;
        CurParent := FieldByName('IdParent').AsInteger;
        if (Ids.IndexOf(CurParent) <> -1) and
          (Ids.IndexOf(CurId) = -1) then begin
          Ids.Add(CurId);
          Inc(AddedCount);
        end;
        Next;
      end;
    end;
    Free;
  end;
  Result := True;
  RestoreCursor;
end;

function GroupsIdsToStr(const KeyField, GrpField, aFixedGrpName, GroupTable, DataBaseName: string): string;
var Ids: TsohoDBGridResults;
  index: Longint;
begin
  Ids := TsohoDBGridResults.Create;
  Result := '('+GrpField+' = 0)';
  if GetGroupsIds(KeyField, aFixedGrpName, GroupTable, DataBaseName, Ids) then
    for index := 0 to pred(Ids.Count) do begin
      Result := Result + '('+GrpField+'=' + IntToStr(Ids.Items[index]) + ')';
      if index <> pred(Ids.Count) then Result := Result + ' or ';
    end;
  Ids.Free;
end;

{ TsohoTreeView }
function  TsohoTreeView.TreeViewGetGroupsIds(const aFixedGrpName, aGroupTable: string;
              var Ids: TsohoDBGridResults): boolean;
begin
  Result := GetGroupsIds(KeyField, aFixedGrpName, aGroupTable,
    FDataBaseName, Ids);
end;

function TsohoTreeView.QuietAddGroup(var NewName: string): boolean;
var ParentIndex, LastChildIndex, LastChildHash, NewGroupHash,
  NewGroupId, ParentId: Longint;
  Query               : TQuery;
  Allow               : boolean;
  F1, F2, F3          : string;
  aOnNewCust          : TsohoTreeCustomGroup;
  aOnNew              : TsohoTreeOnNewGroup;

  procedure CreateInsertQuery;
  begin
    Query := TQuery.Create(Self);
    Query.DataBaseName := DataBaseName;
    with Query, SQL do begin
      if ExtractFileExt(GroupsTable)<>'' then
        Add('Insert into "' + GroupsTable + '"')
      else
        Add('Insert into ' + GroupsTable);
      Add('('+KeyField+', '+HashField+', '+NameParentID+', Name)');
      NewGroupId := SoUnit.GetNewId(GetNewGroupIdPreffix);
      Add('Values (' + IntToStr(NewGroupId) + ', ' + IntToStr(NewGroupHash) + ',');
      ParentId := GetLeafRecord(ParentIndex).ItemID;
      Add(IntToStr(ParentId) + ',"' + NewName + '")');
    end;
  end;

begin
  Result := False;
  WordToWordForm(GroupsName, F1, F2, F3);
  with GroupOutLine do begin
    ParentIndex := Items[SelectedItem].index;
    LastChildIndex := Items[ParentIndex].GetLastChild;
    if LastChildIndex = -1 then NewGroupHash := 0
    else begin
      LastChildHash := GetLeafRecord(LastChildIndex).ItemHash;
      NewGroupHash := GetHash(LastChildHash, MaxLongint);
    end;
  end;
  {  Hash    }
  try
    CreateInsertQuery;
    try
      Allow := True;
      aOnNewCust := OnCustomNewGrp;
      aOnNew     := OnNewGrp;

      if Assigned(aOnNewCust) then aOnNewCust(Self, NewGroupId,
        NewGroupHash, ParentId, NewName, Allow)
      else if Assigned(aOnNew) then aOnNew(Self, SohoTreeNode(NewName, NewGroupId), Allow);
      if Allow then begin
        if not Assigned(aOnNewCust) then begin
          SetCursor(crHourGlass);
          Query.ExecSQL;
        end;
        {     }
        if AddTreeItem(NewGroupId, ParentId, NewGroupHash,
          ParentIndex, NewName) then
          with GroupOutLine do begin
            Items[ParentIndex].Expand;
            SelectedItem := GetIndexByName(NewName);
          end;
        {   OutLine }
        Result := True;
      end;
      if Allow and Assigned(aOnNewCust) then RefreshTreeView;
      Changed;
    except
      // RestoreCursor;
      ErrorMsg(Format(sohoTreeGroupDontCreate, [Name, F1]));
    end;
  finally
    Query.Free;
    RestoreCursor;
  end;
end;

function TsohoTreeView.MoveItem: boolean;
var Allow: boolean;
  index: Integer;

  procedure DoMoveItem(aItemId, aNewGrpId, aNewHash: Longint);
  var aOnMove : TsohoTreeOnMoveItem;
  begin
    OperationQuery.DataBaseName := DataBaseName;
    with OperationQuery, OperationQuery.SQL do begin
      Allow := True;
      aOnMove := OnItemMove;
      if Assigned(aOnMove) then
        aOnMove(Self, FMoveItem.OldGrpId, aNewGrpId, aItemId, aNewHash, Allow);
      if not Allow then exit;
      Clear;
      if ExtractFileExt(ItemsTable) <> '' then
        Add('update "' + ItemsTable + '"')
      else
        Add('update ' + ItemsTable);
      Add('set '+NameGroupID+'=' + IntToStr(aNewGrpId) + ', '+
          HashField+'=' + IntToStr(aNewHash));
      Add('where '+KeyField+'=' + IntToStr(aItemId));
      try
        try
          SetCursor(crHourGlass);
          ExecSQL;
          Result := True;
          Changed;
        except
          // RestoreCursor;
          ErrorMsg(Format(sohoTreeErrorOnItemMove, [Name]));
        end;
      finally
        RestoreCursor;
      end;
    end;
  end;

begin
  { Event on drag and drop }
  Result := False;
  if not (trMoveItem in Options) then exit;
  if ItemsTable = '' then begin
    ErrorMsg(Format(sohoTreeItemsTableNotDefined,[Name]));
    exit;
  end;
  if DBGrid.Results.Count = 0 then DoMoveItem(FMoveItem.ID, FMoveItem.NewGrpId,
    FMoveItem.NewHash)
  else
    for index := 0 to pred(DBGrid.Results.Count) do begin
      FMoveItem.NewHash := GetHash(FMoveItem.NewHash, RightHash);
      DoMoveItem(DBGrid.Results.Items[index], FMoveItem.NewGrpId,
                 FMoveItem.NewHash);
    end;
  DBGrid.Results.Clear;
  RefreshItems;
end;

function TsohoTreeView.QuietEditGroup(var NewName: string): boolean;
var CurIndex: Longint;
  aGroupId, aGroupHash,
   aParentId: Longint;
  Query      : TQuery;
  Allow      : boolean;

  procedure CreateUpdateQuery;
  begin
    Query := TQuery.Create(Self);
    Query.DataBaseName := DataBaseName;
    with Query, SQL do begin
      if ExtractFileExt(GroupsTable)<>'' then
        Add('Update "' + GroupsTable + '"')
      else
        Add('Update ' + GroupsTable);
      Add('Set Name="' + NewName + '"');
      aGroupId := GetLeafRecord(CurIndex).ItemID;
      aGroupHash := GetLeafRecord(CurIndex).ItemHash;
      aParentId := GetLeafRecord(CurIndex).ParentId;
      Add('Where '+KeyField+'=' + IntToStr(aGroupId));
    end;
  end;

var aOnCustEd : TsohoTreeCustomGroup;
    aOnEdit   : TsohoTreeOnEditGroup;
begin
  Result := False;
  CurIndex := GroupOutLine.SelectedItem;
  try
    try
      CreateUpdateQuery;
      Allow := True;
      aOnCustEd := OnCustomEditGrp;
      aOnEdit := OnGrpEdit;
      if Assigned(aOnCustEd) then aOnCustEd(Self, aGroupId,
        aGroupHash, aParentId, NewName, Allow)
      else if Assigned(aOnEdit) then aOnEdit(Self,
        SohoTreeNode(GroupOutLine.Items[CurIndex].Text, aGroupId), Allow);
      if Allow then begin
        if not Assigned(aOnCustEd) then begin
          SetCursor(crHourGlass);
          Query.ExecSQL;
        end;
        GroupOutLine.Items[CurIndex].Text := NewName;
        Result := True;
        if Allow and Assigned(aOnCustEd) then RefreshTreeView;
        Changed;
      end;
    except
      // RestoreCursor;
      ErrorMsg(Format(sohoTreeGroupRenameError, [Name]));
    end;
  finally
    Query.Free;
    RestoreCursor;
  end;
end;

function TsohoTreeView.DeleteGroup: boolean;
var JustOneDelete: boolean;
  WasChecked: boolean;

  function DeleteSubTree(TreeIndex, GrpId: Longint): boolean;
  var GrpName: string;
    BottomIndex, TopIndex: Longint;
    index                : Longint;
    DeleteThatGroup      : boolean;
    DeleteMany           : boolean;
    aOnDel               : TsohoTreeOnDeleteGroup;

  begin
    GrpName := GroupOutLine.Items[TreeIndex].Text;
    aOnDel := OnGrpDelete;
    if Assigned(aOnDel) then aOnDel(Self, GrpId, Result)
    else Result := YesNoMsg(Format(sohoTreeDeleteGroup, [Name, GrpName]));
    if not Result then exit;
    TopIndex := GroupOutLine.Items[TreeIndex].GetFirstChild;
    BottomIndex := GroupOutLine.Items[TreeIndex].GetLastChild;
    {  ,  ...  :( }
    { ,  ,        
          ,     . ,    
             :) }
    DeleteThatGroup := True;
    if TopIndex <> -1 then begin
      index := TopIndex;
      while index <= BottomIndex do begin
        if not DeleteSubTree(index, GetLeafRecord(index).ItemID) then
          DeleteThatGroup := False
        else JustOneDelete := True;
        Inc(index);
      end;
    end;
    {     -   ,
           IdGrp  }
    try
      ItemsDataSet.DisableControls;
      GroupOutLine.SelectedItem := TreeIndex;
      OperationQuery.DatabaseName := DataBaseName;
      with OperationQuery, OperationQuery.SQL do begin
        Clear;
        if ExtractFileExt(ItemsTable) <> '' then
          Add('delete from "' + ItemsTable + '"')
        else
          Add('delete from ' + ItemsTable);
        Add('Where '+KeyField+'=:Id');
      end;
      DeleteMany := False;
      with ItemsDataSet do begin
        Refresh;
        {    }
        while not EOF do begin
          if not DeleteOneRecord(DeleteMany, ItemsDataSet.FieldByName(KeyField).AsInteger)
            then DeleteThatGroup := False
          else JustOneDelete := True;
          Next;
        end;
      end;
      {     }
      if DeleteThatGroup then
        with OperationQuery, OperationQuery.SQL do begin
          Clear;
          if ExtractFileExt(GroupsTable)<>'' then
             Add('delete from "' + GroupsTable + '"')
          else
             Add('delete from ' + GroupsTable);
          Add('Where '+KeyField+'=' + IntToStr(GrpId));
          try
            ExecSQL;
            JustOneDelete := True;
          except
            ErrorMsg(Format(sohoTreeGroupDeleteError, [Name, GrpName]));
          end;
        end;
    finally
      ItemsDataSet.EnableControls;
      Result := DeleteThatGroup;
    end;
  end;

var aAfterDel : TNotifyEvent;
begin
  Result := False;
  JustOneDelete := False;
  if not (trDeleteGroup in Options) then exit;
  WasChecked := ChildCheckBox.Checked;
  ChildCheckBox.Checked := False;
  Result := DeleteSubTree(GroupOutLine.SelectedItem,
    GetLeafRecord(GroupOutLine.SelectedItem).ItemID);
  {     ,   }
  ChildCheckBox.Checked := WasChecked;
  if not JustOneDelete then exit;
  aAfterDel := AfterGrpDelete;
  if Assigned(aAfterDel) then aAfterDel(Self);
  {    -   !}
  TreeViewButtonsClick(actRefresh);
  Changed;
end;

function TsohoTreeView.AddNewItem(GrpId, ItemID, ItemHash: Longint): boolean;
begin
  SetCursor(crHourGlass);
  Result := False;
  OperationQuery.DataBaseName := DataBaseName;
  with OperationQuery, OperationQuery.SQL do begin
    Clear;
    if ExtractFileExt(ItemsTable) <> '' then
      Add('insert into "' + ItemsTable + '" ('+KeyField+', '+NameGroupID+', '+HashField+')')
    else
      Add('insert into ' + ItemsTable + ' ('+KeyField+', '+NameGroupID+', '+HashField+')');
    Add('values (' + IntToStr(ItemID) + ', ' + IntToStr(GrpId) +
      ', ' + IntToStr(ItemHash) + ')');
    try
      ExecSQL;
      Result := True;
    except ErrorMsg(Format(sohoTreeItemAddError, [Name]));
    end;
  end;
  RestoreCursor;
end;

function TsohoTreeView.DeleteOneRecord(var ManyDelete: boolean; ItemID: Longint): boolean;
const MsgTexts: array[boolean] of string = (sohoTreeDeleteCurrentItem,
  sohoTreeDeleteSelectedItems);
var aOnDel : TsohoTreeOnDeleteItem;
begin
  Result := ManyDelete;
  aOnDel := OnItemDelete;
  if Assigned(aOnDel) then begin
    if not ManyDelete then aOnDel(Self, ItemID, ManyDelete, Result);
  end
  else
    if not ManyDelete then Result := YesNoMsg(MsgTexts[ManyDelete]);
  if not Result then exit;
  try
    with OperationQuery do begin
      Params[0].AsInteger := ItemID;
      try
        SetCursor(crHourGlass);
        ExecSQL;
        {         
                ! }
        Results.Remove(ItemID);
        Result := True;
      except ErrorMsg(Format(sohoTreeDeleteItemError, [name]));
      end;
    end;
  finally
    RestoreCursor;
  end;
end;

function TsohoTreeView.DeleteItem: boolean;
var ID, index: Longint;
  ManyDelete: boolean;
begin
  Result := False;
  if not (trDeleteItem in Options) then exit;
  if (ItemsDataSet = nil) or not (ItemsDataSet.Active) then exit;
  if ItemsDataSet.FieldByName(KeyField).IsNull then exit;
  Result := True;
  ID := ItemsDataSet.FieldByName(KeyField).AsInteger;
  ManyDelete := False;
  OperationQuery.DataBaseName := DataBaseName;
  with OperationQuery, OperationQuery.SQL do begin
    Clear;
    if ExtractFileExt(ItemsTable) <> '' then
      Add('delete from "' + ItemsTable + '"')
    else
      Add('delete from ' + ItemsTable);
    Add('Where '+KeyField+'=:Id');
  end;
  if Results.Count <> 0 then begin
    Result := False;
    {    ,      
           }
    index := 0;
    while index < Results.Count do begin
      if DeleteOneRecord(ManyDelete, Results.Items[index]) then Result := True
      else Inc(index);
    end;
  end
  else Result := DeleteOneRecord(ManyDelete, ID);
  {  -   ,    }
  if Result then begin
    RefreshItems;
    Changed;
  end;
end;

constructor TsohoTreeView.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  OperationQuery := TQuery.Create(Self);
  FDataBaseName := '';
end;

function TsohoTreeView.RenumberRecords: boolean;
var index: Longint;
  Number: Longint;
  FMany : boolean;
begin
  {    }
  Result := True;
  FMany := ChildCheckBox.Checked;
  ChildCheckBox.Checked := False;
  Number := 0;
  if SaveFile <> '' then SaveOutLineDescription(GroupOutLine, SaveFile);
  GroupOutLine.FullExpand;
  OperationQuery.DataBaseName := DataBaseName;
  for index := 1 to GroupOutLine.ItemCount do begin
    GroupOutLine.SelectedItem := index;
    ItemsDataSet.First;
    while not ItemsDataSet.EOF do begin
      Inc(Number);
      with OperationQuery, SQL do begin
        Clear;
        if ExtractFileExt(ItemsTable) <> '' then
          Add('update "' + ItemsTable + '" as Item')
        else
          Add('update ' + ItemsTable + ' as Item');
        Add('set Item."' + OrderField + '"=' + IntToStr(Number));
        Add('where Item.'+KeyField+'=' + ItemsDataSet.FieldByName(KeyField).AsString);
        ExecSQL;
      end;
      ItemsDataSet.Next;
    end;
  end;
  RefreshItems;
  try
    if SaveFile <> '' then ApplyOutLineDescription(GroupOutLine, SaveFile);
  except
  end;
  ChildCheckBox.Checked := FMany;
end;

destructor TsohoTreeView.Destroy;
begin
  OperationQuery.Free;
  inherited Destroy;
end;

procedure TsohoTreeView.MoveGroup (NewParentId, NewHash, Id : LongInt);
begin
  OperationQuery.DataBaseName := DataBaseName;
  with OperationQuery do begin
   Close;
   SQL.Clear;
   if ExtractFileExt(GroupsTable)<>'' then
     SQL.Add('Update "' + GroupsTable + '"')
   else
     SQL.Add('Update ' + GroupsTable);
   SQL.Add('Set '+HashField+'=' + IntToStr(NewHash) + ',');
   SQL.Add('    '+NameParentID+' =' + IntToStr(NewParentId));
   SQL.Add('Where '+KeyField+'=' + IntToStr(Id));
   try
    SetCursor(crHourGlass);
    ExecSQL;
   except
    RestoreCursor;
    ErrorMsg(Format(sohoTreeGroupMoveError,[Name]));
   end;
  end;
  RestoreCursor;
end;

function TsohoTreeView.GetNewItemHash;
var Temp: TQuery;
begin
  Result := MaxLongint;
  if ItemsTable = '' then begin
    ErrorMsg(Format(sohoTreeHashGetError,[Name]));
    exit;
  end;
  Temp := TQuery.Create(Self);
  Temp.DataBaseName := DataBaseName;
  with Temp, Temp.SQL do begin
    Clear;
    if ExtractFileExt(ItemsTable) <> '' then
      Add('select MAX('+HashField+') from "' + ItemsTable + '"')
    else
      Add('select MAX('+HashField+') from ' + ItemsTable);
    Add('Where ' + NameGroupID + '=' + IntToStr(GrpId));
    try
      Open;
      if EOF then Result := 0
      else Result := GetHash(Fields[0].AsInteger, MaxLongint);
      { Result = Fields[0].AsInteger  MaxLongInt, 
               }
      Close;
      Temp.Free;
    except ErrorMsg(Format(sohoTreeLastHashGetError,[Name]));
      Temp.Free;
    end;
  end;
end;

function TsohoTreeView.CreateGroupsTree: boolean;
begin
  if (FDataBaseName = '') and (SingleRegister<>nil) then
    FDataBaseName := SingleRegister.PathToData;
  Result := inherited CreateGroupsTree;
end;

end.

