{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
     TsohoTabSet  TsohoVertTabSet
}
unit SohoTabs;

{$I SOHOLIB.INC}

interface

uses WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, ExtCtrls, Tabs, Menus, SohoBtns, RxCtrls;

type

  {    OnTabSelect. TabIndex -    }
  TsohoTabSelect = procedure (Sender: TObject; TabIndex: Integer) of object;
  {       }
  TsohoTabKind = (tkHorizontal, tkVertical);

  {  ""   TNotebook.  
         ,
       .     
     TabEnabled,      
     }
  TsohoTabSet = class(TCustomControl)
  private
    { Private declarations }
    FKind: TsohoTabKind;
    FPopup: TPopupMenu;
    FTabReserve: Integer;
    FOffset: Integer;
    FAlign: tAlign;
    FTabs: TStringList;
    FNoteBook: TNoteBook;
    FIndex: Integer;
    FOnTrueDrawTab: TDrawTabEvent;
    FOnDrawTab: TDrawTabEvent;
    FOnMeasureTab: TMeasureTabEvent;
    FOnTabSelect: TsohoTabSelect;
    FActiveColor,
      FBackColor: TColor;
    FDisableColor: TColor;
    FHighLight,
      FShadow: TColor;
    FFirstTab: Integer;
    FBackBtn,
      FForwBtn: TRxSpeedButton;
    FLastDrawed: boolean;
    FTabsParColor: boolean;
    procedure CMParentColorChanged(var message: TMessage); message CM_PARENTCOLORCHANGED;
    procedure BeforePopup(Sender: TObject);
    procedure ClickMenu(Sender: TObject);
    function GetTabs: TStrings;
    function TabsCount: Integer;
    procedure SetKind(Value: TsohoTabKind);
    procedure SetTabs(Value: TStrings);
    procedure SetAlign(Value: tAlign);
    procedure SetIndex(Value: Integer);
    procedure SetNoteBook(Value: TNoteBook);
    procedure SetActiveCol(Value: TColor);
    procedure SetDisableCol(Value: TColor);
    procedure SetShadowCol(Value: TColor);
    procedure SetBackCol(Value: TColor);
    procedure SetHighLight(Value: TColor);
    procedure SetReserve(Value: Integer);
    procedure WMSize(var message: TWMSize); message WM_SIZE;
    procedure SetOffset(Value: Integer);
    procedure BtnsClick(Sender: TObject; Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer);
    procedure UpdateColors;
    procedure ShowButtons;
    procedure HideButtons;
    procedure SetTabsParColor(Value: boolean);
    procedure ReadEnabled(Stream: TStream);
    procedure WriteEnabled(Stream: TStream);
    procedure SetTabEnabled(index: Integer; Value: boolean);
    function GetTabEnabled(index: Integer): boolean;
  protected
    { Protected declarations }
    procedure RequestBounds; virtual;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure KeyDown (var Key: Word; Shift: TShiftState); override;
    procedure UpdateButtons; virtual;
    procedure DefineProperties(Filer: TFiler); override;
    procedure Paint; override;
    procedure Loaded; override;
  public
    {      }
    procedure DefaultTrueDrawTab(MemCanvas: TCanvas; R: TRect; index: Integer; Selected: boolean); virtual;
    {      }
    procedure DefaultDrawTab(MemCanvas: TCanvas; R: TRect; index: Integer; Selected: boolean); virtual;
    {  ,     }
    function MouseInTab(X, Y: Integer): Integer; virtual;
    {   }
    procedure DrawTab(MemCanvas: TCanvas; R: TRect; index: Integer; Selected: boolean); virtual;
    {    }
    procedure MeasureTab(index: Integer; var TabWidth: Integer); virtual;
    {  . Disabled-   }
    procedure UpdateTabs;
    {  tab }
    procedure AddTab(TabName: string; Enabled: boolean);
    {  tab }
    procedure InsertTab(TabName: string; Enabled: boolean; index: Integer);
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {      }
    property TabEnabled[index: Integer]: boolean read GetTabEnabled write SetTabEnabled;
  published
    property Ctl3D;
    property ParentCtl3D;
    {       }
    property Align: tAlign read FAlign write SetAlign default alTop;
    property Color;
    property ParentColor;
    property ParentFont;
    property TabOrder;
    property TabStop;
    property Visible;
    property Enabled;
    property DragCursor;
    property DragMode;
    property Font;
    property ParentShowHint;
    property PopupMenu;
    {    }
    property TabsKind: TsohoTabKind read FKind write SetKind;
    {    disabled- }
    property DisableColor: TColor read FDisableColor write SetDisableCol default clGray;
    {     parent   }
    property ParentTabsColor: boolean read FTabsParColor write SetTabsParColor default True;
    {       ,  "" }
    property TabReserve: Integer read FTabReserve write SetReserve default 6;
    {        TabSet }
    property PageOffset: Integer read FOffset write SetOffset default 4;
    {    }
    property TabIndex: Integer read FIndex write SetIndex;
    {   }
    property Tabs: TStrings read GetTabs write SetTabs;
    {  NoteBook }
    property NoteBook: TNoteBook read FNoteBook write SetNoteBook;
    {    }
    property ActiveColor: TColor read FActiveColor write SetActiveCol default clBtnFace;
    {    TabSet }
    property BackColor: TColor read FBackColor write SetBackCol default clBtnFace;
    {  ""  }
    property HighLight: TColor read FHighLight write SetHighLight default clBtnHighlight;
    {  "" }
    property Shadow: TColor read FShadow write SetShadowCol default clBtnShadow;
    {       }
    property OnMeasureTab: TMeasureTabEvent read FOnMeasureTab write FOnMeasureTab;
    {       }
    property OnTrueDrawTab: TDrawTabEvent read FOnTrueDrawTab write FOnTrueDrawTab;
    {          }
    property OnDrawTab: TDrawTabEvent read FOnDrawTab write FOnDrawTab;
    {       }
    property OnTabSelect: TsohoTabSelect read FOnTabSelect write FOnTabSelect;
    property OnClick;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;
  
  {    OnMeasureTab.  Index -  
      TabHeight -    }
  TMeasureVertTabEvent = procedure (Sender: TObject; index: Integer;
    var TabHeight: Integer) of object;
  {    OnTrueDrawTab  OnDrawTab. :
    TabCanvas -   ;
    R -  ,   ;
    Index -   ;
    Selected -       }
  TDrawVertTabEvent = procedure (Sender: TObject; TabCanvas: TCanvas;
    R: TRect; index: Integer; Selected: boolean) of object;

  {  TabSet -  TsohoTabSet,   
      }
  TsohoVertTabSet = class(TsohoTabSet)
  private
    {Private declarations}
    FOnTrueDrawTab: TDrawVertTabEvent; {  Rect}
    FOnDrawTab: TDrawVertTabEvent; {  Rect -   
                                         }
    FOnMeasureTab: TMeasureVertTabEvent;
  protected
    { Protected declarations }
    procedure WMSize(var message: TWMSize); message WM_SIZE;
    function GetAlign: tAlign;
    procedure SetAlign(Value: tAlign);
    procedure RequestBounds; override;
    procedure UpdateButtons; override;
    procedure Paint; override;
  public
    {  ,     }
    function MouseInTab(X, Y: Integer): Integer; override;
    {      }
    procedure DefaultTrueDrawTab(MemCanvas: TCanvas; R: TRect; index: Integer; Selected: boolean); override;
    {      }
    procedure DefaultDrawTab(MemCanvas: TCanvas; R: TRect; index: Integer; Selected: boolean); override;
    {    }
    procedure MeasureTab(index: Integer; var TabHeight: Integer); override;
    constructor Create(AOwner: TComponent); override;
  published
    {       }
    property Align: tAlign read GetAlign write SetAlign default alLeft;
    {       }
    property OnMeasureTab: TMeasureVertTabEvent read FOnMeasureTab write FOnMeasureTab;
    {       }
    property OnTrueDrawTab: TDrawVertTabEvent read FOnTrueDrawTab write FOnTrueDrawTab;
    {          }
    property OnDrawTab: TDrawVertTabEvent read FOnDrawTab write FOnDrawTab;
  end;
  
implementation
uses SoUtils, SysUtils, SoCmnCns;

{$IFDEF Win32}
{$R SOHOTABS.R32}
{$ELSE}
{$R SOHOTABS.R16}
{$ENDIF}

procedure DrawTabText(Kind: TsohoTabKind; Canvas: TCanvas; R: TRect;
    Caption: TCaption; Enabled: boolean; DisableColor: TColor;
    Align: tAlign);
var Angle, X, Y: Integer;
begin
  with Canvas do begin
    if Kind = tkVertical then begin
      if (Align = alLeft) or (Align = alTop) then begin
        Angle := 90;
        X := HorCenter(R, TextHeight(Caption));
        Y := R.Bottom - (VertCenter(R, TextWidth(Caption)) - R.Top);
      end
      else
        if (Align = alRight) or (Align = alBottom) then begin
          Angle := 270;
          X := R.Right - (HorCenter(R, TextHeight(Caption)) - R.Left);
          Y := VertCenter(R, TextWidth(Caption));
        end;
    end;
    if not Enabled then begin
      Font.Color := clWhite;
      if Kind = tkHorizontal then
        TextRect(R, 1 + HorCenter(R, TextWidth(Caption)),
        1 + VertCenter(R, TextHeight(Caption)), Caption)
      else AngleTextInRect(Canvas, Caption, R, X + 1, Y + 1, Angle);
      Font.Color := DisableColor;
    end;
    if Kind = tkHorizontal then
      TextRect(R, HorCenter(R, TextWidth(Caption)),
      VertCenter(R, TextHeight(Caption)), Caption)
    else AngleTextInRect(Canvas, Caption, R, X, Y, Angle);
  end;
end;

{ TsohoTabSet }
procedure TsohoTabSet.KeyDown (var Key: Word; Shift: TShiftState);
begin
  if Tabs.Count = 0 then begin
    inherited;
    exit;
  end;
  if Key = vk_Tab then begin
    if (ssCtrl in Shift) and (ssShift in Shift) then begin
       if FIndex > 0 then TabIndex := TabIndex - 1
       else TabIndex := Tabs.Count - 1;
    end
    else
      if ssCtrl in Shift then begin
        if FIndex < pred(Tabs.Count) then TabIndex := TabIndex + 1
        else TabIndex := 0;
      end
  end;
  inherited;
end;

procedure TsohoTabSet.AddTab(TabName: string; Enabled: boolean);
begin
  FTabs.Add(TabName);
  TabEnabled[FTabs.Count - 1] := Enabled;
end;

procedure TsohoTabSet.InsertTab(TabName: string; Enabled: boolean; index: Integer);
begin
  FTabs.Insert(index, TabName);
  TabEnabled[index] := Enabled;
end;

function TsohoTabSet.GetTabs: TStrings;
begin
  Result := TStrings(FTabs);
end;

function TsohoTabSet.TabsCount: Integer;
begin
  Result := FTabs.Count;
end;

procedure TsohoTabSet.SetTabs(Value: TStrings);
var index: Integer;
begin
  FTabs.Assign(Value);
  for index := 0 to TabsCount - 1 do TabEnabled[index] := True;
  UpdateButtons;
  Repaint;
end;

procedure TsohoTabSet.SetDisableCol(Value: TColor);
begin
  FDisableColor := Value;
  Repaint;
end;

procedure TsohoTabSet.SetIndex(Value: Integer);
begin
  if (FIndex = Value) or (Value > TabsCount - 1) then exit;
  if not (TabEnabled[Value]) and not (csDesigning in ComponentState) then exit;
  if (Value = -1) and (TabsCount > 0) then exit;
  FIndex := Value;
  Repaint;
  if Assigned(FOnTabSelect) then FOnTabSelect(Self, FIndex);
  if FNoteBook <> nil then FNoteBook.PageIndex := FIndex;
  if (Owner is TForm) and (csDesigning in ComponentState) then
    (Owner as TForm).Designer.Modified;
end;

procedure TsohoTabSet.SetNoteBook(Value: TNoteBook);
var index: Integer;
begin
  if FNoteBook = Value then exit;
  FNoteBook := Value;
  FTabs.Clear;
  if FNotebook <> nil then FTabs.Assign(FNoteBook.Pages);
  for index := 0 to TabsCount - 1 do TabEnabled[index] := True;
  if FNoteBook <> nil then FIndex := FNoteBook.PageIndex;
  Repaint;
end;

procedure TsohoTabSet.UpdateColors;
begin
  Color := GetParentColor(Self);
  FActiveColor := Color;
  FBackColor := Color;
  Repaint;
end;

procedure TsohoTabSet.SetTabsParColor(Value: boolean);
begin
  if FTabsParColor = Value then exit;
  FTabsParColor := Value;
  if Value then UpdateColors;
end;

procedure TsohoTabSet.CMParentColorChanged(var message: TMessage);
begin
  if FTabsParColor then UpdateColors;
  inherited;
  Repaint;
end;

procedure TsohoTabSet.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if (AComponent = FNoteBook) and (Operation = opRemove) then FNoteBook := nil;
  inherited Notification(AComponent, Operation);
end;

procedure TsohoTabSet.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties(Filer);
  Filer.DefineBinaryProperty('TabEnabled', ReadEnabled, WriteEnabled,
    TabsCount > 0);
end;

procedure TsohoTabSet.SetTabEnabled(index: Integer; Value: boolean);
var Tmp: Longint;
begin
  if (index < 0) or (index > TabsCount - 1) then exit;
  if Value then Tmp := 1
  else Tmp := 0;
  Tabs.Objects[index] := TObject(Tmp);
  Invalidate;
end;

function TsohoTabSet.GetTabEnabled(index: Integer): boolean;
var Tmp: Longint;
begin
  Result := False;
  if (index < 0) or (index > TabsCount - 1) then exit;
  Tmp := Longint(Tabs.Objects[index]);
  Result := Tmp <> 0;
end;

procedure TsohoTabSet.ReadEnabled(Stream: TStream);
var P, TmpP:^Integer;
  iP  : Integer absolute P;
  Size: Integer;           
  I   : Integer;           
begin
  Size := TabsCount * SizeOf(Integer);
  GetMem(P, Size);
  try
    Stream.read (P^, Size);
    TmpP := P;
    for I := 0 to TabsCount - 1 do begin
      Tabs.Objects[I] := TObject(P^);
      Inc(iP, SizeOf(Integer));
    end;
    P := TmpP;
  finally
    FreeMem(P, Size);
  end;
end;

procedure TsohoTabSet.WriteEnabled(Stream: TStream);
var P, TmpP:^Integer;
  iP  : Integer absolute P;
  Size: Integer;           
  I   : Integer;           
begin
  Size := TabsCount * SizeOf(Integer);
  GetMem(P, Size);
  try
    TmpP := P;
    for I := 0 to TabsCount - 1 do begin
      P^ := Integer(Tabs.Objects[I]);
      Inc(iP, SizeOf(Integer));
    end;
    P := TmpP;
    Stream.write (P^, Size);
  finally
    FreeMem(P, Size);
  end;
end;

procedure TsohoTabSet.DefaultTrueDrawTab;
begin
  with MemCanvas do begin
    if Selected then Brush.Color := FActiveColor
    else Brush.Color := FBackColor; FillRect(R);
    DoHorRect(MemCanvas, Align = alTop, R, FShadow, FHighLight);
    DoHorRect(MemCanvas, Align = alTop, R, FHighLight, FShadow);
    InflateRect(R, - 1, - 1);
    Font := Self.Font;
    Brush.Style := bsClear;
    if Assigned(FOnDrawTab) then FOnDrawTab(Self, MemCanvas, R, index, Selected)
    else DefaultDrawTab(MemCanvas, R, index, Selected);
  end;
end;

procedure TsohoTabSet.DefaultDrawTab;
begin
  DrawTabText(FKind, MemCanvas, R, Tabs[index], TabEnabled[index], DisableColor, Align);
end;

procedure TsohoTabSet.DrawTab;
begin
  if Assigned(FOnTrueDrawTab) then FOnTrueDrawTab(Self, MemCanvas, R, index, Selected)
  else DefaultTrueDrawTab(MemCanvas, R, index, Selected);
end;

procedure TsohoTabSet.MeasureTab(index: Integer; var TabWidth: Integer);
begin
  Canvas.Font := Self.Font;
  TabWidth := Canvas.TextWidth(Tabs[index]) + FTabReserve;
end;

procedure TsohoTabSet.RequestBounds;
var index: Integer;
  CurRect     : TRect;   
  LstWidth    : PInteger;
  TabWidth    : Integer; 
  SelfRight   : Integer; 
  FTabsRect   : TList;   
  Done, WasDec: boolean; 
  LastTab     : Integer; 
begin
  FTabsRect := TList.Create;
  CurRect := ClientRect;
  SelfRight := CurRect.Right;
  for index := 0 to TabsCount - 1 do begin
    if Assigned(FOnMeasureTab) then FOnMeasureTab(Self, index, TabWidth)
    else MeasureTab(index, TabWidth);
    New(LstWidth);
    if FKind = tkHorizontal then LstWidth^ := TabWidth
    else LstWidth^ := Canvas.TextHeight(Tabs[index]) + FTabReserve;
    FTabsRect.Add(LstWidth);
  end;
  Done := False;
  while not Done do begin
    {   ,   FFirstTab 
            ,   FFirstTab.
            ,     - Done := true,
           inc(FFirstTab).
              ,  Done := true}
    WasDec := False;
    CurRect := Rect(6, 0, 6, Height - PageOffset - 2);
    LastTab := -1;
    for index := FFirstTab to TabsCount - 1 do begin
      CurRect.Right := CurRect.Left + Integer(FTabsRect[index]^);
      if CurRect.Right + 2 >= SelfRight then begin
        LastTab := index;
        Break;
      end;
      CurRect.Left := CurRect.Right + 1;
    end;
    Done := LastTab <> -1;
    if not Done then begin
      Done := FFirstTab = 0;
      if not Done then begin
        WasDec := True;
        Dec(FFirstTab);
      end;
    end;
  end;
  if WasDec then Inc(FFirstTab);
  FLastDrawed := (index = TabsCount - 1) and (LastTab = -1);
  if LastTab = -1 then HideButtons else ShowButtons;

  for index := 0 to TabsCount - 1 do Dispose(PInteger(FTabsRect[index]));
  FTabsRect.Free;
end;

procedure TsohoTabSet.Paint;
var index: Integer;
  CurRect  : TRect;  
  TabWidth : Integer;
  Active   : TRect;  
  R        : TRect;  
  SelfRight: Integer;
  MemBmp   : TBitmap;
  FLastTab : integer;
begin
  try
    MemBmp := TBitmap.Create;
    MemBmp.Height := Height;
    MemBmp.Width := Width;
    with MemBmp.Canvas do begin
      Brush.Color := Self.Color;
      R := ClientRect;
      SelfRight := R.Right;
      if FBackBtn.Visible then SelfRight := FBackBtn.Left - 1;
      FillRect(R);
      CurRect := Rect(6, 0, 6, Height - PageOffset - 2);
      if Align = alTop then OffsetRect(CurRect, 0, PageOffset + 1)
      else begin
        OffsetRect(CurRect, 0, 2); {2-    NoteBook}
        CurRect.Bottom := CurRect.Bottom - 2;
      end;
      FLastDrawed := true;
      FLastTab := TabsCount - 1;
      for index := FFirstTab to TabsCount - 1 do begin
        if Assigned(FOnMeasureTab) then FOnMeasureTab(Self, index, TabWidth)
        else MeasureTab(index, TabWidth);
        if FKind <> tkHorizontal then
          TabWidth := Canvas.TextHeight(Tabs[index]) + FTabReserve;
        CurRect.Right := CurRect.Left + TabWidth;
        if CurRect.Right + 2 < SelfRight then begin
          if index <> FIndex then DrawTab(MemBmp.Canvas, CurRect, index, False)
          else Active := CurRect;
        end
        else begin
          FLastDrawed := False;
          FLastTab := Index -1;
          Break;
        end;
        CurRect.Left := CurRect.Right + 1;
      end;
      if FLastDrawed then FLastDrawed := Index = TabsCount;
      if Align = alTop then begin
        R := Rect(R.Left, R.Bottom - 2, R.Right, R.Bottom);
        if FNoteBook <> nil then Brush.Color := FNoteBook.Color
        else Brush.Color := Self.Color;
        FillRect(R);
        DoHorRect(MemBmp.Canvas, Align = alTop, R, FShadow, FHighLight);
        DoHorRect(MemBmp.Canvas, Align = alTop, R, FHighLight, FShadow);
      end
      else begin
        R := Rect(R.Left, R.Top, R.Right, R.Top + 2);
        if FNoteBook <> nil then Brush.Color := FNoteBook.Color
        else Brush.Color := Self.Color;
        FillRect(R);
        DoHorRect(MemBmp.Canvas, Align = alTop, R, FShadow, FHighLight);
        DoHorRect(MemBmp.Canvas, Align = alTop, R, FHighLight, FShadow);
      end;
      if FIndex <> -1 then begin
        if FIndex < FFirstTab then FIndex := FFirstTab;
        if FIndex > FLastTab then FIndex := FLastTab;
        Active.Left := Active.Left - 4;
        Active.Right := Active.Right + 4;
        if Align = alTop then Active.Top := Active.Top - 2
        else Active.Bottom := Active.Bottom + 2;
        DrawTab(MemBmp.Canvas, Active, FIndex, True);
      end;
    end;
    BitBlt(Canvas.Handle, 0, 0, Width, Height, MemBmp.Canvas.Handle, 0, 0, SRCCOPY);
  finally
    MemBmp.Free;
  end;
end;

procedure TsohoTabSet.WMSize;
begin
  with message do begin
    if Height < FBackBtn.Height + 2 then Height := FBackBtn.Height + 2;
    if Width < 2 * FBackBtn.Width + 1 then Width := 2 * FBackBtn.Width + 1;
    Result := 1;
  end;
  inherited;
  UpdateButtons;
end;

procedure TsohoTabSet.BtnsClick;
begin
  if (csDesigning in ComponentState) or (Button = mbLeft) then begin
    if not (Sender as TRxSpeedButton).Enabled then exit;
    if (Sender as TRxSpeedButton) = FBackBtn then Dec(FFirstTab)
    else Inc(FFirstTab);
    FBackBtn.Enabled := FFirstTab <> 0;
    Repaint;
    FForwBtn.Enabled := not FLastDrawed;
  end;
end;

procedure TsohoTabSet.UpdateButtons;
var T: Integer;
begin
  RequestBounds;
  if Align = alTop then T := Height - FBackBtn.Height - 2
  else T := 2;
  with FForwBtn do begin
    Left := Self.Width - Width;
    Top := T;
    Enabled := not FLastDrawed;
  end;
  with FBackBtn do begin
    Left := FForwBtn.Left - Width - 1;
    Top := T;
    Enabled := FFirstTab <> 0;
  end;
end;

procedure TsohoTabSet.ShowButtons;
begin
  if FBackBtn.Visible and FForwBtn.Visible then exit;
  if csDesigning in ComponentState then begin
    FBackBtn.Parent := Self;
    FForwBtn.Parent := Self;
  end;
  FBackBtn.Visible := True;
  FForwBtn.Visible := True;
end;

procedure TsohoTabSet.HideButtons;
begin
  FBackBtn.Visible := False;
  FForwBtn.Visible := False;
  if csDesigning in ComponentState then begin
    FBackBtn.Parent := nil;
    FForwBtn.Parent := nil;
  end;
end;

function TsohoTabSet.MouseInTab(X, Y: Integer): Integer;
var index: Integer;
  CurRect  : TRect;  
  Point    : TPoint; 
  TabWidth : Integer;
  SelfRight: Integer;
begin
  Result := -1;
  Point.X := X; Point.Y := Y;
  CurRect := ClientRect;
  SelfRight := CurRect.Right;
  if FBackBtn.Visible then SelfRight := FBackBtn.Left - 1;
  CurRect := Rect(6, 0, 6, Height - PageOffset);
  if Align = alTop then OffsetRect(CurRect, 0, PageOffset + 1)
  else OffsetRect(CurRect, 0, 2); {2-    NoteBook}
  for index := FFirstTab to TabsCount - 1 do begin
    if Assigned(FOnMeasureTab) then FOnMeasureTab(Self, index, TabWidth)
    else MeasureTab(index, TabWidth);
    if FKind = tkVertical then
      TabWidth := Canvas.TextHeight(Tabs[index]) + FTabReserve;
    CurRect.Right := CurRect.Left + TabWidth;
    if CurRect.Right > SelfRight then exit;
    if PtInRect(CurRect, Point) then begin
      if (csDesigning in ComponentState) or TabEnabled[index] then
        Result := index;
      exit;
    end;
    CurRect.Left := CurRect.Right + 1;
  end;
end;

procedure TsohoTabSet.BeforePopup(Sender: TObject);
begin
  with FPopup do begin
    Items[0].Enabled := not TabEnabled[TabIndex];
    Items[1].Enabled := TabEnabled[TabIndex];
  end;
end;

procedure TsohoTabSet.ClickMenu(Sender: TObject);
begin
  if (Sender as TMenuItem).Caption = sohoTabsUpdate then begin
    UpdateTabs;
    exit;
  end;
  TabEnabled[TabIndex] := (Sender as TMenuItem).Caption = sohoTabsEnable;
  Repaint;
  if (Owner is TForm) and (csDesigning in ComponentState) then
    (Owner as TForm).Designer.Modified;
end;

procedure TsohoTabSet.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var OldIndex, NewIndex: Integer;
  Point: TPoint;
begin
  inherited MouseDown(Button, Shift, X, Y);
  OldIndex := TabIndex;
  NewIndex := OldIndex;
  if (Button = mbLeft) or (csDesigning in ComponentState) then
    NewIndex := MouseInTab(X, Y);
  if (NewIndex = OldIndex) and (csDesigning in ComponentState) then begin
    Point.X := X; Point.Y := Y; Point := ClientToScreen(Point);
    FPopup.Popup(Point.X, Point.Y);
  end
  else
   if OldIndex <> NewIndex then TabIndex := NewIndex;
  {if OldIndex <> TabIndex then
    if Assigned(FOnTabSelect) then FOnTabSelect(Self, TabIndex);}
end;

procedure TsohoTabSet.SetAlign(Value: tAlign);
begin
  if (inherited Align = Value) or
    (Value in [alLeft, alRight, alClient, alNone]) then exit;
  FAlign := Value;
  inherited Align := Value;
  UpdateButtons;
  Repaint;
end;

procedure TsohoTabSet.Loaded;
begin
  inherited Loaded;
  if FNoteBook <> nil then TabIndex := FNoteBook.PageIndex;
  UpdateButtons;
end;

procedure TsohoTabSet.SetKind(Value: TsohoTabKind);
begin
  FKind := Value;
  Invalidate;
end;

constructor TsohoTabSet.Create(AOwner: TComponent);
var index: Integer;
  MI: TMenuItem;
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csDesignInteractive, csOpaque];
  FTabs := TStringList.Create;
  FIndex := -1;
  FDisableColor := clGray;
  FNoteBook := nil; {  -  !}
  for index := 0 to Owner.ComponentCount - 1 do
    if Owner.Components[index] is TNoteBook then begin
      FNoteBook := (Owner.Components[index] as TNoteBook);
      Break;
    end;
  FAlign := alTop;
  inherited Align := alTop;
  FKind := tkHorizontal;
  Height := 30;
  Width := 100;
  FOffset := 4;
  FTabReserve := 6;
  FActiveColor := clBtnFace;
  FBackColor := clBtnFace;
  FHighLight := clBtnHighlight;
  FShadow := clBlack;
  FFirstTab := 0;
  FBackBtn := TRxSpeedButton.Create(Self);
  with FBackBtn do begin
    Parent := Self;
    Visible := False;
    Glyph.Handle := ResBitmap('WTBACK');
    NumGlyphs := 2;
    Height := 15;
    Width := 15;
    Color := Self.Color;
    OnMouseDown := BtnsClick;
    ControlStyle := ControlStyle + [csDesignInteractive, csOpaque];
    Transparent := True;
  end;
  FForwBtn := TRxSpeedButton.Create(Self);
  with FForwBtn do begin
    Parent := Self;
    Visible := False;
    Glyph.Handle := ResBitmap('WTFORWARD');
    NumGlyphs := 2;
    Height := 15;
    Width := 15;
    Color := Self.Color;
    OnMouseDown := BtnsClick;
    ControlStyle := ControlStyle + [csDesignInteractive, csOpaque];
    Transparent := True;
  end;
  FLastDrawed := True;
  FTabsParColor := True;
  FPopup := TPopupMenu.Create(Self);
  with FPopup do begin
    MI := TMenuItem.Create(Self);
    MI.Caption := sohoTabsEnable;
    MI.OnClick := ClickMenu;
    Items.Add(MI);
    MI := TMenuItem.Create(Self);
    MI.Caption := sohoTabsDisable;
    MI.OnClick := ClickMenu;
    Items.Add(MI);
    MI := TMenuItem.Create(Self);
    MI.Caption := '-';
    Items.Add(MI);
    MI := TMenuItem.Create(Self);
    MI.Caption := sohoTabsUpdate;
    MI.OnClick := ClickMenu;
    Items.Add(MI);
    OnPopup := BeforePopup;
  end;
end;

destructor TsohoTabSet.Destroy;
begin
  FTabs.Free;
  FBackBtn.Free;
  FForwBtn.Free;
  FPopup.Free;
  inherited Destroy;
end;

procedure TsohoTabSet.SetOffset;
begin
  if (FOffset = Value) or (FOffset < 0) or
    (FOffset > Height - Canvas.TextHeight('W')) then exit;
  FOffset := Value;
  Repaint;
end;

procedure TsohoTabSet.SetReserve(Value: Integer);
begin
  if (FTabReserve = Value) or (Value < 0) then exit;
  FTabReserve := Value;
  UpdateButtons;
  Repaint;
end;

procedure TsohoTabSet.SetActiveCol(Value: TColor);
begin
  if FActiveColor = Value then exit;
  FActiveColor := Value;
  ParentTabsColor := False;
  Repaint;
end;

procedure TsohoTabSet.UpdateTabs;
begin
  if FNoteBook <> nil then begin
    FTabs.Clear;
    FTabs.Assign(FNoteBook.Pages);
    FIndex := FNoteBook.PageIndex;
    UpdateButtons;
    Repaint;
  end;
end;

procedure TsohoTabSet.SetShadowCol(Value: TColor);
begin
  if FShadow = Value then exit;
  FShadow := Value;
  Repaint;
end;

procedure TsohoTabSet.SetBackCol(Value: TColor);
begin
  if FBackColor = Value then exit;
  FBackColor := Value;
  ParentTabsColor := False;
  Repaint;
end;

procedure TsohoTabSet.SetHighLight(Value: TColor);
begin
  if FHighLight = Value then exit;
  FHighLight := Value;
  Repaint;
end;

{ TsohoHorTabSet }
function TsohoVertTabSet.GetAlign: tAlign;
begin
  Result := TCustomControl(Self).Align;
end;

procedure TsohoVertTabSet.SetAlign(Value: tAlign);
begin
  if (TCustomControl(Self).Align = Value) or
    (Value in [alTop, alBottom, alClient, alNone]) then exit;
  TCustomControl(Self).Align := Value;
  UpdateButtons;
  Repaint;
end;

procedure TsohoVertTabSet.RequestBounds;
var index: Integer;
  CurRect     : TRect;   
  LstHeight   : PInteger;
  TabHeight   : Integer; 
  SelfBottom  : Integer; 
  FTabsRect   : TList;   
  Done, WasDec: boolean; 
  LastTab     : Integer; 
begin
  FTabsRect := TList.Create;
  CurRect := ClientRect;
  SelfBottom := CurRect.Bottom;
  for index := 0 to TabsCount - 1 do begin
    if Assigned(FOnMeasureTab) then FOnMeasureTab(Self, index, TabHeight)
    else MeasureTab(index, TabHeight);
    New(LstHeight);
    if FKind = tkHorizontal then
      LstHeight^ := Canvas.TextHeight(Tabs[index]) + FTabReserve
    else LstHeight^ := TabHeight;
    FTabsRect.Add(LstHeight);
  end;
  Done := False;
  while not Done do begin
    {   ,   FFirstTab 
            ,   FFirstTab.
            ,     - Done := true,
           inc(FFirstTab).
              ,  Done := true}
    WasDec := False;
    CurRect := Rect(0, 6, Width - PageOffset, 6);
    LastTab := -1;
    for index := FFirstTab to TabsCount - 1 do begin
      CurRect.Bottom := CurRect.Top + Integer(FTabsRect[index]^);
      if CurRect.Bottom + 2 >= SelfBottom then begin
        LastTab := index;
        Break;
      end;
      CurRect.Top := CurRect.Bottom + 1;
    end;
    Done := LastTab <> -1;
    if not Done then begin
      Done := FFirstTab = 0;
      if not Done then begin
        WasDec := True;
        Dec(FFirstTab);
      end;
    end;
  end;
  if WasDec then Inc(FFirstTab);
  FLastDrawed := (index = TabsCount{ - 1}) and (LastTab = -1);
  if LastTab = -1 then HideButtons else ShowButtons;
  
  for index := 0 to TabsCount - 1 do Dispose(PInteger(FTabsRect[index]));
  FTabsRect.Free;
end;

procedure TsohoVertTabSet.UpdateButtons;
var L: Integer;
begin
  RequestBounds;
  if Align = alLeft then L := Width - FBackBtn.Width - 2
  else L := 2;
  with FForwBtn do begin
    Left := L;
    Top := Self.Height - Height;
    Enabled := not FLastDrawed;
  end;
  with FBackBtn do begin
    Left := L;
    Top := FForwBtn.Top - Height - 1;
    Enabled := FFirstTab <> 0;
  end;
end;

function TsohoVertTabSet.MouseInTab(X, Y: Integer): Integer;
var index: Integer;
  CurRect   : TRect;  
  Point     : TPoint; 
  TabHeight : Integer;
  SelfBottom: Integer;
begin
  Result := -1;
  Point.X := X; Point.Y := Y;
  CurRect := ClientRect;
  SelfBottom := CurRect.Bottom;
  if FBackBtn.Visible then SelfBottom := FBackBtn.Top - 1;
  CurRect := Rect(0, 6, Width - PageOffset, 6);
  if Align = alLeft then OffsetRect(CurRect, PageOffset + 1, 0)
  else OffsetRect(CurRect, 2, 0); {2-    NoteBook}
  for index := FFirstTab to TabsCount - 1 do begin
    if Assigned(FOnMeasureTab) then FOnMeasureTab(Self, index, TabHeight)
    else MeasureTab(index, TabHeight);
    if FKind = tkHorizontal then
      TabHeight := Canvas.TextHeight(Tabs[index]) + FTabReserve;
    CurRect.Bottom := CurRect.Top + TabHeight;
    if CurRect.Bottom > SelfBottom then exit;
    if PtInRect(CurRect, Point) then begin
      if (csDesigning in ComponentState) or TabEnabled[index] then
        Result := index;
      exit;
    end;
    CurRect.Top := CurRect.Bottom + 1;
  end;
end;

procedure TsohoVertTabSet.DefaultTrueDrawTab;
begin
  with MemCanvas do begin
    if Selected then Brush.Color := FActiveColor
    else Brush.Color := FBackColor; FillRect(R);
    DoVertRect(MemCanvas, Align = alLeft, R, FShadow, FHighLight);
    DoVertRect(MemCanvas, Align = alLeft, R, FHighLight, FShadow);
    InflateRect(R, - 1, - 1);
    Font := Self.Font;
    Brush.Style := bsClear;
    if Assigned(FOnDrawTab) then FOnDrawTab(Self, MemCanvas, R, index, Selected)
    else DefaultDrawTab(MemCanvas, R, index, Selected);
  end;
end;

procedure TsohoVertTabSet.DefaultDrawTab;
begin
  DrawTabText(FKind, MemCanvas, R, Tabs[index], TabEnabled[index], DisableColor, Align);
end;

procedure TsohoVertTabSet.MeasureTab(index: Integer; var TabHeight: Integer);
begin
  Canvas.Font := Self.Font;
  TabHeight := Canvas.TextWidth(Tabs[index]) + FTabReserve;
end;

procedure TsohoVertTabSet.Paint;
var index: Integer;
  CurRect   : TRect;  
  TabHeight : Integer;
  Active    : TRect;  
  R         : TRect;  
  SelfBottom: Integer;
  MemBmp    : TBitmap;
begin
  MemBmp := TBitmap.Create;
  MemBmp.Height := Height;
  MemBmp.Width := Width;
  try
    with MemBmp.Canvas do begin
      Brush.Color := Self.Color;
      R := ClientRect;
      SelfBottom := R.Bottom;
      if FBackBtn.Visible then SelfBottom := FBackBtn.Top - 1;
      FillRect(R);
      CurRect := Rect(0, 6, Width - PageOffset, 6);
      if Align = alLeft then OffsetRect(CurRect, PageOffset + 1, 0)
      else begin
        OffsetRect(CurRect, 2, 0); {2-    NoteBook}
        CurRect.Right := CurRect.Right - 2;
      end;
      FLastDrawed := True;
      for index := FFirstTab to TabsCount - 1 do begin
        if Assigned(FOnMeasureTab) then FOnMeasureTab(Self, index, TabHeight)
        else MeasureTab(index, TabHeight);
        if FKind = tkHorizontal then
          TabHeight := Canvas.TextHeight(Tabs[index]) + FTabReserve;
        CurRect.Bottom := CurRect.Top + TabHeight;
        if CurRect.Bottom + 2 < SelfBottom then begin
          if index <> FIndex then DrawTab(MemBmp.Canvas, CurRect, index, False)
          else Active := CurRect;
        end
        else begin
          FLastDrawed := False;
          Break;
        end;
        CurRect.Top := CurRect.Bottom + 1;
      end;
      if FLastDrawed then FLastDrawed := index = TabsCount{ - 1};
      if Align = alLeft then begin
        R := Rect(R.Right - 2, R.Top, R.Right, R.Bottom);
        if FNoteBook <> nil then Brush.Color := FNoteBook.Color
        else Brush.Color := Self.Color;
        FillRect(R);
        DoVertRect(MemBmp.Canvas, Align = alLeft, R, FShadow, FHighLight);
        DoVertRect(MemBmp.Canvas, Align = alLeft, R, FHighLight, FShadow);
      end
      else begin
        R := Rect(R.Left, R.Top, R.Left + 2, R.Bottom);
        if FNoteBook <> nil then Brush.Color := FNoteBook.Color
        else Brush.Color := Self.Color;
        FillRect(R);
        DoVertRect(MemBmp.Canvas, Align = alLeft, R, FShadow, FHighLight);
        DoVertRect(MemBmp.Canvas, Align = alLeft, R, FHighLight, FShadow);
      end;
      if FIndex <> -1 then begin
        Active.Top := Active.Top - 4;
        Active.Bottom := Active.Bottom + 4;
        if Align = alLeft then Active.Left := Active.Left - 2
        else Active.Right := Active.Right + 2;
        DrawTab(MemBmp.Canvas, Active, FIndex, True);
      end;
    end;
    BitBlt(Canvas.Handle, 0, 0, Width, Height, MemBmp.Canvas.Handle, 0, 0, SRCCOPY);
  finally
    MemBmp.Free;
  end;
end;

constructor TsohoVertTabSet.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  TCustomControl(Self).Align := alLeft;
  Font.name := 'Courier New';
  FKind := tkVertical;
  Height := 100;
  Width := 30;
  FBackBtn.Glyph.Handle := ResBitmap('WVTBACK');
  FForwBtn.Glyph.Handle := ResBitmap('WVTFORWARD');
end;

procedure TsohoVertTabSet.WMSize;
begin
  with message do begin
    if Height < 2 * FBackBtn.Height + 1 then Height := 2 * FBackBtn.Height + 1;
    if Width < FBackBtn.Width + 2 then Width := FBackBtn.Width + 2;
    Result := 1;
  end;
  UpdateButtons;
end;

end.

