{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{              Written by Allex, VSM                    }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
     TsohoRegister.    
  SohoLib,     ,
    ,     
 .
}
unit SohoRgst;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Controls, SoCtmRgs,
     Forms;


type

  {    ,    
       .       ,
        -    ,    ,
          .     
         ( PasswordRequired = true).  
              
      .    TsohoRegister  
     .         
    TsohoRegister.      TsohoSubRegister
  }
  TsohoRegister = class(TsohoCustomRegister)
  protected
    procedure DefineDataPath;override;
  public
    {     }
    procedure ShowUserList; override;
    {         }
    function ShowPasswordDialog: boolean;override;
    {    }
    procedure ChangePassword;override;
    {    ,   TsohoCustomRegister    }
    property WindowHandle;
  published
    {       }
    property UserActionRights;
    {         }
    property UserDataReadRights;
    {         }
    property UserDataWriteRights;
    {     SohoMon }
    property DesignedProgramName;
    {         ? }
    property PasswordRequired default False;
    {    .  TsohoProtect }
    property ProtectionInterval default 0;
    {   .  TsohoProtect }
    property ProtectionLevel default 0;
    {   .  TsohoProtect }
    property Trial;
    property Panel;
    {  :   ,     }
    property ActivateOn;
    {     TsohoCustomRegister }
    property OnActivate;
    {         }
    property OnNewUserBox;
  end;

implementation
uses SoUtils, SoUsers, SoUsCard, SohoPswU, FileCtrl, SoBDERtn, SoDBCns;

procedure TsohoRegister.DefineDataPath;
var S: string;
    IsDirectory, IsAlias: boolean;
    Info : TsohoAliasInfo;
begin
  { Paramstr(1)     }
  IsAlias := False;
  if ParamStr(1) <> '' then begin
    S := ParamStr(1); {ExtractFile ...}
    IsDirectory := DirectoryExists(S);
    if not IsDirectory then begin
      Info := GetAliasInfo(S);
      IsAlias := Info.Path <> '';
    end;
    if (not IsDirectory) and (not IsAlias) then ErrorMsg(Format(sohoRegisterPathOrAliasDontExists,[Name, S]));
    PathToData := S;
  end
  else begin
    PathToData := PathToProgram;
    DataName := DefaultName;
  end;
  { -      '\',     }
  if (not IsAlias) and (PathToData[Length(PathToData)] <> '\') then PathToData := PathToData + '\';
end;

procedure TsohoRegister.ShowUserList;
begin
  UserF := TUserF.Create(Application);
  with UserF do begin
    ShowModal;
    Free;
  end;
end;

function TsohoRegister.ShowPasswordDialog: boolean;
var PasswordF: TPasswordF;
begin
  DataReadRights := [0..255];
  DataWriteRights := [0..255];
  Result := False;
  if (csDesigning in ComponentState) then exit;
  PasswordF := TPasswordF.Create(Application);
  Result := PasswordF.ShowModal = mrOk;
  if Result then begin
    DataReadRights := PasswordF.ReadRight;
    DataWriteRights := PasswordF.WriteRight;
    ActionRights := PasswordF.ActionRight;
    UserID := PasswordF.UserID;
    DataLevel := PasswordF.DataLevel;
    UserName := PasswordF.NameC.Text;
    ShortName := PasswordF.ShortName;
    PasswordF.Free;
  end;
end;

procedure TsohoRegister.ChangePassword;
begin
  if UserID = 0 then exit;
  UserF := TUserF.Create(Self);
  with UserF do begin
    Query1.SQL.Delete(1);
    Query1.SQL.Add('where ID=' + IntToStr(UserID));
    Query1.Close;
    try
      Query1.Open;
    except ErrorMsg(Format(sohoRegisterChangePasswordError, [name]));
    end;
    sohoBitBtn2.Visible := False;
    sohoBitBtn3.Visible := False;
    ShowModal;
    Free;
  end;
end;

end.
