{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{     TsohoRecordForm - ,  
       
}
unit SohoRec;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Controls,
     SoCtmRec;

type

  { TsohoRecordForm - ,       
     .   TDataSet,    SQL
       .      ,
        SQL-    
    
  }
  TsohoRecordForm = class(TsohoCustomRecordForm)
  private
    FDataBaseName: TFileName;
  protected
    function  RunUpdateSQL (SQLText : TStringList) : boolean;override;
    function  RunInsertSQL (SQLText : TStringList) : boolean;override;
    procedure PrepareCard; override;
  published
    {    }
    property DataBaseName: TFileName read FDataBaseName write FDataBaseName;
  end;

implementation
uses SoUtils, DBTables, SoCtmRgs, SoDBCns;

procedure TsohoRecordForm.PrepareCard;
begin
  if (FDataBaseName = '') and (SingleRegister<>nil) then
    FDataBaseName := SingleRegister.PathToData;
  inherited PrepareCard;  
end;

function TsohoRecordForm.RunUpdateSQL (SQLText : TStringList) : boolean;
var Query : TQuery;
begin
  try
    Query := TQuery.Create(Self);
    Query.DataBaseName := DataBaseName;
    with Query do begin
     SetCursor(crHourGlass);
     SQL.Assign(SQLText);
     ExecSQL;
     Result := True;
     DoAfterSQLExecute;
    end;
  except
   on E: Exception do
     ErrorMsg(Format(sohoRecFormUpdateError, [Self.name, E.Message]));
  end;
  Query.Free;
end;

function TsohoRecordForm.RunInsertSQL (SQLText : TStringList) : boolean;
var Query : TQuery;
begin
  try
    Query := TQuery.Create(Self);
    Query.DataBaseName := DataBaseName;
    with Query do begin
     SetCursor(crHourGlass);
     SQL.Assign(SQLText);
     ExecSQL;
     Result := True;
     DoAfterSQLExecute;
    end;
  except
    on E:Exception do
     ErrorMsg(Format(sohoRecFormInsertError, [Self.name, E.Message]));
  end;
  Query.Free;
end;

end.

