{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{             Written by Allex, MVL, VSM                }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SohoPswU;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, Dialogs, StdCtrls, Buttons, IniFiles, SoUnit, DB,
     DBTables, SoSDlgs, SohoBtns, SoCtrls, SoTools, Placemnt, SoRxTls;

type
  TPasswordF = class(TForm)
    PasswordE: TEdit;
    NameC: TComboBox;
    Query1: TQuery;
    WDirectoryDialog1: TsohoDirectoryDialog;
    sohoLabel1: TsohoLabel;
    sohoLabel2: TsohoLabel;
    OkB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    DiskB: TsohoBitBtn;
    PasswordIni: TsohoFormStorage;
    procedure BitBtn3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    ReadRight,WriteRight,ActionRight:SetOfByte;
    PasswordValid : Boolean;
    DataBaseName  : string;
    UserID        : Longint;
    DataLevel     : LongInt;
    ShortName     : string;
    function PassWordIsValid(S:String):Boolean;
    { Public declarations }
  end;

var  PasswordF: TPasswordF;

function CalculatePassWord (var DataSet; S:String):Longint;

implementation
uses SoUtils;

{$R *.DFM}
var Ini : TIniFile;

procedure TPasswordF.BitBtn3Click(Sender: TObject);
begin
   with WDirectoryDialog1 do begin
     Directory:=Ini.ReadString('Password','Directory',ExtractFilePath(Paramstr(0)));
     WDirectoryDialog1.Execute;
   end;
   Ini.WriteString('Password','Directory',WDirectoryDialog1.Directory);
end;

procedure TPasswordF.FormCreate(Sender: TObject);
{$IfDef WIN32}
var UserName : PChar;
    {BufferSize : integer;}
    BufferSize : DWord; {D4}
{$EndIF}
begin
   {Fill Names List}
   Ini:=TIniFile.Create(ExtractFilePath(ParamStr(0))+'Soho.ini');
   WDirectoryDialog1.Directory:=Ini.ReadString('Password','Directory','');
   with NameC do begin
     Items.Clear;
     Ini.ReadSection('UserList',Items);
     Items.Insert(0,'');
     {$Ifdef WIN32}
      {        " " }
      GetMem(UserName, 254);
      BufferSize := 254;
      if GetUserName(UserName, BufferSize) then Items.Insert(0,StrPas(UserName));
      FreeMem(UserName, 254);
     {$Endif}
     ItemIndex:=0;
   end;
end;

function StringSum(s : string):LongInt;
var i : Longint;
begin
   Result := 14142135;
   if Length(s)>0 then
      for i := 0 to Length(s) do Result := Result+(i+1)*ord(S[i+1]);
end;

function CalculatePassWord(var DataSet;S:String):Longint;
const WE0 = 16111963;
var WE : Extended;
    WS : string;
begin
   with TDataSet(DataSet) do begin
      {ID}        WE := FieldByName('ID').AsInteger*Pi+WE0;
      {Action}    WS := FieldByName('Action').AsString;
                  WE := WE-ln(10)*StringSum(WS);
      {DataRead}  WS := FieldByName('ReadR').AsString;
                  WE := WE/(StringSum(WS));
      {DataWrite} WS := FieldByName('WriteR').AsString;
                  WE := WE+StringSum(WS)/exp(1);
      {Name}      WE := WE+StringSum(FieldByName('UserName').AsString);
      {String}    WE := LN(ABS(WE))*StringSum(S);
      if WE=0 then WE := 999999;
      while WE<MaxLongInt/2 do WE := WE*2;
      while WE>MaxLongInt do WE := WE/2;
      Result := trunc(WE);
   end;
end;

function TPasswordF.PassWordIsValid(S:String):Boolean;
var PassWord : Longint;
begin
   PassWord := CalculatePassword(Query1,S);
   Result   := PassWord=Query1.FieldByName('PassWordR').AsInteger;
end;


function Modified(s:string):string;
var i : byte;
begin
   for i := 1 to length(s) do s[i] := chr(not ord(s[i]));
   Result := S;
end;

procedure TPasswordF.BitBtn1Click(Sender: TObject);
const SuperWizard='';
begin
   {Control of Guest and Supervisor rights}
   if (NameC.Text='Guest') or (NameC.Text='') then begin
      PassWordValid := true;
      ActionRight   := [0..10];
      ReadRight     := ActionRight;
      WriteRight    := ReadRight;
      UserID        := 0;
      DataLevel     := 0;
      DataBaseName  := WDirectoryDialog1.Directory;
      exit;
   end;

   if ANSIUPPERCASE(NameC.Text)='SUPERVISOR' then begin
      PassWordValid := PassWordE.Text=Modified(SuperWizard);
      ActionRight   := [0..255];
      ReadRight     := ActionRight;
      WriteRight    := ReadRight;
      UserID        := MaxLongInt;
      DataLevel     := 0;
      DataBaseName  := WDirectoryDialog1.Directory;
      if PassWordValid then exit;
   end;

   {Control of DataBase, Read user, Validate Password}
   If not FileExists(WDirectoryDialog1.Directory+'\SoPswrd.db') then begin
      InfoMsg('  -  !'#13'(,     )');
      ModalResult := 0;
      exit;
   end;

   with Query1 do begin
      DataBaseName := WDirectoryDialog1.Directory;
      Open;
      First;
      PassWordValid := false;
      while not EOF do begin
         PassWordValid := (FieldByName('UserName').AsString=NameC.Text)
                           and PasswordIsValid(PasswordE.Text);
         if PassWordValid then break;
         Next;
      end;
      try
       ActionRight := StrToSet(FieldByName('Action').AsString);
       ReadRight   := StrToSet(FieldByName('ReadR').AsString);
       WriteRight  := StrToSet(FieldByName('WriteR').AsString);
       UserID      := FieldByName('ID').AsInteger;
       DataLevel   := FieldByName('DataLevel').AsInteger;
       ShortName   := FieldByName('ShortName').AsString;
      except ErrorMsg('   ');
             Application.Terminate;
      end;
      Close;
   end;
   DataBaseName := Query1.DataBaseName;
   if not PasswordValid then begin
      ErrorMsg('  - !');
      ModalResult := 0;
      exit;
   end;

   Ini.WriteString('UserList',NameC.Text,DateTimeToStr(Now));
   Ini.Free;
end;

end.



