{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
   Excel  OLE-Automation
}
unit SohoOLE;

{$I SOHOLIB.INC}

interface
uses ComObj, Graphics;

const
   {   Excel    }
   AutoCloseExcel    : boolean = true;
   {   Excel    ? }
   ShowExcelOnCreate : boolean = false;

var

   {    Excel }
   MsExcel : Variant;

{  Excel   ,     }
function  OpenExcel  : boolean;
{  Excel }
function  CloseExcel : boolean;
{  Excel  }
function  ShowExcel  : boolean;
{  Excel }
function  HideExcel  : boolean;
{    -    }
function  ExcelOpened : boolean;
{    Excel }
function  ReOpenExcel : boolean;
{   Excel }
function  ExcelVersion : string;
{ true,    Excel' 7- }
function ExcelVersionIs70 : boolean;
{      Excel   , 
   Left, Top, Right, Bottom.}
{ example: ExcelRectToStr(1,1,5,2) = 'A1:E2' }
function  ExcelRectToStr (Left, Top, Right, Bottom : LongInt) : string;
{       Rect }
procedure SetCellsFont   (Sheet : Variant; const Rect, FontName : string; FontSize : integer;
                          FontColor : TColor; FontStyle : TFontStyles);
{     }
procedure SetCellsBackground  (Sheet : Variant; const Rect : string; Color : TColor);


implementation
uses SysUtils, SoUtils{, OleFix};

var ExcelWasRunned : boolean;
    Version        : string;


function ExcelVersionIs70 : boolean;
begin
  Result := Copy(ExcelVersion,1,1)='7';
end;

function  ExcelVersion : string;
begin
  if not ExcelOpened then ReOpenExcel;
  Result := Version;
end;

function ExcelRectToStr (Left, Top, Right, Bottom : LongInt) : string;
begin
   if Top=0 then
     Result := chr(Left+ord('@'))+':'+chr(Right+ord('@'))
   else
     if Left = 0 then
        Result := IntToStr(Top)+':'+IntToStr(Bottom)
     else
        Result := chr(Left+ord('@'))+IntToStr(Top)+':'+
                 chr(Right+ord('@'))+IntToStr(Bottom);
end;

procedure SetCellsFont  (Sheet : Variant; const Rect, FontName : string; FontSize : integer;
                         FontColor : TColor; FontStyle : TFontStyles);
begin
   if ExcelVersionIs70 then begin
     Sheet.Range(Rect).Font.Name := FontName;
     Sheet.Range(Rect).Font.Size := FontSize;
     Sheet.Range(Rect).Font.Italic := fsItalic in FontStyle;
     Sheet.Range(Rect).Font.Bold := fsBold in FontStyle;
     Sheet.Range(Rect).Font.StrikeOut := fsStrikeOut in FontStyle;
     Sheet.Range(Rect).Font.Color := ColorToRGB(FontColor);
   end
   else begin
     Sheet.Range[Rect].Font.Name := FontName;
     Sheet.Range[Rect].Font.Size := FontSize;
     Sheet.Range[Rect].Font.Italic := fsItalic in FontStyle;
     Sheet.Range[Rect].Font.Bold := fsBold in FontStyle;
     Sheet.Range[Rect].Font.StrikeOut := fsStrikeOut in FontStyle;
     Sheet.Range[Rect].Font.Color := ColorToRGB(FontColor);
   end;
end;

procedure SetCellsBackground  (Sheet : Variant; const Rect : string; Color : TColor);
begin
   if ExcelVersionIs70 then
     Sheet.Range(Rect).Interior.Color := ColorToRGB(Color)
   else
     Sheet.Range[Rect].Interior.Color := ColorToRGB(Color)
end;

function  ExcelOpened : boolean;
var Tmp : string;
begin
   Result := false;
   try
     if not ExcelWasRunned then exit;
     Tmp := MsExcel.Caption;
     Result := true;
   except
   end;
end;

function  ShowExcel  : boolean;
begin
  Result := false;
  if ExcelOpened then begin
    try
      MsExcel.Visible := true;
      Result := true;
    except
    end;
  end;
end;

function  HideExcel  : boolean;
begin
  Result := false;
  if ExcelOpened then begin
    MsExcel.Visible := false;
    Result := true;
  end;
end;

function  ReOpenExcel : boolean;
begin
  try
   MsExcel := CreateOLEObject('Excel.Application');
   MsExcel.Visible := ShowExcelOnCreate;
   Result := true;
   ExcelWasRunned := true;
   Version := MsExcel.Version;
  except Result := false;
    Version := 'unknown';
    ErrorMsg('  OLE- Excel.Application!');
  end;
end;

function  OpenExcel  : boolean;
begin
   Result := ShowExcel;
   if Result then exit;
   Result := ReOpenExcel;
end;

function  CloseExcel : boolean;
begin
   Result := true;
   if not ExcelOpened then exit;
   try
     MsExcel.WorkBooks.Close;
     MsExcel.Quit;
     MsExcel := UnAssigned;
     ExcelWasRunned := false;
   except
     Result := false;
   end;
end;

initialization
   MsExcel        := UnAssigned;
   ExcelWasRunned := false;
   Version        := 'unknown';
finalization
   if AutoCloseExcel then CloseExcel;
   MsExcel       := UnAssigned;
end.
