{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SohoHntE;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, StdCtrls, SohoBtns, SoTools, Placemnt, SoRxTls;

type
  THintCollectorForm = class(TForm)
    OkB: TsohoBitBtn;
    Ini: TsohoFormStorage;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    ComponentsL: TListBox;
    HintM: TMemo;
    procedure HintMEnter(Sender: TObject);
    procedure HintMExit(Sender: TObject);
    procedure ComponentsLClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Form : TForm;
    function Execute (aForm : TForm) : boolean;
  end;

var HintCollectorForm: THintCollectorForm;

function SetHintsExecute (aForm : TForm) : boolean;

implementation
uses SoUtils;

{$R *.DFM}

function SetHintsExecute (aForm : TForm) : boolean;
begin
     Result := false;
     try
       HintCollectorForm := THintCollectorForm.Create(Application);
       Result := HintCollectorForm.Execute(aForm);
     finally
       HintCollectorForm.Free;
     end;
end;

function THintCollectorForm.Execute (aForm : TForm) : boolean;
var Index : LongInt;
begin
     Form := aForm;
     ComponentsL.Items.Clear;
     for Index := 0 to pred(Form.ComponentCount) do
      if IsProperty(Form.Components[Index],'Hint') then
       if Form.Components[Index].Name<>'' then
       ComponentsL.Items.Add(Form.Components[Index].Name);
     ShowModal;
     Result := true;
end;

procedure THintCollectorForm.HintMEnter(Sender: TObject);
var Index : LongInt;
begin
     {Get hint}
     if ComponentsL.Items.Count=0 then exit;
     for Index := 0 to pred(ComponentsL.Items.Count) do
      if ComponentsL.Selected[Index] then begin
      HintM.Text := GetStringProperty(Form.FindComponent(ComponentsL.Items[Index]),
                   'Hint');
      exit;
     end;
end;

procedure THintCollectorForm.HintMExit(Sender: TObject);
var Index : LongInt;
begin
     {Set hint}
     if ComponentsL.Items.Count=0 then exit;
     for Index := 0 to pred(ComponentsL.Items.Count) do
      if ComponentsL.Selected[Index] then
       SetStringProperty(Form.FindComponent(ComponentsL.Items[Index]),
            'Hint', HintM.Text);
end;

procedure THintCollectorForm.ComponentsLClick(Sender: TObject);
var Index : LongInt;
begin
     {Show hint}
     Index := ComponentsL.ItemIndex;
     if Index<0 then exit;
     HintM.Text := GetStringProperty(Form.FindComponent(ComponentsL.Items[Index]),
                   'Hint');
end;

end.
