{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoHintCollector,  
    hints ,   
}
unit SohoHntC;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls;

type

  {         }
  THintFileName = type string;

  {      (hints)  ,
      .  design-time   
     ,     
        (   ,
    ,           
         -       ).
     ,  ,   TsohoHintsCollector 
     "Save hints",      
     .
  }
  TsohoHintsCollector = class(TComponent)
  private
    { Private declarations }
    FErrorMessage  : boolean;
    FFileName      : THintFileName;
    FAuto          : boolean;
    FSection       : string;
    FOnAfterCreate : TNotifyEvent;
    FIgnoreNull    : boolean;
  protected
    { Protected declarations }
    procedure AfterFormCreate (Sender : TObject);
  public
    { Public declarations }
    constructor Create (AOwner : TComponent);override;
    destructor  Destroy;override;
    procedure   Loaded;override;
    procedure   Execute;
  published
    {   ? }
    property Auto          : boolean read FAuto write FAuto default false;
    {   ,       }
    property ErrorMessage  : boolean read FErrorMessage write FErrorMessage default false;
    {       ? }
    property HintsFile     : THintFileName read FFileName write FFileName;
    {         ? }
    property Section       : string read FSection write FSection;
    {        IgnoreNull=true,  
               }
    property IgnoreNull    : boolean read FIgnoreNull write FIgnoreNull default true;
  end;

function GetRealHintFileName (Value : THintFileName) : THintFileName;

implementation
uses Forms, SoUtils, IniFiles, SoCmnCns;

function GetRealHintFileName (Value : THintFileName) : THintFileName;
begin
     Result := Value;
     if (not FileExists(Result)) or (ExtractFilePath(Result)='') then
      Result := GetRunDir+ExtractFileName(Value);
     if not FileExists(Result) then Result := '';
end;


procedure TsohoHintsCollector.Execute;
var RealHintsFile : THintFileName;
    Form          : TForm;
    ReadHint      : string;
    Index         : LongInt;
begin
     {Prepare and make!}
     RealHintsFile := GetRealHintFileName(HintsFile);
     if RealHintsFile='' then begin
       if FErrorMessage then ErrorMsg(Format(soHintsHintFileNotFound, [HintsFile]));
       exit;
     end;
     Form := GetOwnerForm(Self);
     if Form=nil then exit;
     with TIniFile.Create(RealHintsFile) do begin
        for Index := 0 to pred(Form.ComponentCount) do
         if IsProperty(Form.Components[Index],'Hint') then
           if Form.Components[Index].Name <> '' then begin
            ReadHint := ReadString(Section,Form.Components[Index].Name,'');
            ReadHint := ChangeChars(ReadHint,'|',#13);
            if (ReadHint<>'') or IgnoreNull then
              SetStringProperty(Form.Components[Index],'Hint',ReadHint);
           end;
        Free;
     end;
end;

procedure TsohoHintsCollector.AfterFormCreate (Sender : TObject);
begin
     if Auto then Execute;
     if Assigned(FOnAfterCreate) then FOnAfterCreate(Sender);
end;

constructor TsohoHintsCollector.Create (AOwner : TComponent);
var Form : TForm;
begin
     inherited Create(AOwner);
     FAuto := false;
     FFileName := '';
     Form := GetOwnerForm(Self);
     FSection := '';
     if Form<>nil then FSection := Form.ClassName;
     FErrorMessage := false;
     FIgnoreNull := true;
end;

destructor  TsohoHintsCollector.Destroy;
var Form : TForm;
begin
    Form := GetOwnerForm(Self);
    if Assigned(FOnAfterCreate) then
     if Form<>nil then Form.OnCreate := FOnAfterCreate;
    inherited Destroy;
end;

procedure   TsohoHintsCollector.Loaded;
var Form : TForm;
begin
    inherited Loaded;
    if csDesigning in ComponentState then exit;
    Form := GetOwnerForm(Self);
    if Form<>nil then begin
       FOnAfterCreate := Form.OnCreate;
       Form.OnCreate  := AfterFormCreate;
       if HintsFile='' then HintsFile := ChangeFileExt(ParamStr(0),'.HNT');
    end;
end;

end.
