{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
     -   TsohoDBGuide.  
   : TsohoTreeView (TsohoTVContainer)
}
unit SohoGuid;

{$I SOHOLIB.INC}


interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, SoTools, SoDBGrid, DBTables, SoGuidF, SoUnit, DBGrids,
     SoFolder, SoCtmRec, SohoRec, DB, SohoBtns, SoGauges, Menus, RxDBCtrl;

type

  {        
    ,    .     
         -    
    . ,      
    .         
      MDIChild.        
      - TsohoDBGrid, TsohoRecordForm  TsohoFolder. 
      TsohoDBGuide -      
     .
  }
  TsohoDBGuide = class(TComponent)
  private
    { Private declarations }
    FOnProgress   : TsohoProgressEvent; {04/10/98}
    FGauge        : TsohoGauge; {04/10/98}
    FFolderName: TFileName;
    FFolderDir: TDirName;
    {FTablePath: TFileName;}
    FEnabledMenus: SetOfByte;
    FKeyField: string;
    FResSaveFile: TFileName;
    FMarkedColor: TColor;
    FMarkedFont: tFont;
    FFolderTable: TFileName;
    FItemId: Longint;
    FItemsPreffix  : string; {01/10/98}
    FGuideMenu   : TPopupMenu;

    FOkBtn,
      FCancelBtn: TsohoBitBtn;
    FCaption: TCaption;
    FSQLFile: TSQLFileName;
    FDataBaseName: string;
    FOnOperation: TsohoOnGridOperation;
    FOnFilter: TFilterRecordEvent;
    FOnOldFilter: TFilterRecordEvent;
    FOnGetCellsProps: TGetCellPropsEvent;
    FOnDrawCells: TDrawDataCellEvent;

    FHideFields: TStringList;
    FComplexFields: TStringList;
    FComplexLabels: TStringList;
    FSQLHideFields: TStringList;

    FBeforeSQLGen,
      FAfterSQLGen: TsohoOnSQLGenerate;
    FOnAddField: TsohoOnAddField;
    FOnAddFieldToSQL: TsohoOnAddFieldToSQL;
    FOnGetValue: TsohoOnGetValue;
    FOnGetTextForField: TsohoOnGetTextForField;
    FOnGetComplexValue: TsohoOnGetComplexValue;
    FOnCardCreate,
      FOnCardDestroy,
      FOnFormCreate,
      FOnFormDestroy,
      FOnCardSave,
      FOnCardLoad: TNotifyEvent;
    FAfterExec: TNotifyEvent;

    FBeforeQueryOpen: TDataSetNotifyEvent;
    FOnOldBeforeOpen: TDataSetNotifyEvent;
    FGuideForm: TsohoGuideForm;

    FOnCloseQuery : TCloseQueryEvent;
    FMDIClosed : boolean;
  protected
    { Protected declarations }
    procedure AddMenuItems;
    procedure DoFormCreate    (Modal,WithCancel : boolean);virtual;
    procedure DoFormDestroy  (DoFree: boolean); virtual;
    procedure DoOnCloseQuery (Sender: TObject; var CanClose: Boolean);virtual;
    procedure DoFilter       (DataSet: TDataSet; var Accept: boolean);
    procedure SetMarkedFont  (Value: tFont);
    function GetResults: TsohoDBGridResults;
    procedure SetHideFields  (Value: TStringList);
    procedure SetSQLHideFields(Value: TStringList);
    procedure SetComplexFields(Value: TStringList);
    procedure SetComplexLabels(Value: TStringList);
    function GetItemId: Longint;
    procedure SetItemId(Value: Longint);
    procedure SetEnabledMenus(Value: string);
    function GetEnabledMenus: string;
    procedure SetEvents;
    procedure PrepareButtons(MODAL: boolean; WithCancel: boolean);
    procedure RestoreSelection;
    procedure GuideRecordGetValue(Sender: TObject; FieldName: string;
      var Value: string);
    function DoOperation(Sender: TObject; Operation: TsohoGridOperation): boolean;
    procedure DoBeforeOpen(DataSet: TDataSet);
    procedure DoProgress (Stage : TProgressStage; PercentDone : byte;
              const Msg : string);virtual; {04/10/98}
    procedure Notification(AComponent: TComponent; Operation: TOperation);override; {04/10/98}
  public
    {    ,       
           OnFormCreate }
    function GetPublicArea : TPoint;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {   .       }
    procedure RefreshGuide;
    {        Ok, Cancel.    }
    function ReCreateExecute(Modal, WithCancel : boolean): boolean;
    {     Ok, Cancel.    }
    function Execute(Reopen, Modal, WithCancel : boolean): boolean;
    {     MDI-Child  }
    function MDIExecute: boolean;
    {      }
    function ItemsQuery : TQuery;

    {   .  TsohoDBGrid }
    property Results: TsohoDBGridResults read GetResults;
    {   .  ,   
              }
    property ItemID: Longint read GetItemId write SetItemId default - 1;
    {   }
    procedure CloseGuideForm;
    {     }
    property GuideForm: TsohoGuideForm read FGuideForm;
  published
    {  TsohoFolder }
    property FolderName: TFileName read FFolderName write FFolderName;
    {  TsohoFolder }
    property FolderDir: TDirName read FFolderDir write FFolderDir;
    {  TsohoFolder }
    property EnabledMenus: string read GetEnabledMenus write SetEnabledMenus;
    {       }
    property FolderTable: TFileName read FFolderTable write FFolderTable;
    {     SQL-      }
    property SQLFile: TSQLFileName read FSQLFile write FSQLFile;
    {     }
    property DataBaseName: string read FDataBaseName write FDataBaseName;
    {  TsohoTreeView }
    property ItemsPreffix : string read FItemsPreffix write FItemsPreffix; {01/10/98}
    {   }
    property Caption: TCaption read FCaption write FCaption;
    {  TsohoDBGrid }
    property MarkedColor: TColor read FMarkedColor write FMarkedColor;
    {  TsohoDBGrid }
    property MarkedFont: tFont read FMarkedFont write SetMarkedFont;

    { ,     -  'Id' }
    property KeyField: string read FKeyField write FKeyField;
    {  TsohoRecordForm }
    property HideFields: TStringList read FHideFields write SetHideFields;
    {  TsohoRecordForm }
    property SQLHideFields: TStringList read FSQLHideFields write SetSQLHideFields;
    {  TsohoRecordForm }
    property ComplexFields: TStringList read FComplexFields write SetComplexFields;
    {  TsohoRecordForm }
    property ComplexLabels: TStringList read FComplexLabels write SetComplexLabels;

    {    TsohoGauge,     
       .  ""    
       OnProgress }
    property Gauge         : TsohoGauge read FGauge write FGauge; {04/10/98}
    {   PopupMenu,      }
    property GuideMenu     : TPopupMenu  read FGuideMenu write FGuideMenu;

    {  TsohoRecordForm }
    property OnGetTextForField: TsohoOnGetTextForField read FOnGetTextForField write FOnGetTextForField;
    {  TsohoRecordForm }
    property OnGetComplexValue: TsohoOnGetComplexValue read FOnGetComplexValue write FOnGetComplexValue;
    {  TsohoRecordForm }
    property BeforeSQL: TsohoOnSQLGenerate read FBeforeSQLGen write FBeforeSQLGen;
    {  TsohoRecordForm }
    property AfterSQL: TsohoOnSQLGenerate read FAfterSQLGen write FAfterSQLGen;
    {  TsohoRecordForm }
    property OnAddField: TsohoOnAddField read FOnAddField write FOnAddField;
    {  TsohoRecordForm }
    property OnAddFieldToSQL: TsohoOnAddFieldToSQL read FOnAddFieldToSQL write FOnAddFieldToSQL;
    {  TsohoRecordForm }
    property OnGetValue: TsohoOnGetValue read FOnGetValue write FOnGetValue;
    {  TsohoRecordForm }
    property AfterSQLExecute: TNotifyEvent read FAfterExec write FAfterExec;
    {  TsohoRecordForm }
    property OnCardCreate: TNotifyEvent read FOnCardCreate write FOnCardCreate;
    {  TsohoRecordForm }
    property OnCardDestroy: TNotifyEvent read FOnCardDestroy write FOnCardDestroy;
    {  TsohoRecordForm }
    property OnCardSave: TNotifyEvent read FOnCardSave write FOnCardSave;
    {  TsohoRecordForm }
    property OnCardLoad: TNotifyEvent read FOnCardLoad write FOnCardLoad;
    {  TsohoRecordForm }
    {      .  TsohoTreeView }
    property OnFilter: TFilterRecordEvent read FOnFilter write FOnFilter;
    {  TsohoDBGrid }
    property OnGetCellProps: TGetCellPropsEvent read FOnGetCellsProps write FOnGetCellsProps;
    {  TsohoDBGrid }
    property OnDrawDataCell: TDrawDataCellEvent read FOnDrawCells write FOnDrawCells;
    {       -      }
    property BeforeQueryOpen: TDataSetNotifyEvent read FBeforeQueryOpen write FBeforeQueryOpen;
    {  TsohoDBGrid }
    property OnOperation: TsohoOnGridOperation read FOnOperation write FOnOperation;
    {     - }
    property OnFormCreate: TNotifyEvent read FOnFormCreate write FOnFormCreate;
    {     - }
    property OnFormDestroy: TNotifyEvent read FOnFormDestroy write FOnFormDestroy;
    {        }
    property OnProgress     : TsohoProgressEvent read FOnProgress write FOnProgress; {04/10/98}
  end;

implementation
uses SoUtils, SoDBRtn, SoCtmRgs, SoGuidC, SoBDERtn, SoDBCns;

{04/10/98 >>}
procedure TsohoDBGuide.DoProgress (Stage : TProgressStage; PercentDone : byte;
          const Msg : string);
begin
  if Assigned(FGauge) then begin
    case Stage of
      psStarting : begin
        FGauge.MinValue := 0;
        FGauge.MaxValue := 100;
        FGauge.Progress := PercentDone;
        FGauge.Caption  := Msg;
      end;
      psRunning  : begin
        FGauge.Progress := PercentDone;
        FGauge.Caption  := Msg;
      end;
      psEnding   : begin
        FGauge.Progress := 0;
        FGauge.Caption  := Msg;
      end;
    end;
  end;
  if Assigned(FOnProgress) then FOnProgress(Self, Stage, PercentDone, Msg);
end;

procedure TsohoDBGuide.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if (aComponent=FGauge) and (Operation=opRemove) then FGauge := nil;
  inherited Notification(aComponent, Operation);
end;
{04/10/98 <<}

function TsohoDBGuide.ItemsQuery : TQuery;
begin
  Result := nil;
  if FGuideForm<>nil then Result := FGuideForm.GuideQ;
end;

procedure TsohoDBGuide.DoOnCloseQuery (Sender: TObject; var CanClose: Boolean);
begin
  if Assigned(FOnCloseQuery) then FOnCloseQuery(Sender, CanClose);
  if CanClose and (FGuideForm.FormStyle = fsMDIForm) then FMDIClosed := true;
end;

procedure TsohoDBGuide.RefreshGuide;
begin
  if FGuideForm = nil then exit;
  RefreshFolderWithId(FGuideForm.GuideFolder, FKeyField);
end;

procedure TsohoDBGuide.SetMarkedFont(Value: tFont);
begin
  FMarkedFont.Assign(Value);
end;

procedure TsohoDBGuide.GuideRecordGetValue(Sender: TObject; FieldName: string;
    var Value: string);
begin
  if FieldName = 'MDFDATE' then Value := DateToStr(Date); {01/10/98}
  if FieldName = 'MDFTIME' then Value := TimeToStr(Time); {01/10/98}
  if FieldName = 'IDMDFDAUTH' then begin {01/10/98}
    Value := '0';
    if SingleRegister <> nil then Value := IntToStr(SingleRegister.UserID);
  end;
  if FGuideForm.GuideRecord.Mode <> rmInsert then exit;
  if FieldName = StrUpper(FKeyField) then begin
    if FItemsPreffix = '' then
      FItemsPreffix := Owner.ClassName + '.' + ClassName + '.' + Name + '.NewItem'; {01/10/98}
    Value := IntToStr(GetNewId(FItemsPreffix));
  end;
  if Assigned(FOnGetValue) then FOnGetValue(Sender, FieldName, Value);
end;

function TsohoDBGuide.DoOperation(Sender: TObject; Operation: TsohoGridOperation): boolean;

  function DoDeleteRecord : boolean;
  var SQlDir : string;
      SQLText : string;
  begin
    if ExtractFileExt(FFolderTable)<>'' then
      SQLText := 'delete from "' + FFolderTable + '"'
    else
      SQLText := 'delete from ' + FFolderTable;
    SQLText := SQLText +' where ' + FKeyField + '= ' +
      FGuideForm.GuideQ.FieldByName(FKeyField).AsString;
    Result := ExecuteSQLText(SQLText, FDataBaseName, NillParams);
  end;

var DoRefresh : boolean;
begin
  DoRefresh := false;
  if Assigned(FOnOperation) then FOnOperation(Sender, Operation)
  else
    case Operation of
      soNewRecord: begin
         DoRefresh := FGuideForm.GuideRecord.Insert;
         FGuideForm.GuideRecord.Close; {07/10/98}
      end;
      soEditRecord: begin
         if FGuideForm.GuideQ.FieldByName(FKeyField).IsNull then
           DoRefresh := FGuideForm.GuideRecord.Insert
         else DoRefresh := FGuideForm.GuideRecord.Edit;
         FGuideForm.GuideRecord.Close; {07/10/98}
      end;
      soDeleteRecord: if not (FGuideForm.GuideQ.FieldByName(FKeyField).IsNull) and
                      (YesNoMsg(sohoTVContDeleteQuestion)) then
        if DoDeleteRecord then RefreshFolder(FGuideForm.GuideFolder);
    end;
  if DoRefresh then begin
    // FGuideForm.GuideGrid.Repaint;
    RefreshFolderWithID(FGuideForm.GuideFolder, FKeyField);
  end;
end;

procedure TsohoDBGuide.DoBeforeOpen(DataSet: TDataSet);
begin
  if Assigned(FBeforeQueryOpen) then FBeforeQueryOpen(DataSet);
  if Assigned(FOnOldBeforeOpen) then FOnOldBeforeOpen(DataSet);
end;

procedure TsohoDBGuide.AddMenuItems;
var InsIndex, Index : LongInt;
    MnuItem : TMenuItem;
begin
  if FGuideMenu = nil then exit;
  with FGuideForm.GuideGrid.PopupMenu do begin
     InsIndex := Items.Count-1;
     {    -       
        }
     while (InsIndex>=0)and (Items[InsIndex].Caption <> '-') do Dec(InsIndex);
     if InsIndex<0 then InsIndex := 0;
     Items.Insert(InsIndex, NewItem('-', 0, false, true, nil, 0, ''));
     inc(InsIndex);
     for Index := 0 to pred(FGuideMenu.Items.Count) do begin
       MnuItem := CopyMenuItem(Self, FGuideMenu.Items[Index]);
       Items.Insert(InsIndex, MnuItem);
       inc(InsIndex);
     end;
  end;
end;

procedure TsohoDBGuide.SetEvents;
var FSQL: string;
begin
  if FGuideForm = nil then exit;
  if (FDataBaseName = '') and (SingleRegister<>nil)
     then FDataBaseName := SingleRegister.PathToData;
  with FGuideForm do begin
    Tag := Self.Tag;
    KeyField := FKeyField; {07/10/98}
    GuideGrid.KeyField := FKeyField;
    with GuideGrid do begin
      OnGetCellProps := FOnGetCellsProps;
      {OnCalcCellColors := FOnCalcCells;}
      OnDrawDataCell := FOnDrawCells;
      OnOperation := DoOperation;
      AddMenuItems;
    end;
    with GuideFolder do begin
      DataBaseName := FDataBAseName;
      if FFolderDir <> '' then FolderDir := FFolderDir;
      FolderName := FFolderName;
      TableName := FFolderTable;
      KeyField := FKeyField;
      EnabledMenus := SetToStr(FEnabledMenus);
    end;
    FSQL := FSQLFile;
    if SingleRegister<>nil then
      FSQL := SingleRegister.PathToSQL + FSQLFile;
    with GuideQ, SQL do begin
      DataBaseName := FDataBaseName;
      Clear;
      LoadFromFile(FSQL);
      FOnOldBeforeOpen := BeforeOpen;
      BeforeOpen := DoBeforeOpen;
      FOnOldFilter := OnFilter;
      OnFilter := DoFilter;
    end;
    with GuideRecord do begin
      Caption := FCaption;
      KeyField := FKeyField;
      TableName := FFolderTable;
      DataBaseName := FDataBaseName;
      HideFields.Assign(FHideFields);
      SQLHideFields.Assign(FSQLHideFields);
      ComplexFields.Assign(FComplexFields);
      ComplexLabels.Assign(FComplexLabels);
      OnGetTextForField := FOnGetTextForField;
      OnGetComplexValue := FOnGetComplexValue;
      BeforeSQL := FBeforeSQLGen;
      AfterSQL := FAfterSQLGen;
      OnAddField := FOnAddField;
      OnAddFieldToSQL := FOnAddFieldToSQL;
      OnGetValue := GuideRecordGetValue;
      AfterSQLExecute := FAfterExec;
      OnCardCreate := FOnCardCreate;
      OnCardDestroy := FOnCardDestroy;
      OnCardSave := FOnCardSave;
      OnCardLoad := FOnCardLoad;
    end;
    //GradientCaption.FormCaption := FCaption;
    Caption := FCaption;
    GuideStorage.IniSection := Owner.name + '.' + ClassName +
      '.' + name;
  end;
end;

procedure TsohoDBGuide.DoFilter(DataSet: TDataSet; var Accept: boolean);
begin
  if Assigned(FOnOldFilter) then FOnOldFilter(DataSet, Accept);
  if Assigned(FOnFilter) then FOnFilter(DataSet, Accept);
end;

function TsohoDBGuide.GetResults: TsohoDBGridResults;
begin
  Result := nil;
  if FGuideForm = nil then exit;
  Result := FGuideForm.GuideGrid.Results;
end;

procedure TsohoDBGuide.SetHideFields(Value: TStringList);
begin
  FHideFields.Assign(Value);
end;

procedure TsohoDBGuide.SetSQLHideFields(Value: TStringList);
begin
  FSQLHideFields.Assign(Value);
end;

procedure TsohoDBGuide.SetComplexFields(Value: TStringList);
begin
  FComplexFields.Assign(Value);
end;

procedure TsohoDBGuide.SetComplexLabels(Value: TStringList);
begin
  FComplexLabels.Assign(Value);
end;

function TsohoDBGuide.GetItemId: Longint;
begin
  if FGuideForm = nil then Result := FItemId
  else Result := FGuideForm.GuideQ.FieldByName(FKeyField).AsInteger;
end;

procedure TsohoDBGuide.SetItemId(Value: Longint);
begin
  if FGuideForm <> nil then
    if LocaleByID(FGuideForm.GuideQ, FKeyField, Value) then FItemId := Value;
end;

procedure TsohoDBGuide.SetEnabledMenus(Value: string);
begin
  FEnabledMenus := StrToSet(Value);
end;

function TsohoDBGuide.GetEnabledMenus: string;
begin
  Result := SetToStr(FEnabledMenus);
end;

constructor TsohoDBGuide.Create(AOwner: TComponent);
var Form: TForm;
begin
  inherited Create(AOwner);
  FEnabledMenus := StrToSet('0-9,11-12,14-15,17-18,20-21,');
  FKeyField := 'Id';
  FItemId := -1;
  FMarkedFont := tFont.Create;
  with FMarkedFont do begin
    Form := GetOwnerForm(Self);
    if Form <> nil then Assign(Form.Font);
    Style := [];
  end;
  FMarkedColor := clAqua;
  FGuideForm := nil;
  FHideFields := TStringList.Create;
  with FHideFields do begin
    Clear;
    Add('ID');
    Add('MDFDATE');
    Add('MDFTIME');
    Add('IDMDFAUTH');
    Add('PROTECT');
  end;
  FSQLHideFields := TStringList.Create;
  FComplexFields := TStringList.Create;
  FComplexLabels := TStringList.Create;
  FOkBtn := nil;
  FCancelBtn := nil;
end;

destructor TsohoDBGuide.Destroy;
begin
  FHideFields.Free;
  FSQLHideFields.Free;
  FComplexFields.Free;
  FComplexLabels.Free;
  FMarkedFont.Free;
  inherited Destroy;
end;


procedure TsohoDBGuide.PrepareButtons(MODAL: boolean; WithCancel: boolean);
begin
  if FOkBtn <> nil then FOkBtn.Free;
  if FCancelBtn <> nil then FCancelBtn.Free;
  FOkBtn := nil;
  FCancelBtn := nil;

  FOkBtn := TsohoBitBtn.Create(FGuideForm);
  with FOkBtn do begin
    Parent := FGuideForm.BtnsPanel;
    Top := 1;
    Left := 8;
    if Modal then Caption := 'OK'
    else Caption := sohoTVContBtnClose;
    OnClick := FGuideForm.OkMClick;
  end;
  if (not Modal) or (not WithCancel) then exit;
  FCancelBtn := TsohoBitBtn.Create(FGuideForm);
  with FCancelBtn do begin
    Parent := FGuideForm.BtnsPanel;
    Top := 1;
    Left := FOkBtn.Left + FOkBtn.Width + 3;
    OnClick := FGuideForm.CancelMClick;
    Caption := sohoExlRepCancelBtnCaption;
  end;
end;

function TsohoDBGuide.GetPublicArea : TPoint;
begin
   Result.X := 0;
   if FOkBtn<>nil then Result.X := FOkBtn.Left+FOkBtn.Width + 2;
   if FCancelBtn<>nil then Result.X := FCancelBtn.Left+FCancelBtn.Width + 2;
   Result.Y := 1;
end;


procedure TsohoDBGuide.RestoreSelection;
begin
  if FItemId > 0 then LocaleByID(FGuideForm.GuideQ, FKeyField, FItemId);
  if FResSaveFile <> '' then FGuideForm.GuideGrid.Results.LoadFromFile(FResSaveFile);
end;

procedure TsohoDBGuide.DoFormCreate(Modal, WithCancel : boolean);
begin
  try
    SetCursor(crHourGlass);
    DoProgress (psRunning, 45, ResString(gdSetEvents));
    SetEvents;
    DoProgress (psRunning, 60, ResString(gdPrepareButtons));
    PrepareButtons(Modal, WithCancel);
    DoProgress (psRunning, 90, ResString(gdQueryActivate));
    FGuideForm.GuideQ.Open;
    SetCursor(crHourGlass);
    DoProgress (psRunning, 99, ResString(gdRestoring));
    RestoreSelection;
    FGuideForm.ModalMode := Modal;
    if Assigned(FOnFormCreate) then FOnFormCreate(Self);
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TsohoDBGuide.DoFormDestroy(DoFree: boolean);
begin
  try
    SetCursor(crHourGlass);
    if Assigned(FOnFormDestroy) then FOnFormDestroy(Self);
    if FOkBtn <> nil then FOkBtn.Free;
    if FCancelBtn <> nil then FCancelBtn.Free;
    FOkBtn := nil;
    FCancelBtn := nil;
    if DoFree then begin
      if ((FGuideForm.FormStyle=fsMDIForm) and (not FMDIClosed))
         or (FGuideForm.FormStyle<>fsMDIForm) then FGuideForm.Free;
      FGuideForm := nil;
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

function TsohoDBGuide.ReCreateExecute(MODAL: boolean; WithCancel: boolean): boolean;
begin
  DoProgress (psStarting, 0, ResString(gdPreparing));
  if FGuideForm <> nil then begin
    ErrorMsg(Format(sohoTVContFormAlreadyExists, [name]));
    exit;
  end;
  try
    DoProgress (psRunning, 33, ResString(gdFormCreate));
    FGuideForm := TsohoGuideForm.Create(Self);
    with FGuideForm do begin
      Result := not Modal;
      DoFormCreate(Modal, WithCancel);
      DoProgress (psRunning, 100, ResString(gdFormShow));
      if Modal then Result := ShowModal = mrOk
      else Show;
      DoProgress (psEnding, 100, '');
      if Result then begin
        FItemId := GuideQ.FieldByName(FKeyField).AsInteger;
        if FResSaveFile <> '' then GuideGrid.Results.SaveToFile(FResSaveFile);
      end;
    end;
  finally
    DoFormDestroy(True);
  end;
end;

function TsohoDBGuide.Execute(Reopen, Modal, WithCancel: boolean): boolean;
var FSQL : string;
begin
  DoProgress (psStarting, 0, ResString(gdPreparing));
  if FGuideForm <> nil then begin
    {05/10/98 >>}
    Result := not Modal;
    PrepareButtons(Modal, WithCancel);
    if Assigned(FOnFormCreate) then FOnFormCreate(Self);
    if ReOpen then begin
      FSQL := FSQLFile;
      if SingleRegister<>nil then
        FSQL := SingleRegister.PathToSQL + FSQLFile;
      FGuideForm.GuideQ.SQL.LoadFromFile(FSQL);
      RefreshFolderWithId(FGuideForm.GuideFolder, FKeyField);
    end;
    {05/10/98 <<}
    if Modal then Result := FGuideForm.ShowModal = mrOk
    else FGuideForm.Show;
    {05/10/98 >>}
    if Result then begin
      FItemId := FGuideForm.GuideQ.FieldByName(FKeyField).AsInteger;
      if FResSaveFile <> '' then FGuideForm.GuideGrid.Results.SaveToFile(FResSaveFile);
    end;
    DoFormDestroy(False);
    {05/10/98 <<}
    exit;
  end;
  try
    DoProgress (psRunning, 33, ResString(gdFormCreate));
    FGuideForm := TsohoGuideForm.Create(Self);
    with FGuideForm do begin
      DoFormCreate(Modal, WithCancel);
      DoProgress (psRunning, 100, ResString(gdFormShow));
      Result := not Modal;
      if Modal then Result := ShowModal = mrOk
      else Show;
      DoProgress (psEnding, 100, '');
      if Result then begin
        FItemId := GuideQ.FieldByName(FKeyField).AsInteger;
        if FResSaveFile <> '' then GuideGrid.Results.SaveToFile(FResSaveFile);
      end;
      DoFormDestroy(False);
    end;
  except ErrorMsg(Format(sohoTVContFormCreateError, [Self.name]));
  end;
end;

function TsohoDBGuide.MDIExecute: boolean;
var Form: TForm;
begin
  DoProgress (psStarting, 0, ResString(gdPreparing));
  if FGuideForm <> nil then begin
    ErrorMsg(Format(sohoTVContFormAlreadyExists, [name]));
    exit;
  end;
  try
    Form := GetOwnerForm(Self);
    if Form = nil then exit;
    if Form.FormStyle <> fsMDIForm then exit;
    DoProgress (psRunning, 33, ResString(gdFormCreate));
    FGuideForm := TsohoGuideForm.Create(Form);
    with FGuideForm do begin
      FormStyle := fsMDIChild;
      DoProgress (psRunning, 60, ResString(gdSetEvents));
      SetEvents;
      //FGuideForm.GradientCaption.FormCaption := FCaption;
      FGuideForm.Caption := FCaption;
      GuideStorage.IniSection := Owner.name + '.' + ClassName + '.' + name;
      DoProgress (psRunning, 90, ResString(gdQueryActivate));
      GuideQ.Open;
      DoProgress (psRunning, 99, ResString(gdRestoring));
      RestoreSelection;
      if Assigned(FOnFormCreate) then FOnFormCreate(Self);
      ModalMode := False;
      WindowState := wsMaximized;
      DoProgress (psRunning, 100, ResString(gdFormShow));
      Show;
      DoProgress (psEnding, 100, '');
      Result := True;
    end;
  except ErrorMsg(Format(sohoTVContFormCreateError, [Self.Name]));
  end;
end;

procedure TsohoDBGuide.CloseGuideForm;
begin
  if FGuideForm = nil then exit;
  DoFormDestroy(True)
end;

end.

