{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{            Copyright (c) 1996-1998 Soho              }
{                                                       }
{        for Query Visual Builder for SOHO-project      }
{                                                       }
{                                                       }
{*******************************************************}
{   
  TSohoDocument - 
   ,   ,
      
 TsohoTableFolder (?)
 TsohoTableFolderField (??)
 TQPage
 Written 1996-1998 by Wizard,Allex 
       
	
}
unit Sohodoc;

{$I SOHOLIB.INC}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, IniFiles, DB, SoUnit,
  {From QPage} DBTables, SoUtils, ExtCtrls, Buttons, SoCtrls;

type
  TSigns = string;
const
  
  {      }
  Conditions: array[1..7] of TSigns  = ('', ' ', '',
    '', ' ', ' ',
    '');                                                      
  {      " "}
  FieldsLinks: array[1..4] of string = ('', '', ' ', ' ');
  
type
  
  {---------------------------------------------------------------------
     TWField -
     ,    TField,    
      , ,        .
    ---------------------------------------------------------------------}
  
  TWField = class(TComponent)
  private
    FTableName: string; {   }
    FFieldName: string; { }
    FSQLFieldName: string; {Allex -     january 1998}
    FDisplayLabel: string; {  -  Folder}
    FFieldType: TValueKind; { }
    FActive: boolean; {  }
    FSigns: array[1..2] of TSigns; {,      }
    FValues: array[1..2] of string;
    procedure SetFieldType(Value: TValueKind);
    function GetValue(index: Integer): string;
    procedure SetValue(index: Integer; Value: string);
    function GetSign(index: Integer): TSigns;
    procedure SetSign(index: Integer; Value: TSigns);
  public
    DocumentIndex: Longint; {Allex - 1998 Jan -   .
             Request Folder 
              SQL}
    procedure Assign(Value: TWField);
    constructor Create(AOwner: TComponent; AFieldname: string);
  published
    property DisplayLabel: string read FDisplayLabel write FDisplayLabel; { }
    property Active: boolean read FActive write FActive; {  }
    property TableName: string read FTableName write FTableName; { TableFolder,
           }
    property FieldName: string read FFieldName write FFieldName;
    property SQLFieldName: string read FSQLFieldName write FSQLFieldName; {Allex}
    property FieldType: TValueKind read FFieldType write SetFieldType;
    property LeftValue: string index 1 read GetValue write SetValue;
    property RightValue: string index 2 read GetValue write SetValue;
    property LeftSign: TSigns index 1 read GetSign write SetSign;
    property RightSign: TSigns index 2 read GetSign write SetSign;
  end;
  
type
  TsohoTableFolderField = class
  private
    FFieldName: string;
    FDisplayLabel: string;
    FDisplayWidth: Integer;
    FFieldType: TFieldType;
    FActive: boolean;
    FVisible: boolean;
    FLinkedTo: TFileName;
    FIndex: Integer;
  public
    {LinkID           : LongInt;}
    property FieldName: string read FFieldName write FFieldName;
    property DisplayLabel: string read FDisplayLabel write FDisplayLabel;
    property DisplayWidth: Integer read FDisplayWidth write FDisplayWidth;
    property FieldType: TFieldType read FFieldType write FFieldType;
    property Active: boolean read FActive write FActive; {false    }
    property Visible: boolean read FVisible write FVisible; {  CheckBox'  }
    property LinkedTo: TFileName read FLinkedTo write FLinkedTo; {  TableFolder, 
                                                 }
    property index: Integer read FIndex write FIndex;
  end;
  
  TsohoTableFolder = class(TObject)
  private
    FFields: TList;
    FTableName: TFileName;
    FTitle: string;
    FTableFolderName: TFileName;
    DocumentIndex: Longint;
  protected
    function GetField(index: Integer): TsohoTableFolderField;
    procedure CreateFields;
    procedure DestroyFields;
  public
    {LinkID           :LongInt; }
    constructor Create(aTableFolderName: TFileName; index: Longint);
    destructor Destroy; override;
    function FieldsCount: Integer;
    function FieldByName(FieldName: string): TsohoTableFolderField;
    function GetShortFolderName: string;
    property Fields[index: Integer]: TsohoTableFolderField read GetField;
    property TableName: TFileName read FTableName; {   }
    property Title: string read FTitle; { }
    property TableFolderName: TFileName read FTableFolderName; {   -    }
    { -  .   - '', 
                  ,  TableFolder 
               }
    property ShortFolderName: string read GetShortFolderName;
  end;
  
  
  TsohoDocument = class(TListBox)
  private
    { Private declarations }
    fDocFile: string;
    fDocName: string;
    FFolders: TList;
    procedure SetActive(State: boolean);
    function GetActive: boolean;
  protected
    { Protected declarations }
    function GetFolder(index: Integer): TsohoTableFolder;
    procedure CreateFolders;
    procedure DestroyFolders;
  public
    { Public declarations }
    FIni: TIniFile;
    SQL: TStringList;
    procedure Open;
    procedure Close;
    function FoldersCount: Integer;
    function FolderByShortName(ShortTableFolderName: string): TsohoTableFolder;
    function FolderByName(TableFolderName: TFileName): TsohoTableFolder;
    
    procedure CheckBuilder;
    function Execute: boolean;
    function LoadAndEdit: boolean;
    function LoadFromFile: boolean;
    function SaveToFile: boolean;
    function GetSQL: TStringList;
    
    
    property Folders[index: Integer]: TsohoTableFolder read GetFolder;
  published
    { Published declarations }
    property DocFile: string read fDocFile write fDocFile;
    property Title: string read fDocName write fDocName;
    property Active: boolean read GetActive write SetActive;
  end;
  {---------------------------------------------------------------------
     TQueryPage - ,      
     ,    SQL.      
     DocumentFolder
    ---------------------------------------------------------------------}
  
  TQueryPage = class(TCustomControl)
  private
    FTitle: string;
    FDocFolder: TsohoDocument;
    FSQL: TStringList;
    FLastVisible: Integer;
    FFolderName: TFileName;
    FFields: TList; {  }
    FVisibles: TList; {  - checkbox'}
    Labels: TList; {   }
    LeftConds: TList; {    }
    LeftEdits: TList; {   }
    RightConds: TList; {    }
    RightEdits: TList; {   }
    MidConds: TList; {  }
    FLinks: TList; {   -   
                               "", "", " ", " "}
    FNewLines: TList; { "-"}
    FDelLines: TList; { "-"}
    FDown: TList; {  }
    FOnResize: TNotifyEvent;
    procedure SetField(index: Integer; Value: TWField);
    function GetField(index: Integer): TWField;
    procedure SetVisField(index: Integer; Value: TWField);
    function GetVisField(index: Integer): TWField;
    procedure SetVisibles;
    procedure SetVisible(index: Integer; Visible: boolean);
    function GetVisible(index: Integer): boolean;
    procedure SetLinks(index: Integer; Value: string);
    function GetLinks(index: Integer): string;
    procedure ChangeVisible(Sender: TObject);
    procedure ChangeStop(Sender: TObject);
    procedure AddFieldCond(Sender: TObject);
    procedure DelFieldCond(Sender: TObject);
    procedure DoResize;
    procedure SetPositions;
    procedure CreateLine(index: Integer; LabelVisible: boolean;
      FieldRef: TsohoTableFolderField;
      TableName: TFileName;
      DocumentIndex: Longint);
    function LastVisible: Integer;
    procedure FillLine(index: Longint; Checked: boolean;
      LeftCond, RightCond, MidCond, LinkCond: Longint;
      LeftValue, RightValue: string);
    function FieldConditions(FieldName: string): Integer;
    procedure FreeWithItems(List: TList; FreeList: boolean);
    function ActiveParts(index: Integer): Integer; { , 
         }
    function VisibleToReal(Value: Integer): Integer;
    function GetSectionsByFieldName(FieldName, RequestFile: string): TStringList;
    function SelectedCount: Integer;
    function FieldByName(FieldName: string): TWField;
    property QFields[index: Integer]: TWField read GetField write SetField;
    property VisibleFields[index: Integer]: TWField read GetVisField write SetVisField;
    property Visibles[index: Integer]: boolean read GetVisible write SetVisible;
    property Links[index: Integer]: string read GetLinks write SetLinks;
  public
    property DocumentFolderName: TFileName read FFolderName write FFolderName;
    procedure GenerateSQL;
    constructor Create(AOwner: TComponent); override;
    function CreatePage(DOCUMENT: TsohoDocument): boolean;
    function LoadFromFile(DOCUMENT: TsohoDocument): boolean;
    function SaveToFile(DOCUMENT: TsohoDocument): boolean;
    destructor Destroy; override;
    property Title: string read FTitle write FTitle;
    property SQL: TStringList read FSQL;
    property OnResize: TNotifyEvent read FOnResize write FOnResize;
  end;
  
type
  TQBuilderForm = class(TForm)
    Panel1: TPanel;
    PageParent: TPanel;
    SCROLL: TScrollBar;
    OkB: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    procedure FormDestroy(Sender: TObject);
    procedure ScrollChange(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure OkBClick(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
  private
    { Private declarations }
    QPage: TQueryPage;
    function GetSQL: TStringList;
  public
    { Public declarations }
    function Edit(DOCUMENT: TsohoDocument): boolean; {    }
    function Clear(DOCUMENT: TsohoDocument): boolean; { }
    function Execute(DOCUMENT: TsohoDocument): boolean; {  }
    function LoadFromFile(DOCUMENT: TsohoDocument): boolean; {  }
    function SaveToFile(DOCUMENT: TsohoDocument): boolean; {  }
    function LoadAndExecute(DOCUMENT: TsohoDocument): boolean; {    }
    property SQL: TStringList read GetSQL; { SQL-}
  end;
  
var
  QBuilderForm: TQBuilderForm;
  
  {$R *.DFM}
  
  
  { ,    }
function FieldNameToFieldType(FieldName: string): TFieldType;
{  TsohoEdit}
function FieldTypeToValueKind(FieldType: TFieldType; var ValueKind: TValueKind): boolean;
{ }
function ValueKindToFieldType(ValueKind: TValueKind): TFieldType;

implementation
uses SoDate;

function FieldNameToFieldType(FieldName: string): TFieldType;
var Tmp: string[2];
begin
  Tmp := Copy(FieldName, 1, 2);
  Result := ftUnknown;
  if (Tmp = 'IN') or (Tmp = 'LO') then Result := ftInteger;
  if Tmp = 'FL' then Result := ftFloat;
  if Tmp = 'DA' then Result := ftDate;
  if Tmp = 'TI' then Result := ftTime;
  if (Tmp = 'CH') or (Tmp = 'CO') or (Tmp = 'ST') then Result := ftString;
  if Tmp = 'SI' then Result := ftSmallInt;
  if Tmp = 'WO' then Result := ftWord;
  if Tmp = 'BO' then Result := ftBoolean;
  if Tmp = 'CU' then Result := ftCurrency;
  if Tmp = 'BC' then Result := ftBCD;
  if Tmp = 'DT' then Result := ftDateTime;
  if Tmp = 'BY' then Result := ftBytes;
  if Tmp = 'VA' then Result := ftVarBytes;
  if Tmp = 'BL' then Result := ftBlob;
  if Tmp = 'ME' then Result := ftMemo;
  if Tmp = 'GR' then Result := ftGraphic;
end;

function ValueKindToFieldType(ValueKind: TValueKind): TFieldType;
begin
  if ValueKind = vkString then Result := ftString;
  if ValueKind = vkInteger then Result := ftInteger;
  if ValueKind = vkFloat then Result := ftFloat;
  if ValueKind = vkDate then Result := ftDate;
  if ValueKind = vkTime then Result := ftTime;
end;

function FieldTypeToValueKind(FieldType: TFieldType; var ValueKind: TValueKind): boolean;
begin
  if FieldType in [ftInteger, ftSmallInt, ftWord] then ValueKind := vkInteger;
  if FieldType in [ftFloat, ftCurrency] then ValueKind := vkFloat;
  if FieldType = ftDate then ValueKind := vkDate;
  if FieldType = ftTime then ValueKind := vkTime;
  if FieldType = ftString then ValueKind := vkString;
  Result := FieldType in [ftInteger, ftSmallInt, ftWord, ftFloat, ftCurrency,
    ftDate, ftTime, ftString];
end;

{----------------------------TsohoTableFolder-------------------------------}
function TsohoTableFolder.GetShortFolderName: string;
begin
  Result := 'Table' + IntToStr(DocumentIndex);
end;


procedure TsohoTableFolder.CreateFields;
var FieldsList: TStringList;
  index    : Integer;              
  Ini      : TIniFile;             
  NewField : TsohoTableFolderField;
  ValueKind: TValueKind;           
begin
  Ini := TIniFile.Create(FTableFolderName);
  with Ini do begin
    FieldsList := TStringList.Create;
    ReadSection('Fields', FieldsList);
    if FieldsList.Count = 0 then
      raise Exception.Create('     !');
    for index := 0 to FieldsList.Count - 1 do begin
      NewField := TsohoTableFolderField.Create;
      NewField.FieldName := AnsiUpperCase(FieldsList[index]);
      NewField.FieldType := FieldNameToFieldType(NewField.FieldName);
      NewField.DisplayLabel := ReadString(NewField.FieldName, 'DisplayLabel',
        NewField.FieldName);
      NewField.DisplayWidth := ReadInteger(NewField.FieldName, 'DisplayWidth',
        10);
      NewField.Active := FieldTypeToValueKind(NewField.FieldType, ValueKind);
      NewField.Visible := ReadBool(NewField.FieldName, 'Visible',
        True);
      NewField.LinkedTo := ReadString(NewField.FieldName, 'LinkedTo',
        '');
      {NewField.LinkID        := ReadInteger(NewField.FieldName,'LinkID',
                                        0);}
      NewField.index := ReadInteger(NewField.FieldName, 'Index',
        index);
      {NewField.LinkID := ReadInteger(NewField.FieldName,'LinkID',0);}
      FFields.Add(NewField);
    end;
  end;
  Ini.Free;
end;

procedure TsohoTableFolder.DestroyFields;
var index: Integer;
begin
  for index := 0 to FFields.Count - 1 do begin
    TsohoTableFolderField(FFields[index]).Free;
    FFields[index] := nil;
  end;
  FFields.Pack;
end;

function TsohoTableFolder.GetField(index: Integer): TsohoTableFolderField;
begin
  Result := TsohoTableFolderField(FFields[index]);
end;

constructor TsohoTableFolder.Create(aTableFolderName: TFileName; index: Longint);
var Ini: TIniFile;
begin
  FTableFolderName := aTableFolderName;
  Ini := TIniFile.Create(FTableFolderName);
  FTableName := Ini.ReadString('DataSet', 'FileName', '');
  if FTableName = '' then raise Exception.Create('   !');
  FTitle := Ini.ReadString('General', 'Title', '');
  DocumentIndex := index;
  Ini.Free;
  FFields := TList.Create;
  CreateFields;
end;

destructor TsohoTableFolder.Destroy;
begin
  DestroyFields;
  FFields.Free;
  inherited Destroy;
end;

function TsohoTableFolder.FieldsCount: Integer;
begin
  Result := FFields.Count;
end;

function TsohoTableFolder.FieldByName(FieldName: string): TsohoTableFolderField;
var index: Integer;
begin
  Result := nil;
  for index := 0 to FFields.Count - 1 do
    if TsohoTableFolderField(FFields[index]).FieldName = FieldName then
      Result := TsohoTableFolderField(FFields[index]);
  if Result = nil then raise Exception.Create(': ' + FieldName + '  !');
end;


{------------------------ TSohoDocument ----------------}
procedure TsohoDocument.CheckBuilder;
begin
  if QBuilderForm = nil then Application.CreateForm(TQBuilderForm, QBuilderForm);
end;

function TsohoDocument.Execute;
begin
  CheckBuilder;
  Result := QBuilderForm.Execute(Self);
  SQL := QBuilderForm.SQL;
end;

function TsohoDocument.LoadAndEdit;
begin
  CheckBuilder;
  Result := QBuilderForm.LoadAndExecute(Self);
  SQL := QBuilderForm.SQL;
end;

function TsohoDocument.LoadFromFile;
begin
  CheckBuilder;
  Result := QBuilderForm.LoadFromFile(Self);
  SQL := QBuilderForm.SQL;
end;

function TsohoDocument.SaveToFile;
begin
  CheckBuilder;
  Result := QBuilderForm.SaveToFile(Self);
  SQL := QBuilderForm.SQL;
end;


procedure TsohoDocument.Open;
begin
  if FIni <> nil then Close;
  FIni := TIniFile.Create(DocFile);
  FIni.ReadString('General', 'Title', '');
  Clear;
  FIni.ReadSection('Folders', Items);
  ItemIndex := 0;
  FFolders := TList.Create;
  CreateFolders;
end;

procedure TsohoDocument.Close;
var I: Longint;
begin
  if FIni = nil then Exit;
  with FIni do begin
    WriteString('General', 'Title', Title);
    WriteString('General', 'Document', DocFile);
    EraseSection('Folders');
    for I := 0 to Items.Count - 1 do WriteString('Folders', Items[I], 'Exists');
  end;
  FIni.Free;
  FIni := nil;
  DestroyFolders;
  FFolders.Destroy;
  Clear;
end;

function TsohoDocument.GetActive;
begin Result := FIni <> nil end;

procedure TsohoDocument.SetActive;
begin
  if State then Open else Close;
end;


procedure TsohoDocument.CreateFolders;
var Ini: TIniFile;
  index                  : Integer;         
  NewFolder              : TsohoTableFolder;
  {    Section1,Section2 : TStringList;     
    i,j                  :LongInt;          }
begin
  if Items.Count = 0 then
    ErrorMsg('     !');
  for index := 0 to Items.Count - 1 do begin
    {   TableFolder     
                " "}
    NewFolder := TsohoTableFolder.Create(Items[index], index + 1);
    {NewFolder.DocumentIndex:=Index+1;}
    FFolders.Add(NewFolder);
  end;
end;

procedure TsohoDocument.DestroyFolders;
var index: Integer;
begin
  for index := 0 to FFolders.Count - 1 do begin
    TsohoTableFolder(FFolders[index]).Free;
    FFolders[index] := nil;
  end;
  FFolders.Pack;
end;

function TsohoDocument.GetFolder(index: Integer): TsohoTableFolder;
begin
  Result := TsohoTableFolder(FFolders[index]);
end;

function TsohoDocument.FolderByShortName(ShortTableFolderName: string): TsohoTableFolder;
var index: Integer;
begin
  Result := nil;
  for index := 0 to FFolders.Count - 1 do
    if TsohoTableFolder(FFolders[index]).ShortFolderName = ShortTableFolderName then
      Result := TsohoTableFolder(FFolders[index]);
  if Result = nil then
    raise Exception.Create('  : ' + ShortTableFolderName + '!');
end;

function TsohoDocument.FolderByName(TableFolderName: TFileName): TsohoTableFolder;
var index: Integer;
begin
  Result := nil;
  for index := 0 to FFolders.Count - 1 do
    if TsohoTableFolder(FFolders[index]).TableFolderName = TableFolderName then
      Result := TsohoTableFolder(FFolders[index]);
  if Result = nil then
    raise Exception.Create('  : ' + TableFolderName + '!');
end;

function TsohoDocument.FoldersCount: Integer;
begin
  Result := Items.Count;
end;

function TsohoDocument.GetSQL;
begin
  CheckBuilder;
  Result := QBuilderForm.SQL;
end;

{------------------------TWField--------------------------}
procedure TWField.SetFieldType(Value: TValueKind);
begin
  FValues[1] := '';
  FValues[2] := '';
  FFieldType := Value;
end;

function TWField.GetValue(index: Integer): string;
begin
  Result := FValues[index];
end;

procedure TWField.SetValue(index: Integer; Value: string);
begin
  FValues[index] := Value;
end;

function TWField.GetSign(index: Integer): TSigns;
begin
  Result := FSigns[index];
end;

procedure TWField.SetSign(index: Integer; Value: TSigns);
begin
  FSigns[index] := Value;
end;

constructor TWField.Create(AOwner: TComponent; AFieldname: string);
begin
  inherited Create(AOwner);
  FValues[1] := '';
  FValues[2] := '';
  FSigns[1] := '';
  FSigns[2] := '';
  FFieldName := AFieldname;
  FSQLFieldName := AFieldname;
  DocumentIndex := 0;
  FFieldType := vkString;
  FDisplayLabel := AFieldname;
end;

procedure TWField.Assign(Value: TWField);
begin
  FValues[1] := Value.LeftValue;
  FValues[2] := Value.RightValue;
  FSigns[1] := Value.LeftSign;
  FSigns[2] := Value.RightValue;
  FFieldType := Value.FieldType;
  FFieldName := Value.FieldName;
  DocumentIndex := Value.DocumentIndex;
  FSQLFieldName := Value.FSQLFieldName; {Allex}
end;

{------------------------TQueryPage--------------------------}
procedure TQueryPage.DoResize;
begin
  if Assigned(FOnResize) then FOnResize(Self);
end;

function TQueryPage.ActiveParts;
var F: boolean;
begin
  if (GetVisible(index) or (QFields[index].Tag = -1))
    and (TComboBox(LeftConds[index]).ItemIndex > 0) then begin
    if TComboBox(MidConds[index]).ItemIndex = 0 then Result := 1
    else Result := 2;
  end
  else Result := 0;
end;

procedure TQueryPage.SetField(index: Integer; Value: TWField);
begin
  if (index > FFields.Count) or (index < 0) then Exit;
  TWField(FFields[index]).Assign(Value);
end;

function TQueryPage.GetField(index: Integer): TWField;
begin
  Result := nil;
  if (index > FFields.Count) or (index < 0) then Exit;
  Result := FFields[index];
end;

procedure TQueryPage.SetVisField(index: Integer; Value: TWField);
var Field: TWField;
begin
  Field := GetVisField(index);
  if Field <> nil then Field.Assign(Value);
end;

function TQueryPage.GetVisField(index: Integer): TWField;
var K: Integer;
begin
  Result := nil;
  K := VisibleToReal(index);
  if K > -1 then Result := FFields[K];
end;

function TQueryPage.FieldConditions(FieldName: string): Integer;
var index: Integer;
begin
  Result := 0;
  for index := 0 to FFields.Count - 1 do
    if QFields[index].FieldName = FieldName then inc(Result);
end;

function TQueryPage.VisibleToReal(Value: Integer): Integer;
var K: Integer;
begin
  Result := -1;
  if (Value > SelectedCount) or (Value < 0) then Exit;
  for K := 0 to FFields.Count - 1 do begin
    if GetVisible(K) then inc(Result);
    if Result = Value then Break;
  end;
  Result := K;
end;

procedure TQueryPage.AddFieldCond(Sender: TObject);
var index: Integer;
  TmpField: TsohoTableFolderField;
begin
  {      }
  index := FNewLines.IndexOf(Sender);
  if index = -1 then begin
    ShowMessage('     ');
    Exit;
  end;
  TmpField := TsohoTableFolderField.Create;
  with TmpField do begin
    FieldName := QFields[index].FieldName;
    FieldType := ValueKindToFieldType(QFields[index].FFieldType);
    Active := QFields[index].Active;
    DisplayLabel := QFields[index].DisplayLabel;
    Visible := True;
  end;
  
  CreateLine(index + 1, False, TmpField, QFields[index].TableName, QFields[index].DocumentIndex);
  TmpField.Free;
  SetPositions;
  SetVisibles;
end;

procedure TQueryPage.DelFieldCond(Sender: TObject);
var index: Integer;
begin
  {      }
  index := FDelLines.IndexOf(Sender);
  if index = -1 then begin
    ShowMessage('     ');
    Exit;
  end;
  QFields[index].Free;
  TCheckBox(FVisibles[index]).Free;
  TLabel(Labels[index]).Free;
  TComboBox(LeftConds[index]).Free;
  TSohoEdit(LeftEdits[index]).Free;
  TComboBox(MidConds[index]).Free;
  TSohoEdit(RightEdits[index]).Free;
  TComboBox(RightConds[index]).Free;
  TComboBox(FLinks[index]).Free;
  TBitBtn(FNewLines[index]).Free;
  {      ,    -
          -   "" }
  TBitBtn(FDelLines[index]).Visible := False;
  FDown.Add(FDelLines[index]);
  
  FFields.Delete(index);
  FVisibles.Delete(index);
  Labels.Delete(index);
  LeftConds.Delete(index);
  LeftEdits.Delete(index);
  MidConds.Delete(index);
  RightConds.Delete(index);
  RightEdits.Delete(index);
  FLinks.Delete(index);
  FNewLines.Delete(index);
  FDelLines.Delete(index);
  
  SetPositions;
  SetVisibles;
end;

procedure TQueryPage.SetVisible;
begin
  TCheckBox(FVisibles[index]).Checked := Visible;
end;

procedure TQueryPage.SetPositions;
var index: Integer;
  Tmp: Integer;
begin
  Visible := False;
  for index := 0 to FFields.Count - 1 do begin
    TCheckBox(FVisibles[index]).Top := index * 33 + 5;
    TLabel(Labels[index]).Top := index * 33 + 5;
    TComboBox(LeftConds[index]).Top := index * 33 + 5;
    TSohoEdit(LeftEdits[index]).Top := index * 33 + 5;
    TComboBox(MidConds[index]).Top := index * 33 + 5;
    TSohoEdit(RightEdits[index]).Top := index * 33 + 5;
    TComboBox(RightConds[index]).Top := index * 33 + 5;
    TComboBox(FLinks[index]).Top := index * 33 + 5;
    TBitBtn(FNewLines[index]).Top := index * 33 + 5;
    TBitBtn(FDelLines[index]).Top := index * 33 + 5;
    TComboBox(LeftConds[index]).Tag := index;
    TSohoEdit(LeftEdits[index]).Tag := index;
    TComboBox(MidConds[index]).Tag := index;
    TSohoEdit(RightEdits[index]).Tag := index;
    TComboBox(RightConds[index]).Tag := index;
    TComboBox(FLinks[index]).Tag := index;
    TBitBtn(FNewLines[index]).Tag := index;
    TBitBtn(FDelLines[index]).Tag := index;
  end;
  Tmp := Height;
  Height := FFields.Count * 33 + 5;
  if Tmp <> Height then DoResize;
  Visible := True;
end;

function TQueryPage.LastVisible: Integer;
begin
  Result := FLastVisible;
end;

procedure TQueryPage.SetVisibles;
var Stop: boolean;
  index      : Integer;
  LineVisible: boolean;
  LineTag    : Longint;
begin
  FLastVisible := -1;
  for index := 0 to FFields.Count - 1 do begin
    TCheckBox(FVisibles[index]).Enabled :=
      FieldConditions(QFields[index].FieldName) < 2;
    LineVisible := TCheckBox(FVisibles[index]).Checked;
    LineTag := TCheckBox(FVisibles[index]).Tag;
    {     }
    TComboBox(LeftConds[index]).Visible := (LineVisible or (LineTag = -1)) and
      QFields[index].Active;
    Stop := ActiveParts(index) < 1;
    TSohoEdit(LeftEdits[index]).Visible := (LineVisible or (LineTag = -1)) and not Stop;
    TComboBox(MidConds[index]).Visible := (LineVisible or (LineTag = -1)) and not Stop;
    TBitBtn(FNewLines[index]).Visible := (LineVisible or (LineTag = -1)) and
      QFields[index].Active;
    TBitBtn(FDelLines[index]).Visible := LineVisible or (LineTag = -1);
    TComboBox(FLinks[index]).Visible := (LineVisible or (LineTag = -1)) and
      (ActiveParts(index) > 0);
    {   ,      ""}
    Stop := ActiveParts(index) < 2;
    TSohoEdit(RightEdits[index]).Visible := (LineVisible or (LineTag = -1)) and not Stop;
    TComboBox(RightConds[index]).Visible := (LineVisible or (LineTag = -1)) and not Stop;
    if (LineVisible or (LineTag = -1)) and (ActiveParts(index) > 0)
      then FLastVisible := index;
  end;
  if FLastVisible > -1 then TComboBox(FLinks[FLastVisible]).Visible := False;
end;

function TQueryPage.GetVisible(index: Integer): boolean;
begin
  Result := (TCheckBox(FVisibles[index]).Checked)
    and (TCheckBox(FVisibles[index]).Tag <> -1);
end;

procedure TQueryPage.SetLinks(index: Integer; Value: string);
var Ind: Integer;
begin
  Ind := TComboBox(FLinks[index]).Items.IndexOf(Value);
  if Ind = -1 then Exit;
  TComboBox(FLinks[index]).ItemIndex := Ind;
end;

function TQueryPage.GetLinks(index: Integer): string;
begin
  Result := TComboBox(FLinks[index]).Text;
end;

function TQueryPage.FieldByName(FieldName: string): TWField;
var index: Integer;
begin
  Result := nil;
  for index := 0 to FFields.Count - 1 do
    if UpperCase(QFields[index].FieldName) = UpperCase(FieldName) then begin
      Result := FFields[index];
      Exit;
    end;
end;

procedure TQueryPage.ChangeVisible(Sender: TObject);
begin
  SetVisibles;
end;

procedure TQueryPage.ChangeStop(Sender: TObject);
begin
  SetVisibles;
end;

function TQueryPage.SelectedCount: Integer;
var K: Integer;
begin
  Result := 0;
  for K := 0 to FVisibles.Count - 1 do
    if GetVisible(K) then inc(Result);
end;

procedure TQueryPage.GenerateSQL;
const
  SQLConds: array[0..7] of string = ('Error', '=', '<>', '>', '<', '>=', '<=', ' LIKE ');
  SQLLinks: array[0..4] of string = ('Error', ' AND ', ' OR ', ' AND NOT ', ' OR NOT '); 
var
  Term       : string;               
  FLeftCond  : TComboBox;            
  FRightCond : TComboBox;            
  FMidCond   : TComboBox;            
  FLeftEdit  : TSohoEdit;            
  FRightEdit : TSohoEdit;            
  Flink      : TComboBox;            
  index      : Integer;              
  Parts      : Integer;              
  CurrentName: string;               
  LastString : string;               
  CurrentBegin,
    K, I, jjj: Integer;              
  TmpField   : TsohoTableFolderField;
  TempString : string;               
  ws         : string;                wi: Longint;
  {Ini       :TInifile;              }
begin
  if SelectedCount = 0 then Exit;
  {Ini:=tInifile.Create(DocumentFolderName);}
  FSQL.Clear;
  {  ,   }
  FSQL.Add('Select');
  for index := 0 to SelectedCount - 1 do begin
    if index = SelectedCount - 1 then
      FSQL.Add(VisibleFields[index].TableName + '.' +
      VisibleFields[index].FieldName)
    else FSQL.Add(VisibleFields[index].TableName + '.' + VisibleFields[index].FieldName + ',');
  end;
  {Ini.Free;}
  { ,   }
  FSQL.Add('FROM');
  for index := 0 to FDocFolder.Items.Count - 2 do
    FSQL.Add('"' + FDocFolder.Folders[index].TableName + '" AS ' +
    FDocFolder.Folders[index].ShortFolderName + ',');
  FSQL.Add('"' + FDocFolder.Folders[FDocFolder.FoldersCount - 1].TableName + '" AS ' +
    FDocFolder.Folders[FDocFolder.FoldersCount - 1].ShortFolderName);
  
  {  }
  if SelectedCount > 0 then FSQL.Add('WHERE');
  CurrentName := '';
  CurrentBegin := -1;
  for index := 0 to FFields.Count - 1 do
    if GetVisible(index) or (QFields[index].Tag = -1) then begin
      FLeftCond := TComboBox(LeftConds[index]);
      FRightCond := TComboBox(RightConds[index]);
      FMidCond := TComboBox(MidConds[index]);
      FLeftEdit := TSohoEdit(LeftEdits[index]);
      FRightEdit := TSohoEdit(RightEdits[index]);
      Flink := TComboBox(FLinks[index]);
      Parts := ActiveParts(index);
      if Parts > 0 then begin
        {,      }
        if CurrentName <> QFields[index].FieldName then begin
          {      ,   
                             }
          if CurrentBegin <> -1 then begin
            FSQL[CurrentBegin] := '(' + FSQL[CurrentBegin];
            {      ,
                                 }
            LastString := FSQL[FSQL.Count - 1];
            K := Length(LastString);
            while LastString[K] <> ')' do dec(K);
            Insert(')', LastString, K + 1);
            FSQL[FSQL.Count - 1] := LastString;
          end;
          CurrentBegin := FSQL.Count;
          CurrentName := QFields[index].FieldName
            
        end;
        Term := Chars('(', Parts) + QFields[index].TableName +
          '.' + QFields[index].FieldName +
          SQLConds[FLeftCond.ItemIndex];
        {----------------------------------------------------------------
                   ,      ,  
                   ,     SQL-.
                  ,      ,  
                   .
                 ----------------------------------------------------------------}
        if QFields[index].FieldType = vkDate then
          Term := Term + DateToSQLDate(FLeftEdit.AsDate)
        else
          if QFields[index].FieldType in [vkString, vkTime] then
            Term := Term + '"' + FLeftEdit.AsString + '"'
          else Term := Term + FLeftEdit.AsString;
        Term := Term + ')';
        {       Edit}
        if Parts > 1 then begin
          Term := Term + SQLLinks[FMidCond.ItemIndex] + '(' +
            QFields[index].TableName + '.' +
            QFields[index].FieldName + SQLConds[FRightCond.ItemIndex + 1];
          if QFields[index].FieldType = vkDate then
            Term := Term + DateToSQLDate(FRightEdit.AsDate)
          else
            if QFields[index].FieldType in [vkString, vkTime] then
              Term := Term + '"' + FRightEdit.AsString + '"'
            else Term := Term + FRightEdit.AsString;
          Term := Term + Chars(')', Parts);
        end;
        {   ,    
                   }
        if index <> LastVisible then
          Term := Term + ' ' + SQLLinks[Flink.ItemIndex + 1];
        FSQL.Add(Term);
      end;
    end;
  {  ""    }
  if CurrentBegin <> -1 then begin
    FSQL[CurrentBegin] := '(' + FSQL[CurrentBegin];
    {      ,
                   }
    LastString := FSQL[FSQL.Count - 1];
    K := Length(LastString);
    while LastString[K] <> ')' do dec(K);
    Insert(')', LastString, K + 1);
    FSQL[FSQL.Count - 1] := LastString;
  end;
  
  {        
         }
  if FSQL[FSQL.Count - 1] <> 'WHERE' then FSQL.Add('AND');
  
  with FDocFolder do begin
    for K := 0 to FoldersCount - 1 do begin
      {  folder'      }
      for I := 0 to Folders[K].FieldsCount - 1 do begin
        TmpField := Folders[K].Fields[I];
        if (TmpField.LinkedTo <> '') then begin
          for wi := 0 to FoldersCount - 1 do
            if TmpField.LinkedTo = Folders[wi].TableFolderName then Break;
          {if TmpField.LinkID=Folders[wi].LinkID then break;}
          ws := Folders[wi].ShortFolderName;
          FSQL.Add('(' + Folders[K].ShortFolderName + '.' + TmpField.FieldName + '=' +
            ws + '.ID)');
          FSQL.Add('AND');
        end;
      end;
    end;
  end;
  if FSQL[FSQL.Count - 1] = 'AND' then FSQL.Delete(FSQL.Count - 1);
  if FSQL[FSQL.Count - 1] = 'WHERE' then FSQL.Delete(FSQL.Count - 1);
end;

constructor TQueryPage.Create;
begin
  inherited Create(AOwner);
  FFields := TList.Create; {  }
  FVisibles := TList.Create; {  - checkbox'}
  Labels := TList.Create; {   }
  LeftConds := TList.Create; {    }
  LeftEdits := TList.Create; {   }
  MidConds := TList.Create; {  }
  RightConds := TList.Create; {    }
  RightEdits := TList.Create; {   }
  FLinks := TList.Create; {  }
  FNewLines := TList.Create; { ""}
  FDelLines := TList.Create; { "-"}
  FDown := TList.Create; {"" }
  FSQL := TStringList.Create;
  FFolderName := '';
end;

procedure TQueryPage.CreateLine;
const
  CondWidth = 80;
  LinkWidth = 65;
  Space     = 2; 
  
var NewField: TWField;
  NewVisible  : TCheckBox;  
  NewLabel    : TLabel;     
  NewLeftCond : TComboBox;  
  NewRightCond: TComboBox;  
  NewMidCond  : TComboBox;  
  NewLeftEdit : TSohoEdit;  
  NewRightEdit: TSohoEdit;  
  NewLink     : TComboBox;  
  NewLine     : TBitBtn;    
  DelLine     : TBitBtn;    
  CurTag      : Longint;    
  I           : Integer;    
  ValueKind   : TValueKind; 
  TmpFieldA   : TWField;    
  Ini         : TIniFile;   
  Section     : TStringList;
begin
  {     "" }
  if LabelVisible then CurTag := index else CurTag := -1;
  
  NewField := TWField.Create(Self, FieldRef.FieldName);
  {  SQL   --- Allex january 1998 ----}
  {      Fields  
          -  _1
         -  _n}
  TmpFieldA := FieldByName(NewField.FieldName);
  I := 1;
  if TmpFieldA <> nil then repeat
      NewField.SQLFieldName := FieldRef.FieldName + '_' + IntToStr(I);
      inc(I);
      TmpFieldA := FieldByName(NewField.SQLFieldName);
    until TmpFieldA = nil;
  { , SQLFieldName  }
  NewField.DisplayLabel := FieldRef.DisplayLabel;
  if not FieldTypeToValueKind(FieldRef.FieldType, ValueKind) then
    ValueKind := vkString {Unknown};
  {    raise Exception.Create('       TValueKind');}
  NewField.FieldType := ValueKind;
  NewField.Tag := CurTag;
  NewField.TableName := TableName;
  NewField.Active := FieldRef.Active;
  NewField.DocumentIndex := DocumentIndex;
  
  NewVisible := TCheckBox.Create(Self);
  NewVisible.Parent := Self;
  with NewVisible do begin
    Checked := FieldRef.Visible;
    Left := 5;
    Width := 15;
    Tag := CurTag;
    OnClick := ChangeVisible;
    Visible := LabelVisible;
  end;
  
  NewLabel := TLabel.Create(Self);
  NewLabel.Parent := Self;
  with NewLabel do begin
    Caption := FieldRef.DisplayLabel;
    Left := NewVisible.Left + NewVisible.Width + Space;
    AutoSize := False;
    WordWrap := True;
    Height := 30;
    Width := 100;
    Tag := CurTag;
    Visible := LabelVisible;
  end;
  
  NewLeftCond := TComboBox.Create(Self);
  NewLeftCond.Parent := Self;
  with NewLeftCond do begin
    Left := NewLabel.Left + NewLabel.Width + Space;
    Width := CondWidth;
    Tag := CurTag;
    Style := csDropDownList;
    for I := Low(Conditions) to High(Conditions) - 1 do Items.Add(Conditions[I]);
    if NewField.FieldType = vkString then Items.Add(Conditions[7]);
    Items.Insert(0, '');
    ItemIndex := 0;
    OnClick := ChangeStop;
  end;
  
  NewLeftEdit := TSohoEdit.Create(Self);
  NewLeftEdit.Parent := Self;
  with NewLeftEdit do begin
    ValueKind := NewField.FieldType;
    if ValueKind = vkDate then AsDate := Date;
    {    if ValueKind=vkTime then AsTime:=Time;}
    Left := NewLeftCond.Left + NewLeftCond.Width + Space;
    AutoSize := False;
    Width := 100;
    Height := 21;
    Tag := CurTag;
  end;
  
  NewMidCond := TComboBox.Create(Self);
  NewMidCond.Parent := Self;
  with NewMidCond do begin
    Left := NewLeftEdit.Left + NewLeftEdit.Width + Space;
    Width := LinkWidth;
    Tag := CurTag;
    Style := csDropDownList;
    for I := Low(FieldsLinks) to High(FieldsLinks) do Items.Add(FieldsLinks[I]);
    Items.Insert(0, '');
    ItemIndex := 0;
    OnClick := ChangeStop;
  end;
  
  NewRightCond := TComboBox.Create(Self);
  NewRightCond.Parent := Self;
  with NewRightCond do begin
    Left := NewMidCond.Left + NewMidCond.Width + Space;
    Width := CondWidth;
    Tag := CurTag;
    Style := csDropDownList;
    for I := Low(Conditions) to High(Conditions) - 1 do Items.Add(Conditions[I]);
    if NewField.FieldType = vkString then Items.Add(Conditions[7]);
    ItemIndex := 0;
  end;
  
  NewRightEdit := TSohoEdit.Create(Self);
  NewRightEdit.Parent := Self;
  with NewRightEdit do begin
    ValueKind := NewField.FieldType;
    if ValueKind = vkDate then AsDate := Date;
    {          if ValueKind=vkTime then AsDate:=Time;}
    Left := NewRightCond.Left + NewRightCond.Width + Space;
    AutoSize := False;
    Width := 100;
    Height := 21;
    Tag := CurTag;
  end;
  
  NewLink := TComboBox.Create(Self);
  NewLink.Parent := Self;
  with NewLink do begin
    Left := NewRightEdit.Left + NewRightEdit.Width + Space;
    Width := LinkWidth;
    Tag := CurTag;
    Style := csDropDownList;
    for I := Low(FieldsLinks) to High(FieldsLinks) do Items.Add(FieldsLinks[I]);
    ItemIndex := 0;
  end;
  
  NewLine := TBitBtn.Create(Self);
  NewLine.Parent := Self;
  with NewLine do begin
    Caption := '+';
    Left := NewLink.Left + NewLink.Width + Space;
    Width := 15;
    Height := 21;
    Tag := CurTag;
    OnClick := AddFieldCond;
  end;
  
  DelLine := TBitBtn.Create(Self);
  DelLine.Parent := Self;
  with DelLine do begin
    Caption := '-';
    Left := NewLine.Left + NewLine.Width + Space;
    Width := 15;
    Height := 21;
    Tag := CurTag;
    Enabled := not LabelVisible;
    OnClick := DelFieldCond;
  end;
  
  {    }
  FFields.Insert(index, NewField);
  FVisibles.Insert(index, NewVisible);
  Labels.Insert(index, NewLabel);
  LeftConds.Insert(index, NewLeftCond);
  LeftEdits.Insert(index, NewLeftEdit);
  MidConds.Insert(index, NewMidCond);
  RightConds.Insert(index, NewRightCond);
  RightEdits.Insert(index, NewRightEdit);
  FLinks.Insert(index, NewLink);
  FNewLines.Insert(index, NewLine);
  FDelLines.Insert(index, DelLine);
  {      }
  {     FOLDER   }
  Ini := TIniFile.Create(FDocFolder.Items[NewField.DocumentIndex]);
  Section := TStringList.Create; {,     ...}
  Ini.ReadSection(NewField.FieldName, Section); { .  ,    }
  for I := 0 to Section.Count - 1 do { ...}
    FDocFolder.FIni.WriteString(NewField.SQLFieldName, Section[I], { ,    }
    Ini.ReadString(NewField.FieldName, Section[I], '')); {    }
  FDocFolder.FIni.WriteString('Fields', NewField.SQLFieldName, 'Added');
  Ini.Free;
  Section.Free;
end;

function TQueryPage.CreatePage(DOCUMENT: TsohoDocument): boolean;
const
  TypeRange: set of TFieldType = [ftString, ftSmallInt, ftInteger,
    ftWord, ftFloat, ftCurrency, ftDate, ftTime];
var Table: TTable;
  K, I     : Integer;              
  LastTag  : Integer;              
  ValueKind: TValueKind;           
  TmpField : TsohoTableFolderField;
begin
  Result := True;
  Visible := False;
  {---------------------------------------------------------------
          DocumentFolder,     
       .
                
            TableFolder.
     ---------------------------------------------------------------}
  LastTag := 0;
  FDocFolder := DOCUMENT;
  
  if FDocFolder = nil then begin
    InfoMsg('   !'); Exit;
  end;
  
  if not FDocFolder.Active then begin
    InfoMsg('   !'); Exit;
  end;
  
  with FDocFolder do begin
    for K := 0 to FoldersCount - 1 do begin
      {  folder      }
      for I := 0 to Folders[K].FieldsCount - 1 do begin
        TmpField := Folders[K].Fields[I];
        if (TmpField.LinkedTo = '') and
          (TmpField.FieldName <> 'ID') and
          (TmpField.FieldName <> 'IDMDFAUTH') and
          (TmpField.FieldName <> 'MDFDATE') and
          (TmpField.FieldName <> 'MDFTIME') and
          (TmpField.FieldName <> 'COMMENT') and
          (TmpField.FieldName <> 'PROTECT') then begin
          CreateLine(LastTag, True, TmpField, Folders[K].ShortFolderName, K);
          inc(LastTag);
        end;
      end;
    end;
  end;
  Visible := True;
  Width := TBitBtn(FDelLines[FFields.Count - 1]).Left + 20;
  SetPositions;
  SetVisibles;
end;

function TQueryPage.GetSectionsByFieldName(FieldName, RequestFile: string): TStringList;
var {Sections : TStringList;}
  Ini            : TIniFile;
  index          : Longint; 
  FieldNameInSect: string;  
begin
  Ini := TIniFile.Create(RequestFile);
  {     Sections:=TStringList.Create;}
  Result := TStringList.Create;
  index := 0;
  repeat
    FieldNameInSect := Ini.ReadString(IntToStr(index), 'FieldName', 'NONAME');
    if FieldNameInSect = FieldName then Result {Sections}.Add(IntToStr(index));
    inc(index);
  until FieldNameInSect = 'NONAME';
  Ini.Free;
end;

procedure TQueryPage.FillLine(index: Longint; Checked: boolean;
    LeftCond, RightCond, MidCond, LinkCond: Longint;
    LeftValue, RightValue: string);
begin
  TCheckBox(FVisibles[index]).Checked := Checked;
  TComboBox(LeftConds[index]).ItemIndex := LeftCond;
  TComboBox(RightConds[index]).ItemIndex := RightCond;
  TComboBox(MidConds[index]).ItemIndex := MidCond;
  TComboBox(FLinks[index]).ItemIndex := LinkCond;
  TSohoEdit(LeftEdits[index]).Text := LeftValue;
  TSohoEdit(RightEdits[index]).Text := RightValue;
end;

function TQueryPage.LoadFromFile(DOCUMENT: TsohoDocument): boolean;
var Ini: TIniFile;
  index    : Integer;              
  ValueKind: TValueKind;           
  TmpField : TsohoTableFolderField;
  LastName : string;               
  Counter  : Longint;              
begin
  Result := False;
  FDocFolder := DOCUMENT;
  if FDocFolder = nil then begin
    InfoMsg('   '); Exit;
  end;
  
  Ini := TIniFile.Create(DOCUMENT.DocFile);
  with Ini do begin
    Counter := Ini.ReadInteger('General', 'Fields', 0);
    
    for index := 0 to Counter - 1 do begin
      QFields[index].FieldName := ReadString(IntToStr(index), 'FieldName', QFields[index].FieldName);
      { }
      TCheckBox(FVisibles[index]).Checked :=
        ReadBool(IntToStr(index), 'Checked', TCheckBox(FVisibles[index]).Checked);
      { }
      TComboBox(LeftConds[index]).ItemIndex :=
        ReadInteger(IntToStr(index), 'LeftSign', TComboBox(LeftConds[index]).ItemIndex);
      { }
      TSohoEdit(LeftEdits[index]).Text :=
        ReadString(IntToStr(index), 'LeftValue', TSohoEdit(LeftEdits[index]).AsString);
      { }
      TComboBox(MidConds[index]).ItemIndex :=
        ReadInteger(IntToStr(index), 'Middle', TComboBox(MidConds[index]).ItemIndex);
      { }
      TComboBox(RightConds[index]).ItemIndex :=
        ReadInteger(IntToStr(index), 'RightSign', TComboBox(RightConds[index]).ItemIndex);
      { }
      TSohoEdit(RightEdits[index]).Text :=
        ReadString(IntToStr(index), 'RightValue', TSohoEdit(RightEdits[index]).AsString);
      {  ...}
      TComboBox(FLinks[index]).ItemIndex :=
        ReadInteger(IntToStr(index), 'Links', TComboBox(FLinks[index]).ItemIndex);
    end;
    Ini.Free;
    {   ( )     }
    SetVisibles;
    Result := True;
  end;
end;

function TQueryPage.SaveToFile(DOCUMENT: TsohoDocument): boolean;
var Ini: TIniFile;
  index: Integer;
begin
  Ini := TIniFile.Create(DOCUMENT.DocFile);
  with Ini do begin
    WriteInteger('General', 'Fields', FFields.Count);
    for index := 0 to FFields.Count - 1 do begin
      WriteString(IntToStr(index), 'FieldName', QFields[index].FieldName);
      WriteBool(IntToStr(index), 'Checked', TCheckBox(FVisibles[index]).Checked);
      WriteInteger(IntToStr(index), 'LeftSign', TComboBox(LeftConds[index]).ItemIndex);
      WriteString(IntToStr(index), 'LeftValue', TSohoEdit(LeftEdits[index]).AsString);
      WriteInteger(IntToStr(index), 'Middle', TComboBox(MidConds[index]).ItemIndex);
      WriteInteger(IntToStr(index), 'RightSign', TComboBox(RightConds[index]).ItemIndex);
      WriteString(IntToStr(index), 'RightValue', TSohoEdit(RightEdits[index]).AsString);
      WriteInteger(IntToStr(index), 'Links', TComboBox(FLinks[index]).ItemIndex);
    end;
  end;
  Ini.Free;
end;

procedure TQueryPage.FreeWithItems(List: TList; FreeList: boolean);
var index: Integer;
begin
  for index := List.Count - 1 downto 0 do begin
    TControl(List[index]).Free;
    List[index] := nil;
  end;
  if FreeList then List.Free
  else List.Pack;
end;

destructor TQueryPage.Destroy;
begin
  Visible := False;
  FreeWithItems(FFields, True);
  FreeWithItems(FVisibles, True);
  FreeWithItems(Labels, True);
  FreeWithItems(LeftConds, True);
  FreeWithItems(LeftEdits, True);
  FreeWithItems(MidConds, True);
  FreeWithItems(RightConds, True);
  FreeWithItems(RightEdits, True);
  FreeWithItems(FLinks, True);
  FreeWithItems(FNewLines, True);
  FreeWithItems(FDelLines, True);
  FreeWithItems(FDown, True);
  FSQL.Free;
  {FDocFolder.Free; -  !  - !}
  inherited Destroy;
end;


function TQBuilderForm.Clear;
begin
  if QPage <> nil then QPage.Free; {   ...}
  QPage := TQueryPage.Create(Self); { }
  QPage.Parent := PageParent;
  QPage.DocumentFolderName := DOCUMENT.DocFile; {   }
  Result := QPage.CreatePage(DOCUMENT);
  if not Result then begin
    QPage.Free; QPage := nil; {-  ...}
  end
  else begin
    {   }
    QPage.OnResize := FormResize;
    Width := QPage.Width + SCROLL.Width + Panel1.Width + 30;
    SCROLL.Left := PageParent.Width - SCROLL.Width - 5;
    SCROLL.Height := PageParent.Height;
    Caption := ' (' + QPage.Title + ')';
    SCROLL.Visible := QPage.Height > PageParent.Height;
    if SCROLL.Visible then
      SCROLL.MAX := ((QPage.Height - PageParent.Height) div 33) + 1;
    SCROLL.Position := 0;
    QPage.Top := 2 - 33 * SCROLL.Position; QPage.Left := 2;
  end;
end;


function TQBuilderForm.LoadFromFile;
begin
  {   "   !"}
  Result := Clear(DOCUMENT) and QPage.LoadFromFile(DOCUMENT);
  if Result then Self.Caption := QPage.Title;
end;

function TQBuilderForm.SaveToFile(DOCUMENT: TsohoDocument): boolean;
begin
  Result := False;
  if QPage = nil then Exit;
  Result := QPage.SaveToFile(DOCUMENT);
end;

function TQBuilderForm.Edit;
begin
  Result := ShowModal = mrOk;
  if Result then QPage.GenerateSQL;
end;

function TQBuilderForm.Execute(DOCUMENT: TsohoDocument): boolean;
begin
  Result := Clear(DOCUMENT) and Edit(DOCUMENT);
end;

function TQBuilderForm.GetSQL: TStringList;
begin
  Result := nil;
  if QPage <> nil then Result := QPage.SQL;
end;

function TQBuilderForm.LoadAndExecute;
begin
  Result := LoadFromFile(DOCUMENT) and Edit(DOCUMENT);
end;


procedure TQBuilderForm.FormDestroy(Sender: TObject);
begin
  QPage.Free;
end;

procedure TQBuilderForm.ScrollChange(Sender: TObject);
begin
  {  QPage,      }
  QPage.Top := 2 - 33 * SCROLL.Position;
end;

procedure TQBuilderForm.FormResize(Sender: TObject);
begin
  {o ,      ?}
  SCROLL.Visible := QPage.Height > PageParent.Height;
  SCROLL.Height := PageParent.Height;
  if SCROLL.Visible then
    SCROLL.MAX := ((QPage.Height - PageParent.Height) div 33) + 1;
  if Sender is TForm then
    if Width < QPage.Width + SCROLL.Width + Panel1.Width + 30 then
      Width := QPage.Width + SCROLL.Width + Panel1.Width + 30;
  if not SCROLL.Visible then QPage.Top := 2;
end;

procedure TQBuilderForm.OkBClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TQBuilderForm.SpeedButton2Click(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

end.
  
  
  .
   - , 
  
  SQL =
  Select
  Table2.STNAME,
  Table3.STNAME
  From
  "Z: \ALLEX \RESTRUCT \JOURNAL.DB "as Table1,
  "Z: \ALLEX \RESTRUCT \PERSONS.DB "as Table2,
  "Z: \ALLEX \RESTRUCT \PERSONS.DB "as Table3
  WHERE
  (Table1.IDWHO = Table2.ID)
  and
  (Table1.IDWHOM = Table3.ID)
  
  , 
  PERSONS.DB
  IDWHO = Link to Table2
  IDWHOM = Link to Table3
  
  , ,
  ,
  (Table1.IDWHOM = Table2.ID)
   -  - !
  
  ( - !)
  
  
  1.
   - LinkedTo = FullName
  2.
  
  
  
  2  - 
  SQL FieldName, SQLFieldName, 
  (NewField := TWField.Create)
  
  )  -  = 
  .
  ", "
  
  2) ., 
   -  - , 
  .
  
  1) - !!!
  , 
   - , 2 ,
  , 2

