{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoDBComboBox -   
   .      
}
unit SohoComb;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, StdCtrls, Menus, SoUnit, SoTools, DB, SoCtmCmb;

type

  {         .  
      (SQLFile),  ,   
         (TextField),     
     (KeyField),         IdItems.
        DataBaseName  TableName -    
        SQLFile   .   
         ItemId
  }
  TsohoDBComboBox = class(TsohoCustomDBComboBox)
  private
    { Private declarations }
    FDataBaseName: string;
  protected
    { Protected declarations }
    function  ActivateSelection (SQLText : TStringList) : TDataSet;override;
    procedure DoInsertSQL (SQLText : TStringList);override;
    procedure PrepareList;override;
  published
    {    }
    property DataBaseName: string read FDataBaseName write FDataBaseName;
  end;

implementation
uses SoUtils, DBTables, SoCtmRgs;

function  TsohoDBComboBox.ActivateSelection (SQLText : TStringList) : TDataSet;
var Tmp : TQuery;
begin
  SetCursor(crHourGlass);
  try
    Tmp := TQuery.Create(self);
    Tmp.SQL.Assign(SQLText);
    Tmp.DataBaseName := FDataBaseName;
    DoBeforeOpen(Tmp);
    Tmp.Open;
    Result := Tmp;
    RestoreCursor;
  except
    on E: Exception do begin
      RestoreCursor;
      ErrorMsg(Name+': '+E.Message);
      Result := nil;
    end;
  end;
end;

procedure TsohoDBComboBox.DoInsertSQL (SQLText : TStringList);
var Tmp : TQuery;
begin
  SetCursor(crHourGlass);
  try
    Tmp := TQuery.Create(self);
    Tmp.DataBaseName := FDataBaseName;
    with Tmp do begin
      SQL.Assign(SQLText);
      ExecSQL;
    end;
    RestoreCursor;
  except
    on E: Exception do begin
      RestoreCursor;
      ErrorMsg(Name+': '+E.Message);
    end;
  end;
end;

procedure TsohoDBComboBox.PrepareList;
begin
  if (FDataBaseName = '') and (SingleRegister<>nil) then
    FDataBaseName := SingleRegister.PathToData;
  inherited PrepareList;
end;

end.

