{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                Written by Allex, MVL                  }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SohoCalc;

{$I SOHOLIB.INC}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, StdCtrls, Buttons, ExtCtrls, SoTools;

type
  ClassNames = (cnNone, cnDigit, cnOperation, cnName, cnLP, cnRP);

  TCalculatorF = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    FormulaE: TEdit;
    Label1: TLabel;
    ListBox1: TListBox;
    ListBox2: TListBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    DigitalGB: TGroupBox;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    SpeedButton11: TSpeedButton;
    SpeedButton12: TSpeedButton;
    SpeedButton13: TSpeedButton;
    CheckBox1: TCheckBox;
    FieldsBox: TListBox;
    procedure FormulaEKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormulaEKeyPress(Sender: TObject; var Key: Char);
    procedure ListBox1DblClick(Sender: TObject);
    procedure ListBox2DblClick(Sender: TObject);
    procedure ListBox1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ListBox2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormulaEMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormActivate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure FormulaEChange(Sender: TObject);
    procedure SpeedButton11Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
    LeftClass, RightClass : ClassNames;
    procedure SelectRegion(const AStart, ALength : LongInt);
    function GetClassByString(AVar : string) : ClassNames;
  public
    { Public declarations }
  end;

var
  CalculatorF: TCalculatorF;

const C0='';    {It isn't BLANK!!!}

implementation
uses SoIntrpr, SoUtils;

{$R *.DFM}
const
      cnEnabled : array[ClassNames, ClassNames] of boolean =
       (
        (False, False, False, False, False, False),
        (True , True,  True,  False, False, True ),
        (True , True,  False, True,  True,  False),
        (True , False, True,  False, False, True ),
        (True , True,  False, True,  True,  False),
        (True , False, True,  False, False, True )
       );
      Digital : set of char = ['0'..'9','.'];
      NameClassNames : array[ClassNames] of string =
       ('cnNone', 'cnDigit', 'cnOperation', 'cnName', 'cnLP', 'cnRP');

procedure TCalculatorF.FormulaEKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var wKey : word;
    i, j : LongInt;
begin
  wKey := Key;
  Key := $04;
  with FormulaE do
  case wkey of
   VK_LEFT, VK_UP : begin
     i := SelStart-2;
     j:=i;
     while (i>=0) and (Text[i]<>C0) do Dec(i);
     if i < 0 then SelectRegion(0, 0)
              else SelectRegion(i-1, j-i+3);
   end;
   VK_RIGHT, VK_DOWN : begin
     i := SelStart+SelLength+2;                { $$$$ }
     j:=i-2;
     while (i<=Length(Text)) and (Text[i]<>C0) do Inc(i);
     if i > Length(Text) then SelectRegion(SelStart+SelLength, 0)
                         else SelectRegion(j, i-j);
   end;
   VK_INSERT : SelectRegion(SelStart, 0);
   VK_HOME : SelectRegion(0, 0);
   VK_END : SelectRegion(Length(Text), 0);
   VK_BACK : begin
     SelText := '';
     wKey := VK_LEFT;
     FormulaEKeyDown(Sender,wKey,Shift);
   end;
   VK_DELETE : begin
     SelText := '';
     wKey := VK_RIGHT;
     FormulaEKeyDown(Sender,wKey,Shift);
   end;
   VK_RETURN : ModalResult:=mrOK;
  else
   Key := wKey;
  end;
end;

procedure TCalculatorF.FormulaEKeyPress(Sender: TObject; var Key: Char);
var i : LongInt;
begin
  if (Key = '(')
   and cnEnabled[LeftClass, cnLP]
   and cnEnabled[cnLP, RightClass]
  then FormulaE.SelText := C0+Key+C0;
  if (Key = ')')
    and cnEnabled[LeftClass, cnRP]
    and cnEnabled[cnRP, RightClass]
  then FormulaE.SelText := C0+Key+C0;
  if (Key in Digital)
    and cnEnabled[LeftClass, cnDigit]
    and cnEnabled[cnDigit, RightClass]
  then FormulaE.SelText := C0+Key+C0
  else
    with ListBox2, Items do
      if Enabled then
      for i:=0 to Count-1 do
        if Key = copy(strings[i],1,1) then begin
          FormulaE.SelText := C0+Copy(Strings[i],1,pos(' ',Strings[i])-1)+C0;
          Break;
        end;
end;

procedure TCalculatorF.ListBox1DblClick(Sender: TObject);
begin
  with FormulaE, ListBox1, Items do SelText := C0+Strings[ItemIndex]+C0;
  FormulaE.SetFocus;
end;

procedure TCalculatorF.ListBox2DblClick(Sender: TObject);
begin
  with FormulaE, ListBox2, Items do
    SelText := C0+Copy(Strings[ItemIndex],1,pos(' ',Strings[ItemIndex])-1)+C0;
      FormulaE.SetFocus;
end;

procedure TCalculatorF.ListBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then ListBox1DblClick(Sender);
end;

procedure TCalculatorF.ListBox2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then ListBox2DblClick(Sender);
end;

procedure TCalculatorF.FormulaEMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var i : LongInt;
begin
  with FormulaE do begin
    i := SelStart;
    while (i>=0) and (Text[i]<>C0) do dec(i);
    if i<=0 then i:=1;
    SelStart := i-1;
    inc(i);
    while (i<Length(Text)) and (Text[i]<>C0) do inc(i);
    SelLength := i-SelStart;
    if SelStart = Length(Text)-1 then SelStart := Length(Text);
    SelectRegion(SelStart, SelLength);
  end;
end;

procedure TCalculatorF.FormActivate(Sender: TObject);
begin
  Self.Font:=Application.MainForm.Font;
  ListBox1.ItemIndex := 0;
  ListBox2.ItemIndex := 0;
  LeftClass := cnLP;
  RightClass := cnNone;
end;

procedure TCalculatorF.SelectRegion(const AStart, ALength : LongInt);
var i, j : LongInt;
begin
  with FormulaE do begin
    SelStart := AStart;
    SelLength := ALength;
    { }
    i := AStart+ALength+2;                { $$$$ }
    j:=i-2;
    while (i<=Length(Text)) and (Text[i]<>C0) do Inc(i);
    if i > Length(Text) then RightClass := cnNone
                        else RightClass := GetClassByString(Copy(Text, j+1, i-j));
    { }
    i := AStart-2;
    j:=i;
    while (i>=0) and (Text[i]<>C0) do Dec(i);
    if i < 0 then LeftClass := cnLP
             else LeftClass := GetClassByString(Copy(Text, i, j-i+3));
  end;
  ListBox1.Enabled := cnEnabled[LeftClass, cnName] and cnEnabled[cnName, RightClass];
  ListBox2.Enabled := cnEnabled[LeftClass, cnOperation] and cnEnabled[cnOperation, RightClass];
  SpeedButton1.Enabled := cnEnabled[LeftClass, cnLP] and cnEnabled[cnLP, RightClass];
  SpeedButton2.Enabled := cnEnabled[LeftClass, cnRP] and cnEnabled[cnRP, RightClass];
  DigitalGB.Enabled := cnEnabled[LeftClass, cnDigit] and cnEnabled[cnDigit, RightClass];
  for i:=0 to ComponentCount-1 do
    if (Components[i] is TSpeedButton)
     and ((Components[i] as TSpeedButton).Parent = DigitalGB)
    then (Components[i] as TSpeedButton).Enabled := DigitalGB.Enabled;
end;

function TCalculatorF.GetClassByString(AVar : string) : ClassNames;
var i : LongInt;
begin
  Result := cnNone;
  if Length(AVar) = 0 then Exit;
  AVar := DecLength(AVar,1);
  Delete(AVar,1,1);

  if AVar = '(' then begin
    Result := cnLP;
    Exit;
  end;

  if AVar = ')' then begin
    Result := cnRP;
    Exit;
  end;

  if (Length(AVar) = 1) and (AVar[1] in Digital) then Result := cnDigit;

  with ListBox2, Items do
    for i:=0 to Count-1 do
      if AVar = copy(strings[i],1,pos(' ', strings[i])-1) then begin
        Result := cnOperation;
        Break;
  end;

  with ListBox1, Items do
    for i:=0 to Count-1 do
      if AVar = ANSIUpperCase(strings[i]) then begin
        Result := cnName;
        Break;
  end;
end;

procedure TCalculatorF.SpeedButton1Click(Sender: TObject);
const LP:char='(';
begin
 FormulaEKeyPress(Sender,LP);
{ FormulaE.SelText := C0+'('+C0;}
end;

procedure TCalculatorF.SpeedButton2Click(Sender: TObject);
const RP:char=')';
begin
  FormulaEKeyPress(Sender,RP);
{  FormulaE.SelText := C0+')'+C0;}
end;

procedure TCalculatorF.FormulaEChange(Sender: TObject);
begin
  with FormulaE do SelectRegion(SelStart, SelLength);
end;

procedure TCalculatorF.SpeedButton11Click(Sender: TObject);
var D:string;
begin
  d:=TSpeedButton(Sender).Caption;
  FormulaEKeyPress(Sender,d[1]);
end;

procedure TCalculatorF.CheckBox1Click(Sender: TObject);
begin
 if CheckBox1.Checked
  then Digital:=['.','0'..'9']
  else Digital:=[' '..#255]-[C0,'(',')'];
  FormulaE.SetFocus;
end;

end.
