{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
     TsohoDBGrid -   TRxDBGrid  
  
}
unit SoDBGrid;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, DB, Grids, DBGrids, SoClass, RXDBCtrl, StdCtrls;

type

  {      TsohoDBGrid.  
    Results }
  TsohoDBGridResults = class(TsohoIntegerList);

  {       TsohoDBGrid -   ,   
      }
  TsohoGridOperation = (soNewRecord, soDeleteRecord, soEditRecord);

  {    OnScroll  TsohoDBGrid }
  TsohoGridScroll = procedure (Sender: TObject; Vertical: Boolean; wScrollCode: Smallint) of object;

  {         
    :
    1. Enter       -  
    2. Insert -   
    3. Delete -   
  }
  TsohoOnGridOperation = function (Sender: TObject; Operation: TsohoGridOperation): Boolean of object;

  {   TsohoDBGrid.
    dgAllowDelete -  
    dgAllowInsert -    
  }
  TsohoGridKeyOption = (dgAllowDelete, dgAllowInsert);
  {     TsohoDBGrid }
  TsohoGridKeyOptions = set of TsohoGridKeyOption;

  {     TDataSet.    TRxDBGrid  
    RxLib.       . ,  
    ftBoolen      "",     true.
     RowFont  RowColor       
    ,   RowSelect = true.    :
    OnOperation, OnScroll, OnColResize, OnBeforeColumnMoved.  run-time  TsohoDBGrid 
       -       Results
  }
  TsohoDBGrid = class(TRxDBGrid)
  private
    InUpdateRowCount : boolean;
    FUpdateLock : integer;
    FResults: TsohoDBGridResults;
    FRowSelect: Boolean;
    FRowColor: tColor;
    FRowFont: tFont;
    FColReSize: TNotifyEvent;
    FOnScroll: TsohoGridScroll;
    FSpecEvent: TsohoOnGridOperation;
    FSelfChangingRowFont: Boolean;
    FAddColumn: Boolean;
    FDrawChecks: Boolean;
    FMarkedColor: tColor;
    FMarkedFont: tFont;
    FStriply : boolean;
    FStriplyColor : TColor;
    FCalcCellRow,
    FCalcCellCol : LongInt;
    FWordWrap : boolean;
    FRowHeightPercent : integer;

    FVCount,
      FHCount: Integer;
    FBeforeFlag : boolean;

    FBeforeColumnMoved : TNotifyEvent;

    FTitleLines : integer;
    FTitleAlignment : TAlignment;

    FKeyOptions : TsohoGridKeyOptions;

    FTitleColor : TColor;
    FKeyField: string;

    procedure SetTitleLines (Value : integer);
    procedure SetTitleAlignment (Value: TAlignment);
    procedure SetMarkedColor(Value: tColor);
    procedure SetMarkedFont(Value: tFont);
    procedure SetRowSelect(Value: Boolean);
    procedure SetRowColor(Value: tColor);
    procedure SetRowFont(Value: tFont);
    procedure SetAddColumn(Value: Boolean);
    procedure SetDrawChecks(Value: Boolean);
    procedure SetColWidthByFieldIndex(index: Integer; Value: Integer);
    function GetColWidthByFieldIndex(index: Integer): Integer;
    procedure ReReadGrid(Sender: TObject);
    procedure SetStriply (Value : boolean);
    procedure SetStriplyColor (Value : TColor);
    procedure SetWordWrap (Value : boolean);
    procedure SetRowHeightPercent (Value : integer);
  protected
    procedure CalcRowHeight;
    procedure UpdateRowCount;
    procedure ColWidthsChanged; override;
    procedure LayoutChanged;override;

    procedure SetTitleColor (Value : TColor);
    function  CalcCellRow : LongInt;
    procedure DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState); override;
    procedure GetCellProps(Field: TField; AFont: TFont;
              var Background: TColor; Highlight: Boolean);override;
    procedure DoOperation(GridOperation: TsohoGridOperation); virtual;
    procedure DrawColumnCell(const Rect: TRect; DataCol: Integer;
      Column: TColumn; State: TGridDrawState); override;
    procedure CMFontChanged(var message: TMessage); message CM_FONTCHANGED;
    procedure RowFontChanged(Sender: TObject);
    procedure CMParentFontChanged(var message: TMessage); message CM_PARENTFONTCHANGED;
    procedure DblClick; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure Scroll(Distance: Integer); override;
    procedure DoGridScroll(Vertical: Boolean; wScrollCode: Smallint); dynamic;
    procedure WMVScroll(var message: TWMScroll); message WM_VSCROLL;
    procedure WMHScroll(var message: TWMScroll); message WM_HSCROLL;
    function  ActiveRowSelected: Boolean;
  public
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);override;
    { ,  , ""    }
    procedure DrawSmashColumn; virtual;
    procedure Paint; override;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {    .  . }
    function GetActiveRow : integer;
    {       }
    function GetCellRect(ACol, ARow: Longint): TRect;
    {     . Index -    TDataSet }
    property ColWidthsByFieldIndex[index: Integer]: Integer read GetColWidthByFieldIndex write SetColWidthByFieldIndex;
    {     .     
             ,    
      KeyField  ftInteger.          
      ,  ,  , .      GetNewId. 
    }
    property Results: TsohoDBGridResults read FResults;
    {    .  , -  BDE   
       1.  :    ?   ... }
    property TopRow;
    {     protected.      }
    property ColWidths;
    {     protected.      }
    property RowHeights;
    {     protected.     }
    property GridLineWidth;
    property Selection;
    property ColCount;
    property LeftCol;
    property GridState : TGridState read FGridState;
  published
    {   }
    property TitleColor : TColor read FTitleColor write SetTitleColor default clBtnFace;
    {   -       }
    property KeyOptions : TsohoGridKeyOptions read FKeyOptions write FKeyOptions;
    property KeyField: string read FKeyField write FKeyField;
    {   }
    property TitleAlignment : TAlignment read FTitleAlignment write SetTitleAlignment default taLeftJustify;
    { -   .   TField.DisplayLabel   "~",
              ,  
         }
    property TitleLines : integer read FTitleLines write SetTitleLines default 1;
    {     Microsoft Money - .   
        StriplyColor }
    property Striply      : boolean read FStriply write SetStriply default false;
    {       Striply = true }
    property StriplyColor : TColor read FStriplyColor write SetStriplyColor;
    {     (Results) }
    property MarkedColor: tColor read FMarkedColor write SetMarkedColor;
    {      (Results) }
    property MarkedFont: tFont read FMarkedFont write SetMarkedFont;
    {          }
    property RowSelect: Boolean read FRowSelect write SetRowSelect;
    {      }
    property RowColor: tColor read FRowColor write SetRowColor;
    {      }
    property RowFont: tFont read FRowFont write SetRowFont;
    {       "" 
           ""  }
    property SmashColumn: Boolean read FAddColumn write SetAddColumn default False;
    {     ""    ftBoolean }
    property DrawChecks: Boolean read FDrawChecks write SetDrawChecks default True;
    {   -     }
    property WordWrap : boolean read FWordWrap write SetWordWrap default false;
    {         }
    property RowHeightPercent : integer read FRowHeightPercent write SetRowHeightPercent default 100;
    {            }
    property OnScroll: TsohoGridScroll read FOnScroll write FOnScroll;
    {       : Ins, Delete, Enter }
    property OnOperation: TsohoOnGridOperation read FSpecEvent write FSpecEvent;
    {        }
    property OnColResize: TNotifyEvent read FColReSize write FColReSize;
    {    ""  }
    property OnBeforeColumnMoved : TNotifyEvent read FBeforeColumnMoved write FBeforeColumnMoved;
  end;


var
   {        ,  
         TsohoDBGid  .  
     , ,    Interbase,    
        }
   StringBooleanFields : TStringList;

implementation
uses SoUtils, Placemnt, VCLUtils
     {$IFDEF RUSSIAN_MESSAGES}
     , DBConsts
     {$ENDIF}
     ;

{$IFNDEF Win32}
{$R SODBGRID.R16}
{$ELSE}
{$R SODBGRID.R32}
{$ENDIF}

type

  {$HINTS OFF}
  THackDBGrid = class(TCustomGrid)
  private
    FIndicators: TImageList;
    FTitleFont: TFont;
    FReadOnly: Boolean;
    FOriginalImeName: TImeName;
    FOriginalImeMode: TImeMode;
    FUserChange: Boolean;
    FLayoutFromDataset: Boolean;
    FOptions: TDBGridOptions;
    FTitleOffset, FIndicatorOffset: Byte;
    FUpdateLock: Byte;
    FLayoutLock: Byte;
    FInColExit: Boolean;
    FDefaultDrawing: Boolean;
    FSelfChangingTitleFont: Boolean;
    FSelecting: Boolean;
    FSelRow: Integer;
  end;

  THackRxDBGrid = class(TDBGrid)
  private
    FShowGlyphs: Boolean;
    FDefaultDrawing: Boolean;
    FMultiSelect: Boolean;
    FSelecting: Boolean;
    FClearSelection: Boolean;
    FTitleButtons: Boolean;
    FPressedCol: Longint;
    FPressed: Boolean;
    FTracking: Boolean;
    FSwapButtons: Boolean;
    FIniLink: TIniLink;
    FDisableCount: Integer;
    FFixedCols: Integer;
    FOnCheckButton: TCheckTitleBtnEvent;
    FOnGetCellProps: TGetCellPropsEvent;
    FOnGetCellParams: TGetCellParamsEvent;
    FOnGetBtnParams: TGetBtnParamsEvent;
    FOnEditChange: TNotifyEvent;
    FOnKeyPress: TKeyPressEvent;
    FOnTitleBtnClick: TTitleClickEvent;
    FMsIndicators: TImageList;
    FSelectionAnchor: TBookmarkStr;
  end;
  {$HINTS ON}

type
  TGridPicture = (gpBlob, gpMemo, gpPicture, gpOle, gpData,
    gpMarkDown, gpMarkUp);

const
  GridBmpNames: array[TGridPicture] of PChar =
    ('DBG_BLOB', 'DBG_MEMO', 'DBG_PICT', 'DBG_OLE', 'DBG_DATA',
     'DBG_SMDOWN', 'DBG_SMUP');
  GridBitmaps: array[TGridPicture] of TBitmap =
    (nil, nil, nil, nil, nil, nil, nil);
  bmMultiDot = 'DBG_MSDOT';
  bmMultiArrow = 'DBG_MSARROW';
  
  NormalPad = 2;

function GetGridBitmap(BmpType: TGridPicture): TBitmap;
begin
  if GridBitmaps[BmpType] = nil then begin
    GridBitmaps[BmpType] := TBitmap.Create;
    GridBitmaps[BmpType].Handle := LoadBitmap(HInstance, GridBmpNames[BmpType]);
  end;
  Result := GridBitmaps[BmpType];
end;

procedure DestroyLocals; far;
var
  I: TGridPicture;
begin
  for I := Low(TGridPicture) to High(TGridPicture) do GridBitmaps[I].Free;
end;

{ TsohoDBGrid }
procedure TsohoDBGrid.SetRowHeightPercent (Value : integer);
begin
  if Value < 100 then Value := 100;
  if (FRowHeightPercent = Value) then exit;
  FRowHeightPercent := Value;
  LayoutChanged;
end;

procedure TsohoDBGrid.SetWordWrap (Value : boolean);
begin
  if FWordWrap = Value then exit;
  FWordWrap := Value;
  Repaint;
end;

procedure TsohoDBGrid.CalcRowHeight;
var NeedHeight : integer;
begin
  if (Parent <> nil) and not (csDestroying in ComponentState) then begin
    DefaultRowHeight:= Canvas.Textheight('W') + NormalPad;
    if dgRowLines in Options then DefaultRowHeight:= DefaultRowHeight + 1;
    DefaultRowHeight:= (DefaultRowHeight * FRowHeightPercent) div 100;
    
    NeedHeight := FTitleLines * (3+Canvas.TextHeight('W'));
    if RowHeights[0] <> NeedHeight then RowHeights[0] := NeedHeight;
  end;
end;

procedure TsohoDBGrid.UpdateRowCount;
var FTitleOffset : integer;
begin
  if InUpdateRowCount then exit;  { Prevent recursion }
  InUpdateRowCount:= True;

  FTitleOffset := 0;
  if dgTitles in Options then inc(FTitleOffset);

  if RowCount <= FTitleOffset then RowCount := FTitleOffset + 1;
  FixedRows := FTitleOffset;
  with DataLink do
    if not Active or (RecordCount = 0) then RowCount := 1 + FTitleOffset
    else begin
      RowCount := 1000;

      if (DataLink.Buffercount>VisibleRowCount) and
         (row >= VisibleRowCount+FTitleOffset) then
         Invalidate;

      DataLink.BufferCount := VisibleRowCount;
      RowCount := RecordCount + FTitleOffset;
    end;

  InUpdateRowCount:= False;
end;

procedure TsohoDBGrid.LayoutChanged;
var PrevVisibleRowCount : integer;
begin
  inherited LayoutChanged;
  if csLoading in ComponentState then Exit;
  if FUpdateLock <> 0 then Exit;
  if (Parent <> nil) and not (csDestroying in ComponentState) then begin
    Inc(FUpdateLock);
    try
      CalcRowHeight;
      UpdateRowCount;
      PrevVisibleRowCount:= VisibleRowCount;
      if VisibleRowCount<>PrevVisibleRowCount then UpdateRowCount;  {6/1/95}
      Invalidate;
    finally
      Dec(FUpdateLock);
    end;
  end;
end;

procedure TsohoDBGrid.SetTitleColor (Value : TColor);
begin
  FTitleColor := Value;
  FixedColor := Value;
end;

procedure TsohoDBGrid.SetTitleLines (Value : integer);
begin
  if (dgTitles in Options) and (Value > 0) and (Value <= 5) then begin
    FTitleLines := Value;
    CalcRowHeight;
  end;
end;

procedure TsohoDBGrid.SetTitleAlignment (Value: TAlignment);
begin
  if FTitleAlignment = Value then exit;
  FTitleAlignment := Value;
  LayoutChanged;
end;

procedure TsohoDBGrid.DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState);
var
  Down: Boolean;
  SavePen, BackColor: TColor;
  AField: TField;
  SortMarker: TSortMarker;
  Bmp: TBitmap;
  DrawColumn: TColumn;
  TmpTitle : string;
const
  EdgeFlag: array[Boolean] of UINT = (BDR_RAISEDINNER, BDR_SUNKENINNER);
begin
  FCalcCellRow := aRow;
  FCalcCellCol := aCol;

  Canvas.Font := Self.Font;

  if not (csLoading in ComponentState) and (gdFixed in AState) and
    (dgTitles in Options) and (ARow = 0) then
  begin
    SavePen := Canvas.Pen.Color;
    try
      Down := (THackRxDBGrid(Self).FPressedCol = ACol) and
               THackRxDBGrid(Self).FPressed and TitleButtons;
      Canvas.Pen.Color := clWindowFrame;
      if not (dgColLines in Options) then begin
        Canvas.MoveTo(ARect.Right - 1, ARect.Top);
        Canvas.LineTo(ARect.Right - 1, ARect.Bottom);
        Dec(ARect.Right);
      end;
      if not (dgRowLines in Options) then begin
        Canvas.MoveTo(ARect.Left, ARect.Bottom - 1);
        Canvas.LineTo(ARect.Right, ARect.Bottom - 1);
        Dec(ARect.Bottom);
      end;
      if (dgIndicator in Options) then Dec(ACol);
      AField := nil;
      SortMarker := smNone;
      if (DataLink <> nil) and DataLink.Active and (ACol >= 0) and
         (ACol < Columns.Count) then
      begin
        DrawColumn := Columns[ACol];
        AField := DrawColumn.Field;
      end
      else DrawColumn := nil;
      if not TitleButtons then Down := false;
      Canvas.Brush.Color := TitleColor;
      DrawEdge(Canvas.Handle, ARect, EdgeFlag[Down], BF_BOTTOMRIGHT);
      DrawEdge(Canvas.Handle, ARect, EdgeFlag[Down], BF_TOPLEFT);
      InflateRect(ARect, -1, -1);
      if Down then begin
        Inc(ARect.Left); Inc(ARect.Top);
      end;
      Canvas.Font := TitleFont;
      Canvas.Brush.Color := FixedColor;
      if (DrawColumn <> nil) then begin
        Canvas.Font := DrawColumn.Title.Font;
        Canvas.Brush.Color := DrawColumn.Title.Color;
      end;
      if TitleButtons and (AField <> nil) and
         Assigned(THackRxDBGrid(Self).FOnGetBtnParams) then
      begin
        BackColor := Canvas.Brush.Color;
        THackRxDBGrid(Self).FOnGetBtnParams(Self, AField, Canvas.Font, BackColor, SortMarker, Down);
        Canvas.Brush.Color := BackColor;
      end;
      if (DataLink = nil) or not DataLink.Active then
        Canvas.FillRect(ARect)
      else if (DrawColumn <> nil) then begin
        case SortMarker of
          smDown: Bmp := GetGridBitmap(gpMarkDown);
          smUp: Bmp := GetGridBitmap(gpMarkUp);
          else Bmp := nil;
        end;
        with DrawColumn.Title do
          TmpTitle := ChangeChars(Caption, '~', #13);
          WriteText(Canvas, aRect, 2, aRect.Top + 1,
            TmpTitle, FTitleAlignment, FTitleLines>1);
        if Bmp <> nil then
          DrawBitmapTransparent(Canvas, ARect.Right - Bmp.Width - 4,
            (ARect.Bottom + ARect.Top - Bmp.Height) div 2, Bmp, clFuchsia);
      end
      else DrawCellText(Self, ACol, ARow, '', ARect, taLeftJustify, vaCenter);
    finally
      Canvas.Pen.Color := SavePen;
    end;
  end
  else inherited DrawCell(aCol, aRow, aRect, aState);
end;

procedure TsohoDBGrid.DrawColumnCell(const Rect: TRect; DataCol: Integer;
  Column: TColumn; State: TGridDrawState);
var Field: TField;
    NewBackgrnd : TColor;
    Highlight : boolean;

    procedure DrawFocusedColumnCell;
    begin
       if Highlight
         and not (csDesigning in ComponentState)
         and not (dgRowSelect in Options)
         and (ValidParentForm(Self).ActiveControl = Self) then
         Canvas.DrawFocusRect(Rect);
    end;

begin
  Field := Column.Field;
  if DefaultDrawing then begin
    if (Field<>nil) and FDrawChecks and
       (
       (Field.DataType = ftBoolean) or
       (StringBooleanFields.IndexOf(StrUpper(Field.FieldName)) <>-1 )
       ) then begin
      NewBackgrnd := Canvas.Brush.Color;
      Highlight := (gdSelected in State) and ((dgAlwaysShowSelection in Options) or
         Focused);
      GetCellProps(Field, Canvas.Font, NewBackgrnd, Highlight or ActiveRowSelected);
      Canvas.Brush.Color := NewBackgrnd;
      Canvas.FillRect(Rect);
      if ((Field.DataType = ftBoolean) and TBooleanField(Field).AsBoolean) or
          StrToBool(Field.AsString) then
         DrawResBitmapInRect(Canvas, Rect, 'SOHOCHECKEDCELL');
      DrawFocusedColumnCell;
    end
    else
      if (Field<>nil) and (Field is TStringField) and FWordWrap then begin
         NewBackgrnd := Canvas.Brush.Color;
         Highlight := (gdSelected in State) and ((dgAlwaysShowSelection in Options) or
            Focused);
         GetCellProps(Field, Canvas.Font, NewBackgrnd, Highlight or ActiveRowSelected);
         Canvas.Brush.Color := NewBackgrnd;
         Canvas.FillRect(Rect);
         WrapTextInRect(Canvas, Field.AsString, Rect, Column.Alignment);
         DrawFocusedColumnCell;
      end
      else inherited DrawColumnCell(Rect, DataCol, Column, State);
  end
end;

function  TsohoDBGrid.CalcCellRow : LongInt;
begin
  Result := FCalcCellRow;
end;

procedure TsohoDBGrid.SetStriply (Value : boolean);
begin
  if FStriply = Value then exit;
  FStriply := Value;
  Repaint;
end;

procedure TsohoDBGrid.SetStriplyColor (Value : TColor);
begin
  if FStriplyColor = Value then exit;
  FStriplyColor := Value;
  Repaint;
end;

procedure TsohoDBGrid.MouseUp(Button: TMouseButton; Shift: TShiftState;
          X, Y: Integer);
begin
  if GridState = gsColMoving then
    if Assigned(FBeforeColumnMoved) then FBeforeColumnMoved(Self);
  inherited MouseUp(Button, Shift, X, Y);
end;

procedure TsohoDBGrid.DoGridScroll(Vertical: Boolean; wScrollCode: Smallint);
begin
  if Assigned(FOnScroll) then FOnScroll(Self, Vertical, wScrollCode);
end;

procedure TsohoDBGrid.WMVScroll(var message: TWMScroll);
begin
  inherited;
  { -    ,  
               }
  inc(FVCount);
  if FVCount = 2 then begin
    DoGridScroll(True, message.ScrollCode);
    FVCount := 0;
  end;
end;

procedure TsohoDBGrid.WMHScroll(var message: TWMScroll);
begin
  inherited;
  { -    ,  
               }
  inc(FHCount);
  if FHCount = 2 then begin
    DoGridScroll(False, message.ScrollCode);
    FHCount := 0;
  end;
end;

procedure TsohoDBGrid.SetAddColumn(Value: Boolean);
begin
  if FAddColumn = Value then exit;
  FAddColumn := Value;
  Repaint;
end;

procedure TsohoDBGrid.Scroll(Distance: Integer);
begin
  inherited Scroll(Distance);
  DrawSmashColumn;
end;

procedure TsohoDBGrid.SetDrawChecks(Value: Boolean);
begin
  if FDrawChecks = Value then exit;
  FDrawChecks := Value;
  Repaint;
end;

procedure TsohoDBGrid.ColWidthsChanged;
begin
  RowHeightsChanged;
  if Assigned(FColReSize) then FColReSize(Self);
end;

procedure TsohoDBGrid.DrawSmashColumn;
var R : TRect;
    Index : integer;
begin
  if not FAddColumn then exit;
  with Canvas do begin
  R := CellRect(ColCount - 1, 0);
  if (R.Right <> 0) and (R.Right < ClientWidth) and
     (dgTitles in Options) then begin
    Brush.Color := TitleColor;
    R := Rect(R.Right, R.Top, ClientWidth, R.Bottom);
    if dgColLines in Options then Inc(R.Left);
    FillRect(R); Dec(R.Right);
    if [dgRowLines,dgColLines] * Options = [dgRowLines, dgColLines] then begin
      DrawEdge(Canvas.Handle, R, BDR_RAISEDINNER, BF_BOTTOMRIGHT);
      DrawEdge(Canvas.Handle, R, BDR_RAISEDINNER, BF_TOPLEFT);
    end;
    if dgColLines in Options then begin
      Pen.Color := clBlack;
      PolyLine([Point(R.Right, R.Bottom - 1), Point(R.Right, R.Top - 1)]);
    end;
    if dgRowLines in Options then begin
      Pen.Color := clBlack;
      if (dgTitles in Options) then
        PolyLine([Point(R.Left, R.Bottom), Point(R.Right + 1, R.Bottom)]);
      Pen.Color := clSilver;
      if ColorToRGB(Color) = clSilver then Pen.Color := clGray;
      for Index := 0 + integer(dgTitles in Options) to
       VisibleRowCount - integer(not (dgTitles in Options)) do begin
        R := CellRect(ColCount - 1, Index);
        R.Left := R.Right;
        R.Right := ClientWidth;
        PolyLine([Point(R.Left, R.Bottom), Point(R.Right + 1, R.Bottom)]);
       end;
     end;
    end;
  end;
end;

procedure TsohoDBGrid.Paint;
begin
  inherited Paint;
  DrawSmashColumn;
end;

procedure TsohoDBGrid.CMParentFontChanged(var message: TMessage);
begin
  inherited;
  if ParentFont then begin
    FSelfChangingRowFont := True;
    try
      RowFont := Font;
    finally
      FSelfChangingRowFont := False;
    end;
    Invalidate;
  end;
end;

procedure TsohoDBGrid.CMFontChanged(var message: TMessage);
begin
  if ParentFont then RowFont := Font;
  inherited;
end;

procedure TsohoDBGrid.DoOperation(GridOperation: TsohoGridOperation);
begin
  if Assigned(FSpecEvent) then FSpecEvent(Self, GridOperation);
end;

procedure TsohoDBGrid.KeyDown(var KEY: Word; Shift: TShiftState);

  procedure NextRow;
  begin
    with Datalink.Dataset do begin
      if (State = dsInsert) and (not Modified)  then
	if EOF then Exit
        else Cancel
      else begin
	 if Eof and (DataLink.ActiveRecord>=0) and
            (DataLink.ActiveRecord<DataLink.RecordCount-1) and
            not (State=dsInsert) then
	    DataLink.ActiveRecord:= DataLink.ActiveRecord + 1
	 else Next;
      end;
      if EOF and CanModify and (dgEditing in Options)
          and (dgAllowInsert in KeyOptions) then Append;
    end
  end;

  function DeletePrompt: Boolean;
  begin
    Result := (dgConfirmDelete in Options) and
               YesNoMsg(SDeleteRecordQuestion);
    if not (dgConfirmDelete in Options) then Result := true;
  end;

begin
  if not Datalink.Active or not CanGridAcceptKey(Key, Shift) then Exit;
  with Datalink.DataSet do
    case Key of
      VK_DOWN: begin
        Key := 0;
        NextRow;
      end;
      VK_INSERT: if not ReadOnly and (dgEditing in Options) and
                   (dgAllowInsert in KeyOptions) then begin
                   Insert;
                   Key := 0;
                 end
                 else begin
                   DoOperation(soNewRecord);
                   if not (dgAllowInsert in KeyOptions) then Key := 0;
                 end;
      VK_RETURN: DoOperation(soEditRecord);
      VK_DELETE: if (dgAllowDelete in KeyOptions) and (not ReadOnly) and
                    CanModify and (dgEditing in Options) and DeletePrompt then begin
                   Delete;
                   Key := 0;
                 end
                 else begin
                   DoOperation(soDeleteRecord);
                   if not (dgAllowDelete in KeyOptions) then Key := 0;
                   // Key := 0;
                 end;
    end;
  inherited KeyDown(KEY, Shift);
end;

procedure TsohoDBGrid.DblClick;
begin
  DoOperation(soEditRecord);
  inherited DblClick;
end;

procedure TsohoDBGrid.RowFontChanged(Sender: TObject);
begin
  if (not FSelfChangingRowFont) and not (csLoading in ComponentState) then
    ParentFont := False;
  Invalidate;
end;

procedure TsohoDBGrid.ReReadGrid(Sender: TObject);
begin
  Invalidate;
end;

constructor TsohoDBGrid.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FRowSelect := True;
  FRowColor := clAqua;
  FWordWrap := false;
  FRowHeightPercent := 100;
  FAddColumn := False;
  FRowFont := tFont.Create;
  FRowFont.Color := clBlack;
  FRowFont.OnChange := RowFontChanged;
  FSelfChangingRowFont := False;
  FDrawChecks := True;
  FResults := TsohoDBGridResults.Create;
  FResults.OnChange := ReReadGrid;
  FMarkedFont := tFont.Create;
  with FMarkedFont do begin
    Assign(Font);
    Style := [];
    COLOR := clBlack;
  end;
  FMarkedColor := clAqua;
  FVCount := 0;
  FHCount := 0;
  FBeforeFlag := false;
  FStriply := false;
  FStriplyColor := $00DDDDDD;
  FKeyOptions := [dgAllowDelete, dgAllowInsert];
  FKeyField := 'Id';
  FTitleLines := 1;
  FTitleAlignment := taLeftJustify;
  FTitleColor := clBtnFace;
  InUpdateRowCount := false;
  FUpdateLock := 0;
end;

destructor TsohoDBGrid.Destroy;
begin
  FRowFont.Free;
  FResults.Free;
  FMarkedFont.Free;
  inherited Destroy;
end;

procedure TsohoDBGrid.SetRowSelect(Value: Boolean);
begin
  FRowSelect := Value;
  Invalidate;
end;

procedure TsohoDBGrid.SetRowColor(Value: tColor);
begin
  FRowColor := Value;
  Invalidate;
end;

procedure TsohoDBGrid.SetRowFont(Value: tFont);
begin
  FRowFont.Assign(Value);
  if not (csLoading in ComponentState)
    and (not FSelfChangingRowFont) then ParentFont := False;
  Invalidate;
end;

function TsohoDBGrid.GetCellRect(ACol, ARow: Longint): TRect;
begin
  Result := CellRect(ACol, ARow);
end;

function TsohoDBGrid.ActiveRowSelected: Boolean;
var
  Index: Integer;
begin
  Result := False;
  if MultiSelect and Datalink.Active then
    Result := SelectedRows.Find(Datalink.DataSet.Bookmark, Index);
end;

function TsohoDBGrid.GetActiveRow : integer;
begin
  Result := Row;
end;

procedure TsohoDBGrid.GetCellProps(Field: TField; AFont: TFont;
  var Background: TColor; Highlight: Boolean);

  procedure DrawMarkedLines;
  var Id_Field: TField;
  begin
    if not DataLink.Active then exit;
    if FKeyField = '' then exit;
    Id_Field := DataSource.DataSet.FindField(FKeyField);
    if (Id_Field = nil) or (Id_Field.DataType <> ftInteger) then exit;
    if FResults.IndexOf(Id_Field.AsInteger) <> -1 then begin
      AFont.Assign(FMarkedFont);
      Background := FMarkedColor;
    end;
  end;

begin
  if csDestroying in ComponentState then exit;
  inherited GetCellProps(Field, AFont, Background, Highlight);
  if DataLink.Active then begin
    if FStriply then
      if (DataSource.DataSet.RecNo mod 2) = 0 then Background := FStriplyColor;
    if Highlight or (CalcCellRow = GetActiveRow) then begin
      Background := FRowColor;
      AFont.Assign(FRowFont);
    end;
    DrawMarkedLines;
  end;
end;

procedure TsohoDBGrid.SetColWidthByFieldIndex(index: Integer; Value: Integer);
var Offset: Integer;
begin
  if (dgIndicator in Options) then Offset := 1
  else Offset := 0;
  ColWidths[index + Offset] := Value;
end;

function TsohoDBGrid.GetColWidthByFieldIndex(index: Integer): Integer;
var Offset: Integer;
begin
  if (dgIndicator in Options) then Offset := 1
  else Offset := 0;
  Result := ColWidths[index + Offset];
end;

procedure TsohoDBGrid.SetMarkedColor(Value: tColor);
begin
  if FMarkedColor = Value then exit;
  FMarkedColor := Value;
  if not (csLoading in ComponentState) then Repaint;
end;

procedure TsohoDBGrid.SetMarkedFont(Value: tFont);
begin
  FMarkedFont.Assign(Value);
  if not (csLoading in ComponentState) then Repaint;
end;

initialization
  StringBooleanFields := TStringList.Create;
finalization
  StringBooleanFields.Free;
end.

