{$A+,B-,D-,F-,G+,I-,K+,L-,N+,P-,Q-,R-,S-,T-,V+,W-,X+,Y-}
{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoAlignF;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, SoTools, SohoBtns;

type
  TsohoAlignmentForm = class(TForm)
    HorizontalAlignment: TRadioGroup;
    VerticalAlignment: TRadioGroup;
    sohoBitBtn1: TsohoBitBtn;
    sohoBitBtn2: TsohoBitBtn;
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    function GetAlign (var aHorAlign,aVertAlign : integer) : boolean;
  public
    { Public declarations }
  end;

var AlignmentForm: TsohoAlignmentForm;

function GetControlsAlign (var aHorAlign,aVertAlign : integer) : boolean;

implementation

{$R *.DFM}

function GetControlsAlign (var aHorAlign,aVertAlign : integer) : boolean;
begin
   Result := false;
   try
     AlignmentForm := TsohoAlignmentForm.Create(Application);
     Result := AlignmentForm.GetAlign(aHorAlign,aVertAlign);
   finally
     AlignmentForm.Free;
   end;
end;

function TsohoAlignmentForm.GetAlign (var aHorAlign,aVertAlign : integer) : boolean;
begin
   Result := ShowModal = mrOk;
   aHorAlign  := HorizontalAlignment.ItemIndex;
   aVertAlign := VerticalAlignment.ItemIndex;
end;

procedure TsohoAlignmentForm.FormShow(Sender: TObject);
begin
   HorizontalAlignment.ItemIndex := 0;
   VerticalAlignment.ItemIndex := 0;
end;

end.
