{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
          Woll2Woll
}
unit SoWWRtn;
{$I SOHOLIB.INC}

interface
uses Wwquery;

function OpenWwQuery           (Query : TwwQuery; SQLFile : string) : boolean;
function OpenWwQueryWithParams (Query : TwwQuery; SQLFile : string;
                              SQLParams : array of string) : boolean;

implementation
uses Classes, SoUtils, Forms, Controls, SoDBRtn, SoBDERtn;

function OpenWwQuery (Query : TwwQuery; SQLFile : string) : boolean;
begin
     Result := false;
     Screen.Cursor := crSQLWait;
     try
       with Query,SQL do begin
            Close;
            Clear;
            LoadFromFile(SQLFile);
            try
               Open;
               Result := true;
            except ErrorMsg('   : '+SQLFile+'!');
                   exit;
            end;
       end;
     finally
       Screen.Cursor := crDefault;
     end;
end;

function OpenWwQueryWithParams (Query : TwwQuery; SQLFile : string;
         SQLParams : array of string) : boolean;
begin
     Result := false;
     Screen.Cursor := crSQLWait;
     try
       with Query,SQL do begin
            Close;
            Clear;
            LoadFromFile(SQLFile);
            if not PutParameteres(TStringList(SQL),SQLParams) then
                ErrorMsg('     : '+SQLFile)
            else
                try
                  Open;
                  Result := true;
                except ErrorMsg('    : '+SQLFile);
                end;
       end;
     finally
       Screen.Cursor := crDefault;
     end;
end;

end.
 