{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
      ,  
  "Version Info"  
}
unit SoVrsInf;

{$IFNDEF WIN32}
  Unit is designed for Win32 only!
{$ENDIF}

{$I SOHOLIB.INC}

interface
uses Windows;

{    Section   }
function GetVersionInfoSection (Section : string): string;
{    }
function GetCompanyName: string;
{    }
function GetFileDescription: string;
{     (build) }
function GetFileVersion: string;
{     }
function GetInternalName: string;
{      }
function GetLegalCopyright: string;
{      }
function GetLegalTrademarks: string;
{     }
function GetOriginalFilename: string;
{     }
function GetProductName: string;
{     }
function GetProductVersion: string;
{      }
function GetComments: string;

implementation
uses SysUtils, Forms;

var VerBuf  : PChar;
    VerText : PChar;
    {VerSize : integer;}
    VerSize : DWORD; {D4}
    {Temp    : integer;}
    Temp : DWORD; {D4}
    {SectionSize : integer;}
    SectionSize : DWORD; {D4}

procedure GetVersionInfo;
begin
  VerSize := GetFileVersionInfoSize(PChar(Application.ExeName),Temp);
  if (VerSize<>0) then begin
    GetMem(VerBuf, VerSize);
    GetFileVersionInfo(PChar(Application.ExeName),Temp, VerSize, VerBuf);
  end;
end;

function GetVersionInfoSection (Section : string): string;
var Tmp : array [0..254] of char;
begin
  Result := '';
  if VerSize = 0 then exit;
  StrPCopy(Tmp,'\StringFileInfo\041904E3\'+Section);
  VerQueryValue(VerBuf,Tmp,pointer(VerText),SectionSize);
  Result := StrPas(VerText);
end;

function GetCompanyName: string;
begin
  Result := GetVersionInfoSection('CompanyName');
end;

function GetFileDescription: string;
begin
  Result := GetVersionInfoSection('FileDescription');
end;

function GetFileVersion: string;
begin
  Result := GetVersionInfoSection('FileVersion');
end;

function GetInternalName: string;
begin
  Result := GetVersionInfoSection('InternalName');
end;

function GetLegalCopyright: string;
begin
  Result := GetVersionInfoSection('LegalCopyright');
end;

function GetLegalTrademarks: string;
begin
  Result := GetVersionInfoSection('LegalTrademarks');
end;

function GetOriginalFileName: string;
begin
  Result := GetVersionInfoSection('OriginalFilename');
end;

function GetProductName: string;
begin
  Result := GetVersionInfoSection('ProductName');
end;

function GetProductVersion: string;
begin
  Result := GetVersionInfoSection('ProductVersion');
end;

function GetComments: string;
begin
  Result := GetVersionInfoSection('Comments');
end;

initialization
  GetVersionInfo;
finalization
  if VerSize<>0 then FreeMem(VerBuf, VerSize);
end.

