{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoVertLabel -  TLabel,
        
}
unit SoVLbl;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     StdCtrls, Menus;

type

  {   :   ,   ,  ,
      }
  TVertAlignment   = (vaTop,vaBottom,vaCenter,vaNone);

  {    OnAngleChange.  :  
      (OldAngle)     (NewAngle) }
  TTextAngleChange = procedure (Sender : TObject; OldAngle,NewAngle : integer) of object;

  {     TLabel     
     .      TextAngle,  
     ,      
     .     "",  
      : TextX  TextY
  }
  TsohoVertLabel = class(TCustomLabel)
  private
    { Private declarations }
    FTrans         : boolean;
    FAlignment   : TVertAlignment;
    FTextAngle     : integer;
    FX,FY          : integer;
    FOnAngleChange : TTextAngleChange;
  protected
    { Protected declarations }
    procedure SetAlignment (Value : TVertAlignment);
    procedure SetTextAngle  (Value : integer);
    procedure SetX          (Value : integer);
    procedure SetY          (Value : integer);
    procedure SetTrans      (Value : boolean);
    procedure CMFontChanged (var Message : TMessage);message CM_FontChanged;
    procedure CMTextChanged (var Message : TMessage);message CM_TextChanged;
  public
    { Public declarations }
    constructor Create (AOwner : TComponent);override;
    procedure Paint;override;
  published
    { Published declarations }
    property Align;
    property Caption;
    property Color;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property FocusControl;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Visible;
    property Transparent : boolean read FTrans write SetTrans default false;
    {    }
    property Alignment   : TVertAlignment read FAlignment write SetAlignment;
    {      }
    property TextX       : integer read FX write SetX;
    {      }
    property TextY       : integer read FY write SetY;
    {       }
    property TextAngle   : integer read FTextAngle   write SetTextAngle;
    {        }
    property OnAngleChange : TTextAngleChange read FOnAngleChange write FOnAngleChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

implementation
uses SoUtils;

procedure TsohoVertLabel.SetAlignment (Value : TVertAlignment);
begin
     FAlignment := Value;
     Invalidate;
end;

procedure TsohoVertLabel.SetTrans     (Value : boolean);
begin
     FTrans := Value;
     if Value then ControlStyle := ControlStyle - [csOpaque]
     else ControlStyle := ControlStyle + [csOpaque];
     Invalidate;
end;

procedure TsohoVertLabel.CMFontChanged (var Message : TMessage);
begin
     inherited;
     Invalidate;
end;

procedure TsohoVertLabel.CMTextChanged (var Message : TMessage);
begin
     inherited;
     Invalidate;
end;

procedure TsohoVertLabel.SetX (Value : integer);
begin
     FX := Value;
     Invalidate;
end;

procedure TsohoVertLabel.SetY (Value : integer);
begin
     FY := Value;
     Invalidate;
end;

procedure   TsohoVertLabel.SetTextAngle   (Value : integer);
var Old : integer;
begin
     Old := FTextAngle;
     FTextAngle := Value;
     Invalidate;
     if Old<>FTextAngle then
      if Assigned(FOnAngleChange) then FOnAngleChange(Self,Old,FtextAngle);
end;

constructor TsohoVertLabel.Create(AOwner : TComponent);
begin
     inherited Create(AOwner);
     FTextAngle   := 90;
     Font.Name    := 'Courier New';
     FTrans       := false;
     AutoSize     := false;
     FAlignment   := vaBottom;
     Width        := 21;
     Height       := 60;
     FX           := 0;
     FY           := Height;
end;

procedure   TsohoVertLabel.Paint;
var VertFont,
    OldFont   : HFont;
    lf        : TLogFont;
    Rect      : TRect;
    Ptext     : array [0..256] of char;
begin
     with Canvas do begin
        Rect := ClientRect;
        if not Transparent then begin
           Brush.Style:=bsSolid;
           Brush.Color:=Color;
           FillRect(Rect);
        end;
        Brush.Style:=bsClear;
        Font := Self.Font;
        with lf do begin
           {  ,  }
           lfHeight := Font.Height;
           lfWidth := 0;
           lfEscapement := FTextAngle*10;  {    0.1 }
           lfOrientation := 0;  {    }
           if fsBold in Font.Style then lfWeight := FW_BOLD
           else lfWeight := FW_NORMAL;
           lfItalic := Byte(fsItalic in Font.Style);
           lfUnderline := Byte(fsUnderline in Font.Style);
           lfStrikeOut := Byte(fsStrikeOut in Font.Style);
           lfCharSet := DEFAULT_CHARSET;
           StrPCopy(lfFaceName, Font.Name);
           lfQuality := DEFAULT_QUALITY;
           lfOutPrecision := OUT_DEFAULT_PRECIS;
           lfClipPrecision := CLIP_DEFAULT_PRECIS;
           lfPitchAndFamily := DEFAULT_PITCH;
        end;
        VertFont  := CreateFontIndirect(lf);
        OldFont   := SelectObject(Handle,VertFont);
        StrPCopy(Ptext,Caption);
        case FAlignment of
             vaTop    : if (FTextAngle>=0) and (FTextAngle<180) then
                           FY := Rect.Top+3+Canvas.TextWidth(Caption)
                        else FY := Rect.Top+3;
             vaBottom : if (FTextAngle>=0) and (FTextAngle<180) then
                           FY := Rect.Bottom-3
                        else FY := Rect.Bottom-3-Canvas.TextWidth(Caption);
             vaCenter : if (FTextAngle>=0) and (FTextAngle<180) then
                            FY := Rect.Bottom - round((Height-Canvas.TextWidth(Caption))/2)
                        else FY := VertCenter(Rect,Canvas.TextWidth(Caption));
        end;
        if FAlignment<>vaNone then
         if (FTextAngle>=0) and (FTextAngle<180) then FX := 0
         else FX := Width;
        ExtTextOut(Canvas.Handle,FX,FY,ETO_CLIPPED,@Rect,
             PText,length(Caption),nil);
        SelectObject(Canvas.Handle,OldFont);
        DeleteObject(VertFont);
     end;
end;

end.
