{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
          ,
  RTTI  
}
unit SoUtils;

{$I SOHOLIB.INC}

interface
uses Controls,
     {$IFNDEF WIN32} WinTypes, WinProcs,
     {$ELSE} Windows, {$ENDIF}
     Graphics, Classes, FileCtrl, Forms, Menus,
     ExtCtrls, StdCtrls;

const

  {    }
  Space = #32;

  crHourGlass = -11;

type

  {$IFNDEF WIN32}
  {     EnumFunc }
  PHWND = ^HWND;
  {$ENDIF}
  {   }
  SetOfChars = set of Char;

{    .  SetDivisers }
function PointEndWord(const Str: string; Number: LongInt): LongInt;
{    .  SetDivisers }
function PointStartWord(const Str: string; Number: LongInt): LongInt;
{    .  SetDivisers }
function WordsInString(const Str: string): LongInt;
{     .  SetDivisers }
function GetSomeWords(const Str: string; _from, _to: LongInt): string;
{     ,   . 
        "|".  SetDivisers }
function CutStringOnLines(const txt: string; MaxLen: LongInt): string;
{  .  SetDivisers }
procedure DeleteWord(var Str: string; Number: LongInt);
{   .  SetDivisers }
function WordPosition(const Str, Word: string): LongInt;
{     .  SetDivisers }
procedure ChangeWord(var Str: string; const OldWord, NewWord: string);
{    .       , 
     . ,     SetDivisers,
        }
procedure SetDivisers(NewDivisers: SetOfChars);

{  ,     }
function UpCase(C: Char): Char;
{  ,     }
function LowCase(C: Char): Char;
{     }
function StrUpper(const Str: string): string;
{     }
function StrLower(const Str: string): string;
{   -  .     
    ,    .}
{example:
   GetNoSpacePercent('    ') = 0
   GetNoSpacePercent('1111') = 100
}
function GetNoSpacePercent(const Str: string): real;
{     }
function ChangeChars(const Str: string; OldChar, NewChar: Char): string;
{      }
function ChangeStr(const Str, OldText, NewText: string) : string;
{        Count  }
function Chars(C: Char; Count: Integer): string;
{      }
function DeleteChars(const Value: string; Chars: SetOfChars): string;
{  .  Value   AlignChar      
   Alignment    Len}
function AlignStr(const Value: string; Alignment: TAlignment;
  AlignChar: Char; len: Integer): string;
{       .     
  string,     }
function DecLength(const Value: string; Count: Integer): string;

{      ? }
function IsFloat(const Value: string): Boolean;
{      ? }
function IsInteger(const Value: string): Boolean;

{  boolean  string }
function BoolToStr(Value: Boolean): string;
{  string  boolean }
function StrToBool(const Value: string): Boolean;
{  TAlignment  string }
function AlignmentToStr(Value: TAlignment): string;
{  string  TAlignment }
function StrToAlignment(const Value: string): TAlignment;
{  TAlign  string }
function AlignToStr(Value: tAlign): string;
{  string  TAlign }
function StrToAlign(const Value: string): tAlign;
{  TFontStyles  string }
function FontStyleToStr(Value: TFontStyles): string;
{  string  TFontStyles }
function StrToFontStyle(const Value: string): TFontStyles;
{  TFont  string }
function FontToStr(Value: TFont): string;
{  string  TFont }
procedure StrToFont(const Value: string; Font : TFont);

{        (Width) }
function IntToStrF(Value: Longint; Width: Integer): string;
{        (Width)  
      (Decimal) }
function FloatToStrF(Value: Extended; Width: Integer;
  Decimals: Integer): string;
{           SQL-,
          }
function FloatToSQLFloat(Value: Extended): string;

{     .      except,
    0 }
function WStrToInt(const Value: string; var Error: Boolean): Longint;
{     .      except,
    0 }
function WStrToFloat(const Value: string; var Error: Boolean): Extended;

{         ? }
function AllFilesFound(PathTo: string; Files: array of string): Boolean;
{    }
procedure ErrorMsg(const MsgText: string);
{    }
procedure InfoMsg(const MsgText: string);
{    ""  "".   true,     "" }
function YesNoMsg(const MsgText: string): Boolean;
{    "", "", "".      }
function YesNoCancel (const MsgText: string) : TModalResult;
{    "Ok"  ""    true,     "Ok" }
function OkCancelMsg(const MsgText: string): Boolean;
{   ,        }
procedure ErrorResFrm(ResID: Word; Args: array of const);
{   ,      }
procedure ErrorRes(ResID: Word);

{    a  b }
procedure SwapLongInt(var A, B: Longint);
{    a  b }
procedure SwapInteger(var A, B: Integer);

{$IFDEF Win32}
{    TSmallPoint  TPoint, c  Win32 API  
   "",   TPoint  Win16 }
function SmallToPoint(Point: TSmallPoint): TPoint;
{$ENDIF}

{    : ,   . 
   "" ,       TopColor 
    BottomColor }
procedure DoHorRect(Canvas: TCanvas; AlignTop: Boolean; Rect: TRect;
  TopColor, BottomColor: TColor);
{    : ,   . 
   "" ,       TopColor 
    BottomColor }
procedure DoVertRect(Canvas: TCanvas; AlignLeft: Boolean; Rect: TRect;
  TopColor, BottomColor: TColor);

{    Height   Rect. 
   "",     ,     
   Rect }
function VertCenter(Rect: TRect; Height: Integer): Integer;
{    Width   Rect. 
   "x",     ,     
   Rect }
function HorCenter(Rect: TRect; Width: Integer): Integer;
{      }
procedure AdjustColors(Bevel: TPanelBevel; var TopColor, BottomColor: tColor;
          HighLightColor, ShadowColor: tColor);

{    }
function GetMax(X, Y: Integer): Integer;
{    }
function GetMin(X, Y: Integer): Integer;

{  .  ProcessMessages = true,     
     .      }
procedure Delay(Pause: Longint; ProcessMessages: Boolean);

{$IFNDEF WIN32}
{       }
function EnumFunc(Wnd: HWND; TargetWindow: PHWND): BOOL; export;
{     }
procedure GotoPreviousInstance;
{$ENDIF}

{    TControl }
function GetControlColor(AControl: TControl): TColor;
{    aControl }
function GetControlFont(AControl: TControl): tFont;
{    aControl }
procedure SetControlFont(AControl: TControl; AFont: tFont);
{    aControl }
procedure SetControlColor(AControl: TControl; aColor: TColor);
{    aControl.Parent }
function GetParentColor(AControl: TControl): TColor;
{    aControl.Parent }
function GetParentFont(AControl: TControl): tFont;
{  - }
function GetOwnerForm(AComponent: TComponent): TForm;
{    ,        ? }
function FormExists (CheckForm : TForm) : boolean;
{    }
procedure SetComponentState(AComponent: TComponent; State: TComponentState);
{     }
function FindForm(Pos: TPoint): TForm;
{       }
function FindComponentOnForm(Pos: TPoint; Form: TForm; CanBeForm: Boolean): TComponent;
{  true,   OnClick  aControl  }
function ClickAssigned(AControl: TControl): Boolean;
{     Owner,      
       CreateComponentByClassName }
procedure RunTimeRegisterComponents(Owner: TComponent);
{ C     }
function CreateComponentByClassName(const ClassName: string;
  Owner: TComponent): TComponent;
{        }
function ComponentByName(var Form; AName: string): TComponent;

{    PropertyName   Obj? }
function IsProperty(Obj: TPersistent; PropertyName: string): Boolean;
{     PropertyName     Obj }
function SetFloatProperty(Obj: TPersistent; PropertyName: string; Value: Double): Boolean;
{     PropertyName     Obj }
function SetIntegerProperty(Obj: TPersistent; PropertyName: string; Value: Longint): Boolean;
{     PropertyName     Obj }
function SetStringProperty(Obj: TPersistent; PropertyName: string; Value: string): Boolean;
{     PropertyName     Obj }
function SetClassProperty(Obj: TPersistent; PropertyName: string; Value: Pointer): Boolean;
{    PropertyName     Obj }
function GetFloatProperty(Obj: TPersistent; PropertyName: string): Double;
{    PropertyName     Obj }
function GetIntegerProperty(Obj: TPersistent; PropertyName: string): Longint;
{    PropertyName     Obj }
function GetStringProperty(Obj: TPersistent; PropertyName: string): string;
{    PropertyName     Obj }
function GetClassProperty(Obj: TPersistent; PropertyName: string): Pointer;
{       }
function GetUniqueName (aComponent, aOwner: TComponent): string;

{       PropertyName  
  .}
{example:

  StrToIdent(Self, 'Align', 'alLeft') = alLeft
}
function StrToIdent(Obj: TPersistent; PropertyName: string; Ident: string): Cardinal;
{         PropertyName
   .}
{example:

  IdentToStr(Self, 'Align', alLeft) = 'alLeft'
}
function IdentToStr(Obj: TPersistent; PropertyName: string; Value: Cardinal): string;


{   CD-ROM   ? }
function IsCDROM(DriveNum: Integer): Boolean;
{   RAM-drive   ? }
function IsRAMDrive(DriveNum: Integer): Boolean;
{   }
function FindDriveType(DriveNum: Integer): TDriveType;
{    }
function VolumeID(DriveChar: Char): string;
{    }
function NetworkVolume(DriveChar: Char): string;

{     }
function ResString(StrId: Word): string;
{     }
function ResBitmap(const BitMapName: string): HBITMAP;
{     }
function ResCursor(const CursorName: string): HCURSOR;
{    Rect  API }
procedure TextInRect(Canvas: TCanvas; const Text: string; Rect: TRect;
  TextAlign: TAlignment);
{    Rect  API   }
procedure WrapTextInRect(Canvas: TCanvas; const Text: string; Rect: TRect;
  TextAlign: TAlignment);

{    . ,    TTF! }
procedure AngleTextInRect(Canvas: TCanvas; const Text: string; Rect: TRect;
  X, Y: Integer; Angle: Integer);
{     ,     }
function GetStrWidth(DC: HDC; const Value: string): Integer;
{     ,     }
function GetStrHeight(DC: HDC; const Value: string): Integer;

{  bitmap    }
procedure DrawBitmapInRect(Canvas: TCanvas; Rect: TRect; Bitmap: TBitmap);
{  bitmap,       }
procedure DrawResBitmapInRect(Canvas: TCanvas; Rect: TRect; const BitMapName: string);

{ ,    round.     
  -     ,     
   .     ,    
  .   round    , 
  }
function Round(Value: Extended): Longint;

{      Path  List. Attr -  ,
      .  ,    
   ,  Attr     faDirectory }
procedure FilesToStrings(List: TStringList; const Path: string; Attr: Integer);
{ / //,  true   .
   !     ,    - "\"
  ,    - "\*.*". Erase  True,    ,
     }
function CopyFiles(FromName, ToName: string; Erase: Boolean): Boolean;
{    MkDir.    , 
     ,         }
function MakeDirectory(Dir: string): Boolean;
{     ,  ,  . 
     ,   .    
   ProgramName    ,    - ,
  ,    Ms Word: 'c:\temp\test.doc' }
function Exec(const ProgramName, Params: string; ShowCode: Integer; Wait : boolean): string;
{       }
function ExecError(ErrorNum: Longint): string;
{    /  Windows }
function WindowsVerStr: string;
{    Windows }
procedure WindowsVer(var FirstNumb, SecondNumb: Byte);
{    }
function GetEnvVar(Pattern: string): string;
{      }
function ExtractFileNameOnly(Filename: string): string;
{     ( ) }
function DefaultName: string;
{   ,  ,   ...
     }
function ExtractFile(S: string; N: Longint): string;
{  ,    .   
      "\" }
function GetRunDir: string;
{   }
procedure HideApplication;
{      }
function GetPathToTemp: string;
{       }
function GetPathToLocalTemp: string;
{   " ..."}
procedure StandartAboutBox(const ProductName, Comments: string);
{   '/'   ,   }
function NormalDir (const DirName : string) : string;
{       }
function TextFileToStr (const FileName : string) : string;
{       }
function StrToTextFile (const FileName, Text : string) : boolean;

{   ,     FromMenu. 
  Owner      }
function CopyMenuItem(Owner: TComponent; FromItem: TMenuItem): TMenuItem;
{      Tag }
function FindMenuItemByTag (Menu : TComponent; FindTag : LongInt) : TMenuItem;
{       }
procedure MenuItemRightAlign (Menu : TMainMenu; Item : TMenuItem);

{     .    ,
   , , ,    ,  
  ResoreCursor }
procedure SetCursor (aCursor : TCursor);
{  ,   SetCursor }
procedure RestoreCursor;

{     }
procedure SwitchToRussian;
{     }
procedure SwitchToEnglish;
{     }
procedure RestoreLayout;

{     Memo.     1- }
procedure SetCursorPos(Memo : TMemo; XPos, YPos : integer);

implementation
uses SysUtils, TypInfo, SoClass, ShellAPI;

type

  EIdentConvertError = class(Exception);

  {$IFNDEF Win32}
  THackComponent = class(TPersistent)
  private
    FOwner: TComponent;
    FName: PString;
    FTag: Longint;
    FComponents: TList;
    FDesignInfo: Longint;
    FComponentState: TComponentState;
    fReserved: Byte;
  end;

  THackControl = class(TComponent)
  private
    FParent: TWinControl;
    FLeft: Integer;
    FTop: Integer;
    FWidth: Integer;
    FHeight: Integer;
    FControlStyle: TControlStyle;
    FControlState: TControlState;
    FVisible: Boolean;
    FEnabled: Boolean;
    FParentFont: Boolean;
    FParentColor: Boolean;
    FAlign: tAlign;
    FDragMode: TDragMode;
    FIsControl: Boolean;
    FText: PChar;
    FFont: tFont;
    FColor: TColor;
    FCursor: tCursor;
    FDragCursor: tCursor;
    FPopupMenu: TPopupMenu;
    FHint: PString;
    FShowHint: Boolean;
    FParentShowHint: Boolean;
    FOnMouseDown: TMouseEvent;
    FOnMouseMove: TMouseMoveEvent;
    FOnMouseUp: TMouseEvent;
    FOnDragDrop: TDragDropEvent;
    FOnDragOver: TDragOverEvent;
    FOnEndDrag: TEndDragEvent;
    FOnClick: TNotifyEvent;
    FOnDblClick: TNotifyEvent;
  end;
  {$ELSE}
  {$HINTS OFF}
  THackComponent = class(TPersistent)
  private
    FOwner: TComponent;
    FName: TComponentName;
    FTag: Longint;
    FComponents: TList;
    FFreeNotifies: TList;
    FDesignInfo: Longint;
    FVCLComObject: Pointer;
    FComponentState: TComponentState;
  end;

  {$IFDEF Delphi3}
  THackControl = class(TComponent)
  private
    FParent: TWinControl;
    FWindowProc: TWndMethod;
    FLeft: Integer;
    FTop: Integer;
    FWidth: Integer;
    FHeight: Integer;
    FControlStyle: TControlStyle;
    FControlState: TControlState;
    FDesktopFont: Boolean;
    FVisible: Boolean;
    FEnabled: Boolean;
    FParentFont: Boolean;
    FParentColor: Boolean;
    FAlign: tAlign;
    FDragMode: TDragMode;
    FIsControl: Boolean;
    FText: PChar;
    FFont: tFont;
    FColor: TColor;
    FCursor: tCursor;
    FDragCursor: tCursor;
    FPopupMenu: TPopupMenu;
    FHint: string;
    FFontHeight: Integer;
    FScalingFlags: TScalingFlags;
    FShowHint: Boolean;
    FParentShowHint: Boolean;
    FOnMouseDown: TMouseEvent;
    FOnMouseMove: TMouseMoveEvent;
    FOnMouseUp: TMouseEvent;
    FOnDragDrop: TDragDropEvent;
    FOnDragOver: TDragOverEvent;
    FOnStartDrag: TStartDragEvent;
    FOnEndDrag: TEndDragEvent;
    FOnClick: TNotifyEvent;
    FOnDblClick: TNotifyEvent;
  end;
  {$ELSE}
  THackControl = class(TComponent)
  private
    FParent: TWinControl;
    FWindowProc: TWndMethod;
    FLeft: Integer;
    FTop: Integer;
    FWidth: Integer;
    FHeight: Integer;
    FControlStyle: TControlStyle;
    FControlState: TControlState;
    FDesktopFont: Boolean;
    FVisible: Boolean;
    FEnabled: Boolean;
    FParentFont: Boolean;
    FParentColor: Boolean;
    FAlign: TAlign;
    FAutoSize: Boolean;
    FDragMode: TDragMode;
    FIsControl: Boolean;
    FBiDiMode: TBiDiMode;
    FParentBiDiMode: Boolean;
    FText: PChar;
    FFont: TFont;
    FActionLink: TControlActionLink;
    FAnchors: TAnchors;
    FColor: TColor;
    FConstraints: TSizeConstraints;
    FCursor: TCursor;
    FDragCursor: TCursor;
    FPopupMenu: TPopupMenu;
    FHint: string;
    FFontHeight: Integer;
    FLastHeight: Integer;
    FLastWidth: Integer;
    FScalingFlags: TScalingFlags;
    FShowHint: Boolean;
    FParentShowHint: Boolean;
    FDragKind: TDragKind;
    FDockOrientation: TDockOrientation;
    FHostDockSite: TWinControl;
    FUndockWidth: Integer;
    FUndockHeight: Integer;
    FLRDockWidth: Integer;
    FTBDockHeight: Integer;
    FFloatingDockSiteClass: TWinControlClass;
    FOnCanResize: TCanResizeEvent;
    FOnConstrainedResize: TConstrainedResizeEvent;
    FOnMouseDown: TMouseEvent;
    FOnMouseMove: TMouseMoveEvent;
    FOnMouseUp: TMouseEvent;
    FOnDragDrop: TDragDropEvent;
    FOnDragOver: TDragOverEvent;
    FOnResize: TNotifyEvent;
    FOnStartDock: TStartDockEvent;
    FOnEndDock: TEndDragEvent;
    FOnStartDrag: TStartDragEvent;
    FOnEndDrag: TEndDragEvent;
    FOnClick: TNotifyEvent;
    FOnDblClick: TNotifyEvent;
  end;
  {$ENDIF}
  {$HINTS ON}
  {$ENDIF}

{ String routines }
var Divisers: SetOfChars;
  
function GetNoSpacePercent;
var K, I: LongInt;
begin
  if Length(Str) = 0 then begin
    GetNoSpacePercent := 0;
    exit;
  end;
  K := 0;
  for I := 1 to Length(Str) do
    if Str[I] = #32 then inc(K);
  GetNoSpacePercent := 100 - K / Length(Str) * 100;
end;

function ChangeChars;
var K: LongInt;
begin
  Result := Str;
  for K := 1 to Length(Result) do
    if Result[K] = OldChar then Result[K] := NewChar;
end;

function ChangeStr(const Str, OldText, NewText: string) : string;
var Index : LongInt;
begin
  Result := Str;
  Index := pos(StrUpper(OldText), StrUpper(Str));
  if Index = 0 then exit;
  Result := copy(Str, 1, Index-1) + NewText + copy(Str, Index+length(OldText),
    length(Str));
end;

function Chars;
var K: LongInt;
  Res: string;
begin
  Res := '';
  for K := 1 to Count do Res := Res + C;
  Chars := Res;
end;

procedure SetDivisers(NewDivisers: SetOfChars);
begin
  Divisers := NewDivisers;
end;

function PointStartWord;
var K, S, Stop: LongInt;
begin
  K := 1; S := 1;
  repeat
    while (Str[K] in Divisers) and (K <= Length(Str)) do inc(K);
      if K > Length(Str) then begin PointStartWord := 0; exit; end;
    Stop := 0;
    while Stop = 0 do begin
      if (K > Length(Str)) or (S = Number) then Stop := 1
      else
        if Str[K] in Divisers then Stop := 2
        else inc(K);
    end;
    inc(S);
  until (Stop = 1);
  PointStartWord := K;
end;

function PointEndWord;
var K, S, Stop: LongInt;
begin
  K := 1; S := 1;
  repeat
    while (Str[K] in Divisers) and (K <= Length(Str)) do inc(K);
      if K > Length(Str) then begin PointEndWord := 0; exit; end;
    Stop := 0;
    while Stop = 0 do begin
      if (K > Length(Str)) or (S = Number) then Stop := 1
      else
        if Str[K] in Divisers then Stop := 2
        else inc(K);
    end;
    inc(S);
  until (Stop = 1);
  while (not (Str[K] in Divisers)) and (K <= Length(Str)) do inc(K);
  PointEndWord := K - 1;
end;

function WordsInString;
var Res: string;
  K, S, Stop: LongInt;
begin
  K := 1; S := 0;
  if Str = '' then begin
    Result := 0;
    exit;
  end;
  repeat
    while (Str[K] in Divisers) and (K <= Length(Str)) do inc(K);
      if K > Length(Str) then begin WordsInString := S; exit; end;
    Stop := 0;
    Res := '';
    while Stop = 0 do begin
      if K > Length(Str) then Stop := 1
      else
        if Str[K] in Divisers then Stop := 2
        else begin
          Res := Res + Str[K]; inc(K);
        end;
    end;
    inc(S);
  until Stop = 1;
  WordsInString := S;
end;

function GetSomeWords;
var K, k1: LongInt;
begin
  K := WordsInString(Str);
  if (_from < 1) or (_from > K) or (_from > _to) or (_to > K) then begin
    GetSomeWords := '';
    exit;
  end;
  K := PointStartWord(Str, _from);
  k1 := PointEndWord(Str, _to);
  GetSomeWords := Copy(Str, K, k1 - K + 1);
end;

function CutStringOnLines;
var CurTxt, Res, CurLine: string;
  Wrds, WrdsInStr: LongInt;
begin
  CurTxt := txt; {SetDivisers([' ']);} Res := '';
  repeat
    Wrds := WordsInString(CurTxt); WrdsInStr := Wrds;
    CurLine := GetSomeWords(CurTxt, 1, Wrds);
    if (Length(CurLine) > MaxLen) and (Wrds = 1) then begin
      Res := Res + CurLine + '|';
      break;
    end
    else
      while Length(CurLine) > MaxLen do begin
        dec(Wrds);
        if Wrds > 0 then CurLine := GetSomeWords(CurTxt, 1, Wrds);
      end;
    Res := Res + CurLine + '|';
    CurTxt := GetSomeWords(CurTxt, Wrds + 1, WrdsInStr);
  until CurTxt = '';
  CutStringOnLines := Copy(Res, 1, Length(Res) - 1);
end;

function UpCase(C: Char): Char;
begin
  if C in ['a'..'z', ''..''] then
    C := Chr(Ord(C) - 32);
  UpCase := C;
end;

function StrUpper;
var K: Integer;
  Res: string;
begin
  Res := Str;
  for K := 1 to Length(Str) do Res[K] := UpCase(Res[K]);
  StrUpper := Res;
end;

function LowCase(C: Char): Char;
begin
  if C in ['A'..'Z', ''..''] then C := Chr(Ord(C) + 32);
  LowCase := C;
end;

function StrLower;
var K: Integer;
  temp: string;
begin
  temp := Str;
  for K := 1 to Length(Str) do temp[K] := LowCase(temp[K]);
  StrLower := temp;
end;

procedure DeleteWord(var Str: string; Number: LongInt);
var K, k1: LongInt;
  Res: string;
begin
  K := PointStartWord(Str, Number);
  k1 := PointEndWord(Str, Number);
  Res := Copy(Str, 1, K - 1) + Copy(Str, k1 + 1, Length(Str) - k1 + 1);
  Str := Res;
end;

function WordPosition;
var K: LongInt;
  temp: string;
begin
  for K := 1 to WordsInString(Str) do begin
    temp := GetSomeWords(Str, K, K);
    if temp = Word then begin
      WordPosition := K;
      exit;
    end;
  end;
  WordPosition := 0;
end;

procedure ChangeWord;
var K, k1, Z: LongInt;
  Res: string;
begin
  Z := WordPosition(Str, OldWord);
  if Z = 0 then exit;
  K := PointStartWord(Str, Z);
  k1 := PointEndWord(Str, Z);
  Res := Copy(Str, 1, K - 1) + NewWord + Copy(Str, k1 + 1, Length(Str) - k1 + 1);
  Str := Res;
end;

function DeleteChars;
var index: LongInt;
begin
  Result := '';
  for index := 1 to Length(Value) do
    if not (Value[index] in Chars) then Result := Result + Value[index];
end;

function AlignStr(const Value: string; Alignment: TAlignment; AlignChar: Char;
    len: Integer): string;
begin
  Result := Value;
  case Alignment of
    taLeftJustify: while Length(Result) < len do Result := Result + AlignChar;
    taRightJustify: while Length(Result) < len do Result := AlignChar + Result;
    taCenter: while Length(Result) < len do begin
        Result := Result + AlignChar;
        if Length(Result) < len then Result := AlignChar + Result;
      end;
  end;
  Result := Copy(Result, 1, len);
end;

function DecLength(const Value: string; Count: Integer): string;
begin
  Result := Copy(Value, 1, Length(Value) - Count);
end;

{ Converts }
function IndexOfStr(const Value: string; const Values: array of string): Integer;
var index: Integer;
begin
  Result := -1;
  for index := Low(Values) to High(Values) do
    if CompareText(Value, Values[index]) = 0 then begin
      Result := index;
      exit;
    end;
end;

function IsFloat(const Value: string): Boolean;
var index: Integer;
  OneFound: Boolean;
begin
  Result := False;
  OneFound := False; {-  float     }
  if Value <> '' then begin
    for index := 1 to Length(Value) do begin
      if Value[index] = DecimalSeparator then begin
        if not OneFound then OneFound := True
        else exit;
      end;
      if not (Value[index] in [Space, DecimalSeparator, '0'..'9', '-']) then exit;
    end;
    Result := True;
  end;
end;

function IsInteger(const Value: string): Boolean;
var index: Integer;
begin
  Result := False;
  if Value <> '' then begin
    for index := 1 to Length(Value) do
      if not (Value[index] in [Space, '0'..'9', '-']) then exit;
    Result := True;
  end;
end;

function WStrToInt;
begin
  Result := 0;
  if not IsInteger(Value) then exit;
  Error := False;
  try
    Result := StrToInt(DeleteChars(Value,[' ']));
  except Error := True;
  end;
end;

function WStrToFloat;
var tmp: string;
begin
  Tmp := DeleteChars(Value,[' ']);
  Tmp := ChangeChars(Value, '.', DecimalSeparator);
  Result := 0;
  if not IsFloat(Tmp) then exit;
  Error := False;
  try
    Result := StrToFloat(tmp);
  except Error := True;
  end;
end;

function IsPropertyInfo(Obj: TPersistent; PropertyName: string;
    var PropInfo: PPropInfo): Boolean;
var TypeInfo: PTypeInfo;
begin
  Result := False;
  TypeInfo := Obj.ClassInfo;
  if TypeInfo = nil then exit;
  PropInfo := GetPropInfo(TypeInfo, PropertyName);
  if PropInfo = nil then exit;
  Result := True;
end;

function EnumValue(EnumType: PTypeInfo; const EnumName: string): Integer;
begin
  Result := GetEnumValue(EnumType, EnumName);
  if Result = -1 then EIdentConvertError.Create('Error on get enum value!');
end;

function StrToIdent(Obj: TPersistent; PropertyName: string; Ident: string): Cardinal;
var PropInfo: PPropInfo;
    PropType: PTypeInfo;
begin
  if not IsPropertyInfo(Obj, PropertyName, PropInfo) then
    EIdentConvertError.Create('Property ' + PropertyName + ' does not exist!');
  {$IFNDEF WIN32}
  PropType := PPropInfo(PropInfo)^.PropType;
  {$ELSE}
  PropType := PPropInfo(PropInfo)^.PropType^;
  {$ENDIF}
  if PropType^.Kind <> tkEnumeration then
    EIdentConvertError.Create('Property ' + PropertyName + ' is not cardinal!');
  Result := EnumValue(PropType, Ident);
end;

function IdentToStr(Obj: TPersistent; PropertyName: string; Value: Cardinal): string;
var PropInfo: PPropInfo;
  PropType: PTypeInfo;
begin
  Result := '';
  if not IsPropertyInfo(Obj, PropertyName, PropInfo) then
    EIdentConvertError.Create('Property ' + PropertyName + ' does not exist!');
  {$IFNDEF WIN32}
  PropType := PPropInfo(PropInfo)^.PropType;
  {$ELSE}
  PropType := PPropInfo(PropInfo)^.PropType^;
  {$ENDIF}
  if PropType^.Kind <> tkEnumeration then
    EIdentConvertError.Create('Property ' + PropertyName + ' is not cardinal!');
  {$IFNDEF WIN32}
  Result := GetEnumName(PropType, Value)^;
  {$ELSE}
  Result := GetEnumName(PropType, Value);
  {$ENDIF}
end;

function IsProperty(Obj: TPersistent; PropertyName: string): Boolean;
var PropInfo: PPropInfo;
begin
  Result := IsPropertyInfo(Obj, PropertyName, PropInfo);
end;

function SetFloatProperty(Obj: TPersistent; PropertyName: string; Value: Double): Boolean;
var PropInfo: PPropInfo;
begin
  Result := IsPropertyInfo(Obj, PropertyName, PropInfo);
  if not Result then exit;
  SetFloatProp(Obj, PropInfo, Value);
end;

function SetIntegerProperty(Obj: TPersistent; PropertyName: string; Value: Longint): Boolean;
var PropInfo: PPropInfo;
begin
  Result := IsPropertyInfo(Obj, PropertyName, PropInfo);
  if not Result then exit;
  SetOrdProp(Obj, PropInfo, Value);
end;

function SetStringProperty(Obj: TPersistent; PropertyName: string; Value: string): Boolean;
var PropInfo: PPropInfo;
begin
  Result := IsPropertyInfo(Obj, PropertyName, PropInfo);
  if not Result then exit;
  SetStrProp(Obj, PropInfo, Value);
end;

function SetClassProperty(Obj: TPersistent; PropertyName: string; Value: Pointer): Boolean;
var PropInfo: PPropInfo;
begin
  Result := IsPropertyInfo(Obj, PropertyName, PropInfo);
  if not Result then exit;
  SetOrdProp(Obj, PropInfo, Longint(Value));
end;

function GetFloatProperty(Obj: TPersistent; PropertyName: string): Double;
var PropInfo: PPropInfo;
begin
  Result := 0;
  if not IsPropertyInfo(Obj, PropertyName, PropInfo) then exit;
  Result := GetFloatProp(Obj, PropInfo);
end;

function GetIntegerProperty(Obj: TPersistent; PropertyName: string): Longint;
var PropInfo: PPropInfo;
begin
  Result := 0;
  if not IsPropertyInfo(Obj, PropertyName, PropInfo) then exit;
  Result := GetOrdProp(Obj, PropInfo);
end;

function GetStringProperty(Obj: TPersistent; PropertyName: string): string;
var PropInfo: PPropInfo;
begin
  Result := '';
  if not IsPropertyInfo(Obj, PropertyName, PropInfo) then exit;
  Result := GetStrProp(Obj, PropInfo);
end;

function GetClassProperty(Obj: TPersistent; PropertyName: string): Pointer;
var PropInfo: PPropInfo;
begin
  Result := nil;
  if not IsPropertyInfo(Obj, PropertyName, PropInfo) then exit;
  Result := Pointer(GetOrdProp(Obj, PropInfo));
end;

function GetUniqueName (aComponent, aOwner: TComponent): string;
var Index: Integer;
    Temp: string;
    Comp: TComponent;
begin
  Temp := aComponent.ClassName;
  if Temp[1] = 'T' then System.Delete(Temp, 1, 1);
  Index := 1;
  repeat
    Result := Temp + IntToStr(Index);
    Comp := aOwner.FindComponent(Result);
    Inc(Index);
  until (Comp = nil) or (Comp = aComponent);
end;

function BoolToStr(Value: Boolean): string;
const BooleanToStr : array [boolean] of string = ('False', 'True');
begin
  Result := BooleanToStr[Value];
  {if Value then Result := 'True'
  else Result := 'False';}
end;

function StrToBool;
var V: string;
begin
  V := StrUpper(Value);
  Result := (V = 'TRUE') or (V = 'T') or (V = '1') or
    (V = 'YES') or (V = 'Y');
end;

function AlignmentToStr(Value: TAlignment): string;
begin
  if Value = taLeftJustify then Result := 'taLeftJustify';
  if Value = taRightJustify then Result := 'taRightJustify';
  if Value = taCenter then Result := 'taCenter';
end;

function StrToAlignment;
begin
  case IndexOfStr(StrUpper(Value),
    ['TALEFTJUSTIFY', 'TARIGHTJUSTIFY', 'TACENTER']) of
      0: Result := taLeftJustify;
      1: Result := taRightJustify;
      else Result := taCenter;
      end;
  end;
  
function AlignToStr(Value: tAlign): string;
begin
  if Value = alLeft then Result := 'alLeft';
  if Value = alRight then Result := 'alRight';
  if Value = alClient then Result := 'alClient';
  if Value = alNone then Result := 'alNone';
  if Value = alTop then Result := 'alTop';
  if Value = alBottom then Result := 'alBottom';
end;

function StrToAlign;
begin
  case IndexOfStr(StrUpper(Value),
    ['ALCLIENT', 'ALRIGHT', 'ALNONE', 'ALTOP', 'ALBOTTOM', 'ALLEFT']) of
      0: Result := alClient;
      1: Result := alRight;
      2: Result := alNone;
      3: Result := alTop;
      4: Result := alBottom;
      else Result := alLeft;
      end;
  end;
  
function IntToStrF;
begin
  Str(Value: Width, Result);
end;

function FloatToStrF(Value: Extended; Width: Integer; Decimals: Integer): string;
begin
  Str(Value: Width: Decimals, Result);
  Result := DeleteChars(Result, [#32]);
end;

function FloatToSQLFloat(Value: Extended): string;
begin
  Result := FloatToStrF(Value, 15, 3);
end;

function FontStyleToStr(Value: TFontStyles): string;
begin
  Result := '';
  if Value = [] then Result := 'N';
  if fsBold in Value then Result := Result + 'B';
  if fsItalic in Value then Result := Result + 'I';
  if fsUnderline in Value then Result := Result + 'U';
  if fsStrikeOut in Value then Result := Result + 'S';
end;

function StrToFontStyle;
var index: Integer;
begin
  Result := [];
  for index := 1 to Length(Value) do
    case Value[index] of
      'B': Result := Result + [fsBold];
      'I': Result := Result + [fsItalic];
      'U': Result := Result + [fsUnderline];
      'S': Result := Result + [fsStrikeOut];
    end;
end;

function FontToStr(Value: TFont): string;
begin
  Result := Value.name + ',' + ColorToString(Value.Color) + ',' +
    FontStyleToStr(Value.Style) + ',' + IntToStr(Value.Size);
end;

procedure StrToFont;
var Error: Boolean;
begin
  if Font = nil then exit;
  {   -  }
  SetDivisers([',']);
  with Font do begin
    Name := GetSomeWords(Value, 1, 1);
    Color := StringToColor(GetSomeWords(Value, 2, 2));
    Style := StrToFontStyle(GetSomeWords(Value, 3, 3));
    Size := WStrToInt(GetSomeWords(Value, 4, 4), Error);
  end;
end;

{ Others }
procedure SwapInteger(var A, B: Integer);
var tmp: Integer;
begin
  tmp := A;
  A := B;
  B := tmp;
end;

procedure SwapLongInt(var A, B: Longint);
var tmp: Longint;
begin
  tmp := A;
  A := B;
  B := tmp;
end;

function AllFilesFound(PathTo: string; Files: array of string): Boolean;
var index: Integer;
begin
  Result := False;
  if PathTo[Length(PathTo)] <> '\' then PathTo := PathTo + '\';
  for index := Low(Files) to High(Files) do
    if not FileExists(PathTo + Files[index]) then exit;
  Result := True;
end;

procedure ErrorMsg;
begin
  Screen.Cursor := crDefault;
  Application.MessageBox(PChar(MsgText), '', MB_ICONERROR or
     MB_OK or MB_TASKMODAL);
end;

procedure InfoMsg;
begin
  Application.MessageBox(PChar(MsgText), '', MB_ICONINFORMATION
     or MB_OK or MB_TASKMODAL);
end;

function YesNoMsg(const MsgText: string): Boolean;
begin
  Result := Application.MessageBox(PChar(MsgText), '',
    MB_ICONQUESTION or MB_YESNO or MB_TASKMODAL) = IDYES;
end;

function YesNoCancel (const MsgText: string) : TModalResult;
var Tmp : integer;
begin
  Tmp := Application.MessageBox(PChar(MsgText), '',
    MB_ICONQUESTION or MB_YESNOCANCEL or MB_TASKMODAL);
  case Tmp of
    IDYES    : Result := mrYes;
    IDNO     : Result := mrNo;
    else Result := mrCancel;
  end;
end;

function OkCancelMsg(const MsgText: string): Boolean;
begin
  Result := Application.MessageBox(PChar(MsgText), '',
    MB_ICONQUESTION or MB_OKCANCEL or MB_TASKMODAL) = IDOK;
end;

procedure ErrorRes(ResID: Word);
begin
  Screen.Cursor := crDefault;
  ErrorMsg(LoadStr(ResID));
end;

procedure ErrorResFrm(ResID: Word; Args: array of const);
begin
  Screen.Cursor := crDefault;
  ErrorMsg(LoadStr(ResID));
end;

function GetMax(X, Y: Integer): Integer;
begin
  if X > Y then Result := X else Result := Y;
end;

function GetMin(X, Y: Integer): Integer;
begin
  if X < Y then Result := X else Result := Y;
end;

function ExecError(ErrorNum: Longint): string;
begin
  case ErrorNum of
    0: Result := '   !';
    2: Result := '  ';
    3: Result := '  ';
    4: Result := '   ';
    5: Result := ' ';
    6: Result := '       ';
    8: Result := '   ';
    10: Result := '  WINDOWS';
    11: Result := ' ';
    12: Result := ' Windows ';
    13: Result := 'MS-DOS 4.0. ';
    14: Result := '  ';
    15: Result := '   (WINDOWS 3.0)';
    16: Result := '    ';
    19: Result := '   ';
    20: Result := '   ';
    21: Result := ' 32- ';
  else Result := ' !'
    {See help topic WinExec 3.0 , WinProcs unit}
  end;
end;

function Exec(const ProgramName, Params: string; ShowCode: Integer; Wait : boolean): string;
{$IFNDEF WIN32}
var Tmp: string;
    TaskHandle: THandle;
    ExecUsage: Word;
begin
  Tmp := Command + #32+ Params+ #0;
  TaskHandle := WinExec(@Tmp[1], ShowCode);
  if TaskHandle < 32 then begin
    Result := ExecError(TaskHandle);
    exit;
  end;
  if Wait then
   with Application do begin
     ExecUsage := GetModuleUsage(ExecHandle);
     MainForm.Visible := False;
     repeat
       ProcessMessages;
     until GetModuleUsage(TaskHandle) <> ExecUsage;
     MainForm.Visible := True;
   end;
end;
{$ELSE}
var ExecInfo: TShellExecuteInfo;
    {ExitCode: LongInt;}
    ExitCode : DWORD; {D4}
begin
  FillChar(ExecInfo, SizeOf(ExecInfo), 0);
  ExecInfo.cbSize := SizeOf(TShellExecuteInfo);
  with ExecInfo do begin
    fMask := SEE_MASK_NOCLOSEPROCESS;
    Wnd := Application.Handle;
    lpFile := PChar(ProgramName);
    lpParameters := PChar(Params);
    nShow := ShowCode;
  end;
  if ShellExecuteEx(@ExecInfo) then begin
    if Wait then
      repeat
        Application.ProcessMessages;
        GetExitCodeProcess(ExecInfo.hProcess, ExitCode);
      until (ExitCode <> STILL_ACTIVE) or Application.Terminated;
    Result := '';
  end
  else Result := ExecError(GetLastError);
end;
{$ENDIF}

function WindowsVerStr: string;
var
    {$IFNDEF WIN32}
    F, S: Byte;
    {$ELSE}
    Info : TOSVERSIONINFO;
    {$ENDIF}
begin
  {$IFNDEF WIN32}
  WindowsVer(F, S);
  if S > 11 then Result := IntToStr(S)
  else Result := IntToStr(F) + '.' + IntToStr(S);
  Result := 'Windows ' + Result;
  {$ELSE}
  Info.dwOSVersionInfoSize := SizeOf(TOSVERSIONINFO);
  GetVersionEx(Info);
  case Info.dwPlatformId of
    VER_PLATFORM_WIN32_WINDOWS: Result := 'Windows 95/98 '+StrPas(Info.szCSDVersion);
    VER_PLATFORM_WIN32_NT     : Result := 'Windows NT '+StrPas(Info.szCSDVersion);
  end;
  {$ENDIF}
end;

procedure WindowsVer;
var LVerW: Word;
    HVer, LVer: Byte;
begin
  LVerW := GetVersion and $FFFF; HVer := Hi(LVerW); LVer := Lo(LVerW);
  FirstNumb := LVer; SecondNumb := HVer;
end;

function ExtractFileNameOnly(FileName: string): string;
var P: Longint;
begin
  Result := ExtractFileName(Filename);
  P := Pos('.', Result); if P = 0 then P := Length(Result) + 1;
  System.Delete(Result, P, 4);
end;

function ExtractFile(S: string; N: Longint): string;
var I, J: Longint;
begin
  for I := 2 to N do begin
    J := Pos('+', S);
    if J = 0 then J := Length(S) + 1;
    Delete(S, 1, J);
  end;
  J := Pos('+', S);
  if J = 0 then J := Length(S) + 1;
  Result := Copy(S, 1, J - 1);
end;

function DefaultName: string;
begin
  Result := ExtractFileNameOnly(ParamStr(0)){+'.'};
end;

function GetEnvVar(Pattern: string): string;
var TPC: PChar;
  I: Longint;
  {$IFDEF WIN32}
  lpBuffer  : array [0..255] of char;
  VarResult : LongInt;
  {$ELSE}
  S: string;
  {$ENDIF}
  function NextEnvVar: string;
  begin
    Result := '';
    repeat Result := Result + TPC[I]; inc(I); until TPC[I] = #0;
    Result := AnsiUpperCase(Result); inc(I);
  end;
   begin
  Pattern := AnsiUpperCase(Pattern);
  {$IFNDEF Win32}
  TPC := GetDosEnvironment;
  I := 0;
  repeat
    S := NextEnvVar;
  until (TPC[I] = #0) or (Copy(S, 1, Pos('=', S) - 1) = Pattern);
  Result := Copy(S, Pos('=', S) + 1, 254);
  {$ELSE}
  Pattern := AnsiUpperCase(Pattern) + #0;
  VarResult := GetEnvironmentVariable(@Pattern[1], lpBuffer, 255);
  if VarResult > 0 then Result := StrPas(lpBuffer);
  {$ENDIF}
end;

procedure Delay(Pause: Longint; ProcessMessages: Boolean);
var FirstTick: Longint;
begin
  FirstTick := GetTickCount;
  repeat
    if ProcessMessages then Application.ProcessMessages;
  until GetTickCount - FirstTick >= Pause;
end;

{$IFNDEF WIN32}
function IsCDROM(DriveNum: Integer): Boolean; assembler;
asm
  MOV   AX,1500h { look for MSCDEX }
  XOR   BX,BX
  INT   2fh
  OR    BX,BX
  JZ    @Finish
  MOV   AX,150Bh { check for using CD driver }
  MOV   CX,DriveNum
  INT   2fh
  OR    AX,AX
  @Finish:
end;
{$ELSE}
function IsCDROM(DriveNum: Integer): Boolean;
begin
  Result := FindDriveType(DriveNum) = dtCDROM;
end;
{$ENDIF}

{$IFNDEF WIN32}
function IsRAMDrive(DriveNum: Integer): Boolean; assembler;
var
  TempResult: Boolean;
asm
  MOV   TempResult,False
  PUSH  DS
  MOV   BX,SS
  MOV   DS,BX
  SUB   SP,0200h
  MOV   BX,SP
  MOV   AX,DriveNum
  MOV   CX,1
  XOR   DX,DX
  INT   25h  { read boot sector }
  ADD   SP,2
  JC    @ItsNot
  MOV   BX,SP
  CMP   BYTE PTR SS:[BX+15h],0F8h  { reverify fixed disk }
  JNE   @ItsNot
  CMP   BYTE PTR SS:[BX+10h],1  { check for single FAT }
  JNE   @ItsNot
  MOV   TempResult,True
  @ItsNot:
  ADD   SP,0200h
  POP   DS
  MOV   AL, TempResult
end;
{$ELSE}
function IsRAMDrive(DriveNum: Integer): Boolean;
begin
  Result := FindDriveType(DriveNum) = dtRAM;
end;
{$ENDIF}

function FindDriveType(DriveNum: Integer): TDriveType;
{$IFDEF WIN32}
var DriveChar : char;
{$ENDIF}
begin
  {$IFNDEF WIN32}
  Result := TDriveType(GetDriveType(DriveNum));
  if (Result = dtFixed) or (Result = dtNetwork) then begin
    if IsCDROM(DriveNum) then Result := dtCDROM
    else if (Result = dtFixed) then begin
      { do not check for RAMDrive under Windows NT }
      if ((GetWinFlags and $4000) = 0) and IsRAMDrive(DriveNum) then
        Result := dtRAM;
    end;
  end;
  {$ELSE}
  DriveChar := Char(DriveNum + Ord('a'));
  Result := TDriveType(GetDriveType(PChar(DriveChar + ':\')));
  {$ENDIF}
end;

function VolumeID(DriveChar: Char): string;
{$IFNDEF WIN32}
var
  SearchMask  : string[7];
  SearchRec   : TSearchRec;
  DotPos      : Byte;
  OldErrorMode: Word;
begin
  OldErrorMode := SetErrorMode(SEM_FAILCRITICALERRORS);
  try
    SearchMask := 'c:\*.*';
    SearchMask[1] := DriveChar;
    if FindFirst(SearchMask, faVolumeID, SearchRec) = 0 then begin
      Result := SearchRec.name;
      DotPos := Pos('.', Result);
      if DotPos <> 0 then
        System.Delete(Result, DotPos, 1);
      if DriveChar < 'a' then
        Result := ': [' + AnsiUpperCase(Result) + ']'
      else
        Result := ': [' + AnsiLowerCase(Result) + ']'
    end
    else Result := '';
    {    !}
  finally
    SetErrorMode(OldErrorMode);
  end;
end;
{$ELSE}
var
  {
  OldErrorMode: Integer;
  NotUsed, VolFlags: Integer;
  }
  OldErrorMode: DWORD; {D4}
  NotUsed, VolFlags: DWORD; {D4}
  Buf: array [0..MAX_PATH] of Char;
begin
  OldErrorMode := SetErrorMode(SEM_FAILCRITICALERRORS);
  try
    Buf[0] := #$00;
    if GetVolumeInformation(PChar(DriveChar + ':\'), Buf, sizeof(Buf),
      nil, NotUsed, VolFlags, nil, 0) then
      SetString(Result, Buf, StrLen(Buf))
    else Result := '';
    if DriveChar < 'a' then
      Result := AnsiUpperCaseFileName(Result)
    else
      Result := AnsiLowerCaseFileName(Result);
    Result := Format('[%s]',[Result]);
  finally
    SetErrorMode(OldErrorMode);
  end;
end;
{$ENDIF}

function NetworkVolume(DriveChar: Char): string;
{$IFNDEF WIN32}
const
  LocalName: array[0..2] of Char = 'D:'#0;
var
  {BufferSize: Integer;}
  BufferSize: DWORD; {D4}
  TempName  : array[0..128] of Char;
begin
  LocalName[0] := DriveChar;
  BufferSize := SizeOf(TempName) - 1;
  if WNetGetConnection(LocalName, TempName, @BufferSize) = WN_SUCCESS then begin
    if DriveChar < 'a' then
      Result := ': ' + AnsiUpperCase(StrPas(TempName))
    else
      Result := ': ' + AnsiLowerCase(StrPas(TempName));
  end
  else
    Result := VolumeID(DriveChar);
end;
{$ELSE}
var
  Buf: Array [0..MAX_PATH] of Char;
  DriveStr: array [0..3] of Char;
  {$IFDEF Delphi3}
  BufferSize: Integer;
  {$ELSE}
  BufferSize: DWORD;
  {$ENDIF}
begin
  BufferSize := sizeof(Buf);
  DriveStr[0] := UpCase(DriveChar);
  DriveStr[1] := ':';
  DriveStr[2] := #0;
  if WNetGetConnection(DriveStr, Buf, BufferSize) = WN_SUCCESS then
  begin
    SetString(Result, Buf, BufferSize);
    if DriveChar < 'a' then
      Result := AnsiUpperCaseFileName(Result)
    else
      Result := AnsiLowerCaseFileName(Result);
  end
  else
    Result := VolumeID(DriveChar);
end;
{$ENDIF}

{$IFDEF Win32}
function SmallToPoint(Point: TSmallPoint): TPoint;
begin
  Result.X := Point.X;
  Result.Y := Point.Y;
end;
{$ENDIF}

{         TsohoTabSet }
procedure DoHorRect(Canvas: TCanvas; AlignTop: Boolean; Rect: TRect; TopColor, BottomColor: TColor);
var TopRight, BOTTOMLEFT: TPoint;
begin
  with Canvas, Rect do begin
    TopRight.X := Right;
    TopRight.Y := Top;
    BOTTOMLEFT.X := Left;
    BOTTOMLEFT.Y := Bottom;
    Pen.Color := TopColor;
    if AlignTop then Polyline([BOTTOMLEFT, TopLeft, TopRight])
    else Polyline([BOTTOMLEFT, TopLeft]);
    Pen.Color := BottomColor;
    dec(BOTTOMLEFT.X);
    if AlignTop then Polyline([TopRight, BottomRight])
    else Polyline([TopRight, BottomRight, BOTTOMLEFT]);
  end;
end;

{         TsohoTabSet }
procedure DoVertRect(Canvas: TCanvas; AlignLeft: Boolean; Rect: TRect;
    TopColor, BottomColor: TColor);
var TopRight, BOTTOMLEFT: TPoint;
begin
  with Canvas, Rect do begin
    TopRight.X := Right;
    TopRight.Y := Top;
    BOTTOMLEFT.X := Left;
    BOTTOMLEFT.Y := Bottom;
    Pen.Color := TopColor;
    if AlignLeft then Polyline([BOTTOMLEFT, TopLeft, TopRight])
    else Polyline([TopLeft, TopRight]);
    Pen.Color := BottomColor;
    dec(BOTTOMLEFT.X);
    if AlignLeft then Polyline([BOTTOMLEFT, BottomRight])
    else Polyline([BOTTOMLEFT, BottomRight, TopRight]);
  end;
end;

function VertCenter(Rect: TRect; Height: Integer): Integer;
begin
  Result := Rect.Top + trunc((Rect.Bottom - Rect.Top - Height) / 2);
end;

function HorCenter(Rect: TRect; Width: Integer): Integer;
begin
  Result := Rect.Left + trunc((Rect.Right - Rect.Left - Width) / 2);
end;

procedure AdjustColors(Bevel: TPanelBevel; var TopColor, BottomColor: tColor;
    HighLightColor, ShadowColor: tColor);
begin
  TopColor := HighLightColor;
  if Bevel = bvLowered then TopColor := ShadowColor;
  BottomColor := ShadowColor;
  if Bevel = bvLowered then BottomColor := HighLightColor;
end;

function ResString(StrId: Word): string;
begin
  Result := LoadStr(StrId);
end;

function ResBitmap;
var tmp: string;
begin
  tmp := BitMapName + #0;
  Result := LoadBitmap(HInstance, @tmp[1]);
end;

function ResCursor;
var tmp: string;
begin
  tmp := CursorName + #0;
  Result := LoadCursor(HInstance, @tmp[1]);
end;

procedure WrapTextInRect(Canvas: TCanvas; const Text: string; Rect: TRect;
  TextAlign: TAlignment);
const Aligns: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
var PText: array[0..256] of Char;
  Flags: Word;
  Leng : Integer;
begin
  Flags := Aligns[TextAlign];
  StrPCopy(PText, Text);
  Leng := Length(Text);
  DrawText(Canvas.Handle, PText, Leng, Rect, Flags or DT_WORDBREAK);
end;

procedure TextInRect;
const Aligns: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
var PText: array[0..256] of Char;
  Flags: Word;
  Leng : Integer;
begin
  Flags := Aligns[TextAlign];
  StrPCopy(PText, Text);
  Leng := Length(Text);
  DrawText(Canvas.Handle, PText, Leng, Rect, Flags);
end;

procedure AngleTextInRect;
var PText: array[0..256] of Char;
  {Flags     : word;                 }
  Leng       : Integer;              
  VertFont,
    OldFont  : HFONT;                
  FontName   : array[0..256] of Char;
  lf         : TLogFont;             
begin
  {Flags := DT_LEFT;}
  StrPCopy(PText, Text);
  Leng := Length(Text);
  StrPCopy(FontName, Canvas.Font.name);
  with lf, Canvas do begin
    {  ,  }
    lfHeight := Font.Height;
    lfWidth := 0;
    lfEscapement := Angle * 10; {    0.1 }
    lfOrientation := 0 {90*10}; {    }
    if fsBold in Font.Style then lfWeight := FW_BOLD
    else lfWeight := FW_NORMAL;
    lfItalic := Byte(fsItalic in Font.Style);
    lfUnderline := Byte(fsUnderline in Font.Style);
    lfStrikeOut := Byte(fsStrikeOut in Font.Style);
    lfCharSet := DEFAULT_CHARSET;
    StrPCopy(lfFaceName, Font.name);
    lfQuality := DEFAULT_QUALITY;
    lfOutPrecision := OUT_DEFAULT_PRECIS;
    lfClipPrecision := CLIP_DEFAULT_PRECIS;
    lfPitchAndFamily := DEFAULT_PITCH;
  end;
  VertFont := CreateFontIndirect(lf);
  OldFont := SelectObject(Canvas.Handle, VertFont);
  ExtTextOut(Canvas.Handle, X, Y, ETO_CLIPPED, @Rect,
    PText, Leng, nil);
  SelectObject(Canvas.Handle, OldFont);
  DeleteObject(VertFont);
end;

{     ,     }
function GetStrWidth(DC: HDC; const Value: string): Integer;
var tmp: string;
  {$IFDEF Win32}
  aSize : TSize;
  {$ELSE}
  TmpInt: Longint;
  {$ENDIF}
begin
  Result := 0;
  tmp := Value + #0;
  {$IFNDEF Win32}
  TmpInt := GetTextExtent(DC, @tmp[0], Length(tmp));
  Result := LongRec(TmpInt).Lo;
  {$ELSE}
  if not GetTextExtentPoint32(DC, @tmp, Length(tmp) - 1, aSize) then exit;
  Result := aSize.cx;
  {$ENDIF}
end;

{     ,     }
function GetStrHeight(DC: HDC; const Value: string): Integer;
var tmp: string;
  {$IFDEF Win32}
  aSize : TSize;
  {$ELSE}
  TmpInt: Longint;
  {$ENDIF}
begin
  Result := 0;
  tmp := Value + #0;
  {$IFNDEF Win32}
  TmpInt := GetTextExtent(DC, @tmp[0], Length(tmp));
  Result := LongRec(TmpInt).Hi;
  {$ELSE}
  if not GetTextExtentPoint32(DC, @tmp, Length(tmp) - 1, aSize) then exit;
  Result := aSize.cy;
  {$ENDIF}
end;

procedure DrawBitmapInRect(Canvas: TCanvas; Rect: TRect; Bitmap: TBitmap);
var X, Y: Integer;
begin
  with Canvas do begin
    X := (Rect.Right - Rect.Left - Bitmap.Width) div 2 + Rect.Left;
    Y := (Rect.Bottom - Rect.Top - Bitmap.Height) div 2 + Rect.Top;
    BrushCopy(Classes.Rect(X, Y, X + Bitmap.Width, Y + Bitmap.Height), Bitmap,
      Classes.Rect(0, 0, Bitmap.Width, Bitmap.Height), clBlack);
  end;
end;

procedure DrawResBitmapInRect(Canvas: TCanvas; Rect: TRect; const BitMapName: string);
var X, Y: Integer;
  Bitmap: TBitmap;
begin
  with Canvas do begin
    Bitmap := TBitmap.Create;
    Bitmap.Handle := ResBitmap(BitMapName);
    X := (Rect.Right - Rect.Left - Bitmap.Width) div 2 + Rect.Left;
    Y := (Rect.Bottom - Rect.Top - Bitmap.Height) div 2 + Rect.Top;
    BrushCopy(Classes.Rect(X, Y, X + Bitmap.Width, Y + Bitmap.Height), Bitmap,
      Classes.Rect(0, 0, Bitmap.Width, Bitmap.Height), clBlack);
    Bitmap.Free;
  end;
end;

{$IFNDEF WIN32}
function EnumFunc(Wnd: HWND; TargetWindow: PHWND): BOOL;
var ClassName: array[0..30] of Char;
begin
  Result := True;
  if GetWindowWord(Wnd, GWW_HINSTANCE) = HPrevInst then begin
    GetClassName(Wnd, ClassName, 30);
    if StrIComp(ClassName, 'TApplication') = 0 then begin
      TargetWindow^ := Wnd;
      Result := False;
    end;
  end;
end;

procedure GotoPreviousInstance;
var PrevInstWnd: HWND;
begin
  PrevInstWnd := 0;
  EnumWindows(@EnumFunc, Longint(@PrevInstWnd));
  if PrevInstWnd <> 0 then
    if IsIconic(PrevInstWnd) then SHOWWINDOW(PrevInstWnd, SW_RESTORE)
    else BringWindowToTop(PrevInstWnd);
end;
{$ENDIF}

function GetControlColor(AControl: TControl): TColor;
begin
  Result := clBtnFace;
  if (AControl <> nil) then Result := THackControl(AControl).FColor;
end;

function GetControlFont(AControl: TControl): tFont;
begin
  Result := nil;
  if AControl <> nil then Result := THackControl(AControl).FFont;
end;

function GetParentColor(AControl: TControl): TColor;
begin
  if AControl.Parent = nil then Result := GetControlColor(AControl)
  else Result := GetControlColor(AControl.Parent);
end;

function GetParentFont(AControl: TControl): tFont;
begin
  if AControl.Parent = nil then Result := GetControlFont(AControl)
  else Result := GetControlFont(AControl.Parent);
end;

procedure SetControlFont(AControl: TControl; AFont: tFont);
begin
  if (AControl <> nil) and (AFont <> nil) then begin
    THackControl(AControl).FFont.Assign(AFont);
    AControl.Repaint;
  end;
end;

procedure SetControlColor(AControl: TControl; aColor: TColor);
begin
  if AControl <> nil then begin
    THackControl(AControl).FColor := aColor;
    AControl.Repaint;
  end;
end;

function GetOwnerForm(AComponent: TComponent): TForm;
var tmp: TComponent;
begin
  tmp := AComponent;
  while (not (tmp.Owner is TForm))
    and (tmp.Owner <> nil) do tmp := tmp.Owner;
  Result := Pointer(tmp.Owner);
end;

function FormExists (CheckForm : TForm) : boolean;
var Index : integer;
begin
  Result := (CheckForm <> nil);
  if not Result then exit;
  for Index := 0 to pred(Screen.FormCount) do
    if Screen.Forms[Index] = CheckForm then exit;
  Result := false;
end;

procedure SetComponentState(AComponent: TComponent; State: TComponentState);
begin
  THackComponent(AComponent).FComponentState := State;
end;

function FindForm(Pos: TPoint): TForm;
var index: Integer;
  Rect: TRect;
begin
  Result := nil;
  with Screen do
    for index := 0 to FormCount - 1 do begin
      Result := Forms[index];
      Rect := Result.BoundsRect;
      if PtInRect(Rect, Pos) then exit;
    end;
end;

function FindComponentOnForm(Pos: TPoint; Form: TForm; CanBeForm: Boolean): TComponent;
var index: Integer;
  Component: TComponent;
  Rect     : TRect;     
  DesInfo  : Longint;
  CompPos  : TPoint;
begin
  with Form do begin
    for index := 0 to ComponentCount - 1 do begin
      Component := Components[index];
      if (Component is TControl) or (Component.DesignInfo = 0) then Continue;
      DesInfo := Component.DesignInfo;
      {$IFNDEF Win32}
      CompPos := TPoint(DesInfo);
      {$ELSE}
      CompPos := SmallToPoint(TSmallPoint(DesInfo));
      {$ENDIF}
      CompPos := ClientToScreen(CompPos);
      with CompPos do Rect := Bounds(X, Y, 26, 26);
      if PtInRect(Rect, Pos) then begin
        Result := Component;
        exit;
      end;
    end;
    Result := FindDragTarget(Pos, True);
    if (Result = Form) and not (CanBeForm) then begin
      Result := nil;
      exit;
    end;
  end;
end;

function ComponentByName;
var I: Longint;
begin
  with TForm(Form) do
    for I := 0 to ComponentCount - 1 do
      if Components[I].name = AName then begin
        Result := Components[I];
        exit;
      end;
  Result := nil;
end;

function ClickAssigned(AControl: TControl): Boolean;
begin
  Result := Assigned(THackControl(AControl).FOnClick);
end;

procedure RunTimeRegisterComponents(Owner: TComponent);
var index: Integer;
begin
  for index := 0 to Owner.ComponentCount - 1 do
    RegisterClass(TPersistentClass(Owner.Components[index].ClassType));
end;

function CreateComponentByClassName(const ClassName: string;
    Owner: TComponent): TComponent;
begin
  Result := TComponentClass(FindClass(ClassName)).Create(Owner);
end;

{ Arithmetic }
function Round(Value: Extended): Longint;
begin
  if Value > 0 then Result := trunc(Value + 0.5)
  else Result := trunc(Value - 0.5);
end;

procedure FilesToStrings(List: TStringList; const Path: string; Attr: Integer);
var F: TSearchRec;
  ErrorCode: Integer;
begin
  with List do begin
    ErrorCode := FindFirst(Path, Attr, F);
    if ErrorCode <> 0 then begin
      FindClose(F);
      exit;
    end;
    Clear;
    repeat
      Add(F.name);
      ErrorCode := FindNext(F);
    until ErrorCode <> 0;
    FindClose(F);
  end;
end;

{ Menus }
function CopyMenuItem(Owner: TComponent; FromItem: TMenuItem): TMenuItem;
var SubItem : TMenuItem;
    Index : LongInt;
begin
  Result := TMenuItem.Create(Owner);
  with Result do begin
    break := FromItem.break;
    Caption := FromItem.Caption;
    checked := FromItem.checked;
    {$IFDEF Win32}
    Default := FromItem.Default;
    MenuIndex := FromItem.MenuIndex;
    RadioItem := FromItem.RadioItem;
    {$ENDIF}
    Enabled := FromItem.Enabled;
    GroupIndex := FromItem.GroupIndex;
    HelpContext := FromItem.HelpContext;
    Hint := FromItem.Hint;
    ShortCut := FromItem.ShortCut;
    Visible := FromItem.Visible;
    OnClick := FromItem.OnClick;
    Tag     := FromItem.Tag;
    if FromItem.Count>0 then
      for Index := 0 to pred(FromItem.Count) do begin
          SubItem := CopyMenuItem(Owner, FromItem.Items[Index]);
          Result.Add(SubItem);
      end;
  end;
end;

function MakeDirectory(Dir: string): Boolean;
var SubDir: string;
begin
  {$i-}
  if Dir[Length(Dir)] = '\' then Dir := Copy(Dir, 1, Length(Dir) - 1);
  MkDir(Dir); {  ?}
  case IOResult of
    0: Result := True; {-, !!!}
    3: begin {,       }
       SubDir := Dir;
       {For Delphi 2,3 use Subdir:=Copy(Subdir ...) or other cases}
       while (SubDir <> '') and (SubDir[Length(SubDir)] <> '\') do
         SubDir := DecLength(SubDir, 1);
       Result := MakeDirectory(SubDir);
       if Result then MkDir(Dir); { -  !}
       Result := (IOResult = 0)
    end;
    5, 183: Result := True; { ,   }
    else begin
    {   -  }
    InfoMsg('  ' + Dir);
    Result := False;
    end;
  end;
end;

function CopyFiles;
type TBuffer = array[1..1024 * 4] of Byte;
var Buffer:^TBuffer;
  DirFrom, FileFrom, DirTo, FileTo: string[128];
  {Exist                          :Boolean;     }
  SR                              : TSearchRec;
  FF, FT                          : file;
  {$IFDEF WIN32}
  Size                            : Integer;    
  {$ELSE}
  Size                            : Word;       
  {$ENDIF}
  Error                           : string[80]; 
  label Finish;                                 

begin
  Result := False; Error := ''; Buffer := nil;
  DirFrom := ExtractFilePath(FromName);
  DirTo := ExtractFilePath(ToName);
  FileFrom := ExtractFileName(FromName);
  if FileFrom = '' then FileFrom := '*.*';
  FileTo := ExtractFileName(ToName);
  if FileTo = '' then FileTo := '*.*';

  { }
  if FindFirst(DirFrom + FileFrom, faAnyFile, SR) <> 0 then begin
    Error := '  ' + DirFrom + FileFrom;
    goto Finish;
  end;
  {$i-}
  {  }
  if not MakeDirectory(DirTo) then begin
    Error := '   ' + DirTo;
    goto Finish;
  end;
  {$IFDEF Delphi3}
  InOutRes := 0;
  {$ELSE}
  SetInOutRes(0); {D4 -   }
  {$ENDIF}

  { }
  if DirFrom + FileFrom = DirTo + FileTo then begin
    Error := '   ' + DirFrom + FileFrom;
    goto Finish; {   }
  end;
  if FileFrom = '*.*' then
    if (DirFrom <> '') and (Pos(DirFrom, DirTo) <> 0) then begin
      Result := False;
      Error := DirFrom + FileFrom + ' -  .  !';
      goto Finish;
    end;
  
  
  if (Pos('*', FileFrom) <> 0) and (Pos('*', FileTo) = 0) then begin
    Error := '    ' + DirFrom + FileFrom + '=>' + DirTo + FileTo;
    goto Finish; { 
        }
  end;
  { }
  {   -  ,  }
  Result := True; {,  }
  if Pos('*', FileFrom) = 0 then begin
    AssignFile(FF, DirFrom + FileFrom);
    FileMode := $40; {Shared and Read Only!}
    Reset(FF, 1);
    FileMode := 2; {Monopolize and Full Access}
    Result := Result and (IOResult = 0);
    if not Result then begin
      Error := '  ' + DirFrom + FileFrom;
      goto Finish; {     }
    end;
    if Pos('*', FileTo) = 0
      then AssignFile(FT, DirTo + FileTo)
    else AssignFile(FT, DirTo + FileFrom);
    Rewrite(FT, 1);
    Result := Result and (IOResult = 0);
    if not Result then begin
      Error := '  ' + DirTo + FileTo;
      goto Finish; {     }
    end;
    {  }
    New(Buffer);
    repeat
      System.BlockRead(FF, Buffer^, SizeOf(TBuffer), Size);
      Result := Result and (IOResult = 0);
      if not Result then begin
        Error := '  ' + DirFrom + FileFrom;
        goto Finish; {     }
      end;
      BlockWrite(FT, Buffer^, Size);
      Result := Result and (IOResult = 0);
      if not Result then begin
        Error := ' ' + DirTo + FileTo;
        goto Finish; {     }
      end;
    until Size <> SizeOf(TBuffer);
    FileSetDate(TFileRec(FT).Handle, FileGetDate(TFileRec(FF).Handle));
    CloseFile(FF);
    CloseFile(FT);
    {  }
    if Erase then SysUtils.DeleteFile(DirFrom + FileFrom);
  end {if * then}
  else begin {      ,
        }
    FindFirst(DirFrom + FileFrom, faAnyFile, SR);
    repeat
      if (SR.name[1] <> '.') then
        if (SR.Attr and faDirectory <> 0)
          then Result := Result and CopyFiles(DirFrom + SR.name + '\' + FileFrom, DirTo + SR.name + '\*', Erase)
        else Result := Result and CopyFiles(DirFrom + SR.name, DirTo + SR.name, Erase);
      if not Result then goto Finish;
    until FindNext(SR) <> 0;
  end {if * else};
Finish:
  {$IFDEF Delphi3}
  InOutRes := 0;
  {$ELSE}
  SetInOutRes(0); {D4 -   }
  {$ENDIF}
  if Buffer <> nil then Dispose(Buffer);
  if not Result then if Error <> '' then InfoMsg(Error);
end;

function GetRunDir: string;
begin
  Result := ExtractFilePath(ParamStr(0));
  if Result = '' then GetDir(0, Result);
  if Result[Length(Result)] <> '\' then Result := Result + '\';
end;

procedure HideApplication;
begin
  Application.Minimize;
  SHOWWINDOW(Application.Handle, SW_HIDE);
end;

function GetPathToTemp: string;
{$IFDEF Win32}
var Buffer: array[0..255] of Char;
begin
  GetTempPath(255, Buffer);
  Result := StrPas(Buffer);
  if Result[Length(Result)] <> '\' then Result := Result + '\';
end;
{$ELSE}
begin
  Result := GetEnvVar('TMP');
  if Result = '' then Result := GetEnvVar('TEMP');
end;
{$ENDIF}

function GetPathToLocalTemp: string;
begin
  Result := ExtractFileNameOnly(ParamStr(0));
  Result := GetPathToTemp+Result+'\';

  if not DirectoryExists(Result) then MakeDirectory(Result);
end;

procedure StandartAboutBox(const ProductName, Comments: string);
var Wnd: HWnd;
    AppIcon: HIcon;
begin
  Wnd := 0;
  if Application.MainForm <> nil then Wnd := Application.MainForm.Handle;
  AppIcon := Application.Icon.Handle;
  if AppIcon = 0 then AppIcon := LoadIcon(0, IDI_APPLICATION);
  ShellAbout(Wnd, PChar(ProductName), PChar(Comments), AppIcon);
end;

function NormalDir (const DirName : string) : string;
begin
  Result := DirName;
  if Result[length(Result)]<>'\' then Result := Result + '\';
end;

function TextFileToStr (const FileName : string) : string;
var FileText : TStringList;
begin
  Result := '';
  if not FileExists(FileName) then exit;
  FileText := TStringList.Create;
  FileText.LoadFromFile(FileName);
  Result := FileText.Text;
  FileText.Free;
end;

function StrToTextFile (const FileName, Text : string) : boolean;
var FileText : TStringList;
begin
  Result := false;
  if not DirectoryExists(ExtractFilePath(FileName)) then exit;
  FileText := TStringList.Create;
  FileText.Text := Text;
  try
    FileText.SaveToFile(FileName);
    Result := true;
  except
    on E: Exception do ErrorMsg(E.Message);
  end;
  FileText.Free;
end;

function FindMenuItemByTag (Menu : TComponent; FindTag : LongInt) : TMenuItem;

  function CheckItem (Item : TMenuItem) : TMenuItem;
  var Index : LongInt;
  begin
    Result := nil;
    if Item.Tag = FindTag then Result := Item
    else
      if Item.Count>0 then
        for Index := 0 to pred(Item.Count) do begin
          Result := CheckItem(Item.Items[Index]);
          if Result <> nil then exit;
        end;
  end;

var aIndex : LongInt;

begin
  Result := nil;
  if Menu is TMainMenu then
    with (Menu as TMainMenu) do begin
      for aIndex := 0 to pred(Items.Count) do begin
        Result := CheckItem(Items[aIndex]);
        if Result <> nil then exit;
      end;
    end
  else
    if Menu is TPopupMenu then
      with (Menu as TPopupMenu) do begin
        for aIndex := 0 to pred(Items.Count) do begin
          Result := CheckItem(Items[aIndex]);
          if Result <> nil then exit;
        end;
      end
    else
      if Menu is TMenuItem then
        with (Menu as TMenuItem) do begin
          for aIndex := 0 to pred(Count) do begin
            Result := CheckItem(Items[aIndex]);
            if Result <> nil then exit;
          end;
        end
end;

procedure MenuItemRightAlign (Menu : TMainMenu; Item : TMenuItem);
var MenuInfo : TMENUITEMINFO;
begin
  with MenuInfo do begin
   cbSize := SizeOf(MenuInfo);
   fMask  := MIIM_TYPE;
   fType  := MFT_RIGHTJUSTIFY;
   wId    := Item.Command;
   hSubMenu   := 0;
   dwTypeData :=  PChar(Item.Caption);
   cch := length(Item.Caption);
  end;
  SetMenuItemInfo(Menu.Handle, Item.Command, FALSE, MenuInfo);
end;

var CursorsList : TsohoIntegerList;

procedure RestoreCursor;
begin
  if CursorsList.Count>0 then begin
    Screen.Cursor := TCursor(CursorsList[CursorsList.Count-1]);
    CursorsList.Delete(CursorsList.Count-1);
  end
  else Screen.Cursor := crDefault;
end;

procedure SetCursor (aCursor : TCursor);
begin
  CursorsList.Add(Screen.Cursor);
  Screen.Cursor := aCursor;
end;

var PrevLayout, NewLayout : HKL;
    LayoutRestored : boolean;

procedure RestoreLayout;
begin
  LayoutRestored := true;
  ActivateKeyboardLayout(PrevLayout, HKL_NEXT);
end;

procedure SwitchToRussian;
begin
  if not LayoutRestored then RestoreLayout;
  PrevLayout := GetKeyboardLayout(0);
  NewLayout  := LoadKeyboardLayout('00000419', KLF_ACTIVATE);
end;

procedure SwitchToEnglish;
begin
  if not LayoutRestored then RestoreLayout;
  PrevLayout := GetKeyboardLayout(0);
  NewLayout  := LoadKeyboardLayout('00000409', KLF_ACTIVATE);
end;

procedure SetCursorPos(Memo : TMemo; XPos, YPos : integer);
var Index, Selection : integer;
begin
  if (XPos <= 0) or (XPos > 300) or
     (YPos <= 0) or (YPos > Memo.Lines.Count) then exit;
  Selection := 0;
  with Memo do begin
    for Index := 1 to YPos - 1 do
      Selection := Selection + length(Lines[Index-1]) + 2;
    Selection := Selection + XPos - 1;
    SetFocus;
    SelStart := Selection;
    SelLength := 0;
  end;
end;

initialization
  CursorsList := TsohoIntegerList.Create;
  LayoutRestored := true;
finalization
  CursorsList.Free;
end.

