{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                Written by Allex, MVL                  }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoUsers;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, DB, DBTables, Grids, SoUnit, SoUsCard, SoSDlgs, IniFiles,
  SoDBGrid, SoFolder, Menus, SohoBtns, RXDBCtrl, DBGrids, StdCtrls,
  ExtCtrls;

type
  TUserF = class(TForm)
    Panel1: TPanel;
    Query2: TQuery;
    Query3: TQuery;
    WizDirectoryDialog1: TsohoDirectoryDialog;
    SOwwDBGrid1: TsohoDBGrid;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    SoFolder1: TsohoFolder;
    sohoBitBtn1: TsohoBitBtn;
    sohoBitBtn2: TsohoBitBtn;
    sohoBitBtn3: TsohoBitBtn;
    sohoBitBtn4: TsohoBitBtn;
    Query1: TQuery;
    DataSource1: TDataSource;
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SOwwDBGrid1KeyDown(Sender: TObject; var KEY: Word;
      Shift: TShiftState);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  UserF: TUserF;

implementation
uses SoUtils, SoCtmRgs;

{$R *.DFM}

procedure TUserF.BitBtn3Click(Sender: TObject);
var Well: boolean;
begin
  Query2.DataBaseName := Query1.DataBaseName;
  Query2.Params[0].AsInteger := Query1.FieldByName('ID').AsInteger;
  with Query1 do begin
    Well := True;
    Well := Well and (StrToSet(FieldByName('Action').AsString) <= SingleRegister.ActionRights);
    Well := Well and (StrToSet(FieldByName('ReadR').AsString) <= SingleRegister.DataReadRights);
    Well := Well and (StrToSet(FieldByName('WriteR').AsString) <= SingleRegister.DataWriteRights);
  end;
  if Well then begin
    Query1.Close;
    Query2.ExecSql;
    Query1.Open;
  end
  else InfoMsg(' ,  !');
end;

procedure TUserF.BitBtn2Click(Sender: TObject);
var ID: Longint;
begin
  ID := GetNewID('USER');
  Query3.DataBaseName := Query1.DataBaseName;
  Query3.Params[0].AsInteger := ID;
  Query3.Params[1].AsDateTime := Now;
  Query3.Params[2].AsInteger := SingleRegister.UserID;
  Query1.Close;
  Query3.ExecSql;
  Query1.Open;
  while (Query1.FieldByName('ID').AsInteger <> ID) do Query1.Next;
  BitBtn1Click(Sender)
end;

procedure TUserF.BitBtn1Click(Sender: TObject);
begin
  Query1.DisableControls;
  UserCardF := TUserCardF.Create(Self);
  UserCardF.ShowModal;
  UserCardF.Free;
  {SoFolder1.Apply;} {- }
  Query1.EnableControls;
end;

procedure TUserF.BitBtn4Click(Sender: TObject);
begin
  Query1.Close;
  Close;
end;

procedure TUserF.FormCreate(Sender: TObject);
var Ini: TIniFile;
  TempForm: TForm;
begin
  Ini := TIniFile.Create(ExtractFilePath(ParamStr(0)) + 'Soho.ini');
  WizDirectoryDialog1.Directory := Ini.ReadString
    ('Password', 'Directory', ExtractFilePath(ParamStr(0)));
  Ini.Free;
  with Query1 do
    repeat
      try
        DataBaseName := WizDirectoryDialog1.Directory;
        SoFolder1.FolderDir := WizDirectoryDialog1.Directory;
        Open;
      except
        if not WizDirectoryDialog1.Execute
          then begin Close; {   } Exit end;
      end;
    until Active;

  Query1.Close;
  { SoFolder1.Activate;}
  TempForm := Self;
  Query1.Open;
end; {proc}

procedure TUserF.SOwwDBGrid1KeyDown(Sender: TObject; var KEY: Word;
    Shift: TShiftState);
begin
  if KEY = VK_DELETE then BitBtn3Click(Sender);
  if KEY = VK_INSERT then BitBtn2Click(Sender);
  if KEY = VK_RETURN then BitBtn1Click(Sender);
end;

procedure TUserF.FormDestroy(Sender: TObject);
var TempForm: TForm;
begin
  TempForm := Self;
  Query1.Close;
end;

end.

