{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                Written by Allex, MVL                  }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoUsCard;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, Dialogs, StdCtrls, DB, Mask, DBCtrls, Buttons, DBTables, SoSDlgs,
     SoUnit, SoCtmRgs, SoTools, SohoBtns, SoCtrls, Placemnt, SoRxTls;

type
  TUserCardF = class(TForm)
    PasswordE: TsohoEdit;
    WriteE: TsohoEdit;
    ReadE: TsohoEdit;
    ActionE: TsohoEdit;
    UserNameE: TsohoEdit;
    Query1: TQuery;
    WizDirectoryDialog1: TsohoDirectoryDialog;
    sohoLabel1: TsohoLabel;
    sohoLabel2: TsohoLabel;
    sohoLabel3: TsohoLabel;
    sohoLabel4: TsohoLabel;
    sohoLabel5: TsohoLabel;
    OkB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    sohoEnterTab1: TsohoEnterTab;
    sohoLabel6: TsohoLabel;
    ShortNameE: TsohoEdit;
    CommentE: TsohoEdit;
    DataLevelE: TsohoEdit;
    sohoLabel7: TsohoLabel;
    sohoLabel8: TsohoLabel;
    sohoLabel9: TsohoLabel;
    DataPasswordE: TsohoEdit;
    UserIni: TsohoFormStorage;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure ActionEExit(Sender: TObject);
    procedure ReadEExit(Sender: TObject);
    procedure WriteEExit(Sender: TObject);
    procedure UserNameEExit(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var UserCardF: TUserCardF;

implementation
uses SoUsers, SohoPswU;

{$R *.DFM}

procedure TUserCardF.FormCreate(Sender: TObject);
var SR:TsohoCustomRegister;
begin
 with UserF.Query1 do begin
   UserNameE.Text:=FieldByName('UserName').AsString;
   ActionE.Text:=FieldByName('Action').AsString;
   ReadE.Text:=FieldByName('ReadR').AsString;
   WriteE.Text:=FieldByName('WriteR').AsString;
   CommentE.Text:=FieldByName('Comment').AsString;
   ShortNameE.Text:=FieldByName('ShortName').AsString;
   DataLevelE.AsInteger:=FieldByName('DataLevel').AsInteger;
   PasswordE.Text:='';
 end;

 SR := SingleRegister;
 if SR=nil then Close;
 with SR,OkB do begin
  Visible:=True;
  Visible:=Visible and (StrToSet(ActionE.Text) <= ActionRights);
  Visible:=Visible and (StrToSet(ReadE.Text) <= DataReadRights);
  Visible:=Visible and (StrToSet(WriteE.Text) <= DataWriteRights);
 end;
end;

procedure TUserCardF.BitBtn1Click(Sender: TObject);
var ID:Longint;
begin
 with Query1,SQL do begin
  DataBaseName:=UserF.Query1.DataBaseName;
  Clear;
  Add('Update "sopswrd.db" ');
  Add('Set ');
  Add('PasswordR=0,');
  Add('UserName="'+UserNameE.Text+'",');
  Add('Action="'+ActionE.Text+'",');
  Add('ReadR="'+ReadE.Text+'",');
  Add('WriteR="'+WriteE.Text+'",');
  Add('Comment="'+CommentE.Text+'",');
  Add('DataLevel='+DataLevelE.AsString+',');
  Add('ShortName="'+ShortNameE.Text+'"');
  Add('Where ID='+UserF.Query1.FieldByName('ID').AsString);
  ID := UserF.Query1.FieldByName('ID').AsInteger;
  UserF.Query1.Close;
  ExecSql;
  UserF.Query1.Open;
  while UserF.Query1.FieldByName('ID').AsInteger<>ID do UserF.Query1.Next;
  Clear;
  Add('Update "sopswrd.db" ');
  Add('Set ');
  Add('PasswordR='+IntToStr(CalculatePassword(UserF.Query1,
     PassWordE.Text)));
  Add('Where ID='+UserF.Query1.FieldByName('ID').AsString);
  ExecSQL;
 end;
end;

procedure TUserCardF.ActionEExit(Sender: TObject);
begin
 {  }
 with  ActionE do
  Text:=SetToStr(StrToSet(Text) * FindSohoRegister.ActionRights);
end;

procedure TUserCardF.ReadEExit(Sender: TObject);
begin
 with  ReadE do
  Text:=SetToStr(StrToSet(Text) * FindSohoRegister.DataReadRights);
end;

procedure TUserCardF.WriteEExit(Sender: TObject);
begin
 with  WriteE do
  Text:=SetToStr(StrToSet(Text) * FindSohoRegister.DataWriteRights);
end;

procedure TUserCardF.UserNameEExit(Sender: TObject);
begin
     if ShortNameE.Text='' then 
        ShortNameE.Text := copy(UserNameE.Text,1,8);
end;

end.
