{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                 Written by Allex,VSM                  }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoUnit;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, Menus, IniFiles, StdCtrls, Outline;

const

   {      SohoMon }

   {   ,     }
   SM_SOHO           = WM_USER + $0044;
   {  ,  -  ,   }
   SM_ActivateUpdate = SM_SOHO + 1;
   {    ,       lParam }
   SM_ID             = SM_SOHO + 2;
   {   , wParam = hWnd  ) }
   SM_AREYOUHERE     = SM_SOHO + 3;
   {   .  ,     SoRegister  SOHOMON }
   SM_REQUEST        = SM_SOHO + 4;
   {  . .  }
   SM_ANSWER         = SM_SOHO + 5;
   {   . wParam = hWnd   }
   SM_UNREGISTER     = SM_SOHO + 6;
   {  - Terminate }
   SM_KILL           = SM_SOHO + 7;
   {  quickStart }
   SM_ShowProgram    = SM_SOHO + 8;

   {        
     ,   -  
     
    -    
   1-  -   (  )
   2-  -    }
   {  ,  Tag1  Tag2  LongInt}
function EncodeData(C: Word; Tag1, Tag2: Byte): Longint;
{   WORD   }
procedure DecodeData(LPARAM: Longint; var C: Word; var Tag1, Tag2: Byte);
{    (  )  }
procedure AppendCharToString(C: Char; N: Byte; var S: string);

{  ,      ,
       ,       lParam
   (   )
    1 - User ID -   lParam
    2 - User Name -   ,   ( Application.Name)
    3 - User Short Name - 
    4 - Default Data Level - lParam
    5 - User Action Rights -  ,    
    6 - User Data Read Rights - 
    7 - User Data Write Rights - 
    8 - Application Name
    9 - Ready for Receive
    11- MonitorFileName {Specifig for SoRegister
        "  ")

    !   =65535   0,     
       !    
       0    C++
    }
const
   ccUserID          = 1; 
   ccUserName        = 2; 
   ccUserShortName   = 3; 
   ccDataLevel       = 4;
   ccUserAction      = 5;
   ccUserRead        = 6;
   ccUserWrite       = 7;
   ccApplicationName = 8;
   ccReadyForReceive = 9;
   ccManagerReady    = 10;
   ccManagerFileName = 11;

type
   { Added by Wizard }
   TSQLFileName = type string;

   SetOfByte = set of Byte;
   {    ,    }
function GetNewID(Prefix: string): Longint;
procedure SetNewID(Prefix: string; Value: Longint);

{,      SOHO
    TSohoFolder,    TSohoDocument}
function SohoNames(FieldName: string): Boolean;

{      -    
      }
procedure ApplyActionRights(Component: TComponent; Rights: SetOfByte); {Use it for user-depended menu}
{    }
function SetToStr(S: SetOfByte): string;
{   ,   0, 5, 8-15 }
function StrToSet(S: string): SetOfByte;
{         
      .   
  
    }
{     ,   }
procedure AppendMenu(var MENU: TMainMenu; IniFileName: string); {Co-Menu}
{    ,      }
procedure SaveMenu(var MENU: TMenuItem; IniFileName: string);
{    OutLine}
procedure ApplyOutLineDescription(Outline: TOutLine; IniFileName: string);
{    OutLine}
procedure SaveOutLineDescription(Outline: TOutLine; IniFileName: string);


{Local objects and variables, used for execute menu and other controls operations
       TMenuExecutor-   
  }
type
   ManagerRecord = record
      Ident: string[8];
      UserName: string[50];
      Level: Longint;
      Action: SetOfByte;
      DataRead: SetOfByte;
      DataWrite: SetOfByte;
      UserID: Longint;
      DataBaseName: string[80];
   end;

   TMenuExecutor = class(TObject)
   private
      IniFileName: string;
   public
      procedure StandartReactionProc(Sender: TObject);
      procedure Execute(ExecString: string);
   end;

const MenuExecutor: TMenuExecutor = nil;

type

   TPublishedControl = class(TControl)
   private
      procedure WC(AValue: string);
      function rc: string;
   published
      property CAPTION: string read rc write WC;
   end;


implementation
uses SoUtils, Dialogs, SoDBCns;

{  ,  Tag1  Tag2   (lParam)}
function EncodeData(C: Word; Tag1, Tag2: Byte): Longint;
   {Data Category Number}
begin
   Result := Longint(Tag1) shl 24 + Longint(Tag2) shl 16 + Word(C);
end;

{      }
procedure DecodeData(LPARAM: Longint; var C: Word; var Tag1, Tag2: Byte);
   {lParam Data Category Number}
begin
   Word(C) := LOWORD(LPARAM);
   Tag1 := Hi(HiWord(LPARAM));
   Tag2 := Lo(HiWord(LPARAM));
end;

{      }
procedure AppendCharToString(C: Char; N: Byte; var S: string);
begin
   if N = 0 then Exit;
   while Length(S) < N do S := S + ' ';
   S[N] := C;
end;

function SohoNames(FieldName: string): Boolean;
begin
   FieldName := AnsiUpperCase(FieldName);
   Result := (FieldName = 'ID')
      or (FieldName = 'MDFDATE')
      or (FieldName = 'MDFTIME')
      or (FieldName = 'IDMDFAUTH')
      or (FieldName = 'PROTECT') {Allex 10/04/1998}
      or (Copy(FieldName, 1, 5) = 'IDGRP')
      or (Copy(FieldName, 1, 4) = 'HASH')
      or (Copy(FieldName, 1, 5) = 'ORDER'); {STOP}
end;

{Some local object procedures}
procedure TPublishedControl.WC;
begin
   inherited CAPTION := AValue;
end;

function TPublishedControl.rc;
begin Result := inherited CAPTION end;


{Main procedure of "Menu Executor" }
procedure TMenuExecutor.Execute;
var Command: string;
   ExecHandle: Word;
   {$IFNDEF WIN32}
   ExecUsage : Longint;
   {$ENDIF}
begin
   {    ShowMessage(ExecString);}
   {Commands support}
   {Syntax : first word is command, other - depending of command syntax}
   ExecString := ExecString + ' ';
   Command := Copy(ExecString, 1, Pos(' ', ExecString) - 1);
   Command := AnsiUpperCase(Command);
   Delete(ExecString, 1, Pos(' ', ExecString));
   if (Command = 'MESSAGE') then InfoMsg(ExecString);
   if (Command = 'HALT') then Application.Terminate;
   if (Command = 'RUN') or (Command = 'FORK') then
   begin
      ExecString[Length(ExecString) + 1] := #0;
      ExecHandle := WinExec(@ExecString[1], SW_RESTORE);
      if ExecHandle < 32 then
      begin
         ErrorMsg(ExecString + ' - ' + ExecError(ExecHandle));
         Exit;
      end;
      {$IFNDEF Win32}
      ExecUsage := GetModuleUsage(ExecHandle);
      if Command = 'RUN' then {Monitoring of program}
         with Application do
         begin
            MainForm.Visible := False;
            {   ""  
                        ,   
                       
                     (or lock any messages)
                     }
            repeat {DO NOTHING}
               {         ShowMessage(' '+ExecString);}
               ProcessMessages;
            until GetModuleUsage(ExecHandle) <> ExecUsage;
            MainForm.Visible := True;
         end;
      {$ENDIF}
   end;
   {Exec}
   {}
end;

procedure TMenuExecutor.StandartReactionProc(Sender: TObject);
var Ini: TIniFile;
begin
   Ini := TIniFile.Create(IniFileName);
   Execute(Ini.ReadString((Sender as TComponent).name, 'Exec', ''));
   Ini.Free;
end;

procedure SaveSubMenu(var MENU: TMenuItem; var Ini: TIniFile);
var I: Longint;
   TempMenu: TMenuItem;
begin
   with Ini, MENU do
   begin
      {Save}
      WriteInteger(name, 'MenuBreak', Ord(Break));
      WriteString(name, 'Caption', CAPTION);
      WriteBool(name, 'Checked', checked);
      WriteInteger(name, 'GroupIndex', GroupIndex);
      WriteInteger(name, 'Tag', Tag);
      WriteString(name, 'Hint', Hint);
      {ShortCut = ?}
      
      {Save SubMenus}
      for I := 0 to Count - 1 do
      begin
         WriteString('SubMenuOf' + name, Items[I].name, 'Exists');
         TempMenu := MENU.Items[I];
         SaveSubMenu(TempMenu, Ini);
      end;
   end; {WITH}
end; {PROC}

procedure SaveMenu(var MENU: TMenuItem; IniFileName: string);
var Ini: TIniFile;
begin
   Ini := TIniFile.Create(IniFileName);
   Ini.WriteString('SubMenu', MENU.name, MENU.CAPTION);
   SaveSubMenu(MENU, Ini);
   Ini.Free;
end;

procedure AppendSubMenu(var MENU: TMenuItem; var Ini: TIniFile; ItemName: string);
var
   ItemList: TStringList;
   I       : Longint;    
   NewItem : TMenuItem;  
begin
   NewItem := TMenuItem.Create(MENU);
   with Ini, NewItem do
   begin {Define properties}
      Break := TMenuBreak(ReadInteger(ItemName, 'MenuBreak', Ord(mbNone)));
      CAPTION := ReadString(ItemName, 'Caption', 'Error in menu descriptor ' + name);
      checked := ReadBool(ItemName, 'Checked', False);
      ENABLED := True; {Constant}
      GroupIndex := ReadInteger(ItemName, 'GroupIndex', 0);
      Visible := True; {Apply Active rights change this attribute}
      Tag := ReadInteger(ItemName, 'Tag', 0);
      Hint := ReadString(ItemName, 'Hint', '');
      name := ItemName; {ItemName is parameter}
      {ShortCut = ?}
      {       }
      if MenuExecutor = nil then
      begin
         MenuExecutor := TMenuExecutor.Create;
         MenuExecutor.IniFileName := Ini.Filename;
      end;
      
      {  ,  ,     
                ,   ,  
              -  }
      if Assigned(MENU) then OnClick := MenuExecutor.StandartReactionProc;
      
   end;
   
   {Insert to Up Menu}
   {Append Sub Menu}
   ItemList := TStringList.Create;
   Ini.ReadSection('SubMenuOf' + ItemName, ItemList);
   for I := 0 to ItemList.Count - 1 do AppendSubMenu(NewItem, Ini, ItemList.Strings[I]);
   ItemList.Free;
   
   if not Assigned(MENU)
      then MENU := NewItem
   else MENU.Insert(MENU.Count, NewItem);
end;

procedure AppendMenu(var MENU: TMainMenu; IniFileName: string);
var
   Ini        : TIniFile;   
   MenuHeader : TMenuItem;  
   SubMenuList: TStringList;
   I          : Longint;
begin
   Ini := TIniFile.Create(IniFileName);
   SubMenuList := TStringList.Create;
   with Ini do
   begin
      ReadSection('SubMenu', SubMenuList);
      for I := 0 to SubMenuList.Count - 1 do
      begin
         MenuHeader := nil;
         AppendSubMenu(MenuHeader, Ini, SubMenuList.Strings[I]);
         MENU.Items.Add(MenuHeader);
      end;
   end;
   SubMenuList.Free;
   Ini.Free;
end;


procedure ApplyActionRights;
var I: Longint;
begin
   {
     -      ,
        - ,
     
      "-"
   }
   {  if not assigned(Component) then Exit;}
   with TComponent(Component) do
      for I := 0 to ComponentCount - 1 do
         if (Components[I] is TControl) then
            with (Components[I] as TControl) do Visible := LOWORD(Tag) in Rights
         else
            if (Components[I] is TMenuItem) then
               with (Components[I] as TMenuItem) do Visible := LOWORD(Tag) in Rights;
end;

function StrToSet(S: string): SetOfByte;
const Digital = ['0'..'9', '-'];
var
   Word             : string; 
   LeftStr, RightStr: string; 
   Left, Right      : Longint;
   I                : Longint;
   Error            : Integer;
begin
   Result := [0];
   {Skip invalid chars}
   I := 1; while (I < Length(S)) and not (S[I] in Digital) do Inc(I);
   Delete(S, 1, I - 1);
   repeat
      {Find WORD}
      I := 1; while (I <= Length(S)) and (S[I] in Digital) do Inc(I);
      Word := Copy(S, 1, I - 1);
      Delete(S, 1, I - 1);
      {Skip invalid chars}
      I := 1; while (I <= Length(S)) and not (S[I] in Digital) do Inc(I);
      Delete(S, 1, I - 1);
      while Pos('--', Word) <> 0 do Delete(Word, Pos('--', Word), 1);
      I := Pos('-', Word); if I = 0 then Word := Word + '-';
      I := Pos('-', Word);
      LeftStr := Copy(Word, 1, I - 1); Val(LeftStr, Left, Error);
      RightStr := Copy(Word, I + 1, 255); Val(RightStr, Right, Error);
      if LeftStr = '' then Left := Right;
      if RightStr = '' then Right := Left;
      if Left > Right
         then Result := Result + [Right..Left]
      else Result := Result + [Left..Right];
   until S = '';
end;

function SetToStr(S: SetOfByte): string;
var Left, Right: Integer;
begin
   Result := ''; if S = [] then Exit;
   Left := 0;
   Right := 0;
   while Right < 256 do
   begin
      {Define start of next section}
      while (Left < 256)
         and not (Left in S)
         do Inc(Left);
      if Left > 255 then Break;
      {Define end of next section}
      Right := Left;
      while (Right < 256)
         and (Right in S)
         do Inc(Right);
      Dec(Right);
      {Append Left&Right to Result}
      Result := Result + IntToStr(Left);
      if Right <> Left then Result := Result + '-' + IntToStr(Right);
      Result := Result + ',';
      Left := Right + 1;
   end;
   if Length(Result) > 0 then DecLength(Result, 1);
end;

function GetNewID;
var IniFile: TIniFile;
begin
   IniFile := TIniFile.Create('SOHO.INI');
   Result := IniFile.ReadInteger('Common', Prefix + 'ID', 0);
   if Result = 0 then
   begin
      Result := IniFile.ReadInteger('Common', 'Computer', 0);
      if Result = 0 then
         Result := StrToInt(InputBox(sohoUnitComputerNumber, sohoUnitOnlyProvider, '0'));
      IniFile.WriteInteger('Common', 'Computer', Result);
      Result := Result * 100000; {CostYE000 QuantWH000}
   end;
   Inc(Result);
   IniFile.WriteInteger('Common', Prefix + 'ID', Result);
   IniFile.Free;
end;

procedure SetNewID;
var IniFile: TIniFile;
begin
   IniFile := TIniFile.Create('SOHO.INI');
   IniFile.WriteInteger('Common', Prefix + 'ID', Value);
   IniFile.Free;
end;

procedure SaveOutLineDescription(Outline: TOutLine; IniFileName: string);
var
   Ini: TIniFile;
   I  : Longint;
begin
   Ini := TIniFile.Create(IniFileName);
   with Ini, Outline do
      for I := 1 to ItemCount do
         WriteBool(Outline.Owner.ClassName + Outline.name + 'OutLine', IntToStr(I), Items[I].Expanded);
   Ini.WriteInteger(Outline.Owner.ClassName + Outline.name + 'OutLine',
      'Selected', Outline.SelectedItem);
   Ini.Free;
end;

procedure ApplyOutLineDescription(Outline: TOutLine; IniFileName: string);
var
   Ini: TIniFile;
   I  : Longint;
begin
   Ini := TIniFile.Create(IniFileName);
   with Ini, Outline do begin
      for I := 1 to ItemCount do
        if Items[I].Parent.Expanded then
         Items[I].Expanded := ReadBool(Outline.Owner.ClassName + Outline.name + 'OutLine', IntToStr(I), True);
   end;
   I := Ini.ReadInteger(Outline.Owner.ClassName + Outline.name + 'OutLine',
      'Selected', 1);
   if Outline.ItemCount <= I then Outline.SelectedItem := I;
   Ini.Free;
end;

end.

