{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoTreeF;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, SoCtrls, StdCtrls, Mask, ToolEdit, SohoBtns, DB, DBTables,
     SoTools, RXCtrls;

type
  TNewTreeGuideForm = class(TForm)
    sohoLabel1: TsohoLabel;
    DirE: TDirectoryEdit;
    OkB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    ItemsG: TGroupBox;
    CreateGroupsC: TCheckBox;
    sohoLabel2: TsohoLabel;
    GroupsNameE: TsohoEdit;
    GroupsFields: TRxCheckListBox;
    sohoLabel4: TsohoLabel;
    GroupsG: TGroupBox;
    sohoLabel6: TsohoLabel;
    ItemsFields: TRxCheckListBox;
    CreateItemsC: TCheckBox;
    sohoLabel3: TsohoLabel;
    ItemsNameE: TsohoEdit;
    CreateQ: TQuery;
    procedure CreateGroupsCClick(Sender: TObject);
    procedure CreateItemsCClick(Sender: TObject);
  private
    { Private declarations }
    function FormCreateTreeGuide : boolean;
  public
    { Public declarations }
  end;

var NewTreeGuideForm: TNewTreeGuideForm;
    aGroupsTableName : string;
    aItemsTableName  : string;

function CreateTreeGuide : boolean;

implementation
uses SoUtils;

{$R *.DFM}

function CreateTreeGuide : boolean;
begin
   try
     Result := false;
     NewTreeGuideForm := TNewTreeGuideForm.Create(Application);
     Result := NewTreeGuideForm.FormCreateTreeGuide;
   finally
     NewTreeGuideForm.Free;
   end;
end;

function TNewTreeGuideForm.FormCreateTreeGuide : boolean;
var Index : integer;
begin
     aGroupsTableName := '';
     aItemsTableName  := '';
     Result := ShowModal = mrOk;
     if not Result then exit;
     CreateQ.DataBaseName := DirE.Text;
     { Create groups? }
     if CreateGroupsC.Checked and (GroupsNameE.AsString<>'') then begin
        with CreateQ,SQL do begin
            Clear;
            aGroupsTableName := GroupsNameE.AsString;
            if Pos('.DB', StrUpper(GroupsNameE.AsString)) = 0 then
              Add('create table '+GroupsNameE.AsString)
            else
              Add('create table "'+GroupsNameE.AsString+'"');
            Add('(');
            for Index := 0 to pred(GroupsFields.Items.Count) do
              if GroupsFields.Checked[Index] then Add(GroupsFields.Items[Index]+',');
            Add(' Primary Key (Id)');
            Add(')');
            try
              ExecSQL;
            except ErrorMsg('    : '+
                   DataBaseName+'\'+GroupsNameE.AsString);
                   exit;
            end;
        end;
     end;
     { Create items? }
     if CreateItemsC.Checked and (ItemsNameE.AsString<>'') then begin
        with CreateQ,SQL do begin
            Clear;
            aItemsTableName  := ItemsNameE.AsString;
            if Pos('.DB', StrUpper(ItemsNameE.AsString)) = 0 then
              Add('create table '+ItemsNameE.AsString)
            else
              Add('create table "'+ItemsNameE.AsString+'"');
            Add('(');
            for Index := 0 to pred(ItemsFields.Items.Count) do
              if ItemsFields.Checked[Index] then Add(ItemsFields.Items[Index]+',');
            Add(' Primary Key (Id)');
            Add(')');
            try
              ExecSQL;
            except ErrorMsg('    : '+
                   DataBaseName+'\'+ItemsNameE.AsString);
                   exit;
            end;
        end;
     end;
end;

procedure TNewTreeGuideForm.CreateGroupsCClick(Sender: TObject);
begin
     GroupsNameE.Enabled := CreateGroupsC.Checked;
     OkB.Enabled := CreateGroupsC.Checked or CreateItemsC.Checked;
end;

procedure TNewTreeGuideForm.CreateItemsCClick(Sender: TObject);
begin
     ItemsNameE.Enabled := CreateItemsC.Checked;
     OkB.Enabled := CreateGroupsC.Checked or CreateItemsC.Checked;
end;

end.
