{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{       
    TsohoTreeView32 -    
 SohoLib        
}
unit SoTree32;

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, Dialogs, DB, ExtCtrls, SoSplit, wwQuery, wwTable, wwDatSrc,
     DBTables, Menus, Grids, StdCtrls, SoCtrls, SoTools, SoFolder,
     SoDBGrid, wwDBIGrd, DBGrids, RxCtrls, ComCtrls;

type

  {    . GroupName -  , GroupId - 
      }
  TsohoTreeNode = record
      GroupName : string;
      GroupId   : LongInt;
  end;

  {   TsohoTreeView32: trDeleteGroup -  , trAddGroup - 
    , trEditGroup -   , trDeleteItem -   ,
    trAddItem -   , trEditItem -   ,
    trRefresh -  , trReNumber -  ,
    trMoveItem -   ,
    trMoveGroup -   
  }
  TsohoTreeOption  = (trDeleteGroup, trAddGroup, trEditGroup, trDeleteItem,
                      trAddItem, trEditItem, trRefresh, trReNumber,
                      trMoveItem,trMoveGroup);

  {     TsohoTreeView32 }
  TsohoTreeOptions = set of TsohoTreeOption;

  { trSaveTreeView   -   TreeView,
    trSaveSplitter  -     TreeView  DBGrid,
    trSaveViewChild -   CheckBox' }
  TsohoTreeSaveOption = (trSaveTreeView, trSaveSplitter, trSaveViewChild);

  {     TreeView }
  TsohoTreeSaveOptions = set of TsohoTreeSaveOption;

  {    OnFilter. DataSet -   
     .  Visible     }
  TsohoTreeOnFilter = procedure (Sender : TObject; DataSet : TDataSet;
                      var Visible : boolean) of object;

  {    OnItemDelete.    ItemId,
     "" . Allow   ,  
     }
  TsohoTreeOnDeleteItem  = procedure (Sender : TObject; ItemId : LongInt;
                           DeleteMany : boolean; var Allow : boolean) of object;
  {    OnGrpDelete.    GrpId.
    Allow   ,    }
  TsohoTreeOnDeleteGroup = procedure (Sender : TObject; GrpId : LongInt;
                           var Allow : boolean) of object;
  {    OnGrpDelete.    GrpId.
    Allow   ,    }
  TsohoTreeOnNewItem  = procedure (Sender : TObject; GroupId : LongInt;
                        var ItemId,ItemHash : LongInt; var Allow : boolean) of object;
  {    OnNewGrp.    NewGroup.
    Allow   ,    }
  TsohoTreeOnNewGroup = procedure (Sender : TObject; NewGroup : TsohoTreeNode;
                        var Allow : boolean) of object;
  {    OnItemEdit.    GroupId 
      itemId. Allow   ,    }
  TsohoTreeOnEditItem  = procedure (Sender : TObject;  GroupId,ItemId : LongInt;
                         var Allow : boolean) of object;
  {    OnGrpEdit.    Group.
    Allow   ,    }
  TsohoTreeOnEditGroup = procedure (Sender : TObject; Group : TsohoTreeNode;
                         var Allow : boolean) of object;
  {     OnCustomEditGrp  OnCustomNewGrp.   
   GroupId,   GroupHash,    ParentId 
     GroupName. Allow       }
  TsohoTreeCustomGroup = procedure (Sender : TObject; GroupId, GroupHash, ParentId : LongInt;
                         var GroupName : string; var Allow : boolean) of object;
  {     OnItemMove.   ,  
     OldGroupId,  ,     NewGroupId,
     ItemId,      NewItemHash. Allow
         }
  TsohoTreeOnMoveItem  = procedure (Sender : TObject;  OldGroupId,NewGroupId : LongInt;
                         ItemId,NewItemHash : LongInt; var Allow : boolean) of object;

  TsohoTreeOnPopupCreate = procedure (Sender : TObject; PopupMenu : TPopupMenu) of object;

  {    TreeView. ItemId -  , ItemsHash -  
     , ParentId -    }
  PTreeLeaf = ^TTreeLeaf;
  TTreeLeaf = record
           ItemId   : LongInt;
           ItemHash : LongInt;
           ParentId : LongInt;
  end;

  {     }
  TsohoMoveItem = record
      Id                : LongInt;
      OldGrpId,NewGrpId : LongInt;
      NewHash           : LongInt;
      { Fields for drag&drop }
      ItemDragBegin     : boolean;
      DragOverId        : LongInt;
      GridDrag          : boolean;
      GridRow           : LongInt;
  end;

  {     }
  TsohoMoveGroup = record
      GrpDragSourceRow : LongInt;
  end;

  {  TsohoTreeView32 -  ,    :
    TTreeView ( GroupTreeView)  TsohoDBGrid ( DBGrid).  
         -     .
           .   
      Id (ftInteger) -   , Hash (ftInteger) - 
        , IdGrp (ftInteger) -   
    ,     , Name -  .    
          TsohoTreeView32.     
    ,       OrderField.   
      : Id, Hash, IdParent (ftInteger) -   
     , Name -  .     ,  
      .      design-time,  
    Component Editor',   TsohoTreeView32.   TsohoTreeView32 
     TDataSet',         ,   -  
    .       GroupsDataSet  ItemsDataSet.  ,
           GroupsTable  ItemsTable (,
    ItemsTable := "items.db").     TsohoTreeView32 
     ,         
     OnNewItem  OnItemEdit.     
          TsohoTVContainer.
     :  "" -      TreeView - 
       TreeView!     ,    
     'Id'      !
  }
  TsohoTreeView32 = class(TCustomControl)
  private
    { Private declarations }
    LeftHash, RightHash : LongInt;
    FFolder       : TsohoFolder;
    FFixedGrpName : string;
    FFixedGrpId   : LongInt;
    FRootName     : string;
    FActive       : boolean;
    FCloseGroups  : boolean;
    FEditOnDblClick : boolean;

    FGroupsDS,
    FItemsDS      : TDataSet;

    FNameGrID     : string;
    FHashField    : string;
    FOrderField   : string;

    FItemsName    : string;
    FGroupsName   : string;
    FTmpGrpName   : string;

    FGroupPreffix,
    FItemsPreffix : string;
    FBottomIndex  : LongInt;
    FSaveFile     : TIniFileName;
    FOptions      : TsohoTreeOptions;
    FSaveOptions  : TsohoTreeSaveOptions;

    { Events }
    FOnFilter       : TsohoTreeOnFilter;
    FOnItemDelete   : TsohoTreeOnDeleteItem;
    FOnGrpDelete    : TsohoTreeOnDeleteGroup;
    FOnNewItem      : TsohoTreeOnNewItem;
    FOnMoveItem     : TsohoTreeOnMoveItem;
    FOnNewGrp       : TsohoTreeOnNewGroup;
    FOnItemEdit     : TsohoTreeOnEditItem;
    FOnGrpEdit      : TsohoTreeOnEditGroup;

    FOnCustomEditGrp : TsohoTreeCustomGroup;
    FOnCustomNewGrp  : TsohoTreeCustomGroup;

    FOnCalcCells    : TCalcCellColorsEvent;
    FOnDrawCells    : TDrawDataCellEvent;
    FOnSaveFolder   : TsohoOnSaveEvent;
    FOnLoadFolder   : TsohoOnLoadEvent;
    FOnPopup        : TNotifyEvent;
    FAfterGrpDelete : TNotifyEvent;
    FOnChange       : TNotifyEvent;
    FOnGroupSelect  : TNotifyEvent;
    FOnPopupMenuCreate : TsohoTreeOnPopupCreate;

    FOnGridDblClick    : TNotifyEvent;
    FOnGridKeyDown     : TKeyEvent;
    FOnGroupsKeyDown   : TKeyEvent;
    FOnGroupsMouseDown : TMouseEvent;
    FOnGroupsMouseMove : TMouseMoveEvent;
    FOnGroupsDragOver  : TDragOverEvent;
    FOnGroupsDragDrop  : TDragDropEvent;
    FOnGridDragDrop    : TDragDropEvent;
    FOnGridMouseMove   : TMouseMoveEvent;
    FOnGridDragOver    : TDragOverEvent;
    FOnGridMouseDown   : TMouseEvent;

    { Visible controls }
    FBtnsPanel,
    FComPanel,
    FTreeViewPanel,
    FGridPanel    : TPanel;
    FGroups       : TTreeView;
    FImages       : TImageList;
    FGrid         : TsohoDBGrid;
    FSplitter     : TsohoSplitter;
    FViewChild    : TCheckBox;
    FReport       : TLabel;
    FMenuBtn      : TRxSpeedButton;
    FBtnMenu      : TPopupMenu;

    { Data Access }
    FSource       : TwwDataSource;
    FOldGrp,
    FOldItm       : boolean;
    FTblOnFilter  : TwwTableFilterEvent;
    FQryOnFilter  : TwwQueryFilterEvent;
    FGroupsTable  : TFileName;
    FItemsTable   : TFileName;

    FPopMenu        : TPopupMenu;
    FGroupMenu      : TPopupMenu;
    FGrpSelItem,
    FGrpDeselItem   : TMenuItem;
    FEnabledItem,
    FDisabledItem   : TMenuItem;
    FParSet         : boolean;
    OperationQuery  : TwwQuery;

    { For drag and drop }
    FMoveItem       : TsohoMoveItem;
    FMoveGroup      : TsohoMoveGroup;
    procedure GroupsKeyDown     (Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure GroupsMouseDown   (Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure GroupsMouseMove   (Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure GroupsDragOver    (Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure GroupsDragDrop    (Sender, Source: TObject; X, Y: Integer);
    procedure ItemsGridDragDrop (Sender, Source: TObject; X,Y: Integer);
    procedure ItemsGridMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure ItemsGridDragOver (Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure ItemsGridMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure GroupsEdit        (Sender: TObject; Node: TTreeNode; var S: string);
    procedure BeforeGroupEdit (Sender: TObject; Node: TTreeNode; var AllowEdit: Boolean);

    { Design and Run-Time routines }
    procedure WriteGrid    (Stream : TStream);
    procedure WriteTreeView (Stream : TStream);
    procedure ReadGrid     (Stream : TStream);
    procedure ReadTreeView  (Stream : TStream);
    procedure DefineProperties (Filer : TFiler);override;
    function  GetGroupsVisible : boolean;
    function  GetItemsVisible  : boolean;
    procedure SetGroupsVisible (Show : boolean);
    procedure SetItemsVisible  (Show : boolean);
    procedure SetIncludeSubTree (Value : boolean);
    function  GetIncludeSubTree : boolean;
    procedure SetGroupsTable   (Value : TFileName);
    function  FindMaxID        (Index : LongInt) : LongInt;
    function  AddTreeItem      (ItemId, ParentId, ItemHash, Index : LongInt;
                                ItemName : string) : boolean;
    function  CreateGroupsTree : boolean;
    procedure ButtonMenuClick      (Sender : TObject);
    procedure CheckTableFilter (Table : TwwTable; var Accept : boolean);
    procedure CheckQueryFilter (Table : TwwQuery; var Accept : boolean);
    procedure GroupSelected    (Sender : TObject);
    procedure SetItemsName     (Value : string);
    procedure SetGroupsName    (Value : string);
    procedure UpdateBtnMenus;
    procedure Notification     (AComponent : TComponent; Operation : TOperation);override;
    procedure SetGroupsDataSet (Value : TDataSet);
    procedure SetItemsDataSet  (Value : TDataSet);
    procedure SetNameGrID      (Value : string);
    procedure SetOrderField    (Value : string);
    procedure SetHashField     (Value : string);
    procedure SetOptions       (Value : TsohoTreeOptions);
    function  GetItemId        : LongInt;
    procedure SetItemId        (Value : LongInt);
    procedure SetActive        (Value : boolean);
    procedure SetRootName      (Value : string);
    function  GetResults : TsohoDBGridResults;

    { Events handlers }
    procedure GridDblClick     (Sender : TObject);
    procedure GridCellColors   (Sender: TObject; Field: TField;
                                State: TGridDrawState; highlight: Boolean;
                                AFont: TFont; ABrush: TBrush);
    procedure GridDataCell     (Sender: TObject; const Rect: TRect; Field: TField;
                                State: TGridDrawState);
    procedure GridKeyDown      (Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FolderSave       (Sender : TObject; DataSet : TDataSet);
    procedure FolderLoad       (Sender : TObject; DataSet : TDataSet);

    procedure MenuItemClick    (Sender : TObject);
    procedure OnMenuPopup      (Sender : TObject);
    function  GetDataBaseName  (DataSet : TDataSet) : string;
    procedure ViewChildClick   (Sender : TObject);
    function  RenumberRecords : boolean;
    procedure SetSaveFile      (Value : TIniFileName);
    function  InGroup          (FilterGroup : LongInt) : boolean;
    procedure SetFolder        (Value : TsohoFolder);
    function  DeleteOneRecord  (ManyDelete : boolean; ItemId : LongInt) : boolean;
    procedure CreateBtnMenus;
  protected
    { Protected declarations }
    procedure Loaded;override;
    procedure Changed; virtual;
  public
    {          }
    function  QuietAddGroup (var NewName : string) : boolean;virtual;
    {   }
    function  AddGroup    : boolean;virtual;
    {          }
    function  QuietEditGroup(var NewName : string) : boolean;virtual;
    {    }
    function  EditGroup   : boolean;virtual;
    {   }
    function  DeleteGroup : boolean;virtual;
    {   }
    function  AddItem     : boolean;virtual;
    {   }
    function  EditItem    : boolean;virtual;
    {   }
    function  MoveItem    : boolean;virtual;
    {   }
    function  DeleteItem  : boolean;virtual;
    {      GroupsDataSet  , 
          GroupTreeView.     CloseGroups = false }
    function LocateOnGroup : boolean;

    {  ,       TreeView, 
      -  }
    function GetNewGroupIdPreffix : string;
    {  ,       TreeView, 
      -  }
    function GetNewItemIdPreffix : string;
    {  TreeView }
    procedure ReDrawTreeView;
    {   GroupTreeView }
    procedure SetTreeViewWidth  (Value : integer);
    {  true,     ChildItemIndex  
          ParentItemIndex }
    function  ItemIsChild      (ParentItemIndex,ChildItemIndex : LongInt) : boolean;
    {       }
    function  GetIndexByName   (Name : string) : LongInt;
    {     Hash    }
    function  GetNewItemHash   (GrpId  : LongInt; AIdGroupField : string) : LongInt;
    {    Hash       }
    function  GetHash          (Left,Right : LongInt) : LongInt;
    {      }
    function  GetLeafRecord    (Index  : LongInt) : TTreeLeaf;
    {      }
    function  GetIndexByID     (ItemID : LongInt) : LongInt;
    {    -   TsohoTreeView32.    
        actDelGroup   }
    procedure TreeViewButtonsClick (ButtonIndex : LongInt);virtual;
    {     }
    procedure   RefreshGroup;
    {   }
    procedure   RefreshItems;
    {    }
    procedure   RefreshTreeView; virtual;
    {   ini-  TreeView }
    procedure   LoadTreeViewState;virtual;
    {   ini-  TreeView }
    procedure   SaveTreeViewState;virtual;
    procedure   Paint;override;
    {     .   
      Id, IdGrp, Hash }
    function    AddNewItem (GrpId,ItemId,ItemHash : LongInt) : boolean;
    constructor Create (AOwner : TComponent);override;
    destructor  Destroy;override;
    {    TreeView }
    property    Active   : boolean            read FActive write SetActive;
    {      TsohoDBGrid }
    property    Results  : TsohoDBGridResults read GetResults;
    {    }
    property    ItemId   : LongInt read GetItemId write SetItemId default -1;
    {    .  ,   TreeView   
       }
    property    FixedGrpName  : string    read FFixedGrpName write FFixedGrpName;
    {    .  ,   TreeView   
       }
    property    FixedGrpId    : LongInt   read FFixedGrpId   write FFixedGrpId;
    {       CheckBox'  TreeView }
    property    BtnsPanel     : TPanel    read FBtnsPanel;
    {   CheckBox' }
    property    ChildCheckBox : TCheckBox read FViewChild;
  published
    property Align;
    property Font;
    property Color;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property DragCursor;
    property DragMode;
    property Ctl3D;
    property ParentCtl3D;
    {  true,     DBGrid    }
    property EditOnDblClick : boolean read FEditOnDblClick write FEditOnDblClick default true;
    {      .    
       GetNewId }
    property GroupPreffix : string read FGroupPreffix write FGroupPreffix;
    {      .    
       GetNewId }
    property ItemsPreffix : string read FItemsPreffix write FItemsPreffix;
    {   TsohoFolder  DBGrid.   Auto  Folder 
        false }
    property Folder       : TsohoFolder read FFolder write SetFolder;
    {               }
    property IncludeSubTree : boolean read GetIncludeSubTree write SetIncludeSubTree;
    {     TreeView }
    property RootName      : string    read FRootName    write SetRootName;
    { DataSet   }
    property GroupsDataSet : TDataSet  read FGroupsDS    write SetGroupsDataSet;
    {     }
    property GroupsTable   : TFileName read FGroupsTable write SetGroupsTable;
    {     }
    property ItemsTable    : TFileName read FItemsTable  write FItemsTable;
    { DataSet   }
    property ItemsDataSet  : TDataSet  read FItemsDS     write SetItemsDataSet;
    {  ,   ItemsDataSet      .
         - 'IdGrp'}
    property NameGroupID   : string    read FNameGrID    write SetNameGrID;
    {  ,          
       }
    property OrderField    : string    read FOrderField  write SetOrderField;
    {  ,         }
    property HashField     : string    read FHashField   write SetHashField;
    {    : , ,     }
    property Options       : TsohoTreeOptions read FOptions write SetOptions;
    {    TreeView    }
    property SaveOptions   : TsohoTreeSaveOptions read FSaveOptions write FSaveOptions default [trSaveSplitter];
    {    -   .     
      :  ,    .      ,
          ,     }
    property ItemsName     : string    read FItemsName   write SetItemsName;
    {    -   .     
      :  ,    .      ,
          ,     }
    property GroupsName    : string    read FGroupsName   write SetGroupsName;
    {     ,       ?
            -   ,  
        ,  CloseGroups    false }
    property CloseGroups   : boolean   read FCloseGroups  write FCloseGroups default true;
    {   TsohoDBGrid }
    property DBGrid        : TsohoDBGrid read FGrid;
    {   TTreeView }
    property GroupTreeView  : TTreeView  read FGroups;
    {     }
    property GroupsVisible : boolean   read GetGroupsVisible write SetGroupsVisible;
    {      }
    property ItemsVisible  : boolean   read GetItemsVisible  write SetItemsVisible;
    {  ini-    TreeView.    Folder,
           -folder }
    property SaveFile      : TIniFileName read FSaveFile write SetSaveFile;

    {      }
    property OnFilter       : TsohoTreeOnFilter      read FOnFilter       write FOnFilter;
    {      }
    property OnItemDelete   : TsohoTreeOnDeleteItem  read FOnItemDelete   write FOnItemDelete;
    {      }
    property OnGrpDelete    : TsohoTreeOnDeleteGroup read FOnGrpDelete    write FOnGrpDelete;
    {      }
    property OnNewItem      : TsohoTreeOnNewItem     read FOnNewItem      write FOnNewItem;
    {      }
    property OnNewGrp       : TsohoTreeOnNewGroup    read FOnNewGrp       write FOnNewGrp;
    {      }
    property OnItemEdit     : TsohoTreeOnEditItem    read FOnItemEdit     write FOnItemEdit;
    {      }
    property OnItemMove     : TsohoTreeOnMoveItem    read FOnMoveItem     write FOnMoveItem;
    {      }
    property OnGrpEdit      : TsohoTreeOnEditGroup   read FOnGrpEdit      write FOnGrpEdit;
    {      ""  ,   ,
           ,     .
         ,  OnGrpEdit   -  
              OnCustomEditGrp }
    property OnCustomEditGrp: TsohoTreeCustomGroup   read FOnCustomEditGrp write FOnCustomEditGrp;
    {      ""  ,   ,
           ,     .
         ,  OnNewGrp   -  
              OnCustomEditGrp }
    property OnCustomNewGrp : TsohoTreeCustomGroup   read FOnCustomNewGrp write FOnCustomNewGrp;
    {      }
    property AfterGrpDelete : TNotifyEvent           read FAfterGrpDelete write FAfterGrpDelete;
    property OnGridDblClick     : TNotifyEvent    read FOnGridDblClick    write FOnGridDblClick;
    property OnGridKeyDown      : TKeyEvent       read FOnGridKeyDown     write FOnGridKeyDown;
    property OnGridDragDrop     : TDragDropEvent  read FOnGridDragDrop    write FOnGridDragDrop;
    property OnGridMouseMove    : TMouseMoveEvent read FOnGridMouseMove   write FOnGridMouseMove;
    property OnGridMouseDown    : TMouseEvent     read FOnGridMouseDown   write FOnGridMouseDown;
    property OnGridDragOver     : TDragOverEvent  read FOnGridDragOver    write FOnGridDragOver;
    property OnTreeViewKeyDown   : TKeyEvent       read FOnGroupsKeyDown   write FOnGroupsKeyDown;
    property OnTreeViewMouseDown : TMouseEvent     read FOnGroupsMouseDown write FOnGroupsMouseDown;
    property OnTreeViewMouseMove : TMouseMoveEvent read FOnGroupsMouseMove write FOnGroupsMouseMove;
    property OnTreeViewDragOver  : TDragOverEvent  read FOnGroupsDragOver  write FOnGroupsDragOver;
    property OnTreeViewDragDrop  : TDragDropEvent  read FOnGroupsDragDrop  write FOnGroupsDragDrop;
    property OnChange           : TNotifyEvent    read FOnChange          write FOnChange;
    {       }
    property OnGroupSelect      : TNotifyEvent    read FOnGroupSelect     write FOnGroupSelect;

    {     sohoTreeView Grid }
    property OnCalcCellColors : TCalcCellColorsEvent read FOnCalcCells write FOnCalcCells;
    {     sohoTreeView Grid }
    property OnDrawDataCell   : TDrawDataCellEvent   read FOnDrawCells write FOnDrawCells;

    { -         }
    property OnPopupMenuCreate : TsohoTreeOnPopupCreate read FOnPopupMenuCreate write FOnPopupMenuCreate;
  end;

{    }
function SohoTreeNode (GroupName : string; GroupId : LongInt) : TsohoTreeNode;

const
    {   }
    actDelGroup  = 0;
    {   }
    actNewGroup  = 1;
    {   }
    actEditGroup = 2;
    {   }
    actDelItem   = 3;
    {   }
    actNewItem   = 4;
    {   }
    actEditItem  = 5;
    {   }
    actRefresh   = 6;
    {   }
    actReNumber  = 7;

    {       }
    ButtonsPanelWidth = 60;

implementation
uses IniFiles, SoDBRtn, SoUnit, SoUtils, SohoWrds;

{$R SOTREE32.R32}

const

    rs_sohoTreeDelete   = 12650;
    rs_sohoTreeCreate   = 12651;
    rs_sohoTreeEdit     = 12652;
    rs_sohoTreeRefresh  = 12653;
    rs_sohoTreeReNumber = 12654;

const sohoTreeViewBtnsCaptions : array [ actDelGroup..actReNumber ] of TCaption = (
      '','','',
      '','','',
      '',''
      );

function SohoTreeNode (GroupName : string; GroupId : LongInt) : TsohoTreeNode;
begin
     Result.GroupName := GroupName;
     Result.GroupId   := GroupId;
end;


procedure ApplyTreeViewDescription(TreeView: TTreeView; IniFileName: string);
begin
end;

procedure SaveTreeViewDescription(TreeView: TTreeView; IniFileName: string);
begin
end;

{ TsohoTreeView32 }
function TsohoTreeView32.LocateOnGroup : boolean;
begin
   Result := false;
   if not FGroupsDS.Active then exit;
   Result := LocaleById(FGroupsDS, 'Id',
     GetLeafRecord(FGroups.Selected.AbsoluteIndex).ItemId);
end;

function  TsohoTreeView32.GetResults : TsohoDBGridResults;
begin
     if FGrid=nil then Result := nil
     else Result := FGrid.Results;
end;

procedure TsohoTreeView32.RefreshItems;
begin
   if FFolder<>nil then RefreshFolderWithId(FFolder, 'Id')
   else RefreshDataSet(FItemsDS)
end;

procedure TsohoTreeView32.Changed;
begin
     if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TsohoTreeView32.WriteGrid    (Stream : TStream);
begin
     Stream.WriteComponent(FGrid);
end;

procedure TsohoTreeView32.WriteTreeView;
begin
     Stream.WriteComponent(FGroups);
end;

procedure TsohoTreeView32.ReadGrid     (Stream : TStream);
begin
     Stream.ReadComponent(FGrid);
end;

procedure TsohoTreeView32.ReadTreeView  (Stream : TStream);
begin
     FGroups.Parent := FTreeViewPanel;
     FParSet := true;
     Stream.ReadComponent(FGroups);
end;

procedure TsohoTreeView32.SetSaveFile;
begin
     if FSaveFile = Value then exit;
     FSaveFile := Value;
end;

procedure TsohoTreeView32.RefreshTreeView;
begin
   TreeViewButtonsClick (actRefresh);
end;

procedure TsohoTreeView32.Loaded;
var Index   : LongInt;
    MnuItem : TMenuItem;
begin
     inherited Loaded;
     if not (csDesigning in ComponentState) then begin
        if PopupMenu<>nil then begin
          if Assigned(FOnPopupMenuCreate) then FOnPopupMenuCreate(Self, FPopMenu);
          FPopMenu.Items.Add(NewItem('-', 0, false, true, nil, 0, ''));
          for Index := 0 to pred(PopupMenu.Items.Count) do begin
            MnuItem := PopupMenu.Items[0];
            PopupMenu.Items.Delete(0);
            FPopMenu.Items.Add(MnuItem);
          end;
          FOnPopup := PopupMenu.OnPopup;
        end;
     end;
     if (FFolder<>nil) and not (csDesigning in ComponentState) then begin
       FOnSaveFolder := FFolder.OnSaveDataSet;
       FOnLoadFolder := FFolder.OnLoadDataSet;
       FFolder.OnSaveDataSet := FolderSave;
       FFolder.OnLoadDataSet := FolderLoad;
     end;
     if not Assigned(FGroups.Images) then FGroups.Images := FImages;
end;

procedure TsohoTreeView32.FolderSave (Sender : TObject; DataSet : TDataSet);
begin
     SaveTreeViewState;
     if Assigned(FOnSaveFolder) then FOnSaveFolder(FFolder, FItemsDS);
end;

procedure TsohoTreeView32.FolderLoad (Sender : TObject; DataSet : TDataSet);
begin
     LoadTreeViewState;
     if Assigned(FOnLoadFolder) then FOnLoadFolder(FFolder, FItemsDS);
end;

procedure TsohoTreeView32.SetFolder (Value : TSohoFolder);
begin
     if FFolder=Value then exit;
     {    , ,     }
     if (FFolder<>nil) and not (csDesigning in ComponentState) then begin
          FFolder.OnSaveDataSet := FOnSaveFolder;
          FFolder.OnLoadDataSet := FOnLoadFolder;
     end;
     FFolder := Value;
end;

procedure TsohoTreeView32.DefineProperties (Filer : TFiler);
begin
     inherited DefineProperties(Filer);
     Filer.DefineBinaryProperty('FGrid',ReadGrid,WriteGrid, FGrid <> nil);
     Filer.DefineBinaryProperty('FGroups',ReadTreeView,WriteTreeView, FGroups <> nil);
end;

procedure   TsohoTreeView32.SetGroupsVisible (Show : boolean);
begin
     FTreeViewPanel.Visible := Show;
     if not Show then
        FOptions := FOptions - [trEditItem, trAddItem, trDeleteItem];
     UpdateBtnMenus;
end;

procedure   TsohoTreeView32.SetItemsVisible  (Show : boolean);
begin
    FGridPanel.Visible := Show;
    if not Show then
     FOptions := FOptions - [trEditGroup, trAddGroup, trDeleteGroup];
    UpdateBtnMenus;
end;

function   TsohoTreeView32.GetGroupsVisible;
begin
     Result := FTreeViewPanel.Visible;
end;

function   TsohoTreeView32.GetItemsVisible;
begin
     Result := FGridPanel.Visible;
end;

function TsohoTreeView32.GetIncludeSubTree : boolean;
begin
     Result := FViewChild.Checked;
end;

procedure TsohoTreeView32.SetIncludeSubTree(Value : boolean);
begin
     if FViewChild.Checked = Value then exit;
     FViewChild.Checked := Value;
end;

function TsohoTreeView32.GetIndexByName (Name : string) : LongInt;
var Index : LongInt;
begin
     Result := -1;
     for Index := 0 to pred(FGroups.Items.Count) do
      if Name = FGroups.Items[Index].Text then begin
          Result := Index;
          exit;
      end;
end;

function TsohoTreeView32.GetHash (Left,Right : LongInt) : LongInt;
begin
     Result := Left div 2 + Right div 2;
end;

function TsohoTreeView32.GetLeafRecord  (Index : LongInt) : TTreeLeaf;
begin
    if (Index<1) or (Index>pred(FGroups.Items.Count)) then exit;
    Result := PTreeLeaf(FGroups.Items[Index].Data)^;
end;

function TsohoTreeView32.GetIndexByID (ItemID : LongInt) : LongInt;
var Index : LongInt;
begin
     Result := -1;
     for Index := 1 to pred(FGroups.Items.Count) do
      if ItemID = PTreeLeaf(FGroups.Items[Index].Data)^.ItemID then begin
          Result := Index;
          exit;
      end;
end;

function TsohoTreeView32.FindMaxID (Index : LongInt) : LongInt;
begin
     Result := Index;
     Index  := FGroups.Items[Index].GetLastChild.AbsoluteIndex;
     if Index<>-1 then Result := FindMaxID(Index);
end;

function TsohoTreeView32.AddTreeItem ( ItemId, ParentId, ItemHash, Index : LongInt;
         ItemName : string) : boolean;
var NewLeaf : PTreeLeaf;
begin
     Result := false;
     try
        New(NewLeaf);
     except exit;
     end;
     NewLeaf^.ItemId   := ItemId;
     NewLeaf^.ParentId := ParentId;
     NewLeaf^.ItemHash := ItemHash;
     try
         FGroups.Items.AddChildObject(FGroups.Items[Index], ItemName, NewLeaf);
     except ErrorMsg(Name+': -  ...');
            exit;
     end;
     Result := true;
end;

function  TsohoTreeView32.QuietAddGroup (var NewName : string) : boolean;
var ParentIndex,LastChildIndex,LastChildHash,NewGroupHash,
    NewGroupId,ParentId : LongInt;
    Query : TQuery;
    Allow : boolean;
    F1,F2,F3 : string;

    procedure CreateInsertQuery;
    begin
       Query := TQuery.Create(self);
       with Query,SQL do begin
            if FGroupsDS is TwwQuery then
               DataBaseName := (FGroupsDS as TwwQuery).DataBaseName;
            if FGroupsDS is TwwTable then
               DataBaseName := (FGroupsDS as TwwTable).DataBaseName;

            Add('Insert into "'+FGroupsTable+'"');
            Add('(ID, Hash, IDParent, Name)');
            NewGroupId := SOUnit.GetNewId(GetNewGroupIdPreffix);
            Add('Values ('+IntToStr(NewGroupId)+', '+IntToStr(NewGroupHash)+',');
            ParentId := GetLeafRecord(ParentIndex).ItemId;
            Add(IntToStr(ParentId)+',"'+NewName+'")');
       end;
    end;

begin
     Result := false;
     WordToWordForm (FGroupsName, F1, F2, F3);
     with FGroups do begin
          ParentIndex    := Selected.AbsoluteIndex;
          LastChildIndex := Items[ParentIndex].GetLastChild.AbsoluteIndex;
          if LastChildIndex=-1 then NewGroupHash := 0
          else begin
              LastChildHash := GetLeafRecord(LastChildIndex).ItemHash;
              NewGroupHash  := GetHash(LastChildHash,MaxLongInt);
          end;
     end;
     {  Hash    }
     try
        CreateInsertQuery;
        try
           Allow := true;
           if Assigned(FOnCustomNewGrp) then FOnCustomNewGrp(Self, NewGroupId,
              NewGroupHash, ParentId, NewName, Allow)
           else if Assigned(FOnNewGrp) then FOnNewGrp(Self, SohoTreeNode(NewName,NewGroupID),Allow);
           if Allow then begin
              if not Assigned(FOnCustomNewGrp) then begin
                Screen.Cursor := crSQLWait;
                Query.ExecSQL;
              end;
              {     }
              if AddTreeItem (NewGroupId,  ParentId, NewGroupHash,
                              ParentIndex, NewName) then
                with FGroups do begin
                  Items[ParentIndex].Expand(true);
                  Selected := Items[GetIndexByName(NewName)];
                end;
              {   TreeView }
              Result := true;
           end;
           if Allow and Assigned(FOnCustomNewGrp) then RefreshTreeView;
           Changed;
       except Screen.Cursor := crDefault;
              ErrorMsg(Name+ ': '+F1+'  .');
       end;
     finally
       Query.Free;
       Screen.Cursor := crDefault;
     end;
end;

function  TsohoTreeView32.AddGroup    : boolean;
var NewName : string;
    F1,F2,F3,NewC : string;
begin
     {         }
     Result := false;
     if not (trAddGroup in FOptions) then exit;
     NewName := '';
     {   ,  -      ,
            }
     if not Assigned(FOnCustomNewGrp) then begin
         WordToWordForm (FGroupsName, F1, F2, F3);
         if WordSex(F1)=Female then NewC := ' '
         else NewC := ' ';
         repeat
            if not InputQuery(NewC+F1,' '+F3,NewName) then exit;
            if NewName='' then exit;
            NewName := ChangeChars(NewName,'"','''');
         until GetIndexByName(NewName)=-1;
     {         }
     end;
     Result := QuietAddGroup(NewName);
end;

function  TsohoTreeView32.MoveItem    : boolean;
var Allow : boolean;
    Index : integer;
    
    procedure DoMoveItem (aItemId, aNewGrpId, aNewHash : LongInt);
    begin
     with OperationQuery,OperationQuery.SQL do begin
       DataBaseName := GetDataBaseName(FItemsDS);
       Allow := true;
       if Assigned(FOnMoveItem) then
          FOnMoveItem(Self, FMoveItem.OldGrpId, aNewGrpId, aItemId, aNewHash, Allow);
       if not Allow then exit;
       Clear;
       Add('update "'+FItemsTable+'"');
       Add('set IDGrp='+IntToStr(aNewGrpId)+', Hash='+IntToStr(aNewHash));
       Add('where ID='+IntToStr(aItemId));
       try
         try
            Screen.Cursor := crSQLWait;
            ExecSQL;
            Result := true;
            Changed;
         except
           Screen.Cursor := crDefault;
           ErrorMsg('    !');
         end;
       finally
         Screen.Cursor := crDefault;
       end;
     end;
    end;

begin
     { Event on drag and drop }
     Result := false;
     if not (trMoveItem in FOptions) then exit;
     if FItemsTable='' then begin
        ErrorMsg('    ,  '#13+
        '   ItemsTable!');
        exit;
     end;
     if FGrid.Results.Count=0 then DoMoveItem(FMoveItem.Id, FMoveItem.NewGrpId,
      FMoveItem.NewHash)
     else
       for Index := 0 to pred(FGrid.Results.Count) do begin
         FMoveItem.NewHash := GetHash(FMoveItem.NewHash, RightHash);
         DoMoveItem(FGrid.Results.Items[Index], FMoveItem.NewGrpId, FMoveItem.NewHash);
       end;
     FGrid.Results.Clear;
     RefreshItems;
end;

function  TsohoTreeView32.QuietEditGroup(var NewName : string) : boolean;
var CurIndex           : LongInt;
    aGroupId, aGroupHash,
    aParentId           : LongInt;
    Query              : TQuery;
    Allow              : boolean;

    procedure CreateUpdateQuery;
    begin
        Query := TQuery.Create(self);
        with Query,SQL do begin
             if FGroupsDS is TwwQuery then
                DataBaseName := (FGroupsDS as TwwQuery).DataBaseName;
             if FGroupsDS is TwwTable then
                DataBaseName := (FGroupsDS as TwwTable).DataBaseName;

             Add('Update "'+FGroupsTable+'"');
             Add('Set Name="'+NewName+'"');
             aGroupId   := GetLeafRecord(CurIndex).ItemId;
             aGroupHash := GetLeafRecord(CurIndex).ItemHash;
             aParentId  := GetLeafRecord(CurIndex).ParentId;
             Add('Where Id='+IntToStr(aGroupId));
        end;
    end;

begin
     Result := false;
     CurIndex := FGroups.Selected.AbsoluteIndex;
     try
        try
            CreateUpdateQuery;
            Allow := true;
            if Assigned(FOnCustomEditGrp) then FOnCustomEditGrp(Self, aGroupId,
               aGroupHash, aParentId, NewName, Allow)
            else if Assigned(FOnGrpEdit) then FOnGrpEdit(Self,
                 SohoTreeNode(FGroups.Items[CurIndex].Text, aGroupId),Allow);
            if Allow then begin
               if not Assigned(FOnCustomEditGrp) then begin
                  Screen.Cursor := crSQLWait;
                  Query.ExecSQL;
               end;
               FGroups.Items[CurIndex].Text := NewName;
               Result := true;
               if Allow and Assigned(FOnCustomNewGrp) then RefreshTreeView;
               Changed;
            end;
        except
           Screen.Cursor := crDefault;
           ErrorMsg(Name+':     !');
        end;
     finally
        Query.Free;
        Screen.Cursor := crDefault;
     end;
end;

function  TsohoTreeView32.EditGroup   : boolean;
var NewName : string;
    F1, F2, F3 : string;
    CurIndex,NowIndex  : LongInt;
begin
     {   }
     Result := false;
     if not (trEditGroup in FOptions) then exit;
     with FGroups do begin
        CurIndex := Selected.AbsoluteIndex;
        NewName  := Items[CurIndex].Text;
     end;
     if CurIndex=1 then exit;
     if not Assigned(FOnCustomEditGrp) then begin
        WordToWordForm (FGroupsName, F1, F2, F3);
        repeat
           if not InputQuery(' '+F2,' '+F2, NewName) then exit;
           if NewName='' then exit;
           NewName  := ChangeChars(NewName,'"','''');
           NowIndex := GetIndexByName(NewName);
           if CurIndex=NowIndex then exit;
        until (NowIndex=-1);
     end;
     Result := QuietEditGroup(NewName);
end;

procedure TsohoTreeView32.BeforeGroupEdit (Sender: TObject; Node: TTreeNode; var AllowEdit: Boolean);
begin
  FTmpGrpName := Node.Text;
  AllowEdit := trEditItem in FOptions;
end;

procedure TsohoTreeView32.GroupsEdit (Sender: TObject; Node: TTreeNode; var S: string);
begin
  if S = '' then begin
    Node.Text := FTmpGrpName;
    exit;
  end;
  if S = FTmpGrpName then exit;
  QuietEditGroup(S);
end;

function  TsohoTreeView32.DeleteGroup : boolean;
var JustOneDelete   : boolean;
    WasChecked      : boolean;

    function DeleteSubTree (TreeIndex, GrpId : LongInt) : boolean;
    var GrpName               : string;
        BottomIndex, TopIndex : LongInt;
        Index                 : LongInt;
        DeleteThatGroup       : boolean;
    begin
        GrpName := FGroups.Items[TreeIndex].Text;
        if Assigned(FOnGrpDelete) then FOnGrpDelete(Self,GrpId,Result)
        else Result := YesNoMsg(' : '+GrpName+'?');
        if not Result then exit;
        TopIndex    := FGroups.Items[TreeIndex].GetFirstChild.AbsoluteIndex;
        BottomIndex := FGroups.Items[TreeIndex].GetLastChild.AbsoluteIndex;
        {  ,  ...  :( }
        { ,  ,        
          ,     . ,    
             :) }
        DeleteThatGroup := true;
        if TopIndex<>-1 then begin
          Index := TopIndex;
          while Index<=BottomIndex do begin
             if not DeleteSubTree(Index, GetLeafRecord(Index).ItemId) then
                DeleteThatGroup := false
             else JustOneDelete := true;
             inc(Index);
          end;
        end;
        {     -   ,
           IdGrp  }
        try
          FItemsDS.DisableControls;
          FGroups.Selected := FGroups.Items[TreeIndex];
          with OperationQuery, OperationQuery.SQL do begin
              Clear;
              DataBaseName := GetDataBaseName(FItemsDS);
              Add('delete from "'+FItemsTable+'"');
              Add('Where ID=:Id');
          end;
          with FItemsDS do begin
             Refresh;
             {    }
             while not Eof do begin
                if not DeleteOneRecord(true, FItemsDS.FieldByName('Id').AsInteger)
                 then DeleteThatGroup := false
                else JustOneDelete := true;
                Next;
             end;
          end;
          {     }
          if DeleteThatGroup then
          with OperationQuery, OperationQuery.SQL do begin
              Clear;
              DataBaseName := GetDataBaseName(FItemsDS);
              Add('delete from "'+FGroupsTable+'"');
              Add('Where ID='+IntToStr(GrpId));
              try
                 ExecSQL;
                 JustOneDelete := true;
              except ErrorMsg('   : '+GrpName);
              end;
          end;
        finally
          FItemsDS.EnableControls;
          Result := DeleteThatGroup;
        end;
    end;

begin
     Result := false;
     JustOneDelete := false;
     if not (trDeleteGroup in FOptions) then exit;
     WasChecked := FViewChild.Checked;
     FViewChild.Checked := false;
     Result := DeleteSubTree(FGroups.Selected.AbsoluteIndex,
               GetLeafRecord(FGroups.Selected.AbsoluteIndex).ItemId);
     {     ,   }
     FViewChild.Checked := WasChecked;
     if not JustOneDelete then exit;
     if Assigned(FAfterGrpDelete) then FAfterGrpDelete(Self);
     {    -   !}
     TreeViewButtonsClick(actRefresh);
     Changed;
end;

function  TsohoTreeView32.AddNewItem (GrpId,ItemId,ItemHash : LongInt) : boolean;
begin
     Screen.Cursor := crSQLWait;
     Result := false;
     with OperationQuery, OperationQuery.SQL do begin
         Clear;
         DataBaseName := GetDataBaseName(FItemsDS);
         Add('insert into "'+FItemsTable+'" (ID, IDGrp, Hash)');
         Add('values ('+IntToStr(ItemId)+', '+IntToStr(GrpId)+
             ', '+IntToStr(ItemHash)+')');
         try
            ExecSQL;
            Result := true;
         except ErrorMsg(Name+':    !');
         end;
     end;
     Screen.Cursor := crDefault;
end;

function TsohoTreeView32.GetNewGroupIdPreffix : string;
begin
     if FGroupPreffix <> '' then Result := FGroupPreffix
     else Result := Owner.Name+'.'+Name+'.Group';
end;

function TsohoTreeView32.GetNewItemIdPreffix : string;
begin
     if FItemsPreffix <> '' then Result := FItemsPreffix
     else Result := Owner.Name+'.'+Name+'.Items';
end;

function TsohoTreeView32.AddItem     : boolean;
var NewId,GrpId   : LongInt;
    NewHash : LongINt;
begin
     Result  := false;
     if not (trAddItem in FOptions) then exit;
     {         }
     NewId := SOUnit.GetNewId(GetNewItemIdPreffix);
     GrpId := GetLeafRecord(FGroups.Selected.AbsoluteIndex).ItemId;
     {    }
     NewHash := GetNewItemHash(GrpId,FNameGrID);
     if Assigned(FOnNewItem) then FOnNewItem(Self, GrpId, NewId, NewHash, Result);
     {      AddNewItem(IDGrp,IDItem, ItemHash) }
     if Result then begin
        RefreshItems;
        Changed;
     end;
end;

function  TsohoTreeView32.EditItem    : boolean;
begin
     Result := false;
     if not (trEditItem in FOptions) then exit;
     if FItemsDS.FieldByName('Id').IsNull then Result := AddItem
     else
        if Assigned(FOnItemEdit) then FOnItemEdit(Self,
           GetLeafRecord(FGroups.Selected.AbsoluteIndex).ItemId,
           FItemsDS.FieldByName('ID').AsInteger,Result);
     if Result then begin
        RefreshItems;
        Changed;
     end;
end;

function TsohoTreeView32.DeleteOneRecord (ManyDelete : boolean; ItemId : LongInt) : boolean;
const MsgTexts : array [boolean] of string = ('  ?',
      '  ?');
begin
    Result := false;
    if Assigned(FOnItemDelete) then FOnItemDelete(Self, ItemId, ManyDelete, Result)
    else Result := YesNoMsg(MsgTexts[ManyDelete]);
    if not Result then exit;
    try
      with OperationQuery do begin
          Params[0].AsInteger := ItemId;
          try
             Screen.Cursor := crSQLWait;
             ExecSQL;
             {        
               !}
             Results.Delete(ItemId);
             Result := true;
          except ErrorMsg(Name+':    !');
          end;
      end;
    finally
      Screen.Cursor := crDefault;
    end;
end;

function  TsohoTreeView32.DeleteItem  : boolean;
var Id, Index  : LongInt;
    ManyDelete : boolean;
begin
     Result := false;
     if not (trDeleteItem in FOptions) then exit;
     if (FItemsDS = nil) or not (FItemsDS.Active) then exit;
     if FItemsDS.FieldByName('Id').IsNull then exit;
     Result := true;
     Id         := FItemsDS.FieldByName('ID').AsInteger;
     ManyDelete := Results.Count<>0;
     with OperationQuery, OperationQuery.SQL do begin
         Clear;
         DataBaseName := GetDataBaseName(FItemsDS);
         Add('delete from "'+FItemsTable+'"');
         Add('Where ID=:Id');
     end;
     if ManyDelete then begin
       Result := false;
       {   ,      
         .}
       Index := 0;
       while Index<Results.Count do begin
         if DeleteOneRecord(true, Results.Items[Index]) then Result := true
         else inc(Index);
       end;
     end
     else Result := DeleteOneRecord(false, Id);
     { -   ,   }
     if Result then begin
        RefreshItems;
        Changed;
     end;
end;

function TsohoTreeView32.CreateGroupsTree : boolean;

   function GetParentIndex (ParentId : LongInt) : integer;
   var sIndex : integer;
   begin
        Result := -1;
        for sIndex := 1 to pred(FGroups.Items.Count) do
         with FGroups.Items[sIndex] do begin
            if PTreeLeaf(Data)^.ItemId = ParentId then begin
                Result := sIndex;
                exit;
            end;
         end;
   end;

var LastParentId,LastIndex,Index : LongInt;
    ItemId,ParentId,ItemHash     : LongInt;
    ItemName                     : string;
    DoAddItem                    : boolean;
    ParentIndex                  : LongInt;
    
begin
     Result := false;
     if FGroups=nil then begin
         ErrorMsg(Name+':  nil  TreeView!');
         exit;
     end;
     for Index := 1 to pred(FGroups.Items.Count) do
       Dispose(PTreeLeaf(FGroups.Items[Index].Data));

     FGroups.Items.BeginUpdate;
     FGroups.Items.Clear;
     SetRootName(FRootName);
     with FGroupsDS do begin
          if not Active then
            try
               Open;
            except ErrorMsg(Name+':     !');
                   exit;
            end;
          {  }
          LastParentId := 0;
          LastIndex    := 1;
          //if not AddTreeItem(0,0,0,0,FRootName) then exit;
          {    }
          First;
          while not Eof do begin
               ItemId   := FieldByName('Id').AsInteger;
               ParentId := FieldByName('IdParent').AsInteger;
               ItemHash := FieldByName('Hash').AsInteger;
               ItemName := FieldByName('Name').AsString;
               DoAddItem := ((ItemId=FFixedGrpId) or (FFixedGrpId=-1))
                            and
                            ((CompareText(ItemName,FFixedGrpName)=0) or (FFixedGrpName=''));

               if DoAddItem then
                   AddTreeItem(ItemId,ParentId,ItemHash,0,ItemName);
               Next;
          end;
          if FCloseGroups then Close;
     end;
     Index := pred(FGroups.Items.Count);
     with FGroups do begin
       while Index>0 do begin
        ParentId := GetLeafRecord(Index).ParentId;
        ParentIndex := GetParentIndex(ParentId);
        if (ParentId<>0) and //     
           (Items[Index].Parent.AbsoluteIndex<>ParentIndex) then begin
          Items[Index].MoveTo(Items[ParentIndex], naAddChild)
        end
        else dec(Index);
       end;
       FullExpand;
       Selected := Items[0];
       for Index := 0 to pred(Items.Count) do
         Items[Index].ImageIndex := 2;
     end;
     FGroups.Items.EndUpdate;
     Result := true;
end;


procedure TsohoTreeView32.Notification(AComponent : TComponent; Operation : TOperation);
begin
     if (AComponent=FGroupsDS) and (Operation=opRemove) then begin
        Active := false;
        FGroupsDS:=nil;
     end;
     if (AComponent=FItemsDS) and (Operation=opRemove) then begin
        Active := false;
        FItemsDS:=nil;
     end;
end;

procedure TsohoTreeView32.SetGroupsTable;
begin
     FGroupsTable := Value;
end;

procedure TsohoTreeView32.SetTreeViewWidth  (Value : integer);
begin
     FTreeViewPanel.Width := Value;
end;

procedure  TsohoTreeView32.LoadTreeViewState;
var FIniFile : TFIleName;
begin
     if csDesigning in ComponentState then exit;
     FIniFile := FSaveFile;
     if (FIniFile='') and (FFolder<>nil) then FIniFile := FFolder.FullFolderName;
     if FIniFile = '' then exit;
     with TIniFile.Create(FIniFile) do begin
       if trSaveSplitter in FSaveOptions then
          FTreeViewPanel.Width := ReadInteger(Owner.ClassName+Name+'Splitter',
          'Width',FTreeViewPanel.Width);
       if trSaveViewChild in FSaveOptions then
          FViewChild.Checked := ReadBool(Owner.ClassName+Name+'ViewChild',
          'View',false);
       Free;
     end;
     try
        if trSaveTreeView in FSaveOptions then ApplyTreeViewDescription(FGroups,FIniFile);
     except {     }
     end;
end;

procedure  TsohoTreeView32.SaveTreeViewState;
var FIniFile : TFIleName;
begin
     if csDesigning in ComponentState then exit;
     FIniFile := FSaveFile;
     if (FIniFile='') and (FFolder<>nil) then FIniFile := FFolder.FullFolderName;
     if FIniFile = '' then exit;
     with TIniFile.Create(FIniFile) do  begin
       if trSaveSplitter in FSaveOptions then
          WriteInteger(Owner.ClassName+Name+'Splitter','Width',FTreeViewPanel.Width);
       if trSaveViewChild in FSaveOptions then
          WriteBool(Owner.ClassName+Name+'ViewChild','View',FViewChild.Checked);
       Free;
       if trSaveTreeView in FSaveOptions then SaveTreeViewDescription(FGroups,FIniFile);
    end;
end;

procedure TsohoTreeView32.SetActive (Value : boolean);

    procedure RestoreDataSets;
    begin
        if FOldGrp then FGroupsDS.Open
        else FGroupsDS.Close;
        if FOldItm then FItemsDS.Open
        else FItemsDS.Close;
        {FGroupsDS.Active := FOldGrp;
        FItemsDS.Active  := FOldItm;}
    end;

begin
     if (FActive = Value) then exit;
     if (FGroupsDS=nil) or (FItemsDS=nil) or
        (FNameGrID='') or (FGroupsTable='') then begin
        ErrorMsg(Name+':    TreeView.  ItemsDataSet, GroupsDataSet,'#13+
                 'GroupsTable  NameGroupID');
        exit;
     end;
     if not Value then begin
        if FFolder<>nil then begin
           FFolder.SaveDataSet;
           FFolder.SaveDBGridColumns;
           FFolder.DeActivate;
           FFolder.RestoreEvents;
           FFolder.Grid := nil;
        end;
        {      Popup}
        FGrid.PopupMenu.OnPopup := OnMenuPopup;
        RestoreDataSets;
        FActive := Value;
        if FGroups<>nil then FGroups.Items.Clear;
        if FItemsDS is TwwQuery then
           (FItemsDS as TwwQuery).OnFilter := FQryOnFilter;
        if FItemsDS is TwwTable then
           (FItemsDS as TwwTable).OnFilter := FTblOnFilter;
        exit;
     end;
     try
        FOldGrp := FGroupsDS.Active;
        FOldItm := FItemsDS.Active;
        if not FGroupsDS.Active then FGroupsDS.Open;
        if not FItemsDS.Active then FItemsDS.Open;
        {Check fields}
        with FGroupsDS do
        if (FindField('ID')=nil) or
           (FindField('IDParent')=nil) or
           (FindField('Name')=nil) or
           (FindField('Hash')=nil)
           then begin
           ErrorMsg(Name+':       : ID, IDParent, Hash, Name!');
           RestoreDataSets;
           exit;
        end;

        with FItemsDS do begin
          if (FindField('ID')=nil) or
             (FindField(FNameGrID)=nil) or
             (FindField('Hash')=nil) then begin
             ErrorMsg(Name+':       : ID,'+
              FNameGrID+',Hash !');
             RestoreDataSets;
             exit;
          end;
        end;

        with FGroups do begin
             Parent  := FTreeViewPanel;
             Align   := alClient;
             PopupMenu := FGroupMenu;
             OnClick := GroupSelected;
        end;

        CreateGroupsTree;
        FQryOnFilter := nil;
        FTblOnFilter := nil;

        if FItemsDS is TwwQuery then begin
           FQryOnFilter := (FItemsDS as TwwQuery).OnFilter;
           (FItemsDS as TwwQuery).OnFilter := CheckQueryFilter;
        end;
        if FItemsDS is TwwTable then begin
           FTblOnFilter := (FItemsDS as TwwTable).OnFilter;
           (FItemsDS as TwwTable).OnFilter := CheckTableFilter;
        end;

        FGrid.DataSource := FSource;
        FSource.DataSet  := FItemsDS;
        FActive := Value;
        {LoadTreeViewState;}
        if FFolder<>nil then begin
           FFolder.Grid := FGrid;
           FFolder.Activate;
           FFolder.LoadDBGridColumns;
        end;
       FGrid.PopupMenu := FPopMenu;
     except ErrorMsg(Name+':    DataSets');
     end;
end;

procedure TsohoTreeView32.SetGroupsDataSet (Value : TDataSet);
begin
     if FGroupsDS = Value then exit;
     if not (Value is TwwQuery) and not (Value is TwwTable) then begin
        ErrorMsg(Name+':     TwwQuery,  TwwTable!');
        exit;
     end;
     Active := false;
     FGroupsDS := Value;
end;

procedure TsohoTreeView32.SetItemsDataSet  (Value : TDataSet);
begin
     if FItemsDS = Value then exit;
     if not (Value is TwwQuery) and not (Value is TwwTable) then begin
        ErrorMsg(Name+':     TwwQuery,  TwwTable!');
        exit;
     end;
     Active := false;
     FItemsDS := Value;
end;

procedure TsohoTreeView32.SetOrderField    (Value : string);
begin
    if FOrderField = Value then exit;
    Active := false;
    FOrderField := Value;
end;

procedure TsohoTreeView32.SetHashField     (Value : string);
begin
    if FHashField = Value then exit;
    Active := false;
    FHashField := Value;
end;

procedure TsohoTreeView32.SetNameGrID (Value : string);
begin
    if FNameGrID = Value then exit;
    Active := false;
    FNameGrId := Value;
end;

procedure TsohoTreeView32.SetOptions (Value : TsohoTreeOptions);
begin
     if FOptions = Value then exit;
     FOptions := Value;
     UpdateBtnMenus;
end;

procedure TsohoTreeView32.SetGroupsName (Value : string);
begin
     if FGroupsName = Value then exit;
     FGroupsName := Value;
     UpdateBtnMenus;
end;

procedure TsohoTreeView32.SetItemsName (Value : string);
begin
     if FItemsName = Value then exit;
     FItemsName := Value;
     UpdateBtnMenus;
end;

procedure TsohoTreeView32.UpdateBtnMenus;
var Index    : integer;
    F1,F2,F3 : string;
begin
     if csDestroying in ComponentState then exit;
     for Index := actDelGroup to actReNumber do
         with FBtnMenu.Items[Index] do begin
            Caption := sohoTreeViewBtnsCaptions[Index];
            if (Index < 3) then WordToWordForm(FGroupsName, F1, F2, F3)
            else WordToWordForm(FItemsName, F1, F2, F3);
            if Index <= actEditItem then Caption := Caption + ' '+ F2;
            if Index <= actReNumber then Enabled := TsohoTreeOption(Index) in FOptions;
         end;
end;

function  TsohoTreeView32.GetItemId : LongInt;
begin
     Result := -1;
     if (FItemsDS=nil) or (not FItemsDS.Active) then exit;
     Result := FItemsDS.FieldByName('ID').AsInteger;
end;

procedure TsohoTreeView32.SetItemId (Value : LongInt);
var CurGrp,CurItem : LongInt;
    Id,Index : LongInt;
begin
     if (FItemsDS=nil) or (not FItemsDS.Active) then begin
       ErrorMsg(Name+':     '+#13+
       ' DataSet!');
       exit;
     end;
     if Value < 0 then exit;
     {     ! }
     CurGrp  := FGroups.Selected.AbsoluteIndex;
     with FItemsDS do begin
          CurItem := FieldByName('ID').AsInteger;
          DisableControls;
          Screen.Cursor := crSQLWait;
          for Index := 1 to pred(FGroups.Items.Count) do begin
             FGroups.Selected := FGroups.Items[Index];
             First;
             Id := -1;
             while not Eof do begin
                 Id := FieldByName('ID').AsInteger;
                 if ID=Value then begin
                    FGroups.Selected :=
                      FGroups.Items[GetIndexByID(FieldByName(FNameGrID).AsInteger)];
                    EnableControls;
                    Screen.Cursor := crDefault;
                    exit;
                 end;
                 Next;
             end;
          end;
          {ErrorMsg('   !');}
          FGroups.Selected := FGroups.Items[CurGrp];
          First;
          while not Eof and not (CurItem=FieldByName('ID').AsInteger) do Next;
          EnableControls;
          Screen.Cursor := crDefault;
     end;
end;

procedure   TsohoTreeView32.Paint;
begin
     inherited Paint;
     if not FParSet then begin
       FGroups.Parent := FTreeViewPanel;
       FParSet := true;
     end;
     FTreeViewPanel.Update;
     FGridPanel.Update;
end;

procedure   TsohoTreeView32.ViewChildClick(Sender : TObject);
begin
     if FActive then GroupSelected(Sender);
end;

procedure TsohoTreeView32.CreateBtnMenus;
var Index : LongInt;
    Item  : TMenuItem;
begin
     for Index := actDelGroup to actReNumber do begin
       Item := NewItem(sohoTreeViewBtnsCaptions[Index], 0, false, true, ButtonMenuClick, 0, '');
       Item.Tag := Index;
       FBtnMenu.Items.Add(Item);
     end;
end;

constructor TsohoTreeView32.Create (AOwner : TComponent);
var CheckM : TMenuItem;
begin
     inherited Create(AOwner);
     FOptions     := [trDeleteGroup, trAddGroup, trEditGroup, trDeleteItem,
                      trAddItem, trEditItem, trRefresh, trReNumber,
                      trMoveItem,trMoveGroup];
     FSaveOptions := [trSaveSplitter];
     FEditOnDblClick := true;
     FGroupsDS   := nil;
     FItemsDS    := nil;
     FFolder     := nil;
     FActive     := false;
     FNameGrID   := 'IDGrp';
     FOrderField := 'NumOrder';
     FHashField  := 'Hash';
     FItemsName  := '';
     FGroupsName  := '';
     Font.Name   := 'Ms Sans Serif';
     Font.Size   := 8;
     FFixedGrpId := -1;
     FFixedGrpName := '';
     FItemsPreffix := '';
     FGroupPreffix := '';
     FCloseGroups  := true;

     { Create visible controls }
     Width  := 400;
     Height := 200;

     FBtnsPanel := TPanel.Create(Self);
     with FBtnsPanel do begin
          Parent := self;
          Width  := ButtonsPanelWidth;
          Align  := alLeft;
          BevelOuter  := bvNone;
          BevelInner  := bvNone;
          ParentColor := true;
          ParentFont  := true;
     end;

     FComPanel := TPanel.Create(Self);
     with FComPanel do begin
          Parent := self;
          Align  := alClient;
          BevelOuter  := bvNone;
          BevelInner  := bvNone;
          ParentColor := true;
          ParentFont  := true;
     end;

     FTreeViewPanel := TPanel.Create(Self);
     with FTreeViewPanel do begin
          Parent := FComPanel;
          Width  := 100;
          Align  := alLeft;
          BevelOuter  := bvNone;
          BevelInner  := bvNone;
          ParentColor := true;
          ParentFont  := true;
     end;

     FSplitter := TsohoSplitter.Create(self);
     with FSplitter do begin
       Parent := FComPanel;
       Left   := FTreeViewPanel.Left+FTreeViewPanel.Width + 2;
       Align  := alLeft;
     end;

     FGridPanel := TPanel.Create(Self);
     with FGridPanel do begin
          Parent := FComPanel;
          Align  := alClient;
          BevelOuter := bvNone;
          BevelInner := bvNone;
          Caption    := ' ';
          ParentColor := true;
          ParentFont  := true;
     end;

     FGrid := TsohoDBGrid.Create(self);
     with FGrid do begin
          Parent  := FGridPanel;
          Align   := alClient;
          Options := [wwDBIGrd.dgTitles, wwDBIGrd.dgIndicator, wwDBIGrd.dgColumnResize,
          wwDBIGrd.dgColLines, wwDBIGrd.dgRowLines, wwDBIGrd.dgTabs,
          wwDBIGrd.dgAlwaysShowSelection, wwDBIGrd.dgCancelOnExit];
          ReadOnly := true;
          OnCalcCellColors := GridCellColors;
          OnDrawDataCell   := GridDataCell;
          OnDblClick       := GridDblClick;
          OnKeyDown        := GridKeyDown;
          OnDragDrop       := ItemsGridDragDrop;
          OnMouseMove      := ItemsGridMouseMove;
          OnMouseDown      := ItemsGridMouseDown;
          OnDragOver       := ItemsGridDragOver;
          ParentFont       := true;
     end;

     FBtnMenu           := TPopupMenu.Create(Self);
     CreateBtnMenus;

     FMenuBtn      := TRxSpeedButton.Create(self);
     with FMenuBtn do begin
       Parent       := FBtnsPanel;
       Transparent  := true;
       DropDownMenu := FBtnMenu;
       Width        := ButtonsPanelWidth - 4;
       Left         := 2;
       Top          := 2;
       Hint         := '     ';
       Glyph.Handle := ResBitmap('SOHOTVMENUBTN32');
     end;

     FViewChild := TCheckBox.Create(Self);
     with FViewChild do begin
          Parent  := FBtnsPanel;
          Hint    := '    ';
          Checked := false;
          OnClick := ViewChildClick;
          Top     := FMenuBtn.Top + FMenuBtn.Height + 4;
          Left    := 2;
          Caption := '.';
     end;

     FEnabledItem := NewItem('&',0,false,true,MenuItemClick,0,'');
     FEnabledItem.Tag := -1;
     FDisabledItem := NewItem('& ',0,false,true,MenuItemClick,0,'');
     FDisabledItem.Tag := -1;
     FPopMenu := NewPopupMenu(self,'',paLeft,true,[FEnabledItem, FDisabledItem]);
     FPopMenu.OnPopup := OnMenuPopup;

     FGrpSelItem   := NewItem('&',0,false,true,MenuItemClick,0,'');
     FGrpDeselItem := NewItem('& ',0,false,true,MenuItemClick,0,'');
     FGroupMenu    := NewPopupMenu(self,'',paLeft,true,[FGrpSelItem, FGrpDeselItem]);
     FGroupMenu.OnPopup := OnMenuPopup;

     FImages := TImageList.Create(Self);
     FImages.GetResource(rtBitmap, 'SOHOTREEVIEW32IMAGES', 0,
        [lrDefaultSize,lrTransparent], clBlue);

     FGroups := TTreeView.Create(self);
     with FGroups do begin
         Name        := Self.Name+'TreeView';
         Align       := alClient;
         Parent      := FTreeViewPanel;
         PopupMenu   := FGroupMenu;
         OnKeyDown   := GroupsKeyDown;
         OnMouseDown := GroupsMouseDown;
         OnMouseMove := GroupsMouseMove;
         OnDragOver  := GroupsDragOver;
         OnDragDrop  := GroupsDragDrop;
         OnEdited    := GroupsEdit;
         OnEditing   := BeforeGroupEdit;
     end;

     FParSet       := false;

     FGrid.PopupMenu := FPopMenu;

     FSource   := TwwDataSource.Create(self);
     FRootName := '';
     FGrid.DataSource := FSource;

     OperationQuery := TwwQuery.Create(self);
     with FMoveItem do begin
        Id            := -1;
        OldGrpId      := -1;
        NewGrpId      := -1;
        NewHash       := -1;
        {Fields for drag&drop}
        ItemDragBegin := false;
        DragOverId    := -1;
        GridDrag      := false;
        GridRow       := -1;
     end;
     with FMoveGroup do begin
         GrpDragSourceRow := -1;
     end;

end;

procedure TsohoTreeView32.SetRootName;
begin
     FRootName := Value;
     if csLoading in ComponentState then exit;
     if FGroups.Items.Count<>0 then FGroups.Items[0].Text := Value
     else FGroups.Items.Add(nil, Value);
end;

function  TsohoTreeView32.RenumberRecords : boolean;
var Index : LongInt;
    Number    : LongInt;
    FMany     : boolean;
begin
     {    }
     Result := true;
     FMany  := FViewChild.Checked;
     FViewChild.Checked := false;
     Number := 0;
     if FSaveFile<>'' then SaveTreeViewDescription(FGroups,FSaveFile);
     FGroups.FullExpand;
     for Index := 0 to pred(FGroups.Items.Count) do begin
         FGroups.Selected := FGroups.Items[Index];
         FItemsDS.First;
         while not FItemsDS.Eof do begin
            inc(Number);
            with OperationQuery,SQL do begin
                 Clear;
                 Add('update "'+FItemsTable+'" as Item');
                 Add('set Item."'+FOrderField+'"='+IntToStr(Number));
                 Add('where Item.Id='+FItemsDS.FieldByName('Id').AsString);
                 ExecSQL;
            end;
            FItemsDS.Next;
         end;
     end;
     RefreshItems;
     try
        if FSaveFile<>'' then ApplyTreeViewDescription(FGroups,FSaveFile);
     except
     end;
     FViewChild.Checked := FMany;
end;

procedure TsohoTreeView32.TreeViewButtonsClick (ButtonIndex : LongInt);
var Res   : boolean;
    FIniFile : TFileName;
begin
     Res := false;
     case ButtonIndex of
        actDelGroup  : Res := DeleteGroup; { }
        actNewGroup  : Res := AddGroup;    { }
        actEditGroup : EditGroup;          { }
        actDelItem   : Res := DeleteItem;  { item}
        actNewItem   : Res := AddItem;     { item}
        actEditItem  : Res := EditItem;    { item}
        actRefresh   : begin Res := true;  {}
                         if trSaveTreeView in FSaveOptions then begin
                            FIniFile := FSaveFile;
                            if (FIniFile='') and (FFolder<>nil) then
                                 FIniFile := FFolder.FullFolderName;
                            SaveTreeViewDescription(FGroups, FIniFile);
                         end;
                         Active := false;
                         Active := true;
                         try
                           if trSaveTreeView in FSaveOptions then
                                ApplyTreeViewDescription(FGroups,FIniFile);
                         except
                         end;
                       end;
       actReNumber   : Res := RenumberRecords; {}
     end;
     if Res then GroupSelected(FGroups);
end;

procedure TsohoTreeView32.ButtonMenuClick  (Sender : TObject);
var Index : integer;
begin
     Index := (Sender as TMenuItem).Tag;
     if (Index>=actDelGroup) and (Index<=actReNumber) then TreeViewButtonsClick (Index);
end;

function TsohoTreeView32.InGroup (FilterGroup : LongInt) : boolean;
var Index  : integer;
    Ftmp   : TTreeLeaf;
begin
     Result := false;
     with FGroups do begin
       if Selected.AbsoluteIndex = pred(Items.Count) then exit; {  }
       if not Selected.HasChildren then exit;
       Result := true;
       for Index := Selected.AbsoluteIndex+1 to FBottomIndex do begin
          FTmp := GetLeafRecord(Index);
          if Ftmp.ItemId = FilterGroup then exit;
       end;
       Result := false;
     end;
end;

procedure TsohoTreeView32.CheckTableFilter (Table : TwwTable; var Accept : boolean);
var GrpId,CurId : LongInt;
    Allow : boolean;
begin
     GrpId  := GetLeafRecord(FGroups.Selected.AbsoluteIndex).ItemId;
     CurId  := (FItemsDS as TwwTable).wwFilterField('IdGrp').AsInteger;
     if not FViewChild.Checked then Allow := CurId  = GrpId
     else Allow := (GrpID=0) or (CurID=GrpId) or InGroup(CurID);
     if Assigned(FOnFilter) then FOnFilter(Self, FItemsDS, Allow);
     Accept := Allow;
     if Assigned(FTblOnFilter) then FTblOnFilter(Table, Accept);
end;

procedure TsohoTreeView32.CheckQueryFilter (Table : TwwQuery; var Accept : boolean);
var GrpId : LongInt;
    CurID : LongInt;
    Allow : boolean;
begin
     GrpId  := GetLeafRecord(FGroups.Selected.AbsoluteIndex).ItemId;
     CurID  := (FItemsDS as TwwQuery).wwFilterField('IdGrp').AsInteger;
     if not FViewChild.Checked then Allow := CurId  = GrpId
     else Allow := (GrpID=0) or (CurID=GrpId) or InGroup(CurID);
     if Assigned(FOnFilter) then FOnFilter(Self,FItemsDS, Allow);
     Accept := Allow;
     if Assigned(FQryOnFilter) then FQryOnFilter(Table, Accept);
end;

procedure TsohoTreeView32.RefreshGroup;
begin
    GroupSelected(FGroups);
end;

procedure TsohoTreeView32.GroupSelected (Sender : TObject);
begin
     {      }
     with FGroups do begin
        FBottomIndex := Selected.AbsoluteIndex;
        while Items[FBottomIndex].HasChildren do
           FBottomIndex := Items[FBottomIndex].GetLastChild.AbsoluteIndex;
     end;
     { Update filter texts }
     FItemsDS.Refresh;
     if FItemsDS is TwwTable then
       FGrid.Visible := (FItemsDS as TwwTable).FilterCount>0;
     if Assigned(FOnGroupSelect) then FOnGroupSelect(Self);
end;

procedure TsohoTreeView32.GridDblClick     (Sender : TObject);
begin
     if FEditOnDblClick then EditItem;
     if Assigned(FOnGridDblClick) then FOnGridDblClick(Sender);
end;

procedure TsohoTreeView32.GridDataCell     (Sender: TObject; const Rect: TRect; Field: TField;
          State: TGridDrawState);
begin
     if Assigned(FOnDrawCells) then FOnDrawCells(Sender, Rect, Field, State);
end;

procedure TsohoTreeView32.GridCellColors (Sender: TObject; Field: TField;
          State: TGridDrawState; highlight: Boolean; AFont: TFont; ABrush: TBrush);
begin
     if Assigned(FOnCalcCells) then FOnCalcCells(Sender, Field, State, HighLight,
        AFont, ABrush);
end;

procedure TsohoTreeView32.GridKeyDown (Sender: TObject; var Key: Word; Shift: TShiftState);
begin
     if Assigned(FOnGridKeyDown) then FOnGridKeyDown(Sender, Key, Shift);
     case Key of
       vk_Insert : begin
                     if Shift=[] then begin
                        TreeViewButtonsClick(actNewItem);
                        Key := 0;
                     end;
                     if (Shift=[ssCtrl]) and (not FMoveItem.ItemDragBegin) then begin
                         Key := 0;
                         if not (trMoveItem in FOptions) then exit;
                         FMoveItem.ItemDragBegin := true;
                         FMoveItem.Id := FItemsDS.FieldByName('Id').AsInteger;
                         SetCaptureControl(FGrid);
                         Screen.Cursor  := crCross;
                     end;
                     if (Shift=[ssShift]) and FMoveItem.ItemDragBegin then  begin
                        Key := 0;
                        SetCaptureControl(nil);
                        if not (trMoveItem in FOptions) then exit;
                        FMoveItem.ItemDragBegin := false;
                        with FItemsDS do begin
                          FMoveItem.DragOverId := FieldByName('Id').AsInteger;
                          FMoveItem.NewGrpId   := FieldByName('IdGrp').AsInteger;
                          RightHash  := FieldByName('Hash').AsInteger;
                          Prior;
                          if FieldByName('Id').AsInteger=FMoveItem.DragOverId then
                            LeftHash := -MaxLongInt
                          else LeftHash := FieldByName('Hash').AsInteger;
                          FMoveItem.NewHash := GetHash(LeftHash, RightHash);
                          { NewHash = Left or Right ,  
                             }
                           {InfoMsg('   !'#13+
                           '  !');}
                        end;
                        {       Hash,    ID }
                        MoveItem;
                        {  Resfresh   }
                        RefreshItems;
                     end;
                   end;
       vk_Escape : if FMoveItem.ItemDragBegin then  begin
                       SetCaptureControl(nil);
                       FMoveItem.ItemDragBegin := false;
                       Screen.Cursor := crDefault;
                       Key := $00;
                   end;
       vk_Return : if Shift = [ssAlt] then TreeViewButtonsClick(actEditItem);
       vk_Delete : DeleteItem;
     end;
end;

procedure TsohoTreeView32.OnMenuPopup (Sender : TObject);
var Index : LongInt;

begin
     if (Sender=FEnabledItem) or (Sender=FDisabledItem) then begin
        Index := Results.IndexOf(FItemsDS.FieldByName('ID').AsInteger);
        with FPopMenu do begin
             FEnabledItem.Enabled := Index=-1;
             FDisabledItem.Enabled := Index<>-1;
        end;
     end;
     if (Sender<>FGroupMenu) and Assigned(FOnPopup) then FOnPopup(Sender);
end;

procedure TsohoTreeView32.MenuItemClick    (Sender : TObject);

    procedure SelectGroup (DoSelect : boolean);
    var OldCheck : boolean;
    begin
         OldCheck := FViewChild.Checked;
         try
            with FItemsDS do begin
               DisableControls;
               FViewChild.Checked := true;
               First;
               while not Eof do begin
                  if DoSelect then Results.AddItem(FItemsDS.FieldByName('ID').AsInteger)
                  else Results.DeleteItem(FItemsDS.FieldByName('ID').AsInteger);
                  Next;
               end;
            end;
         finally
            FViewChild.Checked := OldCheck;
            FItemsDS.EnableControls;
         end;
    end;

begin
     with Sender As TMenuItem do begin
        if (Sender = FEnabledItem) or (Sender = FDisabledItem) then begin
           if Sender = FEnabledItem then Results.AddItem(FItemsDS.FieldByName('ID').AsInteger)
           else Results.DeleteItem(FItemsDS.FieldByName('ID').AsInteger);
        end
        else begin
           if (Sender=FGrpSelItem) then { } SelectGroup(true)
           else {   } SelectGroup(false);
        end;
     end;
end;

destructor  TsohoTreeView32.Destroy;
begin
     {SaveTreeViewState;}
     {     }
     FBtnMenu.Free;
     FMenuBtn.Free;
     FViewChild.Free;
     FBtnsPanel.Free;
     FImages.Free;
     FGroups.Free;
     FTreeViewPanel.Free;
     FGrid.Free;
     FGridPanel.Free;
     FSplitter.Free;
     FComPanel.Free;
     FPopMenu.Free;
     FGroupMenu.Free;
     FSource.Free;
     OperationQuery.Free;
     inherited Destroy;
end;

procedure TsohoTreeView32.GroupsKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
     case Key of
        vk_Insert : begin TreeViewButtonsClick(actNewGroup);
                          Key := $00;
                    end;
        VK_RETURN : begin
                     if Shift = [ssAlt] then begin {Edit Group name}
                       TreeViewButtonsClick(actEditGroup);
                       Key := $00;
                     end;
                     if Shift = [] then begin{Get goods list}
                       Key := $00;
                       FItemsDS.Refresh;
                     end;
                    end;
     end;
     if Assigned(FOnGroupsKeyDown) then FOnGroupsKeyDown(Sender, Key,Shift);
end;

procedure TsohoTreeView32.GroupsMouseDown(Sender: TObject; Button: TMouseButton;
          Shift: TShiftState; X, Y: Integer);
begin
     if (Shift = [ssRight]) then begin
      FGroups.Selected := FGroups.GetNodeAt(X, Y);
      FItemsDS.Refresh;
     end;
     if Assigned(FOnGroupsMouseDown) then FOnGroupsMouseDown(Sender, Button, Shift, X, Y);
end;

procedure TsohoTreeView32.GroupsMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var NowItem : LongInt;
begin
     NowItem := FGroups.GetNodeAt(X, Y).AbsoluteIndex;
     { Drag&Drop   Ctrl }
     if  (Shift = [ssLeft,ssCtrl]) and (FGroups.Dragging = false) then begin
       FGroups.BeginDrag(True);
       FMoveGroup.GrpDragSourceRow := NowItem;
     end;
     if Assigned(FOnGroupsMouseMove) then FOnGroupsMouseMove(Sender, Shift, X, Y);
end;

function TsohoTreeView32.ItemIsChild (ParentItemIndex,ChildItemIndex : LongInt) : boolean;
var Tmp : TTreeNode;
begin
    Result := true;
    if (ParentItemIndex = ChildItemIndex) or (ParentItemIndex = -1) then exit;
    with FGroups do begin
      Tmp := Items[ChildItemIndex].Item[0];
      while (Tmp.AbsoluteIndex<>0) or (Tmp.AbsoluteIndex<>ParentItemIndex) do Tmp := Tmp.Parent;
      Result := Tmp.AbsoluteIndex=ParentItemIndex;
    end;
end;

procedure TsohoTreeView32.GroupsDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var NowItem : LongInt;
begin
     NowItem := FGroups.GetNodeAt(X, Y).AbsoluteIndex;
     Accept := ((FMoveGroup.GrpDragSourceRow<>0) and
               (FMoveGroup.GrpDragSourceRow<>NowItem))
                or FMoveItem.GridDrag;
     FGroups.Selected := FGroups.Items[NowItem];
     if Assigned(FOnGroupsDragOver) then FOnGroupsDragOver(Sender, Source, X,Y, State, Accept);
end;

procedure TsohoTreeView32.GroupsDragDrop(Sender, Source: TObject; X, Y: Integer);
var SelectItm : LongInt;
    GroupName : string;
    Buttons   : TMsgDlgButtons;
    ParentIndex,NewHash,RLeft,RRight : LongInt;
    BeforeChild,AfterChild,LastChild : LongInt;
    ParentID,CurrentId : LongInt;
    Res  : TModalResult;
begin
  SelectItm := FGroups.Selected.AbsoluteIndex;
  if Source is TsohoDBGrid then begin
      FMoveItem.GridDrag := false;
      {     items.db}
      if FItemsTable='' then begin
         ErrorMsg('    ,  '#13+
         '   ItemsTable!');
         exit;
      end;
      RightHash := MaxLongInt;
      with FMoveItem do begin
        NewHash := GetNewItemHash(ParentIndex, FNameGrID);
        NewGrpId := GetLeafRecord(SelectItm).ItemId;
      end;
      MoveItem;
     exit;
  end;
  GroupName := FGroups.Items[FMoveGroup.GrpDragSourceRow].Text;
  if SelectItm=1 then Buttons:=[mbYes, mbCancel]
  else Buttons:=[mbYes,mbNo, mbCancel];
  Res := MessageDlg('  '+GroupName+#13+'   '+
         FGroups.Selected.Text+'?', mtConfirmation,Buttons,0);
  case Res of
       mrCancel : exit; {  }
       mrYes    : begin {  }
                        ParentIndex := SelectItm;
                        BeforeChild := -1;
                        AfterChild  := FGroups.Items[ParentIndex].GetLastChild.AbsoluteIndex;
                  end;
       mrNo     : begin { }
                        ParentIndex  := FGroups.Items[SelectItm].Parent.AbsoluteIndex;
                        BeforeChild  := SelectItm;
                        AfterChild   := FGroups.Items[ParentIndex].
                          GetPrevChild(FGroups.Items[BeforeChild]).AbsoluteIndex;
                  end
       else       begin ErrorMsg('    ');
                        exit;
                  end;
  end;

  with FGroups do begin
        ParentID := GetLeafRecord(ParentIndex).ItemID;

        if AfterChild=-1 then RLeft:=-MaxLongInt
        else RLeft := GetLeafRecord(AfterChild).ItemHash;

        if BeforeChild=-1 then RRight:=MaxLongInt
        else RRight:=GetLeafRecord(BeforeChild).ItemHash;
        NewHash := GetHash(RLeft,RRight);

        CurrentId:=PTreeLeaf(Items[FMoveGroup.GrpDragSourceRow].Data)^.ItemId;
        if (AfterChild=BeforeChild) or (BeforeChild=-1) then
           Items[FMoveGroup.GrpDragSourceRow].MoveTo(Items[ParentIndex], naAddChild)
        else
           Items[FMoveGroup.GrpDragSourceRow].MoveTo(Items[BeforeChild], naInsert);

        Update;
        FullExpand;
        ParentIndex := GetIndexById(ParentId);
        {      }
        LastChild  := GetIndexById(CurrentId);
        if LastChild<1 then exit;
        PTreeLeaf(Items[LastChild].Data)^.ItemHash:=NewHash;
        PTreeLeaf(Items[LastChild].Data)^.ParentID:=ParentID;
  end;
 with OperationQuery do begin
      Close;
      DataBaseName := GetDataBaseName(FGroupsDS);
      SQL.Clear;
      SQL.Add('Update "'+FGroupsTable+'"');
      SQL.Add('Set Hash='+IntToStr(NewHash)+',');
      SQL.Add('    IDParent ='+IntToStr(ParentID));
      SQL.Add('Where Id='+IntToStr(GetLeafRecord(LastChild).ItemId));
      try
         Screen.Cursor := crSQLWait;
         ExecSQL;
      except
         Screen.Cursor := crDefault;
         ErrorMsg('  !');
      end;
 end;
 Screen.Cursor := crDefault;
 if Assigned(FOnGroupsDragDrop) then FOnGroupsDragDrop(Sender, Source, X, Y);
end;

function TsohoTreeView32.GetDataBaseName (DataSet : TDataSet) : string;
begin
     Result := '';
     if DataSet is TwwQuery then Result := (DataSet as TwwQuery).DataBaseName;
     if DataSet is TwwTable then Result := (DataSet as TwwTable).DataBaseName;
end;

function TsohoTreeView32.GetNewItemHash;
var Temp : TwwQuery;
begin
     Result := MaxLongInt;
     if FItemsTable='' then begin
        ErrorMsg('   hash ,  '#13+
                 '   ItemsTable!');
        exit;
     end;
     Temp := TwwQuery.Create(Self);
     with Temp, Temp.SQL do
     begin
          Clear;
          DataBaseName := GetDataBaseName(FItemsDS);
          Add('select MAX(Hash) from "'+FItemsTable+'"');
          Add('Where '+FNameGrID+'='+IntToStr(GrpId));
          try
           Open;
           if EOF then Result:=0
           else Result := GetHash(Fields[0].AsInteger, MaxLongInt);
           { Result = Fields[0].AsInteger  MaxLongInt, 
               }
           Close;
           Temp.Free;
          except ShowMessage('      ');
                 Temp.Free;
          end;
     end;
end;

procedure TsohoTreeView32.ItemsGridDragDrop(Sender, Source: TObject; X,Y: Integer);
var Coord  : TGridCoord;
    Insert : word;
begin
     Coord  := (Sender as TsohoDBGrid).MouseCoord(x,y);
     Insert := vk_Insert;
     GridKeyDown(Sender,Insert,[ssCtrl]);
     FItemsDS.MoveBy(Coord.Y-FMoveItem.GridRow);
     Insert := vk_Insert;
     GridKeyDown(Sender,Insert,[ssShift]);
     if Assigned(FOnGridDragDrop) then FOnGridDragDrop(Sender, Source, X,Y);
end;

procedure TsohoTreeView32.ItemsGridMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
     if Shift = [ssLeft, ssCtrl] then begin
         FGrid.BeginDrag(false);
         if not FMoveItem.GridDrag then begin
           FMoveItem.GridDrag := true;
           FMoveItem.GridRow  := 1+(Sender as TsohoDBGrid).GetActiveRow;
           FMoveItem.Id := FItemsDS.FieldByName('ID').AsInteger;
           FReport.Caption := IntToStr(FMoveItem.ID);
         end;
      end;
     if Assigned(FOnGridMouseMove) then FOnGridMouseMove(Sender, Shift, X, Y);
end;

procedure TsohoTreeView32.ItemsGridDragOver(Sender, Source: TObject; X, Y: Integer;
          State: TDragState; var Accept: Boolean);
var Coord : TGridCoord;
begin
     Coord := (Sender as TsohoDBGrid).MouseCoord(x,y);
     Accept := (Source is TsohoDBGrid) and (FMoveItem.GridRow<>Coord.Y);
     if Assigned(FOnGridDragOver) then
       FOnGridDragOver(Sender, Source, X, Y, State, Accept);
end;

procedure TsohoTreeView32.ItemsGridMouseDown(Sender: TObject; Button: TMouseButton;
          Shift: TShiftState; X, Y: Integer);
begin
     if Assigned(FOnGridMouseDown) then
       FOnGridMouseDown(Sender, Button, Shift, X, Y);
end;

procedure TsohoTreeView32.ReDrawTreeView;
begin
    FGroups.Height := Height;
    FGroups.Width := FTreeViewPanel.Width;
end;

end.
