{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoSound, TsohoMsgGrabber 
 TsohoEnterTab,
}
unit SoTools;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, MMSystem;

type

  {       }
  TFileName = type string;
  {       }
  TDirName = type string;
  {       WAV- }
  TWaveFileName = type string;
  {       INI- }
  TIniFileName = type string;
  {       c TTF- }
  TTTFDirName = type string;

  {    OnProgress. Stage -   
    (psStarting, psRunning, psEnding), PercentDone -   ,
    Msg -    
  }
  TsohoProgressEvent = procedure (Sender: TObject; Stage: TProgressStage;
    PercentDone: byte; const Msg: string) of object;
  
  {     WAV-  
    Windows.       Win16 API,  
          WAV  .  
       : PlayResourceWave.  , 
     SohoLib   TsohoSound,  ""  
     }
  TsohoSound = class(TComponent)
  private
    { Private declarations }
    FEnabled: boolean;
    FAsync: boolean;
    FOnSound: TNotifyEvent;
  public
    function PlaySync(Filename: string): boolean;
    function PlayAsync(Filename: string): boolean;
    {   }
    function PlayWave(Filename: string): boolean;
    {  wav   }
    function PlayResourceWave(WaveName: string): boolean;
    constructor Create(AOwner: TComponent); override;
  published
    { /  }
    property Enabled: boolean read FEnabled write FEnabled default True;
    {    (false)   (true) }
    property Async: boolean read FAsync write FAsync default False;
    {       }
    property OnSound: TNotifyEvent read FOnSound write FOnSound;
  end;

  ENonWindowOwner = class(Exception);
  
  {   OnMessage  TsohoMsgGrabber }
  TGrabbedMessageEvent = procedure (Sender: TObject; var Msg: TMessage) of object;

  {    - }
  TsohoMsgGrabber = class(TComponent)
  private
    { Private declarations }
    OwnerWndProc: TFarProc;
    MyWndProc: TFarProc;
    FGrabbed: boolean;
    FOnMessage: TGrabbedMessageEvent;
  protected
    { Protected declarations }
    procedure FreeHandlerHook; virtual;
    procedure WNDPROC(var Msg: TMessage); virtual;
    procedure DefaultHandler(var Msg); override;
    procedure WMDestroy(var Msg: TWMDestroy); message WM_DESTROY;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {       }
    property OnMessage: TGrabbedMessageEvent read FOnMessage write FOnMessage;
  end;

  {       Enter.   
    ,          Enter 
      AddControl, RemoveControl, OutList
    :    -  KeyPreview = true!
       ,     !
  }
  TsohoEnterTab = class(TComponent)
  private
    { Private declarations }
    Form: TForm;
    FOnKeyPress: TKeyPressEvent;
    FOutList: TList;
    function GetControl(index: Integer): TWinControl;
    procedure ReadList(Reader: TReader);
    procedure WriteList(Writer: TWriter);
  protected
    { Protected declarations }
    procedure DoKeyPress(Sender: TObject; var KEY: Char); virtual;
    procedure DefineProperties(Filer: TFiler); override;
  public
    { Public declarations }
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    constructor Create(AOwner: TComponent); override;
    procedure Loaded; override;
    destructor Destroy; override;
    {      }
    procedure AddControl(AControl: TWinControl);
    {      }
    procedure RemoveControl(AControl: TWinControl);
    {     }
    procedure DeleteControl(index: Integer);
    {    }
    function ControlCount: Integer;
    {      }
    function IndexOf(AControl: TWinControl): Integer;
    {    }
    procedure Clear;
    {     }
    property OutList[index: Integer]: TWinControl read GetControl;
  end;

  {      }
function FindSound(Form: TForm): TsohoSound;

implementation
uses SoUtils, SoCmnCns;

function FindSound(Form: TForm): TsohoSound;
var index: Integer;
begin
  Result := nil;
  if Form = nil then exit;
  for index := 0 to Form.ComponentCount - 1 do
    if Form.Components[index] is TsohoSound then begin
      Result := Form.Components[index] as TsohoSound;
      exit;
    end;
end;

{ TsohoSound }
function TsohoSound.PlaySync(Filename: string): boolean;
begin
  Result := False;
  if not FEnabled then exit;
  Filename := Filename + #0;
  Result := sndPlaySound(@Filename[1], 0);
  if Assigned(FOnSound) then FOnSound(Self);
end;

function TsohoSound.PlayAsync(Filename: string): boolean;
begin
  Result := False;
  if not FEnabled then exit;
  Filename := Filename + #0;
  Result := sndPlaySound(@Filename[1], snd_Async);
  if Assigned(FOnSound) then FOnSound(Self);
end;

function TsohoSound.PlayWave(Filename: string): boolean;
const Flags: array[boolean] of Word = (0, snd_Async);
begin
  Result := False;
  if not FEnabled then exit;
  if ExtractFilePath(FileName) = '' then FileName := GetRunDir+'Sounds\'+FileName;
  if ExtractFileExt(FileName) = '' then FileName := FileName + '.wav';
  if not FileExists(FileName) then exit;
  Filename := Filename + #0;
  PlayWave := sndPlaySound(@Filename[1], Flags[FAsync]);
  if Assigned(FOnSound) then FOnSound(Self);
end;

function TsohoSound.PlayResourceWave(WaveName: string): boolean;
const Flags: array[boolean] of Word = (0, snd_Async);
var WaveHandle: THandle;
  WavePointer: Pointer;
begin
  Result := False;
  if not FEnabled then exit;
  WaveName := WaveName + #0;
  try
    WaveHandle := FindResource(HInstance, @WaveName[1], RT_RCDATA);
    if WaveHandle <> 0 then begin
      WaveHandle := LoadResource(HInstance, WaveHandle);
      if WaveHandle <> 0 then begin;
        WavePointer := LockResource(WaveHandle);
        PlayResourceWave := sndPlaySound(WavePointer, snd_Memory or Flags[FAsync]);
        UnlockResource(WaveHandle);
        FreeResource(WaveHandle);
        if Assigned(FOnSound) then FOnSound(Self);
      end;
    end;
  except ErrorMsg(name + ': '+ soToolsResourceWavError);
  end;
end;

constructor TsohoSound.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEnabled := True;
end;

{ TsohoMsgGrabber }
constructor TsohoMsgGrabber.Create(AOwner: TComponent);
begin
  FGrabbed := False;
  if not (AOwner is TWinControl) then
    raise ENonWindowOwner.Create(sohoOwnerMustBeWindow);
  inherited Create(AOwner);
  OwnerWndProc := TFarProc(GetWindowLong((Owner as TWinControl).Handle, GWL_WNDPROC));
  MyWndProc := MakeObjectInstance(WNDPROC);
  SetWindowLong((Owner as TWinControl).Handle, GWL_WNDPROC, Longint(MyWndProc));
  FGrabbed := True;
end;

procedure TsohoMsgGrabber.FreeHandlerHook;
begin
  SetWindowLong((Owner as TWinControl).Handle, GWL_WNDPROC, Longint(OwnerWndProc));
  FGrabbed := False;
end;

destructor TsohoMsgGrabber.Destroy;
begin
  if FGrabbed then FreeHandlerHook;
  FreeObjectInstance(MyWndProc);
  inherited Destroy;
end;

procedure TsohoMsgGrabber.WMDestroy(var Msg: TWMDestroy);
begin
  if FGrabbed then FreeHandlerHook;
  inherited;
end;

procedure TsohoMsgGrabber.WNDPROC(var Msg: TMessage);
begin
  if Assigned(FOnMessage) then FOnMessage(Self, Msg);
  { Thank's to Andrey Denisov 2:5019/1.34 :) }
  if Msg.Result = 0 then Dispatch(Msg);
end;

procedure TsohoMsgGrabber.DefaultHandler(var Msg);
begin
  with TMessage(Msg) do
    Result := CallWindowProc(OwnerWndProc, (Owner as TWinControl).Handle,
    Msg, WPARAM, LPARAM);
end;

{ TsohoEnterTab }
procedure TsohoEnterTab.DoKeyPress(Sender: TObject; var KEY: Char);
begin
  if (KEY = #13) and (IndexOf(Form.ActiveControl) = -1) then begin
    SendMessage(Form.Handle, WM_NEXTDLGCTL, 0, 0);
    KEY := #0;
  end;
  if Assigned(FOnKeyPress) then FOnKeyPress(Sender, KEY);
end;

procedure TsohoEnterTab.Loaded;
begin
  inherited Loaded;
  if Form <> nil then begin
    FOnKeyPress := Form.OnKeyPress;
    Form.OnKeyPress := DoKeyPress;
    Form.KeyPreview := True;
  end;
end;

constructor TsohoEnterTab.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Form := GetOwnerForm(Self);
  FOutList := TList.Create;
end;

destructor TsohoEnterTab.Destroy;
begin
  if Assigned(FOnKeyPress) and (Form <> nil) then Form.OnKeyPress := FOnKeyPress;
  FOutList.Free;
  inherited Destroy;
end;

type
  TBuffer = array[1..1] of Pointer;
  PBuffer = ^TBuffer;

procedure TsohoEnterTab.WriteList(Writer: TWriter);
var index: Integer;
begin
  with Writer do begin
    WriteListBegin;
    WriteInteger(ControlCount);
    for index := 0 to Pred(ControlCount) do WriteString(OutList[index].name);
    WriteListEnd;
  end;
end;

procedure TsohoEnterTab.ReadList(Reader: TReader);
var index, aCount: Integer;
  AName   : string;
  AControl: TComponent;
begin
  with Reader do begin
    ReadListBegin;
    aCount := ReadInteger;
    for index := 0 to Pred(aCount) do begin
      AName := ReadString;
      AControl := Form.FindComponent(AName);
      if AControl <> nil then FOutList.Add(AControl)
      else ErrorMsg(AName + soToolsNotFound);
    end;
    ReadListEnd;
  end;
end;

procedure TsohoEnterTab.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties(Filer);
  Filer.DefineProperty('OutList', ReadList, WriteList, True);
end;

procedure TsohoEnterTab.Clear;
begin
  FOutList.Clear;
end;

function TsohoEnterTab.GetControl(index: Integer): TWinControl;
begin
  Result := TWinControl(FOutList[index]);
end;

procedure TsohoEnterTab.AddControl(AControl: TWinControl);
begin
  if FOutList.IndexOf(AControl) = -1 then FOutList.Add(AControl);
end;

procedure TsohoEnterTab.RemoveControl(AControl: TWinControl);
begin
  FOutList.Remove(AControl);
end;

procedure TsohoEnterTab.DeleteControl(index: Integer);
begin
  FOutList.Delete(index);
end;

function TsohoEnterTab.ControlCount: Integer;
begin
  Result := FOutList.Count;
end;

function TsohoEnterTab.IndexOf(AControl: TWinControl): Integer;
begin
  Result := FOutList.IndexOf(AControl);
end;

procedure TsohoEnterTab.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if (Operation = opRemove) and (AComponent is TWinControl) and
    (IndexOf(TWinControl(AComponent)) <> -1) then
    RemoveControl(TWinControl(AComponent));
end;

end.

