{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoTimeF;

{$I SOHOLIB.INC}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, SoTools, StdCtrls, SohoBtns, RXSpin;

type
  TsohoTimeFormDialog = class(TForm)
    HoursS: TRxSpinEdit;
    MinS: TRxSpinEdit;
    SecS: TRxSpinEdit;
    OkB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
  private
    { Private declarations }
    function Execute (var Time : TDateTime; const aCaption : string) : boolean;
  public
    { Public declarations }
  end;

var sohoTimeFormDialog: TsohoTimeFormDialog;

function GetTimeDialog (var Time : TDateTime; const aCaption : string) : boolean;
function GetTimeDialogStr (var Time : string; const aCaption : string) : boolean;

implementation

{$R *.DFM}

function GetTimeDialog (var Time : TDateTime; const aCaption : string) : boolean;
begin
     try
       sohoTimeFormDialog := TsohoTimeFormDialog.Create(Application);
       Result := sohoTimeFormDialog.Execute(Time,aCaption);
     finally
       sohoTimeFormDialog.Free;
     end;
end;

function GetTimeDialogStr (var Time : string; const aCaption : string) : boolean;
var NewTime : TDateTime;
begin
   NewTime := StrToTime(Time);
   Result := GetTimeDialog (NewTime,aCaption);
   if Result then Time := TimeToStr(NewTime);
end;

function TsohoTimeFormDialog.Execute(var Time : TDateTime; const aCaption : string) : boolean;
var Hour, Min, Sec, MSec: Word;
begin
     DecodeTime(Time, Hour, Min, Sec, MSec);
     HoursS.Value := Hour;
     MinS.Value   := Min;
     SecS.Value   := Sec;
     Caption      := aCaption;
     Result := ShowModal=mrOk;
     if not Result then exit;
     Hour := trunc(HoursS.Value);
     Min  := trunc(MinS.Value);
     Sec  := trunc(SecS.Value);
     Time := EncodeTime(Hour,Min,Sec,0);
end;

end.
