{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoTVFrm;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, Dialogs, SoFolder, DBTables, DB, SohoTree, Placemnt, SoRxTls,
     SoTools, StdCtrls, SohoBtns, ExtCtrls, SoCtmRec, SohoRec, Menus,
  SoCtmFld, SoCtmTre;

type
  TsohoTreeViewForm = class(TForm)
    TreeView: TsohoTreeView;
    Folder: TsohoFolder;
    TreeViewStorage: TsohoFormStorage;
    RecordCard: TsohoRecordForm;
    ModalMenu: TPopupMenu;
    SelectM: TMenuItem;
    CancelM: TMenuItem;
    GotoGroupM: TMenuItem;
    N2: TMenuItem;
    FindM: TMenuItem;
    N1: TMenuItem;
    SaveIdsM: TMenuItem;
    LoadIdsM: TMenuItem;
    ClearIdsM: TMenuItem;
    OpenD: TOpenDialog;
    SaveD: TSaveDialog;
    ItemsQ: TQuery;
    GroupsQ: TQuery;
    procedure FormDestroy(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SelectMClick(Sender: TObject);
    procedure CancelMClick(Sender: TObject);
    procedure TreeViewNewItem(Sender: TObject; GroupId: Longint;
      var ItemId, ItemHash: Longint; var Allow: Boolean);
    procedure TreeViewItemEdit(Sender: TObject; GroupId, ItemId: Longint;
      var Allow: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure RecordCardGetValue(Sender: TObject; FieldName: String;
      var Value: String);
    procedure GotoGroupMClick(Sender: TObject);
    procedure FindMClick(Sender: TObject);
    procedure FolderSaveDataSet(Sender: TObject; DataSet: TDataSet);
    procedure FolderLoadDataSet(Sender: TObject; DataSet: TDataSet);
    procedure SaveIdsMClick(Sender: TObject);
    procedure LoadIdsMClick(Sender: TObject);
    procedure ClearIdsMClick(Sender: TObject);
  private
    { Private declarations }
    procedure GridKeyPress(Sender: TObject; var Key: Char);
  public
    { Public declarations }
    ItemId  : LongInt;
    GroupId : LongInt;
    NewItemId, NewItemHash, NewGrpId : LongInt;
    ModalMode : boolean;
  end;

var sohoTreeViewForm: TsohoTreeViewForm;

implementation
uses SoUtils, SoDBRtn, SoUnit, Outline, SoWldStr, SoCtmRgs;

{$R *.DFM}

procedure TsohoTreeViewForm.FormDestroy(Sender: TObject);
begin
  if TreeView.Active then TreeView.SaveTreeViewState;
end;

procedure TsohoTreeViewForm.FormActivate(Sender: TObject);
begin
  TreeView.LoadTreeViewState;
end;

procedure TsohoTreeViewForm.SelectMClick(Sender: TObject);
begin
  ItemId  := TreeView.ItemId;
  GroupId := TreeView.GetLeafRecord(TreeView.GroupOutLine.SelectedItem).ItemId;
  if not ModalMode then Close
  else ModalResult := mrOk;
end;

procedure TsohoTreeViewForm.CancelMClick(Sender: TObject);
begin
  ItemId  := -1;
  GroupId := -1;
  ModalResult := mrCancel;
end;

procedure TsohoTreeViewForm.TreeViewNewItem(Sender: TObject;
  GroupId: Longint; var ItemId, ItemHash: Longint; var Allow: Boolean);
begin
  NewItemId   := ItemId;
  NewItemHash := ItemHash;
  NewGrpId    := GroupId;
  Allow := RecordCard.Insert;
  RecordCard.Close;
end;

procedure TsohoTreeViewForm.TreeViewItemEdit(Sender: TObject; GroupId,
  ItemId: Longint; var Allow: Boolean);
begin
  Allow := RecordCard.Edit;
  RecordCard.Close;
end;

procedure TsohoTreeViewForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   TreeView.SaveTreeViewState;
   if FormStyle = fsNormal then Action := caHide
   else Action := caNone;
end;

procedure TsohoTreeViewForm.GridKeyPress(Sender: TObject; var Key: Char);
var ItemId : LongInt;
begin
  with TreeView.DBGrid do
   if (Key = #32) and not
      (DataSource.DataSet.State in [dsEdit, dsInsert]) then begin
     ItemId := ItemsQ.FieldByName(RecordCard.KeyField).AsInteger;
     if Results.IndexOf(ItemId)=-1 then  Results.Add(ItemId)
     else Results.Remove(ItemId);
   end;
end;

procedure TsohoTreeViewForm.FormCreate(Sender: TObject);
begin
  Icon.Handle := LoadIcon(hInstance,'MAINICON');
  TreeView.DBGrid.OnKeyPress := GridKeyPress;
end;

procedure TsohoTreeViewForm.RecordCardGetValue(Sender: TObject;
  FieldName: String; var Value: String);
begin
  if FieldName = 'MDFDATE' then Value := DateToStr(Date);
  if FieldName = 'MDFTIME' then Value := TimeToStr(Time);
  if FieldName = 'IDMDFDAUTH' then begin
    Value := '0';
    if SingleRegister <> nil then Value := IntToStr(SingleRegister.UserID);
  end;
  if RecordCard.Mode <> rmInsert then exit;
  if FieldName = StrUpper(RecordCard.KeyField) then Value := IntToStr(NewItemId);
  if FieldName = StrUpper(TreeView.NameGroupId) then Value := IntToStr(NewGrpId);
  if FieldName = StrUpper(TreeView.HashField) then Value := IntToStr(NewItemHash);
  if FieldName = 'PROTECT' then begin
    Value := '0';
    if SingleRegister <> nil then Value := IntToStr(SingleRegister.DataLevel);
  end;
end;

procedure TsohoTreeViewForm.GotoGroupMClick(Sender: TObject);
var GrpId, GrpIndex : LongInt;
    FoundItem : TOutLineNode;
begin
   if ItemsQ.FieldByName(TreeView.NameGroupId).IsNull then exit;
   GrpId := ItemsQ.FieldByName(TreeView.NameGroupId).AsInteger;
   GrpIndex := TreeView.GetIndexByID(GrpId);
   FoundItem := TreeView.GroupOutLine.Items[GrpIndex];
   while (FoundItem.Index <> 1) and (not FoundItem.Expanded) do FoundItem := FoundItem.Parent;
   FoundItem.FullExpand;
   TreeView.GroupOutLine.SelectedItem := GrpIndex;
end;

procedure TsohoTreeViewForm.FindMClick(Sender: TObject);
begin
   {}
end;

procedure TsohoTreeViewForm.FolderSaveDataSet(Sender: TObject;
  DataSet: TDataSet);
begin
   with Folder.Ini do begin
    WriteString('TreeViewContainer.Design','GridFont',
                FontToStr(TreeView.DBGrid.Font));
    WriteString('TreeViewContainer.Design','GridColor',
                ColorToString(TreeView.DBGrid.Color));
    WriteString('TreeViewContainer.Design','OutLineFont',
                FontToStr(TreeView.GroupOutLine.Font));
    WriteString('TreeViewContainer.Design','OutLineColor',
                ColorToString(TreeView.GroupOutLine.Color));
   end;
end;

procedure TsohoTreeViewForm.FolderLoadDataSet(Sender: TObject;
  DataSet: TDataSet);
begin
   with Folder.Ini do begin
    StrToFont(ReadString('TreeViewContainer.Design','GridFont',
                FontToStr(TreeView.DBGrid.Font)), TreeView.DBGrid.Font);
    TreeView.DBGrid.Color := StringToColor(ReadString('TreeViewContainer.Design','GridColor',
                ColorToString(TreeView.DBGrid.Color)));
    StrToFont(ReadString('TreeViewContainer.Design','OutLineFont',
                FontToStr(TreeView.GroupOutLine.Font)), TreeView.GroupOutLine.Font);
    TreeView.GroupOutLine.Color := StringToColor(ReadString('TreeViewContainer.Design','OutLineColor',
                ColorToString(TreeView.GroupOutLine.Color)));
    TreeView.DBGrid.RowFont.Size    := TreeView.DBGrid.Font.Size;
    TreeView.DBGrid.MarkedFont.Size := TreeView.DBGrid.Font.Size;
   end;
end;

procedure TsohoTreeViewForm.SaveIdsMClick(Sender: TObject);
begin
  if not SaveD.Execute then exit;
  try
    TreeView.DBGrid.Results.SaveToFile(SaveD.FileName);
  except
  end;                                
end;

procedure TsohoTreeViewForm.LoadIdsMClick(Sender: TObject);
begin
  if not OpenD.Execute then exit;
  try
    TreeView.DBGrid.Results.LoadFromFile(OpenD.FileName);
  except
  end;
end;

procedure TsohoTreeViewForm.ClearIdsMClick(Sender: TObject);
begin
  TreeView.DBGrid.Results.Clear;
end;

end.
