{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
     TsohoTVContainer -    
   TsohoTreeView. .   : TsohoDBGuide
}
unit SoTVCont;

{$I SOHOLIB.INC}

interface

//{$DEFINE TREEVIEW32 do not uncomment! Or else you will have big problems :) }
uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, Dialogs, SoTools, SoFolder, SohoRec, SoDBGrid, DBGrids, SoUnit,
     SohoBtns, DB, Menus, StdCtrls, SoGauges, RxDBCtrl, SoCtmTre, SoCtmRec
     {$IFNDEF TREEVIEW32}
     ,SoTVFrm, SohoTree
     {$ELSE}
     ,SoTVFm32, SoTree32
     {$ENDIF};

type

  {        
    .       
       -     .
    ,      
    .         
      MDIChild.        
      - TsohoDBGrid, TsohoRecordForm  TsohoFolder. 
      TsohoTVContainer -      
     .
       ,  TsohoTVContainer,  
     ,          OutLine.
        [TreeViewContainer.Design]:
    GridFont, GridColor, OutLineFont, OutLineColor
       TsohoTVContainer,    TsohoTreeView, - 
      ,  .  
        ,      
    Order  SQL-  ,   ORDER    
    :
  }
  {example:
   select * from Items
   order by IdGrp, Hash
  }
  TsohoTVContainer = class(TComponent)
  private
    { Private declarations }
    FOnProgress   : TsohoProgressEvent; {04/10/98}
    FGauge        : TsohoGauge; {04/10/98}
    FFolderName   : TFileName;
    FFolderDir    : TDirName;
    {FTablePath    : TFileName;}
    FItemId       : LongInt;
    FCloseGroups  : boolean;
    FEditOnDblClick : boolean;

    FFocusField   : string;
    FFixedGrpName : string;
    FFixedGrpId   : LongInt;
    FRootName     : string;
    FDataBaseName : string;
    FIncludeSubTree : boolean;
    FEnabledMenus   : SetOfByte;
    FTreeViewMenu   : TPopupMenu;

    FNameGrID      : string;
    FHashField     : string;
    FOrderField    : string;
    FNameParentID  : string;
    FItemsName     : string;
    FGroupsName    : string;
    FGroupPreffix,
    FItemsPreffix  : string;
    FSortField     : string;
    FSaveFile      : TIniFileName;
    FOptions       : TsohoTreeOptions;
    FSaveOptions   : TsohoTreeSaveOptions;
    FGroupsSQLFile : TSQLFileName;
    FItemsSQLFile  : TSQLFileName;
    FGroupsTable   : TFileName;
    FItemsTable    : TFileName;
    FMarkedColor   : TColor;
    FMarkedFont    : TFont;
    FSortTitleFont : TFont;
    FTreeViewForm  : TsohoTreeViewForm;

    FResults       : TsohoDBGridResults;
    FClearResults  : boolean;

    FOkBtn,
    FCancelBtn      : TsohoBitBtn;
    FSortC          : TCheckBox;
    FOldSortSQL     : string;
    FOrderWordIndex : LongInt;

    { Events }
    FOnFilter       : TsohoTreeOnFilter;
    FOnItemDelete   : TsohoTreeOnDeleteItem;
    FOnGrpDelete    : TsohoTreeOnDeleteGroup;

    FOnNewItem      : TsohoTreeOnNewItem;
    FOnOldNewItem   : TsohoTreeOnNewItem;

    FOnMoveItem     : TsohoTreeOnMoveItem;
    FOnNewGrp       : TsohoTreeOnNewGroup;

    FOnItemEdit     : TsohoTreeOnEditItem;
    FOnOldItemEdit  : TsohoTreeOnEditItem;

    FOnGrpEdit      : TsohoTreeOnEditGroup;

    FOnCustomEditGrp : TsohoTreeCustomGroup;
    FOnCustomNewGrp  : TsohoTreeCustomGroup;

    FOnGetCellsProps: TGetCellPropsEvent;
    //FOnCalcCells    : TCalcCellColorsEvent;
    FOnDrawCells    : TDrawDataCellEvent;
    FOnFormCreate   : TNotifyEvent;
    FOnFormDestroy  : TNotifyEvent;
    FAfterGrpDelete : TNotifyEvent;
    FOnChange       : TNotifyEvent;
    FOnGroupSelect  : TNotifyEvent;
    FOnGridDblClick    : TNotifyEvent;
    FOnGridKeyDown     : TKeyEvent;
    FOnGroupsKeyDown   : TKeyEvent;
    FOnGroupsMouseDown : TMouseEvent;
    FOnGroupsMouseMove : TMouseMoveEvent;
    FOnGroupsDragOver  : TDragOverEvent;
    FOnGroupsDragDrop  : TDragDropEvent;
    FOnGridDragDrop    : TDragDropEvent;
    FOnGridMouseMove   : TMouseMoveEvent;
    FOnGridDragOver    : TDragOverEvent;
    FOnGridMouseDown   : TMouseEvent;

    FHideFields        : TStringList;
    FComplexFields     : TStringList;
    FComplexLabels     : TStringList;
    FSQLHideFields     : TStringList;

    FBeforeSQLGen,
    FAfterSQLGen       : TsohoOnSQLGenerate;
    FOnAddField        : TsohoOnAddField;
    FOnAddFieldToSQL   : TsohoOnAddFieldToSQL;
    FOnGetValue        : TsohoOnGetValue;
    FOnOldGetValue     : TsohoOnGetValue;
    FOnGetTextForField : TsohoOnGetTextForField;
    FOnGetComplexValue : TsohoOnGetComplexValue;
    FOnCardCreate,
    FOnCardDestroy,
    FOnCardSave,
    FOnCardLoad        : TNotifyEvent;

    FCaption           : TCaption;
    FKeyField          : string;
    FAfterExec         : TNotifyEvent;

    FBeforeGroupsOpen  : TDataSetNotifyEvent;
    FBeforeItemsOpen   : TDataSetNotifyEvent;

    FLastGroupId       : LongInt;
    procedure SetMarkedFont (Value : TFont);
    function  GetResults : TsohoDBGridResults;
    procedure SetHideFields    (Value : TStringList);
    procedure SetSQLHideFields (Value : TStringList);
    procedure SetComplexFields (Value : TStringList);
    procedure SetComplexLabels (Value : TStringList);
    function  GetItemId        : LongInt;
    procedure SetItemId        (Value : LongInt);
    procedure SetEnabledMenus  (Value : string);
    function  GetEnabledMenus  : string;
    {$IFNDEF TREEVIEW32}
    function  GetTreeView      : TsohoTreeView;
    {$ELSE}
    function  GetTreeView      : TsohoTreeView32;
    {$ENDIF}
    procedure SetSortField     (Value : string);
    procedure SetSortTitleFont (Value : TFont);
  protected
    { Protected declarations }
    procedure SetTreeViewProperties;
    procedure SetFolderProperties;
    procedure SetRecordProperties;
    procedure SetQueryProperties;
    procedure SetEvents;
    procedure PrepareButtons (Modal : boolean; WithCancel : boolean);
    procedure RestoreSelection;
    procedure DoGetValue     (Sender : TObject; FieldName : string;
                              var Value : string);
    procedure DoNewItem      (Sender: TObject; GroupId: Longint; var ItemId,
                              ItemHash: Longint; var Allow: Boolean);
    procedure DoEditItem     (Sender: TObject; GroupId, ItemId: Longint;
                              var Allow: Boolean);
    procedure AddMenuItems;
    procedure DoFormCreate (Reopen, Modal, WithCancel : boolean);virtual;
    procedure DoFormDestroy(DoFree : boolean);virtual;

    procedure CalcTitleAttributes (Sender: TObject; Field: TField;
              AFont: TFont; var Background: TColor; var SortMarker: TSortMarker;
              IsDown: Boolean);

    procedure SortCClicked(Sender : TObject);
    procedure FindOrderOperator;

    {procedure TitleButtonClick (Sender: TObject; AFieldName: string);}
    procedure  TitleButtonClick (Sender: TObject; ACol: Longint;
               Field: TField);


    procedure DoProgress (Stage : TProgressStage; PercentDone : byte;
              const Msg : string);virtual; {04/10/98}
    procedure Notification(AComponent: TComponent; Operation: TOperation);override; {04/10/98}
  public
    constructor Create (AOwner : TComponent);override;
    destructor  Destroy;override;
    {        Tag }
    function    GetTreeMenuItem (Tag : LongInt) : TMenuItem;
    {    }
    procedure   CloseTreeViewForm (DoFree : boolean);
    {   TQuery c  }
    function    GroupsQuery : TDataSet;
    {   TQuery c  }
    function    ItemsQuery  : TDataSet;

    {        Ok, Cancel.    }
    function    ReCreateExecute (Modal : boolean; WithCancel : boolean) : boolean;
    {     Ok, Cancel.    }
    function    Execute (Reopen, Modal : boolean; WithCancel : boolean) : boolean;
    {     MDIChild- }
    function    MDIExecute : boolean;

    {   .  TsohoDBGrid }
    property    Results  : TsohoDBGridResults read GetResults;
    {   .  ,   
              }
    property    ItemId   : LongInt read GetItemId write SetItemId default -1;
    {  TsohoTreeView }
    property    FixedGrpName : string  read FFixedGrpName write FFixedGrpName;
    {  TsohoTreeView }
    property    FixedGrpId   : LongInt read FFixedGrpId   write FFixedGrpId;
    {       }
    property    TreeViewForm : TsohoTreeViewForm read FTreeViewForm;
    {$IFNDEF TREEVIEW32}
    property    TreeView     : TsohoTreeView read GetTreeView;
    {$ELSE}
    property    TreeView     : TsohoTreeView32 read GetTreeView;
    {$ENDIF}
    { ,      }
    property    SortField    : string read FSortField write SetSortField;
  published
    {  TsohoTreeView }
    property EditOnDblClick : boolean read FEditOnDblClick write FEditOnDblClick default true;
    {  TsohoTreeView }
    property FocusField   : string read FFocusField write FFocusField;
    {   PopupMenu,      TreeView }
    property TreeViewMenu : TPopupMenu read FTreeViewMenu write FTreeViewMenu;
    {  ClearResults = true,    TreeViewForm  
         Results.     
        }
    property ClearResults : boolean read FClearResults write FClearResults default true;
    {   Folder }

    { . TsohoFolder }
    property FolderName  : TFileName read FFolderName  write FFolderName;
    { . TsohoFolder }
    property FolderDir   : TDirName  read FFolderDir   write FFolderDir;
    { . TsohoFolder }
    property EnabledMenus : string read GetEnabledMenus write SetEnabledMenus;

    {  TsohoTreeView }
    property IncludeSubTree : boolean read FIncludeSubTree write FIncludeSubTree;
    {  TsohoTreeView }
    property RootName      : string    read FRootName write FRootName;

    {     }
    property DataBaseName  : string read FDataBaseName write FDataBaseName;
    {    }
    property GroupsSQLFile : TSQLFileName read FGroupsSQLFile  write FGroupsSQLFile;
    {       }
    property GroupsTable   : TFileName read FGroupsTable write FGroupsTable;

    {  TsohoTreeView }
    property CloseGroups   : boolean   read FCloseGroups  write FCloseGroups default true;

    {  TsohoTreeView }
    property ItemsTable    : TFileName read FItemsTable  write FItemsTable;
    {    }
    property ItemsSQLFile : TSQLFileName  read FItemsSQLFile  write FItemsSQLFile;

    {  TsohoTreeView }
    property NameGroupID   : string    read FNameGrID    write FNameGrID;
    {  TsohoTreeView }
    property NameParentID: string read FNameParentID write FNameParentID;
    {  TsohoTreeView }
    property OrderField    : string    read FOrderField  write FOrderField;
    {  TsohoTreeView }
    property HashField     : string    read FHashField   write FHashField;
    {  TsohoTreeView }
    property Options       : TsohoTreeOptions read FOptions write FOptions;
    {  TsohoTreeView }
    property SaveOptions   : TsohoTreeSaveOptions read FSaveOptions write FSaveOptions default [trSaveSplitter];
    {  TsohoTreeView }
    property ItemsName     : string    read FItemsName   write FItemsName;
    {  TsohoTreeView }
    property GroupsName    : string    read FGroupsName   write FGroupsName;
    {  TsohoTreeView }
    property GroupPreffix : string read FGroupPreffix write FGroupPreffix;
    {  TsohoTreeView }
    property ItemsPreffix : string read FItemsPreffix write FItemsPreffix;
    {  TsohoTreeView }
    property SaveFile      : TIniFileName read FSaveFile write FSaveFile;
    {  TsohoTreeView }
    property MarkedColor   : TColor    read FMarkedColor write FMarkedColor;
    {  TsohoTreeView }
    property MarkedFont    : TFont     read FMarkedFont  write SetMarkedFont;
    { ,     ,  
       ,   }
    property SortTitleFont : TFont     read FSortTitleFont write SetSortTitleFont;
    {    TsohoGauge,     
       .  ""    
       OnProgress }
    property Gauge         : TsohoGauge read FGauge write FGauge; {04/10/98}
    {   }
    property Caption      : TCaption  read FCaption      write FCaption;
    {  TsohoRecordForm }
    property KeyField     : string    read FKeyField     write FKeyField;
    {  TsohoRecordForm }
    property HideFields    : TStringList read FHideFields    write SetHideFields;
    {  TsohoRecordForm }
    property SQLHideFields : TStringList read FSQLHideFields write SetSQLHideFields;
    {  TsohoRecordForm }
    property ComplexFields : TStringList read FComplexFields write SetComplexFields;
    {  TsohoRecordForm }
    property ComplexLabels : TStringList read FComplexLabels write SetComplexLabels;

    {  TsohoRecordForm }
    property OnGetTextForField : TsohoOnGetTextForField read FOnGetTextForField write FOnGetTextForField;
    {  TsohoRecordForm }
    property OnGetComplexValue : TsohoOnGetComplexValue read FOnGetComplexValue write FOnGetComplexValue;
    {  TsohoRecordForm }
    property BeforeSQL  : TsohoOnSQLGenerate read FBeforeSQLGen write FBeforeSQLGen;
    {  TsohoRecordForm }
    property AfterSQL   : TsohoOnSQLGenerate read FAfterSQLGen  write FAfterSQLGen;
    {  TsohoRecordForm }
    property OnAddField : TsohoOnAddField    read FOnAddField   write FOnAddField;
    {  TsohoRecordForm }
    property OnAddFieldToSQL : TsohoOnAddFieldToSQL read FOnAddFieldToSQL write FOnAddFieldToSQL;
    {  TsohoRecordForm }
    property OnGetValue : TsohoOnGetValue    read FOnGetValue   write FOnGetValue;
    {  TsohoRecordForm }
    property AfterSQLExecute : TNotifyEvent  read FAfterExec    write FAfterExec;
    {  TsohoRecordForm }
    property OnCardCreate   : TNotifyEvent   read FOnCardCreate write FOnCardCreate;
    {  TsohoRecordForm }
    property OnCardDestroy  : TNotifyEvent   read FOnCardDestroy  write FOnCardDestroy;
    {  TsohoRecordForm }
    property OnCardSave     : TNotifyEvent   read FOnCardSave   write FOnCardSave;
    {  TsohoRecordForm }
    property OnCardLoad     : TNotifyEvent   read FOnCardLoad   write FOnCardLoad;
    {  TsohoRecordForm }
    property OnFilter       : TsohoTreeOnFilter      read FOnFilter       write FOnFilter;
    {  TsohoRecordForm }
    property OnItemDelete   : TsohoTreeOnDeleteItem  read FOnItemDelete   write FOnItemDelete;
    {  TsohoRecordForm }
    property OnGrpDelete    : TsohoTreeOnDeleteGroup read FOnGrpDelete    write FOnGrpDelete;
    {  TsohoRecordForm }
    property OnNewItem      : TsohoTreeOnNewItem     read FOnNewItem      write FOnNewItem;
    {  TsohoRecordForm }
    property OnNewGrp       : TsohoTreeOnNewGroup    read FOnNewGrp       write FOnNewGrp;
    {  TsohoRecordForm }
    property OnItemEdit     : TsohoTreeOnEditItem    read FOnItemEdit     write FOnItemEdit;
    {  TsohoRecordForm }
    property OnItemMove     : TsohoTreeOnMoveItem    read FOnMoveItem     write FOnMoveItem;
    {  TsohoRecordForm }
    property OnGrpEdit      : TsohoTreeOnEditGroup   read FOnGrpEdit      write FOnGrpEdit;
    {  TsohoRecordForm }
    property OnCustomEditGrp: TsohoTreeCustomGroup   read FOnCustomEditGrp write FOnCustomEditGrp;
    {  TsohoRecordForm }
    property OnCustomNewGrp : TsohoTreeCustomGroup   read FOnCustomNewGrp write FOnCustomNewGrp;
    {  TsohoRecordForm }
    property AfterGrpDelete : TNotifyEvent           read FAfterGrpDelete write FAfterGrpDelete;
    {  TsohoRecordForm }
    property OnGridDblClick     : TNotifyEvent    read FOnGridDblClick    write FOnGridDblClick;
    {  TsohoRecordForm }
    property OnGridKeyDown      : TKeyEvent       read FOnGridKeyDown     write FOnGridKeyDown;
    {  TsohoRecordForm }
    property OnGridDragDrop     : TDragDropEvent  read FOnGridDragDrop    write FOnGridDragDrop;
    {  TsohoRecordForm }
    property OnGridMouseMove    : TMouseMoveEvent read FOnGridMouseMove   write FOnGridMouseMove;
    {  TsohoRecordForm }
    property OnGridMouseDown    : TMouseEvent     read FOnGridMouseDown   write FOnGridMouseDown;
    {  TsohoRecordForm }
    property OnGridDragOver     : TDragOverEvent  read FOnGridDragOver    write FOnGridDragOver;
    {  TsohoRecordForm }
    property OnOutLineKeyDown   : TKeyEvent       read FOnGroupsKeyDown   write FOnGroupsKeyDown;
    {  TsohoRecordForm }
    property OnOutLineMouseDown : TMouseEvent     read FOnGroupsMouseDown write FOnGroupsMouseDown;
    {  TsohoRecordForm }
    property OnOutLineMouseMove : TMouseMoveEvent read FOnGroupsMouseMove write FOnGroupsMouseMove;
    {  TsohoRecordForm }
    property OnOutLineDragOver  : TDragOverEvent  read FOnGroupsDragOver  write FOnGroupsDragOver;
    {  TsohoRecordForm }
    property OnOutLineDragDrop  : TDragDropEvent  read FOnGroupsDragDrop  write FOnGroupsDragDrop;
    {  TsohoRecordForm }
    property OnChange           : TNotifyEvent    read FOnChange          write FOnChange;
    {  TsohoRecordForm }
    property OnGroupSelect      : TNotifyEvent    read FOnGroupSelect     write FOnGroupSelect;
    {  TsohoDBGrid }
    property OnGetCellProps: TGetCellPropsEvent read FOnGetCellsProps write FOnGetCellsProps;
    {  TsohoDBGrid }
    property OnDrawDataCell   : TDrawDataCellEvent   read FOnDrawCells write FOnDrawCells;

    {        }
    property BeforeGroupsOpen  : TDataSetNotifyEvent read FBeforeGroupsOpen write FBeforeGroupsOpen;
    {        }
    property BeforeItemsOpen   : TDataSetNotifyEvent read FBeforeItemsOpen  write FBeforeItemsOpen;

    {       }
    property OnFormCreate   : TNotifyEvent read FOnFormCreate  write FOnFormCreate;
    {       }
    property OnFormDestroy  : TNotifyEvent read FOnFormDestroy write FOnFormDestroy;
    {        }
    property OnProgress     : TsohoProgressEvent read FOnProgress write FOnProgress; {04/10/98}
  end;

const

    {  TsohoTreeView }
    btnDelGroup  = 0;
    btnNewGroup  = 1;
    btnEditGroup = 2;
    btnDelItem   = 3;
    btnNewItem   = 4;
    btnEditItem  = 5;
    btnRefresh   = 6;
    btnReNumber  = 7;

implementation
uses SoUtils, ExtCtrls, SoCtmRgs, SoDBRtn, IniFiles, SoGuidC, SoDBCns;

{04/10/98 >>}
procedure TsohoTVContainer.DoProgress (Stage : TProgressStage; PercentDone : byte;
          const Msg : string);
begin
  if Assigned(FGauge) then begin
    case Stage of
      psStarting : begin
        FGauge.MinValue := 0;
        FGauge.MaxValue := 100;
        FGauge.Progress := PercentDone;
        FGauge.Caption  := Msg;
      end;
      psRunning  : begin
        FGauge.Progress := PercentDone;
        FGauge.Caption  := Msg;
      end;
      psEnding   : begin
        FGauge.Progress := 0;
        FGauge.Caption  := Msg;
      end;
    end;
  end;
  if Assigned(FOnProgress) then FOnProgress(Self, Stage, PercentDone, Msg);
end;

procedure TsohoTVContainer.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if (aComponent=FGauge) and (Operation=opRemove) then FGauge := nil;
  inherited Notification(aComponent, Operation);
end;
{04/10/98<<}

procedure TsohoTVContainer.FindOrderOperator;
var Index : LongInt;
    s     : string;
begin
  with TreeViewForm.ItemsQ do begin
    FOldSortSQL := '';
    FOrderWordIndex := SQL.Count;
    SetDivisers([' ']);
    for Index := 0 to pred(SQL.Count) do begin
      S := AnsiUpperCase(SQL[Index]);
      if (GetSomeWords(S, 1, 1) = 'ORDER') and
         (GetSomeWords(S, 2, 2) = 'BY') then begin
        FOrderWordIndex := Index;
        FOldSortSQL := SQL[Index];
      end;
    end;
    if FOrderWordIndex = SQL.Count then SQL.Add(' ');
  end;
end;


procedure TsohoTVContainer.SetSortTitleFont (Value : TFont);
begin
  FSortTitleFont.Assign(Value);
  if FormExists(TreeViewForm) then TreeViewForm.TreeView.DBGrid.Repaint;
end;

procedure TsohoTVContainer.CalcTitleAttributes (Sender: TObject; Field: TField;
          AFont: TFont; var Background: TColor; var SortMarker: TSortMarker;
          IsDown: Boolean);
begin
  if (FSortC=nil) or (not FSortC.Checked) then exit;
  if Field.FieldName = SortField then begin
    aFont.Assign(SortTitleFont);
    SortMarker := smDown;
  end;
end;

{procedure TsohoTVContainer.TitleButtonClick (Sender: TObject; AFieldName: string);}
procedure  TsohoTVContainer.TitleButtonClick (Sender: TObject; ACol: Longint;
               Field: TField);
begin
  if Field.Calculated then exit;
  SetSortField(Field.FieldName);
end;

procedure TsohoTVContainer.SetSortField (Value : string);
var SQL : TStringList;

  procedure ChangeSortField;
  begin
    if FOrderWordIndex = SQL.Count then SQL.Add(' ');
    SQL[FOrderWordIndex] := 'ORDER BY '+FSortField;
  end;

begin
  SQL := TStringList(TreeViewForm.ItemsQ.SQL);
  FSortField := Value;
  if (FSortField <> '') and (FSortC.Checked) then ChangeSortField
  else begin
    if FOrderWordIndex = SQL.Count then SQL.Add(' ');
    if FOldSortSQL = '' then SQL.Delete(FOrderWordIndex)
    else SQL[FOrderWordIndex] := FOldSortSQL;
  end;
  RefreshFolderWithId(TreeViewForm.Folder, FKeyField);
end;

procedure TsohoTVContainer.SortCClicked(Sender : TObject);
begin
  TreeViewForm.TreeView.DBGrid.TitleButtons := FSortC.Checked;
  if (not FSortC.Checked) and (SortField<>'') then SortField := ''
  else SortField := SortField;
end;

function TsohoTVContainer.GetTreeMenuItem (Tag : LongInt) : TMenuItem;

begin
  Result := nil;
  if not FormExists(FTreeViewForm) then exit;
  if FTreeViewForm.TreeView.DBGrid.PopupMenu = nil then exit;
  Result := FindMenuItemByTag(FTreeViewForm.TreeView.DBGrid.PopupMenu, Tag);
end;

function TsohoTVContainer.GroupsQuery : TDataSet;
begin
  Result := nil;
  if not FormExists(FTreeViewForm) then exit;
  Result := FTreeViewForm.GroupsQ;
end;

function TsohoTVContainer.ItemsQuery  : TDataSet;
begin
  Result := nil;
  if not FormExists(FTreeViewForm) then exit;
  Result := FTreeViewForm.ItemsQ;
end;

{$IFNDEF TREEVIEW32}
function  TsohoTVContainer.GetTreeView : TsohoTreeView;
begin
  Result := nil;
  if not FormExists(FTreeViewForm) then exit;
  Result := FTreeViewForm.TreeView;
end;
{$ELSE}
function  TsohoTVContainer.GetTreeView : TsohoTreeView32;
begin
  Result := nil;
  if not FormExists(FTreeViewForm) then exit;
  Result := FTreeViewForm.TreeView;
end;
{$ENDIF}

procedure TsohoTVContainer.DoFormCreate (Reopen, Modal, WithCancel : boolean);
begin
  DoProgress (psRunning, 45, ResString(gdSetEvents));
  if Reopen then SetEvents;
  DoProgress (psRunning, 60, ResString(gdPrepareButtons));
  PrepareButtons(Modal, WithCancel);
  DoProgress (psRunning, 90, ResString(gdQueryActivate));
  if Reopen then TreeView.Active := true;
  DoProgress (psRunning, 99, ResString(gdRestoring));
  if Reopen then RestoreSelection;
  if FClearResults then TreeView.DBGrid.Results.Clear;
  FTreeViewForm.ModalMode := Modal;
  if Assigned(FOnFormCreate) then FOnFormCreate(FTreeViewForm);
  if Reopen then
    with TIniFile.Create(TreeViewForm.Folder.FullFolderName) do begin
      FSortC.Checked := ReadBool('Sorting','Checked',FSortC.Checked);
      SortField := ReadString('Sorting','SortField', '');
      Free;
    end;
end;

procedure TsohoTVContainer.DoFormDestroy (DoFree : boolean);
begin
  if FOkBtn<>nil then FOkBtn.Free;
  if FCancelBtn<>nil then FCancelBtn.Free;
  FOkBtn     := nil;
  FCancelBtn := nil;
  with TIniFile.Create(TreeViewForm.Folder.FullFolderName) do begin
    WriteBool('Sorting','Checked',FSortC.Checked);
    WriteString('Sorting','SortField', SortField);
    Free;
  end;
  if FSortC<>nil then FSortC.Free;
  FSortC     := nil;
  if Assigned(FOnFormDestroy) then FOnFormDestroy(FTreeViewForm);
  if DoFree then begin
    FTreeViewForm.Free;
    FTreeViewForm := nil;
  end
  else FTreeViewForm.Hide;
end;

procedure TsohoTVContainer.CloseTreeViewForm(DoFree : boolean);
begin
  if FTreeViewForm = nil then exit;
  DoFormDestroy(DoFree);
end;

procedure TsohoTVContainer.SetMarkedFont (Value : TFont);
begin
  FMarkedFont.Assign(Value);
end;

procedure TsohoTVContainer.DoNewItem      (Sender: TObject; GroupId: Longint; var ItemId,
                              ItemHash: Longint; var Allow: Boolean);
begin
  if Assigned(FOnNewItem) then FOnNewItem(Sender, GroupId, ItemId,
    ItemHash, Allow)
  else
    if Assigned(FOnOldNewItem) then FOnOldNewItem(Sender, GroupId, ItemId,
       ItemHash, Allow);
end;

procedure TsohoTVContainer.DoEditItem (Sender: TObject; GroupId, ItemId: Longint; var Allow: Boolean);
begin
  if Assigned(FOnItemEdit) then FOnItemEdit(Sender, GroupId, ItemId, Allow)
  else
    if Assigned(FOnOldItemEdit) then FOnOldItemEdit(Sender, GroupId, ItemId,
       Allow);
end;

procedure TsohoTVContainer.DoGetValue (Sender : TObject; FieldName : string; var Value : string);
begin
  if Assigned(FOnOldGetValue) then FOnOldGetValue(Sender, FieldName, Value);
  if Assigned(FOnGetValue) then FOnGetValue(Sender, FieldName, Value);
end;

procedure TsohoTVContainer.AddMenuItems;
var InsIndex, Index : LongInt;
    MnuItem : TMenuItem;
begin
  if FTreeViewMenu = nil then exit;
  with FTreeViewForm.TreeView.DBGrid.PopupMenu do begin
     InsIndex := Items.Count-1;
     {    -       
        }
     while (InsIndex>=0)and (Items[InsIndex].Caption <> '-') do Dec(InsIndex);
     if InsIndex<0 then InsIndex := 0;
     Items.Insert(InsIndex, NewItem('-', 0, false, true, nil, 0, ''));
     inc(InsIndex);
     for Index := 0 to pred(FTreeViewMenu.Items.Count) do begin
       MnuItem := CopyMenuItem(Self, FTreeViewMenu.Items[Index]);
       Items.Insert(InsIndex, MnuItem);
       inc(InsIndex);
     end;
  end;
end;

procedure TsohoTVContainer.SetTreeViewProperties;
begin
  with FTreeViewForm.TreeView do begin
     EditOnDblClick := FEditOnDblClick;
     IncludeSubTree := FIncludeSubTree;
     RootName      := FRootName;
     GroupsSQLFile := FGroupsSQLFile;
     GroupsTable   := FGroupsTable;
     ItemsTable    := FItemsTable;
     ItemsSQLFile  := FItemsSQLFile;
     NameGroupID   := FNameGrID;
     OrderField    := FOrderField;
     NameParentID  := FNameParentID;
     HashField     := FHashField;
     Options       := FOptions;
     SaveOptions   := FSaveOptions;
     ItemsName     := FItemsName;
     GroupsName    := FGroupsName;
     CloseGroups   := FCloseGroups;
     SaveFile      := FSaveFile;
     KeyField	 := FKeyField;
     DBGrid.MarkedColor := FMarkedColor;
     DBGrid.MarkedFont.Assign(FMarkedFont);
     OnFilter      := FOnFilter;
     OnItemDelete  := FOnItemDelete;
     OnGrpDelete   := FOnGrpDelete;
     GroupPreffix  := FGroupPreffix;
     ItemsPreffix  := FItemsPreffix;
     FixedGrpName  := FFixedGrpName;
     FixedGrpId    := FFixedGrpId;
     if FClearResults then FResults.Clear;
     Results.Assign(FResults);

     FOnOldNewItem  := OnNewItem;
     OnNewItem      := DoNewItem;

     FOnOldItemEdit := OnItemEdit;
     OnItemEdit     := DoEditItem;

     OnNewGrp       := FOnNewGrp;

     OnCustomEditGrp := FOnCustomEditGrp;
     OnCustomNewGrp  := FOnCustomNewGrp;

     OnItemMove     := FOnMoveItem;
     OnGrpEdit      := FOnGrpEdit;
     OnGridDblClick     := FOnGridDblClick;
     OnGridKeyDown      := FOnGridKeyDown;
     OnGridDragDrop     := FOnGridDragDrop;
     OnGridMouseMove    := FOnGridMouseMove;
     OnGridMouseDown    := FOnGridMouseDown;
     OnGridDragOver     := FOnGridDragOver;
     OnOutLineKeyDown   := FOnGroupsKeyDown;
     OnOutLineMouseDown := FOnGroupsMouseDown;
     OnOutLineMouseMove := FOnGroupsMouseMove;
     OnOutLineDragOver  := FOnGroupsDragOver;
     OnOutLineDragDrop  := FOnGroupsDragDrop;
     OnChange           := FOnChange;
     OnGroupSelect      := FOnGroupSelect;
     OnGetCellProps     := FOnGetCellsProps;
     OnDrawDataCell     := FOnDrawCells;
     AddMenuItems;
     DataBaseName := FDataBaseName;
     DBGrid.OnTitleBtnClick := TitleButtonClick;
     DBGrid.OnGetBtnParams := CalcTitleAttributes;
  end;
end;

procedure TsohoTVContainer.SetFolderProperties;
begin
  with FTreeViewForm.Folder do begin
     if FFolderDir <> '' then FolderDir := FFolderDir;
     DataBaseName := FDataBaseName;
     FolderName   := FFolderName;
     TableName    := FItemsTable;
     EnabledMenus := SetToStr(FEnabledMenus);
  end;
end;

procedure TsohoTVContainer.SetRecordProperties;
begin
  with FTreeViewForm.RecordCard do begin
     Caption       := FCaption;
     KeyField      := FKeyField;
     TableName     := FItemsTable;
     DataBaseName  := FDataBaseName;
     FocusField    := FFocusField;
     HideFields.Assign(FHideFields);
     SQLHideFields.Assign(FSQLHideFields);
     ComplexFields.Assign(FComplexFields);
     ComplexLabels.Assign(FComplexLabels);
     OnGetTextForField := FOnGetTextForField;
     OnGetComplexValue := FOnGetComplexValue;
     BeforeSQL         := FBeforeSQLGen;
     AfterSQL          := FAfterSQLGen;
     OnAddField        := FOnAddField;
     OnAddFieldToSQL   := FOnAddFieldToSQL;
     FOnOldGetValue    := OnGetValue;
     OnGetValue        := DoGetValue;
     AfterSQLExecute   := FAfterExec;
     OnCardCreate      := FOnCardCreate;
     OnCardDestroy     := FOnCardDestroy;
     OnCardSave        := FOnCardSave;
     OnCardLoad        := FOnCardLoad;
  end;
end;

procedure TsohoTVContainer.SetQueryProperties;
var FGrpsSQL, FItemsSQL : string;
begin
  with FTreeViewForm do begin
     FGrpsSQL  := FGroupsSQLFile;
     FItemsSQL := FItemsSQLFile;

     if SingleRegister<>nil then begin
       FGrpsSQL  := SingleRegister.PathToSQL + FGroupsSQLFile;
       FItemsSQL := SingleRegister.PathToSQL + FItemsSQLFile;
     end;

     with GroupsQ,SQL do begin
       DataBaseName  := FDataBaseName;
       Clear;
       if not FileExists(FGrpsSQL) then begin
         ErrorMsg(Format(sohoTVContFileNotFound, [FGrpsSQL]));
         Abort;
       end;
       LoadFromFile(FGrpsSQL);
       BeforeOpen := FBeforeGroupsOpen;
     end;

     with ItemsQ,SQL do begin
       DataBaseName  := FDataBaseName;
       Clear;
       if not FileExists(FItemsSQL) then begin
         ErrorMsg(Format(sohoTVContFileNotFound, [FItemsSQL]));
         Abort;
       end;
       LoadFromFile(FItemsSQL);
       BeforeOpen := FBeforeItemsOpen;
       { ,    (  ?)  Order by}
       FindOrderOperator;
     end;
  end;
end;

procedure TsohoTVContainer.SetEvents;
begin
  if not FormExists(FTreeViewForm) then exit;
  with FTreeViewForm do begin
    if (FDataBaseName = '') and (SingleRegister<>nil) then
       DataBaseName := SingleRegister.PathToData;
    SetTreeViewProperties;
    SetFolderProperties;
    SetRecordProperties;
    SetQueryProperties;
    Caption := FCaption;
    TreeViewStorage.IniSection := Owner.Name + '.' + ClassName + '.' + Name;
  end;
end;

function  TsohoTVContainer.GetResults : TsohoDBGridResults;
begin
  if FormExists(FTreeViewForm) then Result := FTreeViewForm.TreeView.Results
  else Result := FResults;
end;

procedure TsohoTVContainer.SetHideFields    (Value : TStringList);
begin
  FHideFields.Assign(Value);
end;

procedure TsohoTVContainer.SetSQLHideFields (Value : TStringList);
begin
  FSQLHideFields.Assign(Value);
end;

procedure TsohoTVContainer.SetComplexFields (Value : TStringList);
begin
  FComplexFields.Assign(Value);
end;

procedure TsohoTVContainer.SetComplexLabels (Value : TStringList);
begin
  FComplexLabels.Assign(Value);
end;

function  TsohoTVContainer.GetItemId        : LongInt;
begin
  if not FormExists(FTreeViewForm) then Result := FItemId
  else Result := FTreeViewForm.TreeView.ItemId;
end;

procedure TsohoTVContainer.SetItemId        (Value : LongInt);
begin
  FItemId := Value;
  if FormExists(FTreeViewForm) then FTreeViewForm.TreeView.ItemId := Value;
end;

procedure TsohoTVContainer.SetEnabledMenus  (Value : string);
begin
  FEnabledMenus := StrToSet(Value);
end;

function  TsohoTVContainer.GetEnabledMenus  : string;
begin
  Result := SetToStr(FEnabledMenus);
end;

constructor TsohoTVContainer.Create (AOwner : TComponent);
var Form : TForm;
begin
  inherited Create(AOwner);
  FOptions     := [trDeleteGroup, trAddGroup, trEditGroup, trDeleteItem,
                   trAddItem, trEditItem, trRefresh, trReNumber,
                   trMoveItem,trMoveGroup];
  FSaveOptions  := [trSaveSplitter, trSaveViewChild];
  FEnabledMenus := StrToSet('0-9,11-12,14-15,17-18,20-21,');
  FNameGrID     := 'IDGrp';
  FOrderField   := 'NumOrder';
  FHashField    := 'Hash';
  FNAmeParentId := 'IdParent';
  FItemsName    := sohoTreeDefItemName;
  FGroupsName   := sohoTreeDefGroupName;
  FKeyField     := 'Id';
  FEditOnDblClick := true;
  FCloseGroups  := true;
  FItemId       := -1;
  FFixedGrpId   := -1;
  FFixedGrpName := '';
  FMarkedFont   := TFont.Create;
  with FMarkedFont do begin
     Form := GetOwnerForm(Self);
     if Form<>nil then Assign(Form.Font);
     Color := clBlack;
  end;
  FMarkedColor := $00E5E5E5;

  FSortTitleFont   := TFont.Create;
  with FSortTitleFont do begin
     Form := GetOwnerForm(Self);
     if Form<>nil then Assign(Form.Font);
     Color := clBlue;
  end;

  FTreeViewForm := nil;
  FHideFields    := TStringList.Create;
  with FHideFields do begin
     Clear;
     Add('ID');
     Add('IDGRP');
     Add('HASH');
     Add('PROTECT');
     Add('MDFDATE');
     Add('MDFTIME');
     Add('IDMDFAUTH');
  end;
  FSQLHideFields := TStringList.Create;
  FComplexFields := TStringList.Create;
  FComplexLabels := TStringList.Create;
  FOkBtn         := nil;
  FCancelBtn     := nil;
  FSortC         := nil;
  FLastGroupId   := -1;
  FResults       := TsohoDBGridResults.Create;
  FClearResults  := true;
end;

destructor TsohoTVContainer.Destroy;
begin
  FHideFields.Free;
  FSQLHideFields.Free;
  FComplexFields.Free;
  FComplexLabels.Free;
  FMarkedFont.Free;
  FSortTitleFont.Free;
  FResults.Free;
  inherited Destroy;
end;

procedure TsohoTVContainer.PrepareButtons (Modal : boolean; WithCancel : boolean);
var BtnParent : TPanel;
begin
  if FOkBtn<>nil then FOkBtn.Free;
  if FCancelBtn<>nil then FCancelBtn.Free;
  FOkBtn     := nil;
  FCancelBtn := nil;

  BtnParent := FTreeViewForm.TreeView.BtnsPanel;
  FSortC  := TCheckBox.Create(FTreeViewForm);
  with FSortC do begin
    Parent  := BtnParent;
    Top     := FTreeViewForm.TreeView.ChildCheckBox.Top + 15;
    Width   := BtnParent.Width-4;
    Left    := 2;
    Caption := sohoTVContSortBtnCaption;
    Hint    := sohoTVContSortBtnHint;
    OnClick := SortCClicked;
    Cursor  := crHandPoint;
  end;
  FOkBtn := TsohoBitBtn.Create(FTreeViewForm);
  with FOkBtn do begin
    Parent := BtnParent;
    Top    := FTreeViewForm.TreeView.ChildCheckBox.Top + 35;
    Height := 24;
    Width  := BtnParent.Width-4;
    Left   := 2;
    if Modal then begin
      Caption := 'OK';
      Tag     := 1;
    end
    else begin
      Tag     := 0;
      Caption := sohoTVContBtnClose;
    end;
    OnClick := FTreeViewForm.SelectMClick;
    Cursor := crHandPoint;
  end;
  if (not Modal) or (not WithCancel) then exit;
  FCancelBtn := TsohoBitBtn.Create(FTreeViewForm);
  with FCancelBtn do begin
    Parent  := BtnParent;
    Top     := FOkBtn.Top + FOkBtn.Height+1;
    Height  := 24;
    Width   := BtnParent.Width-4;
    Left    := 2;
    OnClick := FTreeViewForm.CancelMClick;
    Caption := sohoExlRepCancelBtnCaption;
    Cursor := crHandPoint;
  end;
end;

procedure TsohoTVContainer.RestoreSelection;
var GroupIndex : LongInt;
begin
  if FItemId > 0 then FTreeViewForm.TreeView.ItemId := FItemId;
  if FLastGroupId > 0 then begin
     GroupIndex := FTreeViewForm.TreeView.GetIndexByID(FLastGroupId);
     if GroupIndex <> -1 then
       {$IFNDEF TREEVIEW32}
       FTreeViewForm.TreeView.GroupOutLine.SelectedItem := GroupIndex;
       FTreeViewForm.TreeView.RefreshGroup;
       {$ELSE}
       FTreeViewForm.TreeView.GroupTreeView.Selected :=
         FTreeViewForm.TreeView.GroupTreeView.Items[GroupIndex];
       {$ENDIF}
  end
  else FTreeViewForm.TreeView.RefreshGroup;
end;

function  TsohoTVContainer.ReCreateExecute (Modal : boolean; WithCancel : boolean) : boolean;
begin
  SetCursor(crHourGlass);
  DoProgress (psStarting, 0, ResString(gdPreparing));
  if FormExists(TreeViewForm) then begin
    {    ! }
    FTreeViewForm.Free;
    FTreeViewForm := nil;
  end;
  try
    DoProgress (psRunning, 33, ResString(gdFormCreate));
    FTreeViewForm := TsohoTreeViewForm.Create(Application);
    with TreeViewForm do begin
        Result := not Modal;
        DoFormCreate(true, Modal ,WithCancel);
        DoProgress (psRunning, 100, ResString(gdFormShow));
        if Modal then begin
          DoProgress (psEnding, 100, '');
          RestoreCursor;
          Result := ShowModal=mrOk
        end
        else begin
          RestoreCursor;
          Show;
          DoProgress (psEnding, 100, '');
        end;
        if Result then begin
           FItemId := FTreeViewForm.ItemId;
           FLastGroupId := FTreeViewForm.GroupId;
           FResults.Assign(FTreeViewForm.TreeView.Results);
        end;
    end;
  finally
    DoFormDestroy(true);
  end;
end;

function  TsohoTVContainer.Execute (Reopen, Modal : boolean; WithCancel : boolean) : boolean;
begin
  SetCursor(crHourGlass);
  DoProgress (psStarting, 0, ResString(gdPreparing));
  if TreeViewForm<>nil then begin
    if not Reopen then begin
      DoFormCreate(false, Modal, WithCancel);
      DoProgress (psRunning, 100, ResString(gdFormShow));
      if Modal then begin
        DoProgress (psEnding, 100,'');
        RestoreCursor;
        Result := FTreeViewForm.ShowModal=mrOk;
        DoFormDestroy(false);
      end
      else begin
        RestoreCursor;
        FTreeViewForm.Show;
        DoProgress (psEnding, 100,'');
      end;
      exit;
    end
    else begin
      FTreeViewForm.Free;
      FTreeViewForm := nil;
    end;
  end;
  try
    DoProgress (psRunning, 33, ResString(gdFormCreate));
    FTreeViewForm := TsohoTreeViewForm.Create(Application);
    with TreeViewForm do begin
        Result := not Modal;
        DoFormCreate(true, Modal ,WithCancel);
        DoProgress (psRunning, 100, ResString(gdFormShow));
        if Modal then begin
          DoProgress (psEnding, 100,'');
          RestoreCursor;
          Result := ShowModal=mrOk;
          DoFormDestroy(false);
        end
        else begin
          RestoreCursor;
          Show;
          DoProgress (psEnding, 100,'');
        end;
        if Result then begin
           FItemId := FTreeViewForm.ItemId;
           FLastGroupId := FTreeViewForm.GroupId;
           FResults.Assign(FTreeViewForm.TreeView.Results);
        end;
    end;
  except ErrorMsg(Format(sohoTVContFormCreateError, [Name]));
  end;
end;

function  TsohoTVContainer.MDIExecute : boolean;
var Form : TForm;
    BtnParent : TPanel;
begin
  SetCursor(crHourGlass);
  DoProgress (psStarting, 0, ResString(gdPreparing));
  if TreeViewForm<>nil then begin
    TreeViewForm.BringToFront;
    exit;
  end;
  try
    Form := GetOwnerForm(Self);
    if Form=nil then exit;
    if Form.FormStyle<>fsMDIForm then exit;
    DoProgress (psRunning, 33, ResString(gdFormCreate));
    FTreeViewForm := TsohoTreeViewForm.Create(Application);
    with TreeViewForm do begin
        FormStyle := fsMDIChild;
        DoProgress (psRunning, 60, ResString(gdSetEvents));
        SetEvents;
        //FTreeViewForm.GradientCaption.FormCaption := FCaption;
        FTreeViewForm.Caption := FCaption;
        TreeViewStorage.IniSection := Owner.Name + '.' + ClassName + '.' + Name;
        DoProgress (psRunning, 99, ResString(gdRestoring));
        TreeView.Active := true;
        RestoreSelection;
        ModalMode   := false;
        WindowState := wsMaximized;

        BtnParent := FTreeViewForm.TreeView.BtnsPanel;
        FSortC  := TCheckBox.Create(FTreeViewForm);
        with FSortC do begin
          Parent  := BtnParent;
          Top     := FTreeViewForm.TreeView.ChildCheckBox.Top + 15;
          Width   := BtnParent.Width-4;
          Left    := 2;
          Caption := sohoTVContSortBtnCaption;
          Hint    := sohoTVContSortBtnHint;
          OnClick := SortCClicked;
          Cursor := crHandPoint;
        end;

        if Assigned(FOnFormCreate) then FOnFormCreate(FTreeViewForm);
        with TIniFile.Create(TreeViewForm.Folder.FullFolderName) do begin
          FSortC.Checked := ReadBool('Sorting','Checked',FSortC.Checked);
          SortField := ReadString('Sorting','SortField', '');
          Free;
        end;
        DoProgress (psRunning, 100, ResString(gdFormShow));
        RestoreCursor;
        Show;
        DoProgress (psEnding, 100, '');
        Result := true;
    end;
  except ErrorMsg(Format(sohoTVContFormCreateError, [Name]));
  end;
end;

end.
