{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
        
}
unit SoSumRep;

{$I SOHOLIB.INC}

interface

uses Windows, Messages, SysUtils, Classes, Controls, SoExlRep, SoUnit,
     SoGauges, SoRepF, DB, Grids, Graphics, RxDBCtrl;

type

  {    ,    
     .         KeyField  
         (   run-time  
     ).      Ms Excel 
      TsohoExcelReporter
  }
  TsohoSummReport = class(TComponent)
  private
    { Private declarations }
    FDataBaseName : string;
    FCaption   : string;
    FSummField : string;
    FKeyField  : string;
    FFolderName : string;
    FSQLFile : TSQLFileName;
    FSummGroup : boolean;
    FReporter : TsohoExcelReporter;
    FGauge : TsohoGauge;
    FOnSummary,
      FOldSummary : TsohoReportOnSummary;

    FOnGetCellsProps,
     FOldGetCellProps : TGetCellPropsEvent;
    RepForm : TsohoSummReportForm;
  protected
    { Protected declarations }
    procedure WriteReporter    (Stream : TStream);
    procedure ReadReporter     (Stream : TStream);
    procedure DefineProperties (Filer : TFiler);override;
    procedure Notification (aComponent : TComponent; aOperation : TOperation);override;
    procedure DoGetCellProps (Sender: TObject; Field: TField;
              AFont: TFont; var Background: TColor);
    procedure DoSummary (Sender : TObject; DataSet : TDataSet; GroupValue : string);
  public
    constructor Create(aOwner : TComponent);override;
    destructor Destroy;override;
    {  . Params   SQL-,    SQLFile }
    procedure Execute (Params : array of string);
    property ReportForm : TsohoSummReportForm read RepForm;
  published
    {  ,      
        }
    property Gauge      : TsohoGauge read FGauge write FGauge;
    {      }
    property Caption    : string  read FCaption    write FCaption;
    { ,     .    ,
               }
    property KeyField   : string  read FKeyField  write FKeyField;
    { ,      ""   
      .   -     }
    property SummField  : string  read FSummField  write FSummField;
    {        }
    property FolderName : string  read FFolderName write FFolderName;
    {    SQL- }
    property SQLFile    : TSQLFileName  read FSQLFile write FSQLFile;
    {     }
    property DataBaseName : string read FDataBaseName write FDataBaseName;
    {     }
    property SummGroup  : boolean read FSummGroup  write FSummGroup default true;
    {  TsohoExcelReporter,     
       }
    property Reporter : TsohoExcelReporter read FReporter;
    {         }
    property OnGetCellProps: TGetCellPropsEvent read FOnGetCellsProps write FOnGetCellsProps;
    {          }
    property OnSummary : TsohoReportOnSummary read FOnSummary write FOnSummary;
  end;

implementation
uses Forms, FileCtrl, SoUtils, SoBDERtn, SoDBRtn, SoCtmRgs, SoDBCns;

procedure TsohoSummReport.DoSummary (Sender : TObject; DataSet : TDataSet; GroupValue : string);
begin
  if Assigned(FOldSummary) then FOldSummary(Sender, DataSet, GroupValue);
  if Assigned(FOnSummary) then FOnSummary(Self, DataSet, GroupValue);
end;

procedure TsohoSummReport.DoGetCellProps (Sender: TObject; Field: TField;
              AFont: TFont; var Background: TColor);
begin
  if Assigned(FOldGetCellProps) then FOldGetCellProps(Sender, Field, AFont,
    Background);
  if Assigned(FOnGetCellsProps) then FOnGetCellsProps(Sender, Field, AFont,
    Background);
end;

procedure TsohoSummReport.Notification (aComponent : TComponent; aOperation : TOperation);
begin
  if (aComponent=FGauge) and (aOperation = opRemove) then FGauge := nil;
  inherited Notification (aComponent, aOperation);
end;

procedure TsohoSummReport.WriteReporter(Stream : TStream);
begin
  Stream.WriteComponent(FReporter);
end;

procedure TsohoSummReport.ReadReporter(Stream : TStream);
begin
  Stream.ReadComponent(FReporter);
end;

procedure TsohoSummReport.DefineProperties(Filer : TFiler);
begin
  inherited DefineProperties(Filer);
  Filer.DefineBinaryProperty('FReporter', ReadReporter, WriteReporter,
    FReporter <> nil);
end;

constructor TsohoSummReport.Create(aOwner : TComponent);
begin
  inherited Create(aOwner);
  FCaption   := '';
  FSummField := '';
  FKeyField  := '';
  FFolderName := '';
  FSQLFile := '';
  FSummGroup := true;
  FDataBaseName := '';
  FReporter := TsohoExcelReporter.Create(Self);
end;

destructor TsohoSummReport.Destroy;
begin
  FReporter.Free;
  inherited Destroy;
end;

procedure TsohoSummReport.Execute(Params : array of string);
var TmpTemplate : string;
    TmpSQL : string;
begin
  try
    SetCursor(crHourGlass);
    RepForm := TsohoSummReportForm.Create(Application);
    with RepForm do begin
      FOldGetCellProps := ReportGrid.OnGetCellProps;
      FOldSummary := OnSummary;
      OnSummary := DoSummary;
      ReportGrid.OnGetCellProps := DoGetCellProps;
      ProgressGauge := FGauge;
      FReporter.Folder := Folder;
      Reporter := FReporter;
      KeyField := FKeyField;
      CommentField := FSummField;
      if (Folder.FolderDir='') and
         (SingleRegister<>nil) then Folder.FolderDir := SingleRegister.PathToHome;
      Folder.FolderName := FFolderName;
      //GradientCaption.FormCaption    := FCaption;
      Caption := FCaption;
      TmpTemplate := FReporter.Template;
      if SingleRegister<>nil then TmpTemplate :=
        SingleRegister.PathToReports + TmpTemplate;
      FReporter.Template := '';
      if FileExists(TmpTemplate) then aTemplate := TmpTemplate
      else
        if DirectoryExists(TmpTemplate) then aTemplateDir := TmpTemplate
        else begin
          ErrorMsg(Format(sohoSummRepTemplateNotFound, [Self.Name, TmpTemplate]));
          exit;
        end;
      aSummGroup := FSummGroup;
      FBaseDir := FDataBaseName;
      PrepareFields;
      TmpSQL := SQLFile;
      if SingleRegister<>nil then TmpSQL :=  SingleRegister.PathToSQL + TmpSQL;
      ReportSQL.Clear;
      ReportSQL.Strings.LoadFromFile(TmpSQL);
      PutParameteres(TStringList(ReportSQL.Strings), Params);
      try
        SetCursor(crHourGlass);
        try
          PrepareCalcReport;
          GroupC.Checked := FSummGroup;
          ShowModal;
        except
          on E: Exception do
            ErrorMsg(Format(sohoSummRepQueryError, [TmpSQL, E.Message]));
        end;
        KeyField := '';
      finally
        RestoreCursor;
        TmpTableT.Close;
        Folder.Deactivate;
        Reporter.Template := TmpTemplate;
      end;
     end;
  finally
     RepForm.Free;
     RestoreCursor;
  end;
end;

end.
