{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoStatus
}
unit SoStatus;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, ExtCtrls, Menus, SoGauges;

type
  
  {  TsohoStatus    -,  
           : 
      ,  (hints)  .   
       
  }
  TsohoStatus = class(TCustomPanel)
  private
    FDate: boolean;
    FKeys: boolean;
    FTime: boolean;
    DateTimePanel: TPanel;
    KeysPanel: TPanel;
    GaugePanel: TPanel;
    FGaugeV: TsohoGauge; {04/10/98}
    HelpPanel: TPanel;
    UpdateWidth: boolean;
    FTimer: TTimer;
    FGauge: boolean;
    FOldHint: TNotifyEvent;
    FEmbossed : boolean;
    procedure SetDate(A: boolean);
    procedure SetKeys(A: boolean);
    procedure SetTime(A: boolean);
    procedure SetShowGauge(A: boolean);
    procedure SetCaption(A: string);
    function GetCaption: string;
    procedure CMFontChanged(var message: TMessage); message CM_FONTCHANGED;
    procedure SetGaugeMax(Value: Longint);
    procedure SetGaugeMin(Value: Longint);
    procedure SetGaugeProgress(Value: Longint);
    procedure SetGaugeBackColor(Value: TColor);
    procedure SetGaugeForeColor(Value: TColor);
    function GetGaugeMax: Longint;
    function GetGaugeMin: Longint;
    function GetGaugeProgress: Longint;
    function GetGaugeBackColor: TColor;
    function GetGaugeForeColor: TColor;
    procedure SetEmbossed (Value : boolean);
  protected
    procedure ShowAppHint(Sender: TObject);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    {   - }
    procedure UpdateStatusBar(Sender: TObject);
    {    Value  Progress  "" }
    procedure IncProgress(Value: Longint);
    {     TsohoGauge }
    property Gauge: TsohoGauge read FGaugeV;
  published
    {   }
    property Embossed : boolean read FEmbossed write SetEmbossed default true;
    property Align;
    {   ? }
    property ShowDate: boolean read FDate write SetDate default True;
    {      ? }
    property ShowKeys: boolean read FKeys write SetKeys default True;
    {   ? }
    property ShowTime: boolean read FTime write SetTime default True;
    {     ""? }
    property ShowGauge: boolean read FGauge write SetShowGauge default True;
    {    "".  TsohoGauge }
    property GaugeMax: Longint read GetGaugeMax write SetGaugeMax;
    {    "".  TsohoGauge }
    property GaugeMin: Longint read GetGaugeMin write SetGaugeMin;
    {   "".  TsohoGauge }
    property GaugeProgress: Longint read GetGaugeProgress write SetGaugeProgress;
    {   "".  TsohoGauge }
    property GaugeBackColor: TColor read GetGaugeBackColor write SetGaugeBackColor;
    {   "".  TsohoGauge }
    property GaugeForeColor: TColor read GetGaugeForeColor write SetGaugeForeColor;
    property BevelInner;
    property BevelOuter;
    property BevelWidth;
    property BorderStyle;
    property BorderWidth;
    {     TsohoStatus }
    property Caption: string read GetCaption write SetCaption stored False;
    property Color;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Visible;
  end;

implementation
uses SoUtils, SoDate;

procedure TsohoStatus.SetEmbossed (Value : boolean);

   procedure SetBevels (Inner, Outer : TPanelBevel);
   begin
     with DateTimePanel do begin
       BevelInner := Inner;
       BevelOuter := Outer;
     end;    // with
     with KeysPanel do begin
       BevelInner := Inner;
       BevelOuter := Outer;
     end;    // with
     with GaugePanel do begin
       BevelInner := Inner;
       BevelOuter := Outer;
     end;    // with
     with HelpPanel do begin
       BevelInner := Inner;
       BevelOuter := Outer;
     end;    // with
   end;

begin
  if FEmbossed = Value then exit;
  FEmbossed := Value;
  if FEmbossed then SetBevels(bvLowered, bvRaised)
  else SetBevels(bvNone, bvLowered);
end;

procedure TsohoStatus.ShowAppHint(Sender: TObject);
var TmpHint : string;
begin
  TmpHint := ChangeChars(Application.Hint, #13, ' ');
  TmpHint := ChangeChars(TmpHint, #10, ' ');
  HelpPanel.Caption := TmpHint;
  if Assigned(FOldHint) then FOldHint(Sender);
end;

procedure TsohoStatus.SetGaugeMax(Value: Longint);
begin
  FGaugeV.MaxValue := Value;
end;

procedure TsohoStatus.SetGaugeMin(Value: Longint);
begin
  FGaugeV.MinValue := Value;
end;

procedure TsohoStatus.SetGaugeProgress(Value: Longint);
begin
  FGaugeV.Progress := Value;
end;

procedure TsohoStatus.IncProgress(Value: Longint);
begin
  FGaugeV.AddProgress(Value);
end;

procedure TsohoStatus.SetGaugeBackColor(Value: TColor);
begin
  FGaugeV.BackColor := Value;
end;

procedure TsohoStatus.SetGaugeForeColor(Value: TColor);
begin
  FGaugeV.ForeColor := Value;
end;

function TsohoStatus.GetGaugeMax: Longint;
begin
  Result := FGaugeV.MaxValue;
end;

function TsohoStatus.GetGaugeMin: Longint;
begin
  Result := FGaugeV.MinValue;
end;

function TsohoStatus.GetGaugeProgress: Longint;
begin
  Result := FGaugeV.Progress;
end;

function TsohoStatus.GetGaugeBackColor: TColor;
begin
  Result := FGaugeV.BackColor;
end;

function TsohoStatus.GetGaugeForeColor: TColor;
begin
  Result := FGaugeV.ForeColor;
end;

constructor TsohoStatus.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Parent := TWinControl(AOwner);
  FEmbossed := true;
  FTime := True;
  FDate := True;
  FKeys := True;
  FGauge := True;
  {Force the status bar to be aligned bottom}
  Align := alBottom;
  Height := 19;
  BevelInner := bvNone;
  BevelOuter := bvNone;
  {When UpdateWidth is set TRUE, status bar will recalculate panel widths once}
  
  UpdateWidth := True;
  Locked := True;
  TabOrder := 0;
  TabStop := False;
  ParentFont := True;
  ParentColor := True;
  {Font.Name := 'Ms Sans Serif';
   Font.Size := 8;}
  {Create the panel that will hold the date & time}
  DateTimePanel := TPanel.Create(Self);
  DateTimePanel.Parent := Self;
  with DateTimePanel do begin
    Caption := '';
    BevelInner := bvLowered;
    BevelOuter := bvRaised;
    {Set all these true so they reflect the settings of the TsohoStatus}
    
    ParentColor := True;
    ParentFont := True;
    ParentCtl3D := True;
    Width := Canvas.TextWidth('  00/00/00 00:00:00 am  ');
    {Set to rightmost in TsohoStatus boundaries}
    Left := Self.Width - 10;
    Align := alRight;
  end;
  {Create the panel that will hold the Key states}
  KeysPanel := TPanel.Create(Self);
  KeysPanel.Parent := Self;
  with KeysPanel do begin
    Caption := '';
    BevelInner := bvLowered;
    BevelOuter := bvRaised;
    {Set all these true so they reflect the settings of the TsohoStatus}
    ParentColor := True;
    ParentFont := True;
    ParentCtl3D := True;
    Width := Canvas.TextWidth('  Num Cap Ins  ');
    {Set to rightmost up against DateTimePanel}
    Left := DateTimePanel.Left - 10;
    Align := alRight;
  end;
  {Create the panel that will hold the status text}
  GaugePanel := TPanel.Create(Self);
  GaugePanel.Parent := Self;

  with GaugePanel do begin
    BevelInner := bvLowered;
    BevelOuter := bvRaised;
    {Set all these true so they reflect the settings of the TsohoStatus}
    ParentColor := True;
    ParentFont := True;
    ParentCtl3D := True;
    Width := 200;
    Alignment := taLeftJustify;
    Left := KeysPanel.Left - 10;
    Align := alRight;
  end;
  FGaugeV := TsohoGauge.Create(Self);
  with FGaugeV do begin
    Parent := GaugePanel;
    BackColor := Color;
    ForeColor := clBlack;
    Align := alClient;
    ShowText := False;
    BevelMargin := 2;
  end;
  
  HelpPanel := TPanel.Create(Self);
  HelpPanel.Parent := Self;
  with HelpPanel do begin
    BevelInner := bvLowered;
    BevelOuter := bvRaised;
    {Set all these true so they reflect the settings of the TsohoStatus}
    ParentColor := True;
    ParentFont := True;
    ParentCtl3D := True;
    Alignment := taLeftJustify;
    {Have the help panel consume all remaining space}
    Left := GaugePanel.Left - 10;
    Align := alClient;
  end;
  {This is the timer that will update the status bar at regular intervals}

  FTimer := TTimer.Create(Self);
  if FTimer <> nil then begin
    FTimer.OnTimer := UpdateStatusBar;
    {Updates will occur twice a second}
    FTimer.Interval := 500;
    FTimer.Enabled := True;
  end;
  if csDesigning in ComponentState then exit;
  FOldHint := Application.OnHint;
  Application.OnHint := ShowAppHint;
end;

destructor TsohoStatus.Destroy;
begin
  FTimer.Free;
  HelpPanel.Free;
  Gauge.Free;
  GaugePanel.Free;
  KeysPanel.Free;
  DateTimePanel.Free;
  Application.OnHint := FOldHint;
  inherited Destroy;
end;

procedure TsohoStatus.SetDate(A: boolean);
begin
  if FDate = A then exit;
  FDate := A;
  UpdateWidth := True;
end;

procedure TsohoStatus.SetKeys(A: boolean);
begin
  if FKeys = A then exit;
  FKeys := A;
  UpdateWidth := True;
end;

procedure TsohoStatus.SetTime(A: boolean);
begin
  if FTime = A then exit;
  FTime := A;
  UpdateWidth := True;
end;

procedure TsohoStatus.SetShowGauge(A: boolean);
begin
  if FGauge = A then exit;
  FGauge := A;
  UpdateWidth := True;
end;

{When we set or get the TsohoStatus caption, it is affecting the HelpPanel caption instead}
procedure TsohoStatus.SetCaption(A: string);
begin
  HelpPanel.Caption := ' ' + A;
  HelpPanel.Update;
end;

function TsohoStatus.GetCaption: string;
begin
  GetCaption := HelpPanel.Caption;
end;

{This procedure sets the captions appropriately}
procedure TsohoStatus.UpdateStatusBar(Sender: TObject);
var StatStr: string[20];
begin
  DateTimePanel.Caption := '';
  
  if ShowKeys then begin
    StatStr := '';
    if (GetKeyState(VK_NUMLOCK) and $01) <> 0 then StatStr := StatStr + ' Num ';
    if (GetKeyState(VK_CAPITAL) and $01) <> 0 then StatStr := StatStr + ' Cap ';
    if (GetKeyState(VK_INSERT) and $01) <> 0 then StatStr := StatStr + ' Ins ';
    KeysPanel.Caption := StatStr;
  end;
  
  GaugePanel.Visible := FGauge;

  if ShowDate then DateTimePanel.Caption := WDateToStr(Date);
  if ShowTime then DateTimePanel.Caption := DateTimePanel.Caption + ' ' + TimeToStr(Time);

  if UpdateWidth then
    with DateTimePanel do
      if ShowDate or ShowTime then begin
        Visible := True;
        Width := Canvas.TextWidth('  ' + Caption + '  ')
      end
      else Visible := False;
  
  if UpdateWidth then
    with KeysPanel do
      if ShowKeys then begin
        Visible := True;
        Width := Canvas.TextWidth('  Num Cap Ins  ')
      end
      else Visible := False;
  
  UpdateWidth := False;
end;

{This allows font changes to be detected so the panels will be adjusted}
procedure TsohoStatus.CMFontChanged(var message: TMessage);
begin
  inherited;
  UpdateWidth := True;
end;

end.

