{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoSqlFrm;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, StdCtrls, ExtCtrls, SohoBtns, SoCtrls, Mask, ToolEdit,
  Placemnt, SoRxTls, SoTools;

type
  TsohoGetSQLForm = class(TForm)
    SQLFileE: TFilenameEdit;
    sohoLabel1: TsohoLabel;
    SaveB: TsohoBitBtn;
    OpenB: TsohoBitBtn;
    OkB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    Bevel1: TBevel;
    SQLMemo: TMemo;
    sohoLabel2: TsohoLabel;
    Ini: TsohoFormStorage;
    procedure SQLFileEChange(Sender: TObject);
    procedure OpenBClick(Sender: TObject);
    procedure SaveBClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    SQLDir: string;
  end;
  
var sohoGetSQLForm: TsohoGetSQLForm;
  
function SQLFormExecute(var SQLFile: string): boolean;

implementation
uses SoUtils;

{$R *.DFM}

function SQLFormExecute(var SQLFile: string): boolean;
var Tmp: string;
begin
  try
    try
      Result := False;
      sohoGetSQLForm := TsohoGetSQLForm.Create(Application);
      with sohoGetSQLForm do begin
        SQLDir := Ini.ReadString(Ini.IniSection, 'DefaultSQLDir', '');
        if ExtractFilePath(SQLFile) <> '' then SQLDir := ExtractFilePath(SQLFile);
        if (SQLDir <> '') and (SQLDir[Length(SQLDir)] <> '\') then SQLDir := SQLDir + '\';
        Ini.WriteString(Ini.IniSection, 'DefaultSQLDir', SQLDir);
        Tmp := SQLDir + ExtractFileName(SQLFile);
        SQLFileE.Text := Tmp;
        if FileExists(SQLFileE.Text) then SQLMemo.Lines.LoadFromFile(SQLFileE.Text);
        if (Tmp = '') or (Tmp[Length(Tmp)] = '\') then SQLFileE.Text := SQLFileE.Text + '*.SQL';
        Result := ShowModal = mrOk;
        if Result then SQLFile := ExtractFileName(SQLFileE.Text);
      end;
    except
      on E: Exception do ErrorMsg(E.message);
    end;
  finally
    sohoGetSQLForm.Free;
  end
end;

procedure TsohoGetSQLForm.SQLFileEChange(Sender: TObject);
begin
  SaveB.Enabled := SQLFileE.Text <> '';
  OpenB.Enabled := SQLFileE.Text <> '';
  OkB.Enabled := SQLFileE.Text <> '';
end;

procedure TsohoGetSQLForm.OpenBClick(Sender: TObject);
begin
  if FileExists(SQLFileE.Text) then begin
    SQLMemo.Lines.Clear;
    SQLMemo.Lines.LoadFromFile(SQLFileE.Text);
    if ExtractFilePath(SQLFileE.Text) <> '' then
      SQLDir := ExtractFilePath(SQLFileE.Text);
    Ini.WriteString(Ini.IniSection, 'DefaultSQLDir', SQLDir);
  end;
end;

procedure TsohoGetSQLForm.SaveBClick(Sender: TObject);
begin
  try
    SQLMemo.Lines.SaveToFile(SQLFileE.Text);
  except ErrorMsg('  !');
  end;
end;

end.

