{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
     TSpeedBar   Rx-Lib.
}
unit SoSpeed;

{$I SOHOLIB.INC}


interface
uses SysUtils, Classes, SpeedBar, Menus;

type

  {  Rx-Lib    SpeedBar  run-time 
       -.    Customize 
       . TsohoSpeedBar  
         Customize   
      
  }
  TsohoSpeedBar = class(TSpeedBar)
  private
    { Private declarations }
    FSelfMenu    : boolean;
    FEditPopup   : TPopupMenu;
    FIniFileName : string;
    FOnShow      : TNotifyEvent;
    procedure EditItemClick (Sender : TObject);
    procedure DoFormShow    (Sender : TObject);
  protected
    { Protected declarations }
    procedure Loaded; override;
    procedure AfterCustomize; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  end;


implementation
uses SoUtils, SoCtmRgs, IniFiles, Forms, SoDBCns;

{ TsohoSpeedBar }
procedure TsohoSpeedBar.EditItemClick (Sender : TObject);
begin
     Customize(0);
end;

procedure TsohoSpeedBar.AfterCustomize;
var Ini : TIniFile;
begin
     Ini := TIniFile.Create(FIniFileName);
     SaveLayout(Ini);
     Ini.Free;
     inherited AfterCustomize;
end;

procedure TsohoSpeedBar.DoFormShow    (Sender : TObject);
var Ini : TIniFile;
begin
     FSelfMenu := PopupMenu=nil;
     if FSelfMenu then begin
       FEditPopup := TPopupMenu.Create(Self);
       FEditPopup.AutoPopup := true;
     end
     else FEditPopup := PopupMenu;
     if not FSelfMenu then FEditPopup.Items.Add( Menus.NewItem('-',0,false,true,nil,0,''));
     FEditPopup.Items.Add(Menus.NewItem(sohoSpeedCustomize,0,false,true,EditItemClick,0,''));
     if SingleRegister <> nil then
        FIniFileName := SingleRegister.PathToHome+SingleRegister.IniFileName
     else FIniFileName := SoUtils.DefaultName+'.ini';
     PopupMenu := FEditPopup;
     Ini := TIniFile.Create(FIniFileName);
     RestoreLayout(Ini);
     Ini.Free;
     if Assigned(FOnShow) then FOnShow(Sender);
end;

procedure TsohoSpeedBar.Loaded;
var Form : TForm;
begin
     inherited Loaded;
     if csDesigning in ComponentState then exit;
     Form        := GetOwnerForm(Self);
     FOnShow     := Form.OnShow;
     Form.OnShow := DoFormShow;
end;

constructor TsohoSpeedBar.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     FSelfMenu  := false;
     FEditPopup := nil;
     FIniFileName := '';
end;

destructor TsohoSpeedBar.Destroy;
var Form : TForm;
begin
     if FSelfMenu then FEditPopup.Free;
     if not (csDesigning in ComponentState) then begin
        Form        := GetOwnerForm(Self);
        Form.OnShow := FOnShow;
     end;
     inherited Destroy;
end;

end.
