{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoSmRp;

{$I SOHOLIB.INC}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, SohoBtns, SoCtrls, SoFolder, StrHlder;

type
  TsohoAddSummFieldForm = class(TForm)
    sohoLabel1: TsohoLabel;
    sohoLabel2: TsohoLabel;
    sohoLabel3: TsohoLabel;
    Fields1: TListBox;
    Fields2: TListBox;
    ResultFields: TListBox;
    AddOneB: TsohoBitBtn;
    AddTwoB: TsohoBitBtn;
    CancelB: TsohoBitBtn;
    OkB: TsohoBitBtn;
    Results: TStrHolder;
    Fields: TStrHolder;
    procedure AddOneBClick(Sender: TObject);
    procedure AddTwoBClick(Sender: TObject);
    procedure ResultFieldsKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    procedure PrepareControls (FirstEnable : boolean);
    function  Execute (Folder : TsohoFolder) : boolean;
  public
    { Public declarations }
    Current, CurrentF : string;
    FFolder : TsohoFolder;
  end;

var sohoAddSummFieldForm: TsohoAddSummFieldForm;


function EditSummFields (Folder : TsohoFolder) : boolean;

implementation
uses DB, DBTables, SoUtils, SoRepF;

{$R *.DFM}

function EditSummFields (Folder : TsohoFolder) : boolean;
begin
  try
    Result := false;
    sohoAddSummFieldForm := TsohoAddSummFieldForm.Create(Application);
    Result := sohoAddSummFieldForm.Execute(Folder);
  finally
    sohoAddSummFieldForm.Free;
  end;
end;

function TsohoAddSummFieldForm.Execute (Folder : TsohoFolder) : boolean;
var Tmp : string;
    Field1, Field2 : string;
    Index : integer;
begin
  FFolder := Folder;
  for Index := 0 to pred(
    FFolder.Ini.ReadInteger(ReportSection,'FieldsCount',0)) do begin
    Tmp := FFolder.Ini.ReadString(ReportSection,'Fields'+IntToStr(Index+1),'');
    if Tmp <> '' then begin
      SetDivisers(['|']);
      Field1 := GetSomeWords(Tmp, 1, 1);
      Field2 := GetSomeWords(Tmp, 2, 2);
      if (FFolder.DataSet.FindField(Field1)<>nil) and
         (FFolder.DataSet.FindField(Field2)<>nil) then begin
        Results.Strings.Add(Tmp);
        ResultFields.Items.Add(FFolder.DataSet.FindField(Field1).DisplayLabel+' | '+
                         FFolder.DataSet.FindField(Field2).DisplayLabel);
      end;
    end;
  end;

  Fields1.Clear;
  Fields2.Clear;
  for Index := 0 to pred(FFolder.DataSet.FieldCount) do
   with FFolder.DataSet.Fields[Index] do begin
    if (DataType in [ftInteger, ftFloat, ftWord, ftSmallint, ftCurrency]) and
       (copy(FieldName, 1, 6)<>ReportField) then begin
      Fields1.Items.Add(DisplayLabel);
      Fields2.Items.Add(DisplayLabel);
      Fields.Strings.Add(FieldName);
    end;
   end;
  PrepareControls(true);
  Result := ShowModal=mrOk;
  if not Result then exit;

  //    
  with Folder.Ini do begin
    EraseSection(ReportSection);
    if Results.Strings.Count > 0 then begin
      WriteInteger(ReportSection, 'FieldsCount', Results.Strings.Count);
      for Index := 0 to pred(Results.Strings.Count) do
        WriteString(ReportSection, 'Fields'+IntToStr(Index+1),
          Results.Strings[Index]);
    end;
  end;
  InfoMsg('         ');
end;

procedure TsohoAddSummFieldForm.PrepareControls (FirstEnable : boolean);
begin
  Fields1.Enabled      := FirstEnable;
  Fields2.Enabled      := not FirstEnable;
  ResultFields.Enabled := FirstEnable;
  AddOneB.Enabled      := FirstEnable;
  AddTwoB.Enabled      := not FirstEnable;
  OkB.Enabled          := FirstEnable;
end;

procedure TsohoAddSummFieldForm.AddOneBClick(Sender: TObject);
begin
  Current := Fields1.Items[Fields1.ItemIndex]+' | ';
  ResultFields.Items.Add(Current);
  CurrentF := StrUpper(Fields.Strings[Fields1.ItemIndex]+'|');
  Results.Strings.Add(CurrentF);
  PrepareControls(false);
end;

procedure TsohoAddSummFieldForm.AddTwoBClick(Sender: TObject);
begin
  Current := Current + Fields2.Items[Fields2.ItemIndex];
  ResultFields.Items[ResultFields.Items.Count-1] := Current;

  CurrentF := CurrentF + StrUpper(Fields.Strings[Fields2.ItemIndex]);
  Results.Strings[Results.Strings.Count-1] := CurrentF;
  PrepareControls(true);
end;

procedure TsohoAddSummFieldForm.ResultFieldsKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if (Key = vk_Delete) and (YesNoMsg(' ,     ?')) then begin
    Results.Strings.Delete(ResultFields.ItemIndex);
    ResultFields.Items.Delete(ResultFields.ItemIndex);
    PrepareControls(true);
  end;
end;

end.
