(*{$A+,B-,D-,F-,G+,I-,K+,L-,N+,P-,Q-,R-,S-,T-,V+,W-,X+,Y-}*)
{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
        

           >>> Dmitry Shikhman, 2:468/13.32 <<<

        .
}
unit SoSingle;

interface

{      ,  Active = true,
    .   AppId  
     .  TerminateSelf ,
          
  .    TsohoApplication   
    ,    SearchPrev
}
(*Example:
uses
  SoSingle, {        }
  Forms,
  main in 'main.pas' {MainForm},
  GrpCard in 'GrpCard.pas' {EditGroupForm};

{$R *.RES}

begin
  AlreadyRunning('Test.Application.Already.Running', true, true);
  Application.Initialize;
  Application.CreateForm(TMainForm, MainForm);
  Application.Run;
end.
*)
function AlreadyRunning (const AppId: string; Activate, TerminateSelf: boolean): boolean;

implementation
uses Windows, Messages, Forms, SoUtils;

var HFile: THandle;

procedure ErrorMsg (TerminateSelf: boolean);
begin
  SoUtils.ErrorMsg('    !');
  if TerminateSelf then Halt(255);
end;

function AlreadyRunning;
var lpvMem: Pointer;
    AppHandle, TopWindow: HWnd;
begin
  Result := true;
  HFile := CreateFileMapping(THandle($FFFFFFFF), nil, PAGE_READWRITE, 0,
           4096, PChar(AppId));
  if HFile = 0 then begin
    ErrorMsg(TerminateSelf);
    Exit;
  end;
  Result := GetLastError() = ERROR_ALREADY_EXISTS;
  lpvMem := MapViewOfFile(HFile, FILE_MAP_WRITE, 0, 0, 0);
  if lpvMem = nil then begin
    ErrorMsg(TerminateSelf);
    Exit;
  end
  else begin
    if Result then begin
      if Activate then begin
        Move(lpvMem^, AppHandle, SizeOf(AppHandle));
        if AppHandle <> 0 then begin
          if IsIconic(AppHandle) then
             SendMessage(AppHandle, WM_SYSCOMMAND, SC_RESTORE, 0);
          TopWindow := GetLastActivePopup(AppHandle);
          if (TopWindow <> 0) and (TopWindow <> AppHandle) and
            IsWindowVisible(TopWindow) and IsWindowEnabled(TopWindow) then
            SetForegroundWindow(TopWindow);
        end;
      end;
      if TerminateSelf then Halt(255);
    end
    else begin
      AppHandle := Application.Handle;
      Move(AppHandle, lpvMem^, SizeOf(AppHandle));
    end;
    UnmapViewOfFile(lpvMem);
  end;
end;

initialization
  HFile := 0;
finalization
  if HFile <> 0 then CloseHandle(HFile);
end.

