{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
         
}
unit SoShell;

{$I SOHOLIB.INC}

interface
uses WinTypes, WinProcs, Forms;

{     }
function GetCaptionHeight  (Form : TForm) : integer;
{      }
function GetCaptionRect    (Form : TForm) : TRect;
{     }
function GetBorderHeight   (Form : TForm) : integer;
{      }
function GetMainMenuHeight (Form : TForm) : integer;
{       }
function GetMainMenuRect   (Form : TForm) : TRect;

implementation

function GetCaptionHeight  (Form : TForm) : integer;
begin
  Result := 0;
  if Form.BorderStyle<>bsNone then Result := GetSystemMetrics(SM_CYCAPTION);
end;

function GetBorderHeight (Form : TForm) : integer;
begin
  Result := 0;
  if Form.BorderStyle=bsSizeable then
      Result := GetSystemMetrics(SM_CYFRAME);
  if Form.BorderStyle=bsDialog then
      Result := GetSystemMetrics(SM_CYDLGFRAME);
end;


function GetCaptionRect    (Form : TForm) : TRect;
begin
  with Result do begin
    Left  := 0;
    Top   := 0;
    Right := Form.Width;
    Bottom := GetCaptionHeight(Form)+GetBorderHeight(Form);
  end;
end;

function GetMainMenuHeight (Form : TForm) : integer;
begin
  Result := 0;
  if Assigned(Form.Menu) then
     Result := GetSystemMetrics(SM_CYMENU);
end;

function GetMainMenuRect   (Form : TForm) : TRect;
begin
  with Result do begin
    Left  := 0;
    Top   := GetCaptionHeight(Form)+GetBorderHeight(Form);
    Right := Form.Width;
    Bottom := Top+GetMainMenuHeight(Form);
  end;
end;

end.
