{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
    TsohoScrollPanel
}
unit SoScrPnl;

{$I SOHOLIB.INC}

interface

uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
     Forms, ExtCtrls, Menus;

type

  {    Options  TsohoScrollPanel:
    sbHorizontal -     
    sbVertical   -      }
  TScrollBarsOption = (sbHorizontal, sbVertical);
  {    TsohoScrollPanel }
  TScrollBarsOptions = set of TScrollBarsOption;

  {       TPnel    
        .  , ""    
      ,       .  
    VirtualWidth  VirtualHeight        
    "" , ""  .    
      ,    3D Studio Max
  }
  TsohoScrollPanel = class(TCustomPanel)
  private
    { Private declarations }
    FXPos, FYPos   : LongInt;
    FX, FY         : LongInt;

    FScrolling     : boolean;
    FVirtualHeight : LongInt;
    FVirtualWidth  : LongInt;
    FScrollColor   : TColor;
    FScrollWidth   : integer;
    FScrollBack    : TColor;
    FOptions       : TScrollBarsOptions;
    procedure SetOptions        (Value : TScrollBarsOptions);
    procedure SetVirtualHeight  (Value: LongInt);
    procedure SetVirtualWidth   (Value: LongInt);
    procedure SetXPos           (Value: LongInt);
    procedure SetYPos           (Value: LongInt);
    procedure MoveControlsTops  (Offset: LongInt);
    procedure MoveControlsLefts (Offset: LongInt);
    procedure SetScrollColor    (Value: TColor);
    procedure SetScrollBack     (Value: TColor);
    procedure SetScrollWidth    (Value: integer);
  protected
    { Protected declarations }
    procedure BeginScrolling (NewY, NewX : LongInt);
    procedure EndScrolling;
    procedure SetWorkCursor;
    procedure WMRButtonDown (var Message: TWMLButtonDown); message WM_RBUTTONDOWN;
    procedure WMRButtonUp   (var Message: TWMLButtonUp); message WM_RBUTTONUP;
    procedure WMLButtonDown (var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMLButtonUp   (var Message: TWMLButtonUp); message WM_LBUTTONUP;
    procedure WMMouseMove   (var Message: TWMMouseMove); message WM_MOUSEMOVE;
  public
    { Public declarations }
    procedure Paint;override;
    constructor Create(AOnwer : TComponent);override;
  published
    { Published declarations }
    property Align;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Color;
    property Ctl3D;
    property Font;
    property Locked;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    {    }
    property VirtualHeight : LongInt read FVirtualHeight write SetVirtualHeight;
    {    }
    property VirtualWidth : LongInt read FVirtualWidth write SetVirtualWidth;
    {          }
    property VirtualYPos    : LongInt read FYPos           write SetYPos default 0;
    {          }
    property VirtualXPos    : LongInt read FXPos           write SetXPos default 0;
    {   }
    property ScrollColor   : TColor  read FScrollColor   write SetScrollColor default clGray;
    {     }
    property ScrollBack    : TColor  read FScrollBack    write SetScrollBack default clWhite;
    {   }
    property ScrollWidth   : integer read FScrollWidth   write SetScrollWidth default 3;
    {   }
    property Options       : TScrollBarsOptions read FOptions write SetOptions;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
  end;

implementation
uses SoUtils;

{$IFDEF WIN32}
{$R SOSCRPNL.R32}
{$ELSE}
{$R SOSCRPNL.R16}
{$ENDIF}
const
  crHandDrag    = 11;

procedure TsohoScrollPanel.SetWorkCursor;
begin
  if ((sbVertical in Options) and (VirtualHeight>Height)) or
     ((sbHorizontal in Options) and (VirtualWidth>Width)) then
       Cursor := crHandDrag
  else Cursor := crDefault;
end;

procedure TsohoScrollPanel.SetOptions  (Value : TScrollBarsOptions);
begin
  if Value = [] then exit;
  if not (sbVertical in Value) then VirtualYPos := 0;
  if not (sbHorizontal in Value) then VirtualXPos := 0;
  FOptions := Value;
  SetWorkCursor;
end;

procedure TsohoScrollPanel.SetScrollBack    (Value: TColor);
begin
  if FScrollBack = Value then exit;
  FScrollBack := Value;
  Repaint;
end;

procedure TsohoScrollPanel.SetScrollWidth   (Value: integer);
begin
  if FScrollWidth = Value then exit;
  if (Value<1) or (Value>10) then exit;
  FScrollWidth := Value;
  Repaint;
end;

procedure TsohoScrollPanel.SetScrollColor (Value : TColor);
begin
  if FScrollColor = Value then exit;
  FScrollColor := Value;
  Repaint;
end;

procedure TsohoScrollPanel.BeginScrolling (NewY, NewX : LongInt);
begin
  if ((sbVertical in Options) and (Height >= VirtualHeight)) or
     ((sbHorizontal in Options) and (Width >= VirtualWidth)) then exit;
  if sbVertical in Options then FY := NewY;
  if sbHorizontal in Options then FX := NewX;
  FScrolling := true;
  SetCapture(Handle);
end;

procedure TsohoScrollPanel.EndScrolling;
begin
  if not FScrolling then exit;
  FScrolling := false;
  ReleaseCapture;
end;

procedure TsohoScrollPanel.WMRButtonDown(var Message: TWMRButtonDown);
begin
  if (csDesigning in ComponentState) then BeginScrolling(Message.YPos, Message.XPos);
  inherited;
end;

procedure TsohoScrollPanel.WMRButtonUp(var Message: TWMRButtonUp);
begin
  if (csDesigning in ComponentState) then EndScrolling;
  inherited;
end;

procedure TsohoScrollPanel.WMLButtonDown(var Message: TWMLButtonDown);
begin
  if not (csDesigning in ComponentState) then BeginScrolling(Message.YPos, Message.XPos);
  inherited;
end;

procedure TsohoScrollPanel.WMLButtonUp(var Message: TWMLButtonUp);
begin
  EndScrolling;
  inherited;
end;

procedure TsohoScrollPanel.WMMouseMove(var Message: TWMMouseMove);
begin
  if FScrolling then begin
    MoveControlsTops(Message.YPos - FY);
    MoveControlsLefts(Message.XPos - FX);
    FY  := Message.YPos;
    FX  := Message.XPos;
  end;
  inherited;
end;

procedure TsohoScrollPanel.SetVirtualHeight (Value: LongInt);
begin
  if FVirtualHeight = Value then exit;
  FVirtualHeight := Value;
  SetWorkCursor;
  Repaint;
end;

procedure TsohoScrollPanel.SetVirtualWidth   (Value: LongInt);
begin
  if FVirtualWidth = Value then exit;
  FVirtualWidth := Value;
  SetWorkCursor;
  Repaint;
end;

procedure TsohoScrollPanel.MoveControlsTops (Offset : LongInt);
var NewPos, Index : LongInt;
begin
  if not (sbVertical in Options) then exit;
  NewPos := FYPos - Offset;
  if (NewPos < 0) or (NewPos > FVirtualHeight - Height)  then exit;
  FYPos := NewPos;
  for Index := 0 to pred(ControlCount) do
    if Controls[Index].Tag >= 0 then
      Controls[Index].Top := Controls[Index].Top + Offset;
  Repaint;
end;

procedure TsohoScrollPanel.MoveControlsLefts (Offset : LongInt);
var NewPos, Index : LongInt;
begin
  if not (sbHorizontal in Options) then exit;
  NewPos := FXPos - Offset;
  if (NewPos < 0) or (NewPos > FVirtualWidth - Width)  then exit;
  FXPos := NewPos;
  for Index := 0 to pred(ControlCount) do
    if Controls[Index].Tag >= 0 then
      Controls[Index].Left := Controls[Index].Left + Offset;
  Repaint;
end;

procedure TsohoScrollPanel.SetYPos (Value: LongInt);
begin
  if FYPos = Value then exit;
  if (Value < 0) or (Value > FVirtualHeight - Height)  then exit;
  MoveControlsTops(FYPos - Value);
end;

procedure TsohoScrollPanel.SetXPos (Value: LongInt);
begin
  if FXPos = Value then exit;
  if (Value < 0) or (Value > FVirtualWidth - Width)  then exit;
  MoveControlsLefts(FXPos - Value);
end;

procedure TsohoScrollPanel.Paint;
var MemBmp : TBitmap;
    Rect   : TRect;
    TopColor, BottomColor: TColor;
    Tmp : LongInt;
begin
   try
     MemBmp := TBitMap.Create;
     MemBmp.Height := Height;
     MemBmp.Width  := Width;
     Rect := GetClientRect;
     if BevelOuter <> bvNone then begin
       AdjustColors(BevelOuter, TopColor, BottomColor, clBtnHighlight, clBtnShadow);
       Frame3D(MemBmp.Canvas, Rect, TopColor, BottomColor, BevelWidth);
     end;
     Frame3D(MemBmp.Canvas, Rect, Color, Color, BorderWidth);
     if BevelInner <> bvNone then begin
       AdjustColors(BevelInner, TopColor, BottomColor, clBtnHighlight, clBtnShadow);
       Frame3D(MemBmp.Canvas, Rect, TopColor, BottomColor, BevelWidth);
     end;
     with MemBmp.Canvas do begin
       Brush.Color := Self.Color;
       FillRect(Rect);
     end;
     if (Height < VirtualHeight) and (sbVertical in Options) then begin;
       with MemBmp.Canvas do begin
         Pen.Color := clBtnHighlight;
         MoveTo(Width-(3+FScrollWidth),0);
         LineTo(Width-(3+FScrollWidth),Height);
         MoveTo(Width-1,0);
         LineTo(Width-1,Height);
         Pen.Color := clBtnShadow;
         MoveTo(Width-(2+FScrollWidth),0);
         LineTo(Width-(2+FScrollWidth),Height);
         MoveTo(Width,0);
         LineTo(Width,Height);

         Brush.Color := FScrollBack;
         FillRect(Bounds(Width-(1+FScrollWidth),0,
                       FScrollWidth,Height
                      )) ;
         Brush.Color := FScrollColor;
         Tmp := trunc(Height*FYPos/FVirtualHeight);
         FillRect(Bounds(Width-(1+FScrollWidth), Tmp,
                       FScrollWidth,trunc(Height*(FYPos+Height)/FVirtualHeight)-Tmp
                      )) ;

       end;
     end;
     if (Width < VirtualWidth) and (sbHorizontal in Options) then begin;
       with MemBmp.Canvas do begin
         Pen.Color := clBtnHighlight;
         MoveTo(0,Height-(3+FScrollWidth));
         LineTo(Width, Height-(3+FScrollWidth));
         MoveTo(0, Height-1);
         LineTo(Width, Height-1);

         Pen.Color := clBtnShadow;
         MoveTo(0, Height-(2+FScrollWidth));
         LineTo(Width, Height-(2+FScrollWidth));
         MoveTo(0, Height);
         LineTo(Width, Height);

         Brush.Color := FScrollBack;
         FillRect(Bounds(0, Height-(1+FScrollWidth),
                         Width, FScrollWidth
                      )) ;
         Brush.Color := FScrollColor;

         Tmp := trunc(Width*FXPos/FVirtualWidth);
         FillRect(Bounds(Tmp, Height-(1+FScrollWidth),
                       trunc(Width*(FXPos+Width)/FVirtualWidth)-Tmp, FScrollWidth
                      )) ;

       end;
     end;
     BitBlt(Canvas.Handle,0,0,Width,Height,MemBmp.Canvas.Handle,0,0,SRCCOPY);
   finally
     MemBmp.Free;
   end;
end;

constructor TsohoScrollPanel.Create(AOnwer : TComponent);
begin
   inherited Create(AOnwer);
   ControlStyle := ControlStyle + [csDesignInteractive, csOpaque, csCaptureMouse];
   // Cursor := crHandDrag;
   FYPos := 0;
   FXPos := 0;
   FVirtualHeight := Height * 2;
   FVirtualWidth := Width;
   FOptions := [sbVertical];
   FScrolling := false;
   FScrollColor := clGray;
   BevelInner   := bvNone;
   BevelOuter   := bvNone;
   FY           := 0;
   FX           := 0;
   FScrollWidth := 3;
   FScrollBack  := clWhite;
   SetWorkCursor;
end;

procedure DestroyCursors; far;
begin
  DestroyCursor(Screen.Cursors[crHandDrag]);
end;

begin
  Screen.Cursors[crHandDrag] := LoadCursor(hInstance, 'SOHO_DRAG');
  AddExitProc(DestroyCursors);
end.

