{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
{
   -e    :
 TsohoDirectoryDialog
}
unit SoSDlgs;

{$I SOHOLIB.INC}

interface

uses  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
      Forms, StdCtrls, ExtCtrls, FileCtrl, Buttons, SoCtrls, SoTools,
      DBTables, Dialogs;

type

  {     }
  TsohoSelectDirDlg = class(TForm)
    DirList   : TDirectoryListBox;
    DirEdit   : TEdit;
    FileLabel : TLabel;
    DriveList : TDriveComboBox;
    DirLabel  : TLabel;
    OKButton  : TBitBtn;
    Button2   : TBitBtn;
    NetButton : TButton;
    BitBtn1   : TBitBtn;
    procedure DirListChange   (Sender: TObject);
    procedure FormCreate      (Sender: TObject);
    procedure DriveListChange (Sender: TObject);
    procedure NetClick        (Sender: TObject);
    procedure OKClick         (Sender: TObject);
  private
    { Private declarations }
    FAllowCreate : Boolean;
    FPrompt      : Boolean;
    WNetConnectDialog : function (WndParent: HWND; IType: Word): Word;
    procedure SetAllowCreate(Value: Boolean);
    procedure SetDirectory(const Value: string);
    function  GetDirectory: string;
  public
    {     }
    FileList : TFileListBox;
    FindFile : boolean;
    constructor Create(AOwner: TComponent);override;
    {   }
    property Directory   : string  read GetDirectory write SetDirectory;
    {       }
    property AllowCreate : Boolean read FAllowCreate write SetAllowCreate default False;
    {       }
    property Prompt      : Boolean read FPrompt      write FPrompt        default False;
  end;

  {         TsohoDirectoryDialog: 
     ,   ,  -     }
  TsohoShowDriveLabelsOption  = (slFloppy, slHard, slCD, slNetWork);
  {      TsohoDirectoryDialog }
  TsohoShowDriveLabelsOptions = set of TsohoShowDriveLabelsOption;

  {        .  
     ,       
       -  ,     ,
         ( FileMustExists). 
     FileMustExists ,      
    ,    ,   . 
    ,         
    (aliases) }
  TsohoDirectoryDialog = class(TComponent)
  private
    FOptions       : TSelectDirOpts;
    FCaption       : TCaption;
    FDirectory     : TDirName;
    FHelpContext   : THelpContext;
    FFileMustExist : string;
  public
    constructor Create(AOwner : TComponent);override;
    destructor  Destroy;override;
    {  .   true,    OK }
    function    Execute : boolean;
  published
    {   }
    property Options        : TSelectDirOpts read FOptions   write FOptions default [];
    {   }
    property Title          : TCaption       read FCaption   write FCaption;
    {   }
    property Directory      : TDirName       read FDirectory write FDirectory;
    {       }
    property HelpContext    : THelpContext   read FHelpContext write FHelpContext default 0;
    {   ,      }
    property FileMustExists : string         read FFileMustExist write FFileMustExist;
  end;

implementation
uses SoUtils, SoDBCns
     {$IFDEF RUSSIAN_MESSAGES}
     , Consts
     {$ENDIF}
     ;

const AliasMark : char = ' ';

procedure CutFirstDirectory(var S: TFileName);
var
  Root: Boolean;
  P: Integer;
begin
  if S = '\' then S := ''
  else begin
    if S[1] = '\' then
    begin
      Root := True;
      S := Copy(S, 2, 255);
    end else Root := False;
    if S[1] = '.' then S := Copy(S, 5, 255);
    P := Pos('\',S);
    if P <> 0 then S := '...\' + Copy(S, P + 1, 255)
    else S := '';
    if Root then S := '\' + S;
  end;
end;

function MinimizeName(const Filename: TFileName; Canvas: TCanvas;
  MaxLen: Integer): TFileName;
var
  Drive: string[3];
  Dir: TFileName;
  Name: TFileName;
  Ext: TFileName;
begin
  Result := FileName;
  Dir := ExtractFilePath(Result);
  Name := ExtractFileName(Result);
  {$IFNDEF Win32}
  P := Pos('.', Name);
  if P > 0 then Name[0] := Chr(P - 1);
  {$ENDIF}
  Ext := ExtractFileExt(Result);

  if (length(Dir)>=2) and (Dir[2] = ':') then
  begin
    Drive := Copy(Dir, 1, 2);
    Dir := Copy(Dir, 3, 255);
  end else Drive := '';
  while ((Dir <> '') or (Drive <> '')) and (Canvas.TextWidth(Result) > MaxLen) do
  begin
    if Dir = '\...\' then
    begin
      Drive := '';
      Dir := '...\';
    end else if Dir = '' then Drive := ''
    else CutFirstDirectory(Dir);
    Result := Drive + Dir + Name
     {$IFNDEF Win32}
      +Ext
     {$ENDIF};
  end;
end;

procedure ProcessPath (const EditText: string; var Drive: Char;
  var DirPart: string; var FilePart: string);
var
  SaveDir: string;
  SaveDrive: Char;
begin
  GetDir (0, SaveDir);
  SaveDrive := SaveDir[1];
  Drive := SaveDrive;
  DirPart := EditText;
  if (DirPart[1] = '[') and (DirPart[Length(DirPart)] = ']') then
    DirPart := Copy(DirPart, 2, Length(DirPart) - 2)
  else if Pos(':', DirPart) = 2 then
  begin
    Drive := DirPart[1];
    DirPart := Copy(DirPart, 3, Length(DirPart) - 2);
  end;

  try
    if SaveDrive <> Drive then ChDir(Drive + ':');
    FilePart := ExtractFileName (DirPart);
    if Length(DirPart) = (Length(FilePart) + 1) then DirPart := '\'
    else if Length(DirPart) > Length(FilePart) then
      DirPart := Copy (DirPart, 1, Length(DirPart) - Length(FilePart) - 1)
    else
    begin
      GetDir (0, DirPart);
      DirPart := Copy (DirPart, 3, Length(DirPart) - 2);
    end;
    if Length(DirPart) > 0 then ChDir (DirPart);  {first go to our new directory}
    if (Length(FilePart) > 0) and not
       (((Pos('*', FilePart) > 0) or (Pos('?', FilePart) > 0)) or
       FileExists(FilePart)) then
    begin
      ChDir (FilePart);
      if Length (DirPart) = 1 then DirPart := Format('\%s', [FilePart])
      else DirPart := Format('%s\%s', [DirPart, FilePart]);
      FilePart := '';
    end;
  finally
    ChDir (SaveDir);  { restore original directory }
  end;
end;

function GetItemHeight(Font: TFont): Integer;
var
  DC: HDC;
  SaveFont: HFont;
  Metrics: TTextMetric;
begin
  DC := GetDC(0);
  SaveFont := SelectObject(DC, Font.Handle);
  GetTextMetrics(DC, Metrics);
  SelectObject(DC, SaveFont);
  ReleaseDC(0, DC);
  Result := Metrics.tmHeight;
end;

{-----------------------TWSelectDirDlg------------------------}
constructor TsohoSelectDirDlg.Create(AOwner: TComponent);
var AliasList:TStringList;iNDEX:LongInt;
begin
  inherited CreateNew(AOwner);
  FindFile := false;
  {$IFNDEF Win32}
  Caption := LoadStr(SSelectDirCap);
  {$ELSE}
  Caption := SSelectDirCap;
  {$ENDIF}
  BorderStyle := bsDialog;
  ClientWidth := 424;
  ClientHeight := 255;
  Font.Name := 'MS Sans Serif';
  Font.Size := 8;
  Font.Style := [fsBold];
  Position := poScreenCenter;

  DirEdit := TEdit.Create(Self);
  with DirEdit do
  begin
    Parent := Self;
    SetBounds(8, 24, 313, 20);
    Visible := False;
    TabOrder := 1;
  end;

  with TLabel.Create(Self) do
  begin
    Parent := Self;
    SetBounds(8, 8, 92, 13);
    FocusControl := DirEdit;
    {$IFNDEF Win32}
    Caption := LoadStr(SDirNameCap);
    {$ELSE}
    Caption := 'Directory or Alias'//SDirNameCap;
    {$ENDIF}
  end;

  {$IFDEF Ver40}
  DriveList := TsohoDriveCombo.Create(Self);
  {$ELSE}
  DriveList := TDriveComboBox.Create(Self);
  {$ENDIF}

  with DriveList do
  begin
    Parent := Self;
    SetBounds(232, 192, 185, 19);
    TabOrder := 2;
//Added by Allex TWICE
    AliasList:=TStringList.Create;
    Session.GetAliasNames(AliasList);
    for iNDEX:=0 to AliasList.Count-1 do DriveList.Items.Add(AliasMark+AliasList[iNDEX]);
    AliasList.Free;
    OnChange := DriveListChange;
  end;

  with TLabel.Create(Self) do
  begin
    Parent := Self;
    SetBounds(232, 176, 41, 13);
   {$IFDEF Win32}
    Caption := SDrivesCap;
   {$ELSE}
    Caption := LoadStr(SDrivesCap);
   {$ENDIF}
    FocusControl := DriveList;
  end;

  DirLabel := TLabel.Create(Self);
  with DirLabel do
  begin
    Parent := Self;
    SetBounds(120, 8, 213, 13);
    AutoSize := False;
  end;

  DirList := TDirectoryListBox.Create(Self);
  with DirList do
  begin
    Parent := Self;
    SetBounds(8, 72, 213, 138);
    TabOrder := 0;
    TabStop := True;
    ItemHeight := 17;
    IntegralHeight := True;
    OnChange := DirListChange;
  end;

  with TLabel.Create(Self) do
  begin
    Parent := Self;
    SetBounds(8, 56, 66, 13);
   {$IFDEF Win32}
    Caption := SDirsCap;
   {$ELSE}
    Caption := LoadStr(SDirsCap);
   {$ENDIF}
    FocusControl := DirList;
  end;

  FileList := TFileListBox.Create(Self);
  with FileList do
  begin
    Parent := Self;
    SetBounds(232, 72, 185, 93);
    TabOrder := 6;
    TabStop  := True;
    FileType := [ftNormal];
    Mask     := '*.*';
    Font.Color := clGrayText;
    ItemHeight := 13;
    FileType := [ftNormal, ftDirectory];
  end;

  FileLabel:=TLabel.Create(Self);
  with FileLabel do
  begin
    Parent := Self;
    SetBounds(232, 56, 57, 13);
   {$IFDEF Win32}
    Caption := SFilesCap;
   {$ELSE}
    Caption := LoadStr(SFilesCap);
   {$ENDIF}
    FocusControl := FileList;
  end;

  NetButton := TButton.Create(Self);
  with NetButton do
  begin
    Parent := Self;
    SetBounds(8, 224, 77, 27);
    Visible := False;
    TabOrder := 3;
   {$IFDEF Win32}
    Caption := SNetworkCap;
   {$ELSE}
    Caption := LoadStr(SNetworkCap);
   {$ENDIF}
    OnClick := NetClick;
  end;

  OKButton := TBitBtn.Create(Self);
  with OKButton do
  begin
    Parent := Self;
    SetBounds(172, 224, 77, 27);
    TabOrder := 4;
    OnClick := OKClick;
    Kind := bkOK;
    Margin := 2;
    Spacing := -1;
  end;

  with TBitBtn.Create(Self) do
  begin
    Parent := Self;
    SetBounds(256, 224, 77, 27);
    Kind := bkCancel;
    TabOrder := 5;
    Margin := 2;
    Spacing := -1;
  end;

  with TBitBtn.Create(Self) do
  begin
    Parent := Self;
    SetBounds(340, 224, 77, 27);
    Kind := bkHelp;
    TabOrder := 7;
    Margin := 2;
    Spacing := -1;
  end;

  FormCreate(Self);
  ActiveControl := DirList;
end;

procedure TsohoSelectDirDlg.DirListChange(Sender: TObject);
begin
  DirLabel.Caption := DirList.Directory;
  FileList.Directory := DirList.Directory;
  DirEdit.Text := DirLabel.Caption;
  DirEdit.SelectAll;
end;

procedure TsohoSelectDirDlg.FormCreate(Sender: TObject);
const
  User = 'USER';
var
  UserHandle: THandle;
  NetDriver: THandle;
  WNetGetCaps: function (Flags: Word): Word;
begin
  { is network access enabled? }
  UserHandle := GetModuleHandle(User);
  @WNetGetCaps := GetProcAddress(UserHandle, 'WNETGETCAPS');
  if @WNetGetCaps <> nil then
  begin
    NetDriver := WNetGetCaps(Word(-1));
    if NetDriver <> 0 then
    begin
      @WNetConnectDialog := GetProcAddress(NetDriver, 'WNETCONNECTDIALOG');
      NetButton.Visible := @WNetConnectDialog <> nil;
    end;
  end;

  FAllowCreate := False;
  DirLabel.BoundsRect := DirEdit.BoundsRect;
  DirListChange(Self);
end;

procedure TsohoSelectDirDlg.DriveListChange(Sender: TObject);
begin
    if Assigned(DirList) then //Allex
     if Copy(DriveList.Drive,1,1)<>'@' then  //   DriveList :    @ 
     DirList.Drive := DriveList.Drive
     else begin
      DirLabel.Caption:=DriveList.Text;
      DirEdit.Text:=DriveList.Text;
      DirList.Clear;
      FileList.Clear;
     end;
end;

procedure TsohoSelectDirDlg.SetAllowCreate(Value: Boolean);
begin
     if Value <> FAllowCreate then
     begin
          FAllowCreate     := Value;
          DirLabel.Visible := not FAllowCreate;
          DirEdit.Visible  := FAllowCreate;
     end;
end;

procedure TsohoSelectDirDlg.SetDirectory(const Value: string);
var
   Temp: TFileName;
begin
  if Value > '' then
  begin
    Temp := Value;
    if Temp[Length(Temp)] = '\' then Temp := DecLength(Temp,1);
    Temp := ExpandFileName(Temp + '\*.*');
    if (Length(Temp) >= 3) and (Temp[2] = ':') then
    begin
      DriveList.Drive := Temp[1];
      Temp := ExtractFilePath(Temp);
      try
        DirList.Directory := Copy(Temp, 1, Length(Temp) - 1);
      except
        on EInOutError do
        begin
          GetDir(0, Temp);
          DriveList.Drive := Temp[1];
          DirList.Directory := Temp;
        end;
      end;
    end;
  end;
end;

function TsohoSelectDirDlg.GetDirectory: string;
begin
  if FAllowCreate then Result := DirEdit.Text
  else Result := DirLabel.Caption;
end;

procedure TsohoSelectDirDlg.NetClick(Sender: TObject);
begin
  if @WNetConnectDialog <> nil then
    WNetConnectDialog(Handle, WNTYPE_DRIVE);
end;

procedure TsohoSelectDirDlg.OKClick(Sender: TObject);
begin
   {$IFDEF Win32}
   if AllowCreate and Prompt and (not DirectoryExists(Directory)) and
    (MessageDlg(SConfirmCreateDir, mtConfirmation, [mbYes, mbNo],
      0) <> mrYes) or ((FileList.Items.Count=0) and FindFile) then
   {$ELSE}
   if AllowCreate and Prompt and (not DirectoryExists(Directory)) and
    (MessageDlg(LoadStr(SConfirmCreateDir), mtConfirmation, [mbYes, mbNo],
      0) <> mrYes) or ((FileList.Items.Count=0) and FindFile) then
   {$ENDIF}
    ModalResult := 0;
end;

{ TsohoDirectoryDialog }
constructor TsohoDirectoryDialog.Create(AOwner : TComponent);
begin
     inherited Create(AOwner);
     GetDir(0,FDirectory);
     FOptions       := [];
     FCaption       := sohoDirDlgBrowseDir;
     FHelpContext   := 0;
     FFileMustExist := '';
end;

destructor TsohoDirectoryDialog.Destroy;
begin
     inherited Destroy;
end;

function TsohoDirectoryDialog.Execute : boolean;
var
   D            : TsohoSelectDirDlg;
   FileLabelCap,OldDir : string;
begin
  D := TsohoSelectDirDlg.Create(Application);
  try
    GetDir(0,OldDir);
    try
       ChDir(Directory);
       D.Directory        := Directory;
       except D.Directory := OldDir;
    end;
    ChDir(OldDir);
    D.AllowCreate := sdAllowCreate in Options;
    D.Prompt      := sdPrompt in Options;
    D.Caption     := FCaption;
    { scale to screen res }
    if Screen.PixelsPerInch <> 96 then
    begin
      D.ScaleBy(Screen.PixelsPerInch, 96);

      { The ScaleBy method does not scale the font well, so set the
        font back to the original info. }
      D.Left       := (Screen.Width div 2)  - (D.Width div 2);
      D.Top        := (Screen.Height div 2) - (D.Height div 2);
      D.FileList.Font.Color := clGrayText;
    end;
    if FFileMustExist<>'' then
    begin D.FileList.Mask:=FFileMustExist;
          D.FindFile:=true;
          FileLabelCap:=copy(D.FileLabel.Caption,1,pos('(',D.FileLabel.Caption)-1);
          FileLabelCap:=FileLabelCap+'('+FFileMustExist+')';
          D.FileLabel.Caption:=FileLabelCap;
    end;
    D.HelpContext := FHelpContext;

    Result := D.ShowModal = mrOK;
    if Result then
    begin
      Directory := AnsiUpperCase(D.Directory);
      if sdPerformCreate in Options then
        ForceDirectories(Directory);
    end;
  finally
    D.Free;
  end;
end;

end.
