{*******************************************************}
{                                                       }
{           Delphi Visual Component Library             }
{                                                       }
{          Copyright (c) 1996-1997 AllexSoft            }
{                   Written by VSM                      }
{                                                       }
{                   SOHO Components                     }
{                                                       }
{*******************************************************}
unit SoRxPrp;

{$I SOHOLIB.INC}

interface
uses DsgnIntf, PresrDsn;

type

  TsohoMinMaxEditor = class (TFormStorageEditor)
    function  GetVerbCount : integer; override;
    function  GetVerb (Index : integer) : string; override;
    procedure ExecuteVerb (Index : integer);override;
  end;

implementation
uses Forms, SoRxTls;

{ TsohoMinMaxEditor }
function TsohoMinMaxEditor.GetVerbCount : integer;
begin
   Result := 6;
end;

function TsohoMinMaxEditor.GetVerb (Index : integer) : string;
begin
   case Index of
     2 : Result := 'Set current size as Max';
     3 : Result := 'Set current size as Min';
     1,4 : Result := '-';
     5 : Result := 'Clear MinMaxInfo';
     else Result := inherited GetVerb(Index);
   end
end;

procedure TsohoMinMaxEditor.ExecuteVerb (Index : integer);
begin
   if Index=0 then begin
      inherited ExecuteVerb(Index);
      exit;
   end;
   try
      if Component.Owner is TForm then
        with (Component as TsohoFormStorage).MinMaxInfo do begin
             case Index of
                 2 : begin MaxSizeHeight := (Component.Owner as TForm).Height;
                           MaxSizeWidth  := (Component.Owner as TForm).Width;
                           MaxTrackHeight := (Component.Owner as TForm).Height;
                           MaxTrackWidth  := (Component.Owner as TForm).Width;
                     end;
                 3 : begin MinTrackHeight := (Component.Owner as TForm).Height;
                           MinTrackWidth  := (Component.Owner as TForm).Width;
                     end;
                 5 : begin MaxSizeHeight  := 0;
                           MaxSizeWidth   := 0;
                           MaxTrackHeight := 0;
                           MaxTrackWidth  := 0;
                           MinTrackHeight := 0;
                           MinTrackWidth  := 0;
                     end;
             end;
             Designer.Modified;
        end;
   finally
   end;
end;

end.
